/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.base.Preconditions;
import com.google.common.jimfs.File;
import com.google.common.jimfs.JimfsPath;

final class SymbolicLink
extends File {
    private final JimfsPath target;

    public static SymbolicLink create(int id, JimfsPath target) {
        return new SymbolicLink(id, target);
    }

    private SymbolicLink(int id, JimfsPath target) {
        super(id);
        this.target = Preconditions.checkNotNull(target);
    }

    JimfsPath target() {
        return this.target;
    }

    @Override
    File copyWithoutContent(int id) {
        return SymbolicLink.create(id, this.target);
    }
}

