/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.cadixdev.atlas.AtlasTransformerContext;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.analysis.InheritanceType;
import org.cadixdev.bombe.jar.JarClassEntry;
import org.cadixdev.bombe.jar.JarEntryTransformer;
import org.cadixdev.bombe.type.BaseType;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.bombe.type.MethodDescriptor;
import org.cadixdev.bombe.type.ObjectType;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ConstructorInjector
implements JarEntryTransformer {
    private static final MethodDescriptor EMPTY = MethodDescriptor.of("()V");
    private final InheritanceProvider inh;
    private final MappingSet o2m;
    private final MappingSet m2o;

    public ConstructorInjector(AtlasTransformerContext ctx, MappingSet mappings) {
        this.inh = ctx.inheritanceProvider();
        this.o2m = mappings;
        this.m2o = mappings.reverse();
    }

    @Override
    public JarClassEntry transform(JarClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getContents());
        ClassWriter writer = new ClassWriter(reader, 0);
        reader.accept(new InitAdder((ClassVisitor)writer), 0);
        return new JarClassEntry(entry.getName(), entry.getTime(), writer.toByteArray());
    }

    private class InitAdder
    extends ClassVisitor {
        private String className;
        private String parentName;
        private String parentField;
        private ObjectType superType;
        private boolean hasInit;
        private boolean isStatic;
        private Map<String, FieldType> fields;

        public InitAdder(ClassVisitor cv) {
            super(589824, cv);
            this.hasInit = false;
            this.isStatic = false;
            this.fields = new LinkedHashMap<String, FieldType>();
        }

        private void log(String message) {
            System.out.println(message);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            this.superType = new ObjectType(superName);
            this.isStatic = (access & 8) != 0;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (this.className.equals(name)) {
                this.parentName = "L" + outerName + ";";
            }
            super.visitInnerClass(name, outerName, innerName, access);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if ((access & 8) == 0 && (access & 0x10) == 16) {
                if (this.parentName != null && desc.equals(this.parentName) && (access & 0x1000) == 4096) {
                    this.parentField = name;
                } else {
                    this.fields.put(name, FieldType.of(desc));
                }
            }
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<init>".equals(name)) {
                this.hasInit = true;
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        @Override
        public void visitEnd() {
            boolean isInner;
            boolean bl = isInner = this.parentField != null && this.parentName != null && !this.isStatic;
            if (this.hasInit) {
                super.visitEnd();
                return;
            }
            MethodDescriptor sup = this.findSuper(this.superType);
            if (!isInner && this.fields.isEmpty() && sup.equals(EMPTY)) {
                super.visitEnd();
                return;
            }
            this.log("  Adding synthetic <init> to " + this.className);
            MethodVisitor mv = isInner ? this.visitMethod(2 | (this.fields.isEmpty() ? 4096 : 0), "<init>", "(" + this.parentName + ")V", null, null) : this.visitMethod(2, "<init>", "()V", null, null);
            mv.visitVarInsn(25, 0);
            if (!sup.equals(EMPTY)) {
                this.log("    Super: " + sup);
            }
            for (FieldType fieldType : sup.getParamTypes()) {
                this.loadConstant(mv, fieldType);
            }
            mv.visitMethodInsn(183, this.superType.getClassName(), "<init>", sup.toString(), false);
            if (isInner) {
                this.log("    Inner: " + this.parentName + " " + this.parentField);
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitFieldInsn(181, this.className, this.parentField, this.parentName);
            }
            if (!this.fields.isEmpty()) {
                for (Map.Entry entry : this.fields.entrySet()) {
                    mv.visitVarInsn(25, 0);
                    this.loadConstant(mv, (FieldType)entry.getValue());
                    mv.visitFieldInsn(181, this.className, (String)entry.getKey(), ((FieldType)entry.getValue()).toString());
                    this.log("    Field: " + (String)entry.getKey());
                }
            }
            mv.visitTypeInsn(187, "java/lang/RuntimeException");
            mv.visitInsn(89);
            mv.visitLdcInsn("Synthetic constructor do not call");
            mv.visitMethodInsn(183, "java/lang/RuntimeException", "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
            super.visitEnd();
        }

        private MethodDescriptor findSuper(ObjectType parent) {
            boolean obfed = false;
            InheritanceProvider inh = ConstructorInjector.this.inh;
            MappingSet o2m = ConstructorInjector.this.o2m;
            MappingSet m2o = ConstructorInjector.this.m2o;
            Optional<InheritanceProvider.ClassInfo> pcls = inh.provide(parent.getClassName());
            if (!pcls.isPresent() && (pcls = inh.provide(((ObjectType)m2o.deobfuscate(parent)).getClassName())).isPresent()) {
                obfed = true;
            }
            MethodDescriptor sig = null;
            if (pcls.isPresent()) {
                for (Map.Entry<MethodSignature, InheritanceType> entry : pcls.get().getMethods().entrySet()) {
                    if (!"<init>".equals(entry.getKey().getName()) || entry.getValue() == InheritanceType.NONE) continue;
                    MethodDescriptor edesc = entry.getKey().getDescriptor();
                    if (sig == null) {
                        sig = edesc;
                        continue;
                    }
                    if (edesc.getParamTypes().size() < sig.getParamTypes().size()) {
                        sig = edesc;
                        continue;
                    }
                    if (edesc.getParamTypes().size() != sig.getParamTypes().size() || edesc.toString().compareTo(sig.toString()) >= 0) continue;
                    sig = edesc;
                }
            }
            return sig == null ? EMPTY : (obfed ? o2m.deobfuscate(sig) : sig);
        }

        private void loadConstant(MethodVisitor mv, FieldType type) {
            if (type instanceof BaseType) {
                switch ((BaseType)type) {
                    case BOOLEAN: 
                    case BYTE: 
                    case CHAR: 
                    case INT: 
                    case SHORT: {
                        mv.visitInsn(3);
                        break;
                    }
                    case FLOAT: {
                        mv.visitInsn(11);
                        break;
                    }
                    case LONG: {
                        mv.visitInsn(9);
                        break;
                    }
                    case DOUBLE: {
                        mv.visitInsn(14);
                        break;
                    }
                    default: {
                        mv.visitInsn(1);
                        break;
                    }
                }
            } else {
                mv.visitInsn(1);
            }
        }
    }
}

