/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.stream.Collectors;
import net.minecraftforge.lex.ExtendedClassRemapper;
import org.cadixdev.atlas.AtlasTransformerContext;
import org.cadixdev.bombe.jar.AbstractJarEntry;
import org.cadixdev.bombe.jar.JarClassEntry;
import org.cadixdev.bombe.jar.JarEntryTransformer;
import org.cadixdev.bombe.jar.JarManifestEntry;
import org.cadixdev.bombe.jar.JarResourceEntry;
import org.cadixdev.bombe.jar.JarServiceProviderConfigurationEntry;
import org.cadixdev.bombe.jar.ServiceProviderConfiguration;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.asm.LorenzRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class EnhancedRemappingTransformer
implements JarEntryTransformer,
ExtendedClassRemapper.AbstractConsumer {
    private final boolean makeFFMeta;
    private final Set<String> abstractParams = ConcurrentHashMap.newKeySet();
    private static final Attributes.Name SHA_256_DIGEST = new Attributes.Name("SHA-256-Digest");
    private final Remapper remapper;
    private final BiFunction<ClassVisitor, Remapper, ClassRemapper> clsRemapper;

    public EnhancedRemappingTransformer(MappingSet mappings, AtlasTransformerContext ctx, boolean makeFFMeta) {
        this.makeFFMeta = makeFFMeta;
        this.remapper = new LorenzRemapper(mappings, ctx.inheritanceProvider());
        this.clsRemapper = (cv, remapper) -> new ExtendedClassRemapper((ClassVisitor)cv, (Remapper)remapper, mappings, ctx.inheritanceProvider(), this);
    }

    @Override
    public List<AbstractJarEntry> additions() {
        if (!this.makeFFMeta || this.abstractParams.isEmpty()) {
            return Collections.emptyList();
        }
        byte[] data = this.abstractParams.stream().sorted().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8);
        return Arrays.asList(new JarResourceEntry("fernflower_abstract_parameter_names.txt", 1L, data));
    }

    @Override
    public void storeNames(String className, String methodName, String methodDescriptor, Collection<String> paramNames) {
        this.abstractParams.add(className + ' ' + methodName + ' ' + methodDescriptor + ' ' + paramNames.stream().collect(Collectors.joining(" ")));
    }

    @Override
    public JarClassEntry transform(JarClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getContents());
        ClassWriter writer = new ClassWriter(reader, 0);
        reader.accept(this.clsRemapper.apply(writer, this.remapper), 0);
        String originalName = entry.getName().substring(0, entry.getName().length() - ".class".length());
        String name = this.remapper.map(originalName) + ".class";
        return new JarClassEntry(name, entry.getTime(), writer.toByteArray());
    }

    @Override
    public JarManifestEntry transform(JarManifestEntry entry) {
        if (entry.getManifest().getMainAttributes().containsKey(Attributes.Name.MAIN_CLASS)) {
            String mainClassObf = entry.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS).replace('.', '/');
            String mainClassDeobf = this.remapper.map(mainClassObf).replace('/', '.');
            entry.getManifest().getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClassDeobf);
        }
        Iterator<Map.Entry<String, Attributes>> it = entry.getManifest().getEntries().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Attributes> section = it.next();
            if (section.getValue().remove(SHA_256_DIGEST) == null || !section.getValue().isEmpty()) continue;
            it.remove();
        }
        return entry;
    }

    @Override
    public JarServiceProviderConfigurationEntry transform(JarServiceProviderConfigurationEntry entry) {
        String obfServiceName = entry.getConfig().getService().replace('.', '/');
        String deobfServiceName = this.remapper.map(obfServiceName).replace('/', '.');
        List<String> deobfProviders = entry.getConfig().getProviders().stream().map(provider -> provider.replace('.', '/')).map(this.remapper::map).map(provider -> provider.replace('/', '.')).collect(Collectors.toList());
        ServiceProviderConfiguration config = new ServiceProviderConfiguration(deobfServiceName, deobfProviders);
        return new JarServiceProviderConfigurationEntry(entry.getTime(), config);
    }

    @Override
    public JarResourceEntry transform(JarResourceEntry entry) {
        if (entry.getName().startsWith("META-INF") && (entry.getExtension().equals("RSA") || entry.getExtension().equals("SF"))) {
            return null;
        }
        return entry;
    }
}

