/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.impl.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.analysis.InheritanceType;
import org.cadixdev.bombe.type.MethodDescriptor;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.impl.model.AbstractMappingImpl;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.InnerClassMapping;
import org.cadixdev.lorenz.model.MethodMapping;

public abstract class AbstractClassMappingImpl<M extends ClassMapping, P>
extends AbstractMappingImpl<M, P>
implements ClassMapping<M, P> {
    private final Map<FieldSignature, FieldMapping> fields = new ConcurrentHashMap<FieldSignature, FieldMapping>();
    private final Map<String, FieldMapping> fieldsByName = new ConcurrentHashMap<String, FieldMapping>();
    private final Map<MethodSignature, MethodMapping> methods = new ConcurrentHashMap<MethodSignature, MethodMapping>();
    private final Map<String, InnerClassMapping> innerClasses = new ConcurrentHashMap<String, InnerClassMapping>();
    private boolean complete;

    protected AbstractClassMappingImpl(MappingSet mappings, String obfuscatedName, String deobfuscatedName) {
        super(mappings, obfuscatedName, deobfuscatedName);
    }

    @Override
    public Collection<FieldMapping> getFieldMappings() {
        return Collections.unmodifiableCollection(this.fields.values());
    }

    @Override
    public Map<String, FieldMapping> getFieldsByName() {
        return Collections.unmodifiableMap(this.fieldsByName);
    }

    @Override
    public Optional<FieldMapping> getFieldMapping(FieldSignature signature) {
        return Optional.ofNullable(this.fields.get(signature));
    }

    @Override
    public Optional<FieldMapping> getFieldMapping(String obfuscatedName) {
        return Optional.ofNullable(this.fieldsByName.get(obfuscatedName));
    }

    @Override
    public Optional<FieldMapping> computeFieldMapping(FieldSignature signature) {
        if (!signature.getType().isPresent()) {
            return this.getFieldMapping(signature.getName());
        }
        return Optional.ofNullable(this.fields.computeIfAbsent(signature, sig -> {
            FieldMapping mapping = this.fields.get(new FieldSignature(sig.getName()));
            return mapping != null ? this.getMappings().getModelFactory().createFieldMapping((ClassMapping)mapping.getParent(), (FieldSignature)sig, mapping.getDeobfuscatedName()) : null;
        }));
    }

    @Override
    public FieldMapping createFieldMapping(FieldSignature signature, String deobfuscatedName) {
        return this.fields.compute(signature, (sig, existingMapping) -> {
            if (existingMapping != null) {
                return (FieldMapping)existingMapping.setDeobfuscatedName(deobfuscatedName);
            }
            FieldMapping mapping = this.getMappings().getModelFactory().createFieldMapping(this, (FieldSignature)sig, deobfuscatedName);
            this.fieldsByName.put(sig.getName(), mapping);
            return mapping;
        });
    }

    @Override
    public boolean hasFieldMapping(FieldSignature signature) {
        return this.getFieldMapping(signature).isPresent();
    }

    @Override
    public boolean hasFieldMapping(String obfuscatedName) {
        return this.fieldsByName.containsKey(obfuscatedName);
    }

    @Override
    public Collection<MethodMapping> getMethodMappings() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    @Override
    public Optional<MethodMapping> getMethodMapping(MethodSignature signature) {
        return Optional.ofNullable(this.methods.get(signature));
    }

    @Override
    public MethodMapping createMethodMapping(MethodSignature signature, String deobfuscatedName) {
        return this.methods.compute(signature, (desc, existingMapping) -> {
            if (existingMapping != null) {
                return (MethodMapping)existingMapping.setDeobfuscatedName(deobfuscatedName);
            }
            return this.getMappings().getModelFactory().createMethodMapping(this, signature, deobfuscatedName);
        });
    }

    @Override
    public boolean hasMethodMapping(MethodSignature signature) {
        return this.methods.containsKey(signature);
    }

    @Override
    public Collection<InnerClassMapping> getInnerClassMappings() {
        return Collections.unmodifiableCollection(this.innerClasses.values());
    }

    @Override
    public Optional<InnerClassMapping> getInnerClassMapping(String obfuscatedName) {
        return Optional.ofNullable(this.innerClasses.get(obfuscatedName));
    }

    @Override
    public InnerClassMapping createInnerClassMapping(String obfuscatedName, String deobfuscatedName) {
        return this.innerClasses.compute(obfuscatedName, (name, existingMapping) -> {
            if (existingMapping != null) {
                return existingMapping.setDeobfuscatedName(deobfuscatedName);
            }
            return this.getMappings().getModelFactory().createInnerClassMapping(this, obfuscatedName, deobfuscatedName);
        });
    }

    @Override
    public boolean hasInnerClassMapping(String obfuscatedName) {
        return this.innerClasses.containsKey(obfuscatedName);
    }

    @Override
    protected StringJoiner buildToString() {
        return super.buildToString().add("fields=" + this.getFieldMappings()).add("methods=" + this.getMethodMappings()).add("innerClasses=" + this.getInnerClassMappings());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ClassMapping)) {
            return false;
        }
        ClassMapping that = (ClassMapping)obj;
        return Objects.equals(this.getFieldMappings(), that.getFieldMappings()) && Objects.equals(this.getMethodMappings(), that.getMethodMappings()) && Objects.equals(this.getInnerClassMappings(), that.getInnerClassMappings());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields, this.methods, this.innerClasses);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void complete(InheritanceProvider provider, InheritanceProvider.ClassInfo info) {
        if (this.complete) {
            return;
        }
        HashMap<String, Set> nameToMethods = new HashMap<String, Set>();
        for (Map.Entry<MethodSignature, InheritanceType> method : info.getMethods().entrySet()) {
            Set methods = nameToMethods.computeIfAbsent(method.getKey().getName(), name -> new HashSet());
            methods.add(method.getKey());
        }
        for (InheritanceProvider.ClassInfo parent : info.provideParents(provider)) {
            ClassMapping<?, ?> parentMappings = this.getMappings().getOrCreateClassMapping(parent.getName());
            parentMappings.complete(provider, parent);
            for (FieldMapping fieldMapping : parentMappings.getFieldMappings()) {
                if (this.computeFieldMapping(fieldMapping.getSignature()).isPresent() || !parent.canInherit(info, fieldMapping.getSignature())) continue;
                this.fields.putIfAbsent(fieldMapping.getSignature(), fieldMapping);
            }
            for (MethodMapping methodMapping : parentMappings.getMethodMappings()) {
                if (parent.canInherit(info, methodMapping.getSignature())) {
                    this.methods.putIfAbsent(methodMapping.getSignature(), methodMapping);
                }
                if (!nameToMethods.containsKey(methodMapping.getObfuscatedName())) continue;
                for (MethodSignature methodSignature : (Set)nameToMethods.get(methodMapping.getObfuscatedName())) {
                    MethodDescriptor methodDescriptor = methodSignature.getDescriptor();
                    MethodSignature mappingSignature = methodMapping.getSignature();
                    MethodDescriptor mappingDescriptor = mappingSignature.getDescriptor();
                    if (!Objects.equals(methodDescriptor.getParamTypes(), mappingDescriptor.getParamTypes()) || !mappingDescriptor.getReturnType().isAssignableFrom(methodDescriptor.getReturnType(), provider)) continue;
                    this.methods.putIfAbsent(methodSignature, methodMapping);
                }
            }
        }
        this.complete = true;
    }
}

