/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.vignette;

import com.google.common.collect.ImmutableList;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.lex.ConstructorInjector;
import net.minecraftforge.lex.EnhancedRemappingTransformer;
import net.minecraftforge.lex.ParameterAnnotationFixer;
import org.cadixdev.atlas.Atlas;
import org.cadixdev.atlas.AtlasTransformerContext;
import org.cadixdev.atlas.util.NIOHelper;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.io.MappingFormat;
import org.cadixdev.lorenz.io.MappingFormats;
import org.cadixdev.vignette.util.MappingFormatValueConverter;
import org.cadixdev.vignette.util.PathValueConverter;

public final class VignetteMain {
    public static void main(String[] args) {
        block49: {
            OptionSet options;
            OptionParser parser = new OptionParser();
            AbstractOptionSpec helpSpec = parser.acceptsAll(Arrays.asList("?", "help"), "Show the help").forHelp();
            OptionSpecBuilder versionSpec = parser.accepts("version", "Shows the version");
            ArgumentAcceptingOptionSpec<Path> jarInSpec = parser.acceptsAll(Arrays.asList("jar-in", "i"), "The jar to remap/map").withRequiredArg().withValuesConvertedBy(PathValueConverter.INSTANCE);
            ArgumentAcceptingOptionSpec<Path> jarOutSpec = parser.acceptsAll(Arrays.asList("jar-out", "o"), "The output jar").withRequiredArg().withValuesConvertedBy(PathValueConverter.INSTANCE);
            ArgumentAcceptingOptionSpec<MappingFormat> mappingFormatSpec = parser.acceptsAll(Arrays.asList("mapping-format", "f"), "The mapping format").withRequiredArg().withValuesConvertedBy(MappingFormatValueConverter.INSTANCE).defaultsTo(MappingFormats.SRG, (MappingFormat[])new MappingFormat[0]);
            ArgumentAcceptingOptionSpec<Path> mappingsSpec = parser.acceptsAll(Arrays.asList("mappings", "m"), "The mappings to remap with").withRequiredArg().withValuesConvertedBy(PathValueConverter.INSTANCE);
            ArgumentAcceptingOptionSpec<Integer> threadsSpec = parser.acceptsAll(Arrays.asList("threads", "t"), "Number of threads to use when remapping").withRequiredArg().ofType(Integer.class);
            ArgumentAcceptingOptionSpec<Path> librarySpec = parser.acceptsAll(Arrays.asList("library", "l", "e"), "Library to add to the classpath for constructing inheritence").withRequiredArg().withValuesConvertedBy(PathValueConverter.INSTANCE);
            OptionSpecBuilder ffmetaSpec = parser.acceptsAll(Arrays.asList("fernflower-meta", "f"), "Generate special metadata file for ForgeFlower that will name abstract method arguments during decompilation");
            OptionSpecBuilder ctrSpec = parser.acceptsAll(Arrays.asList("create-inits", "c"), "Automatically inject synthetic <init> functions for classes with final fields and no constructors.");
            OptionSpecBuilder parAnnSpec = parser.acceptsAll(Arrays.asList("fix-param-annotations", "p"), "Attempts to fix parameter annotations that get shifted due to the compiler injecting synthetics");
            OptionSpecBuilder stableSpec = parser.accepts("stable", "Generate stable jars that attempt to change less for the same given inputs");
            try {
                options = parser.parse(VignetteMain.enhanceArgs(args));
            }
            catch (OptionException ex) {
                System.err.println("Failed to parse OptionSet! Exiting...");
                ex.printStackTrace(System.err);
                System.exit(-1);
                return;
            }
            if (options.has(helpSpec)) {
                try {
                    parser.printHelpOn(System.out);
                }
                catch (IOException ex) {
                    System.err.println("Failed to print help information!");
                    ex.printStackTrace(System.err);
                    System.exit(-1);
                }
            } else if (options.has(versionSpec)) {
                Arrays.asList("Vignette 0.1.0", "Copyright (c) 2019 Jamie Mansfield <https://www.jamiemansfield.me/>", "Vignette is made available under the terms of the Mozilla Public License 2.0, giving", "you the freedom to use, copy, and distribute Vignette to others, in addition to", "the right to distribute modified versions.").forEach(System.out::println);
            } else {
                if (options.has(mappingsSpec) && options.has(jarInSpec) && options.has(jarOutSpec)) {
                    MappingSet mappings;
                    Path jarInPath = options.valueOf(jarInSpec);
                    Path jarOutPath = options.valueOf(jarOutSpec);
                    System.out.println("Input: " + jarInPath);
                    System.out.println("Output: " + jarOutPath);
                    if (Files.notExists(jarInPath, new LinkOption[0])) {
                        throw new RuntimeException("Input jar does not exist!");
                    }
                    MappingFormat mappingFormat = options.valueOf(mappingFormatSpec);
                    Path mappingsPath = options.valueOf(mappingsSpec);
                    if (Files.notExists(mappingsPath, new LinkOption[0])) {
                        throw new RuntimeException("Input mappings does not exist!");
                    }
                    try {
                        System.out.println("Format: " + mappingFormat);
                        System.out.println("Mappings: " + mappingsPath);
                        mappings = mappingFormat.read(mappingsPath);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Failed to read input mappings!", ex);
                    }
                    try (Atlas atlas = options.has(threadsSpec) ? new Atlas(options.valueOf(threadsSpec)) : new Atlas();){
                        for (Path lib : options.valuesOf(librarySpec)) {
                            try {
                                System.out.println("Library: " + lib);
                                atlas.use(lib);
                            }
                            catch (IOException ex) {
                                throw new RuntimeException("Failed to read library!", ex);
                            }
                        }
                        atlas.install(ctx -> new EnhancedRemappingTransformer(mappings, (AtlasTransformerContext)ctx, options.has(ffmetaSpec)));
                        if (options.has(ctrSpec)) {
                            atlas.install(ctx -> new ConstructorInjector((AtlasTransformerContext)ctx, mappings));
                            System.out.println("Constructors");
                        }
                        if (options.has(parAnnSpec)) {
                            atlas.install(ctx -> new ParameterAnnotationFixer());
                            System.out.println("Parameter Annotations");
                        }
                        if (options.has(stableSpec)) {
                            try (FileSystem memFs = Jimfs.newFileSystem(Configuration.unix());){
                                Path memoryOutput = memFs.getPath("output.jar", new String[0]);
                                try {
                                    atlas.run(jarInPath, memoryOutput);
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {
                                    // empty catch block
                                }
                                Files.copy(VignetteMain.makeStableJar(memFs, memoryOutput), jarOutPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                            }
                        }
                        atlas.run(jarInPath, jarOutPath);
                        System.out.println("Processing Complete");
                        break block49;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Failed to remap artifact!", ex);
                    }
                }
                try {
                    parser.printHelpOn(System.err);
                }
                catch (IOException ex) {
                    System.err.println("Failed to print help information!");
                    ex.printStackTrace(System.err);
                }
                System.exit(-1);
            }
        }
    }

    private static Path makeStableJar(FileSystem memFs, Path input) throws IOException {
        Path output = memFs.getPath("stable.jar", new String[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(output, new OpenOption[0]));
             FileSystem zipFs = NIOHelper.openZip(input, false);){
            Path rootInput = zipFs.getPath("/", new String[0]);
            List paths = Files.walk(rootInput, new FileVisitOption[0]).collect(Collectors.toList());
            ImmutableList<String> special = ImmutableList.of("/META-INF", "/META-INF/MANIFEST.MF");
            paths.sort(Comparator.comparing(Path::toString, (left, right) -> {
                boolean containsLeft = special.contains(left);
                boolean containsRight = special.contains(right);
                if (containsLeft && containsRight) {
                    return Integer.compare(special.indexOf(left), special.indexOf(right));
                }
                if (containsLeft) {
                    return 1;
                }
                if (containsRight) {
                    return -1;
                }
                return left.compareTo((String)right);
            }));
            paths.remove(rootInput);
            for (Path path : paths) {
                String pathString = path.toString().substring(1).replace('\\', '/');
                boolean directory = Files.isDirectory(path, new LinkOption[0]);
                if (directory && !pathString.endsWith("/")) {
                    pathString = pathString + "/";
                }
                ZipEntry zipEntry = new ZipEntry(pathString);
                zipEntry.setTime(628041600000L);
                zos.putNextEntry(zipEntry);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    Files.copy(path, zos);
                }
                zos.closeEntry();
            }
        }
        return output;
    }

    private static String[] enhanceArgs(String[] args) {
        ArrayList<String> params = new ArrayList<String>();
        for (int x = 0; x < args.length; ++x) {
            if (args[x].startsWith("--cfg")) {
                String path = null;
                if (args[x].startsWith("--cfg=")) {
                    path = args[x].substring(5);
                } else if (args.length > x + 1) {
                    path = args[++x];
                } else {
                    throw new IllegalArgumentException("Must specify a file when using --cfg argument.");
                }
                Path file = Paths.get(path, new String[0]);
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new IllegalArgumentException("error: missing config '" + path + "'");
                }
                try (Stream<String> stream = Files.lines(file);){
                    stream.forEach(params::add);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("error: Failed to read config file '" + path + "'", e);
                }
            }
            params.add(args[x]);
        }
        return params.toArray(new String[params.size()]);
    }

    private VignetteMain() {
    }
}

