/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class User {
    private final String f_92535_;
    private final String f_92536_;
    private final String f_92537_;
    private final Type f_92538_;
    private PropertyMap properties;

    public User(String p_92540_, String p_92541_, String p_92542_, String p_92543_) {
        if (p_92540_ == null || p_92540_.isEmpty()) {
            p_92540_ = "MissingName";
            p_92542_ = "NotValid";
            p_92541_ = "NotValid";
            Logger logger = LogManager.getLogger((String)this.getClass().getName());
            logger.warn("=========================================================");
            logger.warn("WARNING!! the username was not set for this session, typically");
            logger.warn("this means you installed Forge incorrectly. We have set your");
            logger.warn("name to \"MissingName\" and your session to nothing. Please");
            logger.warn("check your installation and post a console log from the launcher");
            logger.warn("when asking for help!");
            logger.warn("=========================================================");
        }
        this.f_92535_ = p_92540_;
        this.f_92536_ = p_92541_;
        this.f_92537_ = p_92542_;
        this.f_92538_ = Type.m_92561_(p_92543_);
    }

    public String m_92544_() {
        return "token:" + this.f_92537_ + ":" + this.f_92536_;
    }

    public String m_92545_() {
        return this.f_92536_;
    }

    public String m_92546_() {
        return this.f_92535_;
    }

    public String m_92547_() {
        return this.f_92537_;
    }

    public GameProfile m_92548_() {
        try {
            UUID uuid = UUIDTypeAdapter.fromString((String)this.m_92545_());
            GameProfile ret = new GameProfile(uuid, this.m_92546_());
            if (this.properties != null) {
                ret.getProperties().putAll((Multimap)this.properties);
            }
            return ret;
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return new GameProfile((UUID)null, this.m_92546_());
        }
    }

    public void setProperties(PropertyMap properties) {
        if (this.properties == null) {
            this.properties = properties;
        }
    }

    public boolean hasCachedProperties() {
        return this.properties != null;
    }

    public Type m_168638_() {
        return this.f_92538_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LEGACY = new Type("legacy");
        public static final /* enum */ Type MOJANG = new Type("mojang");
        private static final Map<String, Type> f_92551_;
        private final String f_92552_;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String p_92558_) {
            this.f_92552_ = p_92558_;
        }

        @Nullable
        public static Type m_92561_(String p_92562_) {
            return f_92551_.get(p_92562_.toLowerCase(Locale.ROOT));
        }

        private static /* synthetic */ Type[] m_168639_() {
            return new Type[]{LEGACY, MOJANG};
        }

        static {
            $VALUES = Type.m_168639_();
            f_92551_ = Arrays.stream(Type.values()).collect(Collectors.toMap(p_92560_ -> p_92560_.f_92552_, Function.identity()));
        }
    }
}

