/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.status;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Type;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fmllegacy.network.FMLStatusPing;

public class ServerStatus {
    public static final int f_179835_ = 64;
    public static final int f_179836_ = 64;
    private Component f_134900_;
    private Players f_134901_;
    private Version f_134902_;
    private String f_134903_;
    private transient FMLStatusPing forgeData;
    private Semaphore mutex = new Semaphore(1);
    private String json = null;

    public FMLStatusPing getForgeData() {
        return this.forgeData;
    }

    public void setForgeData(FMLStatusPing data) {
        this.forgeData = data;
        this.invalidateJson();
    }

    public Component m_134905_() {
        return this.f_134900_;
    }

    public void m_134908_(Component p_134909_) {
        this.f_134900_ = p_134909_;
        this.invalidateJson();
    }

    public Players m_134914_() {
        return this.f_134901_;
    }

    public void m_134910_(Players p_134911_) {
        this.f_134901_ = p_134911_;
        this.invalidateJson();
    }

    public Version m_134915_() {
        return this.f_134902_;
    }

    public void m_134912_(Version p_134913_) {
        this.f_134902_ = p_134913_;
        this.invalidateJson();
    }

    public void m_134906_(String p_134907_) {
        this.f_134903_ = p_134907_;
        this.invalidateJson();
    }

    public String m_134916_() {
        return this.f_134903_;
    }

    public String getJson() {
        String ret = this.json;
        if (ret == null) {
            this.mutex.acquireUninterruptibly();
            ret = this.json;
            if (ret == null) {
                this.json = ret = ClientboundStatusResponsePacket.f_134885_.toJson((Object)this);
            }
            this.mutex.release();
        }
        return ret;
    }

    public void invalidateJson() {
        this.json = null;
    }

    public static class Players {
        private final int f_134917_;
        private final int f_134918_;
        private GameProfile[] f_134919_;

        public Players(int p_134921_, int p_134922_) {
            this.f_134917_ = p_134921_;
            this.f_134918_ = p_134922_;
        }

        public int m_134923_() {
            return this.f_134917_;
        }

        public int m_134926_() {
            return this.f_134918_;
        }

        public GameProfile[] m_134927_() {
            return this.f_134919_;
        }

        public void m_134924_(GameProfile[] p_134925_) {
            this.f_134919_ = p_134925_;
        }

        public static class Serializer
        implements JsonDeserializer<Players>,
        JsonSerializer<Players> {
            public Players deserialize(JsonElement p_134930_, Type p_134931_, JsonDeserializationContext p_134932_) throws JsonParseException {
                JsonArray jsonarray;
                JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_134930_, (String)"players");
                Players serverstatus$players = new Players(GsonHelper.m_13927_((JsonObject)jsonobject, (String)"max"), GsonHelper.m_13927_((JsonObject)jsonobject, (String)"online"));
                if (GsonHelper.m_13885_((JsonObject)jsonobject, (String)"sample") && (jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"sample")).size() > 0) {
                    GameProfile[] agameprofile = new GameProfile[jsonarray.size()];
                    for (int i = 0; i < agameprofile.length; ++i) {
                        JsonObject jsonobject1 = GsonHelper.m_13918_((JsonElement)jsonarray.get(i), (String)("player[" + i + "]"));
                        String s = GsonHelper.m_13906_((JsonObject)jsonobject1, (String)"id");
                        agameprofile[i] = new GameProfile(UUID.fromString(s), GsonHelper.m_13906_((JsonObject)jsonobject1, (String)"name"));
                    }
                    serverstatus$players.m_134924_(agameprofile);
                }
                return serverstatus$players;
            }

            public JsonElement serialize(Players p_134934_, Type p_134935_, JsonSerializationContext p_134936_) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("max", (Number)p_134934_.m_134923_());
                jsonobject.addProperty("online", (Number)p_134934_.m_134926_());
                if (p_134934_.m_134927_() != null && p_134934_.m_134927_().length > 0) {
                    JsonArray jsonarray = new JsonArray();
                    for (int i = 0; i < p_134934_.m_134927_().length; ++i) {
                        JsonObject jsonobject1 = new JsonObject();
                        UUID uuid = p_134934_.m_134927_()[i].getId();
                        jsonobject1.addProperty("id", uuid == null ? "" : uuid.toString());
                        jsonobject1.addProperty("name", p_134934_.m_134927_()[i].getName());
                        jsonarray.add((JsonElement)jsonobject1);
                    }
                    jsonobject.add("sample", (JsonElement)jsonarray);
                }
                return jsonobject;
            }
        }
    }

    public static class Version {
        private final String f_134962_;
        private final int f_134963_;

        public Version(String p_134965_, int p_134966_) {
            this.f_134962_ = p_134965_;
            this.f_134963_ = p_134966_;
        }

        public String m_134967_() {
            return this.f_134962_;
        }

        public int m_134968_() {
            return this.f_134963_;
        }

        public static class Serializer
        implements JsonDeserializer<Version>,
        JsonSerializer<Version> {
            public Version deserialize(JsonElement p_134971_, Type p_134972_, JsonDeserializationContext p_134973_) throws JsonParseException {
                JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_134971_, (String)"version");
                return new Version(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name"), GsonHelper.m_13927_((JsonObject)jsonobject, (String)"protocol"));
            }

            public JsonElement serialize(Version p_134975_, Type p_134976_, JsonSerializationContext p_134977_) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("name", p_134975_.m_134967_());
                jsonobject.addProperty("protocol", (Number)p_134975_.m_134968_());
                return jsonobject;
            }
        }
    }

    public static class Serializer
    implements JsonDeserializer<ServerStatus>,
    JsonSerializer<ServerStatus> {
        public ServerStatus deserialize(JsonElement p_134947_, Type p_134948_, JsonDeserializationContext p_134949_) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_134947_, (String)"status");
            ServerStatus serverstatus = new ServerStatus();
            if (jsonobject.has("description")) {
                serverstatus.m_134908_((Component)p_134949_.deserialize(jsonobject.get("description"), Component.class));
            }
            if (jsonobject.has("players")) {
                serverstatus.m_134910_((Players)p_134949_.deserialize(jsonobject.get("players"), Players.class));
            }
            if (jsonobject.has("version")) {
                serverstatus.m_134912_((Version)p_134949_.deserialize(jsonobject.get("version"), Version.class));
            }
            if (jsonobject.has("favicon")) {
                serverstatus.m_134906_(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"favicon"));
            }
            if (jsonobject.has("forgeData")) {
                serverstatus.setForgeData(FMLStatusPing.Serializer.deserialize((JsonObject)GsonHelper.m_13930_((JsonObject)jsonobject, (String)"forgeData"), (JsonDeserializationContext)p_134949_));
            }
            return serverstatus;
        }

        public JsonElement serialize(ServerStatus p_134951_, Type p_134952_, JsonSerializationContext p_134953_) {
            JsonObject jsonobject = new JsonObject();
            if (p_134951_.m_134905_() != null) {
                jsonobject.add("description", p_134953_.serialize((Object)p_134951_.m_134905_()));
            }
            if (p_134951_.m_134914_() != null) {
                jsonobject.add("players", p_134953_.serialize((Object)p_134951_.m_134914_()));
            }
            if (p_134951_.m_134915_() != null) {
                jsonobject.add("version", p_134953_.serialize((Object)p_134951_.m_134915_()));
            }
            if (p_134951_.m_134916_() != null) {
                jsonobject.addProperty("favicon", p_134951_.m_134916_());
            }
            if (p_134951_.getForgeData() != null) {
                jsonobject.add("forgeData", (JsonElement)FMLStatusPing.Serializer.serialize((FMLStatusPing)p_134951_.getForgeData(), (JsonSerializationContext)p_134953_));
            }
            return jsonobject;
        }
    }
}

