/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SetTag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.extensions.IForgeRawTagBuilder;

public interface Tag<T> {
    public static <T> Codec<Tag<T>> m_13290_(Supplier<TagCollection<T>> p_13291_) {
        return ResourceLocation.f_135803_.flatXmap(p_13297_ -> Optional.ofNullable(((TagCollection)p_13291_.get()).m_13404_(p_13297_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + p_13297_))), p_13294_ -> Optional.ofNullable(((TagCollection)p_13291_.get()).m_7473_(p_13294_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + p_13294_))));
    }

    public boolean m_8110_(T var1);

    public List<T> m_6497_();

    default public T m_13288_(Random p_13289_) {
        List<T> list = this.m_6497_();
        return list.get(p_13289_.nextInt(list.size()));
    }

    public static <T> Tag<T> m_13300_(Set<T> p_13301_) {
        return SetTag.m_13222_(p_13301_);
    }

    public static class TagEntry
    implements Entry {
        private final ResourceLocation f_13383_;

        public TagEntry(ResourceLocation p_13385_) {
            this.f_13383_ = p_13385_;
        }

        @Override
        public <T> boolean m_7657_(Function<ResourceLocation, Tag<T>> p_13389_, Function<ResourceLocation, T> p_13390_, Consumer<T> p_13391_) {
            Tag<T> tag = p_13389_.apply(this.f_13383_);
            if (tag == null) {
                return false;
            }
            tag.m_6497_().forEach(p_13391_);
            return true;
        }

        @Override
        public void m_6383_(JsonArray p_13387_) {
            p_13387_.add("#" + this.f_13383_);
        }

        public String toString() {
            return "#" + this.f_13383_;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof TagEntry && Objects.equals(this.f_13383_, ((TagEntry)o).f_13383_);
        }

        public ResourceLocation getId() {
            return this.f_13383_;
        }

        @Override
        public boolean m_142746_(Predicate<ResourceLocation> p_144404_, Predicate<ResourceLocation> p_144405_) {
            return p_144405_.test(this.f_13383_);
        }

        @Override
        public void m_141929_(Consumer<ResourceLocation> p_144402_) {
            p_144402_.accept(this.f_13383_);
        }
    }

    public static class OptionalTagEntry
    implements Entry {
        private final ResourceLocation f_13373_;

        public OptionalTagEntry(ResourceLocation p_13375_) {
            this.f_13373_ = p_13375_;
        }

        @Override
        public <T> boolean m_7657_(Function<ResourceLocation, Tag<T>> p_13379_, Function<ResourceLocation, T> p_13380_, Consumer<T> p_13381_) {
            Tag<T> tag = p_13379_.apply(this.f_13373_);
            if (tag != null) {
                tag.m_6497_().forEach(p_13381_);
            }
            return true;
        }

        @Override
        public void m_6383_(JsonArray p_13377_) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("id", "#" + this.f_13373_);
            jsonobject.addProperty("required", Boolean.valueOf(false));
            p_13377_.add((JsonElement)jsonobject);
        }

        public String toString() {
            return "#" + this.f_13373_ + "?";
        }

        @Override
        public void m_141918_(Consumer<ResourceLocation> p_144400_) {
            p_144400_.accept(this.f_13373_);
        }

        @Override
        public boolean m_142746_(Predicate<ResourceLocation> p_144397_, Predicate<ResourceLocation> p_144398_) {
            return true;
        }
    }

    public static class OptionalElementEntry
    implements Entry {
        private final ResourceLocation f_13363_;

        public OptionalElementEntry(ResourceLocation p_13365_) {
            this.f_13363_ = p_13365_;
        }

        @Override
        public <T> boolean m_7657_(Function<ResourceLocation, Tag<T>> p_13369_, Function<ResourceLocation, T> p_13370_, Consumer<T> p_13371_) {
            T t = p_13370_.apply(this.f_13363_);
            if (t != null) {
                p_13371_.accept(t);
            }
            return true;
        }

        @Override
        public void m_6383_(JsonArray p_13367_) {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("id", this.f_13363_.toString());
            jsonobject.addProperty("required", Boolean.valueOf(false));
            p_13367_.add((JsonElement)jsonobject);
        }

        @Override
        public boolean m_142746_(Predicate<ResourceLocation> p_144394_, Predicate<ResourceLocation> p_144395_) {
            return true;
        }

        public String toString() {
            return this.f_13363_ + "?";
        }
    }

    public static interface Named<T>
    extends Tag<T> {
        public ResourceLocation m_6979_();
    }

    public static interface Entry {
        public <T> boolean m_7657_(Function<ResourceLocation, Tag<T>> var1, Function<ResourceLocation, T> var2, Consumer<T> var3);

        public void m_6383_(JsonArray var1);

        default public void m_141929_(Consumer<ResourceLocation> p_144389_) {
        }

        default public void m_141918_(Consumer<ResourceLocation> p_144392_) {
        }

        public boolean m_142746_(Predicate<ResourceLocation> var1, Predicate<ResourceLocation> var2);
    }

    public static class ElementEntry
    implements Entry {
        private final ResourceLocation f_13349_;

        public ElementEntry(ResourceLocation p_13351_) {
            this.f_13349_ = p_13351_;
        }

        @Override
        public <T> boolean m_7657_(Function<ResourceLocation, Tag<T>> p_13355_, Function<ResourceLocation, T> p_13356_, Consumer<T> p_13357_) {
            T t = p_13356_.apply(this.f_13349_);
            if (t == null) {
                return false;
            }
            p_13357_.accept(t);
            return true;
        }

        @Override
        public void m_6383_(JsonArray p_13353_) {
            p_13353_.add(this.f_13349_.toString());
        }

        @Override
        public boolean m_142746_(Predicate<ResourceLocation> p_144387_, Predicate<ResourceLocation> p_144388_) {
            return p_144387_.test(this.f_13349_);
        }

        public String toString() {
            return this.f_13349_.toString();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ElementEntry && Objects.equals(this.f_13349_, ((ElementEntry)o).f_13349_);
        }
    }

    public static class BuilderEntry {
        final Entry f_13338_;
        private final String f_13339_;

        public BuilderEntry(Entry p_13341_, String p_13342_) {
            this.f_13338_ = p_13341_;
            this.f_13339_ = p_13342_;
        }

        public Entry m_13347_() {
            return this.f_13338_;
        }

        public String m_144385_() {
            return this.f_13339_;
        }

        public String toString() {
            return this.f_13338_ + " (from " + this.f_13339_ + ")";
        }
    }

    public static class Builder
    implements IForgeRawTagBuilder {
        private final List<BuilderEntry> removeEntries = Lists.newArrayList();
        private final List<BuilderEntry> f_13302_ = Lists.newArrayList();
        private boolean replace = false;

        public Stream<BuilderEntry> getRemoveEntries() {
            return this.removeEntries.stream();
        }

        public Builder remove(BuilderEntry proxy) {
            this.removeEntries.add(proxy);
            return this;
        }

        public static Builder m_13304_() {
            return new Builder();
        }

        public Builder m_13305_(BuilderEntry p_13306_) {
            this.f_13302_.add(p_13306_);
            return this;
        }

        public Builder m_13307_(Entry p_13308_, String p_13309_) {
            return this.m_13305_(new BuilderEntry(p_13308_, p_13309_));
        }

        public Builder m_13327_(ResourceLocation p_13328_, String p_13329_) {
            return this.m_13307_(new ElementEntry(p_13328_), p_13329_);
        }

        public Builder m_144379_(ResourceLocation p_144380_, String p_144381_) {
            return this.m_13307_(new OptionalElementEntry(p_144380_), p_144381_);
        }

        public Builder m_13335_(ResourceLocation p_13336_, String p_13337_) {
            return this.m_13307_(new TagEntry(p_13336_), p_13337_);
        }

        public Builder m_144382_(ResourceLocation p_144383_, String p_144384_) {
            return this.m_13307_(new OptionalTagEntry(p_144383_), p_144384_);
        }

        public Builder replace(boolean value) {
            this.replace = value;
            return this;
        }

        public Builder replace() {
            return this.replace(true);
        }

        public <T> Either<Collection<BuilderEntry>, Tag<T>> m_144371_(Function<ResourceLocation, Tag<T>> p_144372_, Function<ResourceLocation, T> p_144373_) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            ArrayList list = Lists.newArrayList();
            for (BuilderEntry tag$builderentry : this.f_13302_) {
                if (tag$builderentry.m_13347_().m_7657_(p_144372_, p_144373_, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0))) continue;
                list.add(tag$builderentry);
            }
            return list.isEmpty() ? Either.right(Tag.m_13300_(builder.build())) : Either.left((Object)list);
        }

        public Stream<BuilderEntry> m_13330_() {
            return this.f_13302_.stream();
        }

        public void m_144366_(Consumer<ResourceLocation> p_144367_) {
            this.f_13302_.forEach(p_144378_ -> p_144378_.f_13338_.m_141929_(p_144367_));
        }

        public void m_144374_(Consumer<ResourceLocation> p_144375_) {
            this.f_13302_.forEach(p_144370_ -> p_144370_.f_13338_.m_141918_(p_144375_));
        }

        public Builder m_13312_(JsonObject p_13313_, String p_13314_) {
            JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)p_13313_, (String)"values");
            ArrayList list = Lists.newArrayList();
            for (JsonElement jsonelement : jsonarray) {
                list.add(Builder.m_13310_(jsonelement));
            }
            if (GsonHelper.m_13855_((JsonObject)p_13313_, (String)"replace", (boolean)false)) {
                this.f_13302_.clear();
            }
            ForgeHooks.deserializeTagAdditions((List)list, (JsonObject)p_13313_, this.f_13302_);
            list.forEach(p_13319_ -> this.f_13302_.add(new BuilderEntry((Entry)p_13319_, p_13314_)));
            return this;
        }

        private static Entry m_13310_(JsonElement p_13311_) {
            boolean flag;
            String s;
            if (p_13311_.isJsonObject()) {
                JsonObject jsonobject = p_13311_.getAsJsonObject();
                s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"id");
                flag = GsonHelper.m_13855_((JsonObject)jsonobject, (String)"required", (boolean)true);
            } else {
                s = GsonHelper.m_13805_((JsonElement)p_13311_, (String)"id");
                flag = true;
            }
            if (s.startsWith("#")) {
                ResourceLocation resourcelocation1 = new ResourceLocation(s.substring(1));
                return flag ? new TagEntry(resourcelocation1) : new OptionalTagEntry(resourcelocation1);
            }
            ResourceLocation resourcelocation = new ResourceLocation(s);
            return flag ? new ElementEntry(resourcelocation) : new OptionalElementEntry(resourcelocation);
        }

        public JsonObject m_13334_() {
            JsonObject jsonobject = new JsonObject();
            JsonArray jsonarray = new JsonArray();
            for (BuilderEntry tag$builderentry : this.f_13302_) {
                tag$builderentry.m_13347_().m_6383_(jsonarray);
            }
            jsonobject.addProperty("replace", Boolean.valueOf(this.replace));
            jsonobject.add("values", (JsonElement)jsonarray);
            this.serializeTagAdditions(jsonobject);
            return jsonobject;
        }
    }
}

