/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.data.worldgen.SurfaceBuilders;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.level.levelgen.surfacebuilders.SurfaceBuilderConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeGenerationSettings {
    public static final Logger f_47776_ = LogManager.getLogger();
    public static final BiomeGenerationSettings f_47777_ = new BiomeGenerationSettings(() -> SurfaceBuilders.f_127291_, (Map<GenerationStep.Carving, List<Supplier<ConfiguredWorldCarver<?>>>>)ImmutableMap.of(), (List<List<Supplier<ConfiguredFeature<?, ?>>>>)ImmutableList.of(), (List<Supplier<ConfiguredStructureFeature<?, ?>>>)ImmutableList.of());
    public static final MapCodec<BiomeGenerationSettings> f_47778_ = RecordCodecBuilder.mapCodec(p_47814_ -> p_47814_.group((App)ConfiguredSurfaceBuilder.f_74763_.fieldOf("surface_builder").flatXmap(ExtraCodecs.m_181037_(), ExtraCodecs.m_181037_()).forGetter(p_151749_ -> p_151749_.f_47779_), (App)Codec.simpleMap((Codec)GenerationStep.Carving.f_64194_, (Codec)ConfiguredWorldCarver.f_64848_.promotePartial(Util.m_137489_("Carver: ", arg_0 -> ((Logger)f_47776_).error(arg_0))).flatXmap(ExtraCodecs.m_181036_(), ExtraCodecs.m_181036_()), (Keyable)StringRepresentable.m_14357_((StringRepresentable[])GenerationStep.Carving.values())).fieldOf("carvers").forGetter(p_151747_ -> p_151747_.f_47780_), (App)ConfiguredFeature.f_65375_.promotePartial(Util.m_137489_("Feature: ", arg_0 -> ((Logger)f_47776_).error(arg_0))).flatXmap(ExtraCodecs.m_181036_(), ExtraCodecs.m_181036_()).listOf().fieldOf("features").forGetter(p_151745_ -> p_151745_.f_47781_), (App)ConfiguredStructureFeature.f_65402_.promotePartial(Util.m_137489_("Structure start: ", arg_0 -> ((Logger)f_47776_).error(arg_0))).fieldOf("starts").flatXmap(ExtraCodecs.m_181036_(), ExtraCodecs.m_181036_()).forGetter(p_151743_ -> p_151743_.f_47782_)).apply((Applicative)p_47814_, BiomeGenerationSettings::new));
    private final Supplier<ConfiguredSurfaceBuilder<?>> f_47779_;
    private final Map<GenerationStep.Carving, List<Supplier<ConfiguredWorldCarver<?>>>> f_47780_;
    private final Set<GenerationStep.Carving> carversView;
    private final List<List<Supplier<ConfiguredFeature<?, ?>>>> f_47781_;
    private final List<Supplier<ConfiguredStructureFeature<?, ?>>> f_47782_;
    private final List<ConfiguredFeature<?, ?>> f_47783_;

    BiomeGenerationSettings(Supplier<ConfiguredSurfaceBuilder<?>> p_47786_, Map<GenerationStep.Carving, List<Supplier<ConfiguredWorldCarver<?>>>> p_47787_, List<List<Supplier<ConfiguredFeature<?, ?>>>> p_47788_, List<Supplier<ConfiguredStructureFeature<?, ?>>> p_47789_) {
        this.f_47779_ = p_47786_;
        this.f_47780_ = p_47787_;
        this.f_47781_ = p_47788_;
        this.f_47782_ = p_47789_;
        this.f_47783_ = (List)p_47788_.stream().flatMap(Collection::stream).map(Supplier::get).flatMap(ConfiguredFeature::m_65398_).filter(p_47802_ -> p_47802_.f_65377_ == Feature.f_65761_).collect(ImmutableList.toImmutableList());
        this.carversView = Collections.unmodifiableSet(this.f_47780_.keySet());
    }

    public List<Supplier<ConfiguredWorldCarver<?>>> m_47799_(GenerationStep.Carving p_47800_) {
        return (List)this.f_47780_.getOrDefault(p_47800_, (List<Supplier<ConfiguredWorldCarver<?>>>)ImmutableList.of());
    }

    public Set<GenerationStep.Carving> getCarvingStages() {
        return this.carversView;
    }

    public boolean m_47808_(StructureFeature<?> p_47809_) {
        return this.f_47782_.stream().anyMatch(p_47812_ -> ((ConfiguredStructureFeature)p_47812_.get()).f_65403_ == p_47809_);
    }

    public Collection<Supplier<ConfiguredStructureFeature<?, ?>>> m_47796_() {
        return this.f_47782_;
    }

    public ConfiguredStructureFeature<?, ?> m_47803_(ConfiguredStructureFeature<?, ?> p_47804_) {
        return (ConfiguredStructureFeature)DataFixUtils.orElse(this.f_47782_.stream().map(Supplier::get).filter(p_47807_ -> p_47807_.f_65403_ == p_47804_.f_65403_).findAny(), p_47804_);
    }

    public List<ConfiguredFeature<?, ?>> m_47815_() {
        return this.f_47783_;
    }

    public List<List<Supplier<ConfiguredFeature<?, ?>>>> m_47818_() {
        return this.f_47781_;
    }

    public Supplier<ConfiguredSurfaceBuilder<?>> m_47821_() {
        return this.f_47779_;
    }

    public SurfaceBuilderConfiguration m_47824_() {
        return this.f_47779_.get().m_74770_();
    }

    public static class Builder {
        protected Optional<Supplier<ConfiguredSurfaceBuilder<?>>> f_47826_ = Optional.empty();
        protected final Map<GenerationStep.Carving, List<Supplier<ConfiguredWorldCarver<?>>>> f_47827_ = Maps.newLinkedHashMap();
        protected final List<List<Supplier<ConfiguredFeature<?, ?>>>> f_47828_ = Lists.newArrayList();
        protected final List<Supplier<ConfiguredStructureFeature<?, ?>>> f_47829_ = Lists.newArrayList();

        public Builder m_47851_(ConfiguredSurfaceBuilder<?> p_47852_) {
            return this.m_47855_(() -> p_47852_);
        }

        public Builder m_47855_(Supplier<ConfiguredSurfaceBuilder<?>> p_47856_) {
            this.f_47826_ = Optional.of(p_47856_);
            return this;
        }

        public Builder m_47842_(GenerationStep.Decoration p_47843_, ConfiguredFeature<?, ?> p_47844_) {
            return this.m_47834_(p_47843_.ordinal(), () -> p_47844_);
        }

        public Builder m_47834_(int p_47835_, Supplier<ConfiguredFeature<?, ?>> p_47836_) {
            this.m_47832_(p_47835_);
            this.f_47828_.get(p_47835_).add(p_47836_);
            return this;
        }

        public <C extends CarverConfiguration> Builder m_47839_(GenerationStep.Carving p_47840_, ConfiguredWorldCarver<C> p_47841_) {
            this.f_47827_.computeIfAbsent(p_47840_, p_47838_ -> Lists.newArrayList()).add(() -> p_47841_);
            return this;
        }

        public Builder m_47849_(ConfiguredStructureFeature<?, ?> p_47850_) {
            this.f_47829_.add(() -> p_47850_);
            return this;
        }

        protected void m_47832_(int p_47833_) {
            while (this.f_47828_.size() <= p_47833_) {
                this.f_47828_.add(Lists.newArrayList());
            }
        }

        public BiomeGenerationSettings m_47831_() {
            return new BiomeGenerationSettings(this.f_47826_.orElseThrow(() -> new IllegalStateException("Missing surface builder")), (Map)this.f_47827_.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_47854_ -> ImmutableList.copyOf((Collection)((Collection)p_47854_.getValue())))), (List)this.f_47828_.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList()), (List<Supplier<ConfiguredStructureFeature<?, ?>>>)ImmutableList.copyOf(this.f_47829_));
        }
    }
}

