/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DistExecutor {
    private static final Logger LOGGER = LogManager.getLogger();

    private DistExecutor() {
    }

    @Deprecated
    public static <T> T callWhenOn(Dist dist, Supplier<Callable<T>> toRun) {
        return DistExecutor.unsafeCallWhenOn(dist, toRun);
    }

    public static <T> T unsafeCallWhenOn(Dist dist, Supplier<Callable<T>> toRun) {
        if (dist == FMLEnvironment.dist) {
            try {
                return toRun.get().call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static <T> T safeCallWhenOn(Dist dist, Supplier<SafeCallable<T>> toRun) {
        DistExecutor.validateSafeReferent(toRun);
        return DistExecutor.callWhenOn(dist, toRun::get);
    }

    @Deprecated
    public static void runWhenOn(Dist dist, Supplier<Runnable> toRun) {
        DistExecutor.unsafeRunWhenOn(dist, toRun);
    }

    public static void unsafeRunWhenOn(Dist dist, Supplier<Runnable> toRun) {
        if (dist == FMLEnvironment.dist) {
            toRun.get().run();
        }
    }

    public static void safeRunWhenOn(Dist dist, Supplier<SafeRunnable> toRun) {
        DistExecutor.validateSafeReferent(toRun);
        if (dist == FMLEnvironment.dist) {
            toRun.get().run();
        }
    }

    @Deprecated
    public static <T> T runForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return DistExecutor.unsafeRunForDist(clientTarget, serverTarget);
    }

    public static <T> T unsafeRunForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                return clientTarget.get().get();
            }
            case DEDICATED_SERVER: {
                return serverTarget.get().get();
            }
        }
        throw new IllegalArgumentException("UNSIDED?");
    }

    public static <T> T safeRunForDist(Supplier<SafeSupplier<T>> clientTarget, Supplier<SafeSupplier<T>> serverTarget) {
        DistExecutor.validateSafeReferent(clientTarget);
        DistExecutor.validateSafeReferent(serverTarget);
        switch (FMLEnvironment.dist) {
            case CLIENT: {
                return clientTarget.get().get();
            }
            case DEDICATED_SERVER: {
                return serverTarget.get().get();
            }
        }
        throw new IllegalArgumentException("UNSIDED?");
    }

    private static final void validateSafeReferent(Supplier<? extends SafeReferent> safeReferentSupplier) {
        SafeReferent setter;
        if (FMLEnvironment.production) {
            return;
        }
        try {
            setter = safeReferentSupplier.get();
        }
        catch (Exception e) {
            return;
        }
        for (Class<?> cl = setter.getClass(); cl != null; cl = cl.getSuperclass()) {
            try {
                Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
                m.setAccessible(true);
                Object replacement = m.invoke((Object)setter, new Object[0]);
                if (!(replacement instanceof SerializedLambda)) break;
                SerializedLambda l = (SerializedLambda)replacement;
                if (!Objects.equals(l.getCapturingClass(), l.getImplClass())) continue;
                LOGGER.fatal("Detected unsafe referent usage, please view the code at {}", (Object)Thread.currentThread().getStackTrace()[3]);
                throw new RuntimeException("Unsafe Referent usage found in safe referent method");
            }
            catch (NoSuchMethodException m) {
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                break;
            }
        }
    }

    public static interface SafeRunnable
    extends SafeReferent,
    Runnable,
    Serializable {
    }

    public static interface SafeSupplier<T>
    extends SafeReferent,
    Supplier<T>,
    Serializable {
    }

    public static interface SafeReferent {
    }

    public static interface SafeCallable<T>
    extends SafeReferent,
    Callable<T>,
    Serializable {
    }
}

