/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.asm.jar;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.stream.Collectors;
import org.cadixdev.bombe.jar.JarClassEntry;
import org.cadixdev.bombe.jar.JarEntryTransformer;
import org.cadixdev.bombe.jar.JarManifestEntry;
import org.cadixdev.bombe.jar.JarResourceEntry;
import org.cadixdev.bombe.jar.JarServiceProviderConfigurationEntry;
import org.cadixdev.bombe.jar.ServiceProviderConfiguration;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class JarEntryRemappingTransformer
implements JarEntryTransformer {
    private static final Attributes.Name SHA_256_DIGEST = new Attributes.Name("SHA-256-Digest");
    private final Remapper remapper;
    private final BiFunction<ClassVisitor, Remapper, ClassRemapper> clsRemapper;

    public JarEntryRemappingTransformer(Remapper remapper, BiFunction<ClassVisitor, Remapper, ClassRemapper> clsRemapper) {
        this.remapper = remapper;
        this.clsRemapper = clsRemapper;
    }

    public JarEntryRemappingTransformer(Remapper remapper) {
        this(remapper, ClassRemapper::new);
    }

    public JarClassEntry transform(JarClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getContents());
        ClassWriter writer = new ClassWriter(reader, 0);
        reader.accept((ClassVisitor)this.clsRemapper.apply((ClassVisitor)writer, this.remapper), 0);
        String originalName = entry.getName().substring(0, entry.getName().length() - ".class".length());
        String name = this.remapper.map(originalName) + ".class";
        return new JarClassEntry(name, entry.getTime(), writer.toByteArray());
    }

    public JarManifestEntry transform(JarManifestEntry entry) {
        if (entry.getManifest().getMainAttributes().containsKey(Attributes.Name.MAIN_CLASS)) {
            String mainClassObf = entry.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS).replace('.', '/');
            String mainClassDeobf = this.remapper.map(mainClassObf).replace('/', '.');
            entry.getManifest().getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClassDeobf);
        }
        Iterator<Map.Entry<String, Attributes>> it = entry.getManifest().getEntries().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Attributes> section = it.next();
            if (section.getValue().remove(SHA_256_DIGEST) == null || !section.getValue().isEmpty()) continue;
            it.remove();
        }
        return entry;
    }

    public JarServiceProviderConfigurationEntry transform(JarServiceProviderConfigurationEntry entry) {
        String obfServiceName = entry.getConfig().getService().replace('.', '/');
        String deobfServiceName = this.remapper.map(obfServiceName).replace('/', '.');
        List deobfProviders = entry.getConfig().getProviders().stream().map(provider -> provider.replace('.', '/')).map(arg_0 -> ((Remapper)this.remapper).map(arg_0)).map(provider -> provider.replace('/', '.')).collect(Collectors.toList());
        ServiceProviderConfiguration config = new ServiceProviderConfiguration(deobfServiceName, deobfProviders);
        return new JarServiceProviderConfigurationEntry(entry.getTime(), config);
    }

    public JarResourceEntry transform(JarResourceEntry entry) {
        if (entry.getName().startsWith("META-INF") && (entry.getExtension().equals("RSA") || entry.getExtension().equals("SF"))) {
            return null;
        }
        return entry;
    }
}

