/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.ManifestVerifier;
import cpw.mods.jarhandling.impl.SecureJarVerifier;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.security.CodeSigner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Jar
implements SecureJar {
    private static final CodeSigner[] EMPTY_CODESIGNERS = new CodeSigner[0];
    private static final UnionFileSystemProvider UFSP = (UnionFileSystemProvider)FileSystemProvider.installedProviders().stream().filter(fsp -> fsp.getScheme().equals("union")).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find UnionFileSystemProvider"));
    private final Manifest manifest;
    private final Hashtable<String, CodeSigner[]> pendingSigners;
    private final Hashtable<String, CodeSigner[]> verifiedSigners;
    private final ManifestVerifier verifier;
    private final Map<String, StatusData> statusData;
    private final JarMetadata metadata;
    private final UnionFileSystem filesystem;
    private final boolean isMultiRelease;
    private final Map<Path, Integer> nameOverrides;
    private Set<String> packages;
    private List<SecureJar.Provider> providers;

    public URI getURI() {
        return this.filesystem.getRootDirectories().iterator().next().toUri();
    }

    public ModuleDescriptor computeDescriptor() {
        return this.metadata.descriptor();
    }

    @Override
    public Path getPrimaryPath() {
        return this.filesystem.getPrimaryPath();
    }

    @Override
    public Optional<URI> findFile(String name) {
        Path rel = this.filesystem.getPath(name, new String[0]);
        if (this.nameOverrides.containsKey(rel)) {
            rel = this.filesystem.getPath("META-INF", "versions", this.nameOverrides.get(rel).toString()).resolve(rel);
        }
        return Optional.of(this.filesystem.getRoot().resolve(rel)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri);
    }

    public Jar(Supplier<Manifest> defaultManifest, Function<SecureJar, JarMetadata> metadataFunction, BiPredicate<String, String> pathfilter, Path ... paths) {
        block28: {
            this.pendingSigners = new Hashtable();
            this.verifiedSigners = new Hashtable();
            this.verifier = new ManifestVerifier();
            this.statusData = new HashMap<String, StatusData>();
            Path[] validPaths = (Path[])Arrays.stream(paths).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toArray(Path[]::new);
            if (validPaths.length == 0) {
                throw new UncheckedIOException(new IOException("Invalid paths argument, contained no existing paths: " + Arrays.toString(paths)));
            }
            this.filesystem = UFSP.newFileSystem(pathfilter, validPaths);
            try {
                Manifest mantmp = null;
                for (int x = validPaths.length - 1; x >= 0; --x) {
                    Path path = validPaths[x];
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        Path manfile = path.resolve("META-INF/MANIFEST.MF");
                        if (!Files.exists(manfile, new LinkOption[0])) continue;
                        try (InputStream is = Files.newInputStream(manfile, new OpenOption[0]);){
                            mantmp = new Manifest(is);
                            break;
                        }
                    }
                    try (JarInputStream jis = new JarInputStream(Files.newInputStream(path, new OpenOption[0]));){
                        Object jv = SecureJarVerifier.getJarVerifier(jis);
                        if (jv != null) {
                            while (SecureJarVerifier.isParsingMeta(jv)) {
                                jis.getNextJarEntry();
                            }
                            if (SecureJarVerifier.hasSignatures(jv)) {
                                this.pendingSigners.putAll(SecureJarVerifier.getPendingSigners(jv));
                                this.verifiedSigners.put("META-INF/MANIFEST.MF", SecureJarVerifier.getVerifiedSigners(jv).get("META-INF/MANIFEST.MF"));
                                StatusData.add("META-INF/MANIFEST.MF", SecureJar.Status.VERIFIED, this.verifiedSigners.get("META-INF/MANIFEST.MF"), this);
                            }
                        }
                        if (jis.getManifest() == null) continue;
                        mantmp = new Manifest(jis.getManifest());
                        break;
                    }
                }
                this.manifest = mantmp == null ? defaultManifest.get() : mantmp;
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
            this.isMultiRelease = Boolean.parseBoolean(this.getManifest().getMainAttributes().getValue("Multi-Release"));
            if (this.isMultiRelease) {
                Path vers = this.filesystem.getRoot().resolve("META-INF/versions");
                try (Stream<Path> walk = Files.walk(vers, new FileVisitOption[0]);){
                    Map allnames = walk.filter(p1 -> !p1.isAbsolute()).filter(path1 -> !Files.isDirectory(path1, new LinkOption[0])).map(p1 -> p1.subpath(2, p1.getNameCount())).collect(Collectors.groupingBy(p -> p.subpath(1, p.getNameCount()), Collectors.mapping(p -> Integer.parseInt(p.getName(0).toString()), Collectors.toUnmodifiableList())));
                    this.nameOverrides = allnames.entrySet().stream().map(e -> Map.entry((Path)e.getKey(), ((List)e.getValue()).stream().reduce(Integer::max).orElse(8))).filter(e -> (Integer)e.getValue() < Runtime.version().feature()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    break block28;
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            this.nameOverrides = Map.of();
        }
        this.metadata = metadataFunction.apply(this);
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public CodeSigner[] getManifestSigners() {
        return this.getData("META-INF/MANIFEST.MF").map(r -> r.signers).orElse(null);
    }

    public synchronized CodeSigner[] verifyAndGetSigners(String name, byte[] bytes) {
        if (!this.hasSecurityData()) {
            return null;
        }
        if (this.statusData.containsKey(name)) {
            return this.statusData.get((Object)name).signers;
        }
        Optional<CodeSigner[]> signers = this.verifier.verify(this.manifest, this.pendingSigners, this.verifiedSigners, name, bytes);
        if (signers == null) {
            StatusData.add(name, SecureJar.Status.INVALID, null, this);
            return null;
        }
        CodeSigner[] ret = signers.orElse(null);
        StatusData.add(name, SecureJar.Status.VERIFIED, ret, this);
        return ret;
    }

    @Override
    public SecureJar.Status verifyPath(Path path) {
        if (path.getFileSystem() != this.filesystem) {
            throw new IllegalArgumentException("Wrong filesystem");
        }
        String pathname = path.toString();
        if (this.statusData.containsKey(pathname)) {
            return this.getFileStatus(pathname);
        }
        try {
            byte[] bytes = Files.readAllBytes(path);
            this.verifyAndGetSigners(pathname, bytes);
            return this.getFileStatus(pathname);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Optional<StatusData> getData(String name) {
        return Optional.ofNullable(this.statusData.get(name));
    }

    @Override
    public SecureJar.Status getFileStatus(String name) {
        return this.hasSecurityData() ? this.getData(name).map(r -> r.status).orElse(SecureJar.Status.NONE) : SecureJar.Status.UNVERIFIED;
    }

    @Override
    public Attributes getTrustedManifestEntries(String name) {
        Attributes manattrs = this.manifest.getAttributes(name);
        CodeSigner[] mansigners = this.getManifestSigners();
        CodeSigner[] objsigners = this.getData(name).map(sd -> sd.signers).orElse(EMPTY_CODESIGNERS);
        if (mansigners == null || mansigners.length == objsigners.length) {
            return manattrs;
        }
        return null;
    }

    @Override
    public boolean hasSecurityData() {
        return !this.pendingSigners.isEmpty() || !this.verifiedSigners.isEmpty();
    }

    @Override
    public String name() {
        return this.metadata.name();
    }

    @Override
    public Set<String> getPackages() {
        if (this.packages == null) {
            try (Stream<Path> walk = Files.walk(this.filesystem.getRoot(), new FileVisitOption[0]);){
                this.packages = walk.filter(path -> !path.getName(0).toString().equals("META-INF")).filter(path -> path.getFileName().toString().endsWith(".class")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.subpath(0, path.getNameCount() - 1)).map(path -> path.toString().replace('/', '.')).filter(pkg -> pkg.length() != 0).collect(Collectors.toSet());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.packages;
    }

    @Override
    public List<SecureJar.Provider> getProviders() {
        block10: {
            if (this.providers == null) {
                Path services = this.filesystem.getRoot().resolve("META-INF/services/");
                if (Files.exists(services, new LinkOption[0])) {
                    try (Stream<Path> walk = Files.walk(services, new FileVisitOption[0]);){
                        this.providers = walk.filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path1 -> SecureJar.Provider.fromPath(path1, this.filesystem.getFilesystemFilter())).toList();
                        break block10;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                this.providers = List.of();
            }
        }
        return this.providers;
    }

    @Override
    public Path getPath(String first, String ... rest) {
        return this.filesystem.getPath(first, rest);
    }

    @Override
    public Path getRootPath() {
        return this.filesystem.getRoot();
    }

    public String toString() {
        return "Jar[" + this.getURI() + "]";
    }

    private record StatusData(String name, SecureJar.Status status, CodeSigner[] signers) {
        static void add(String name, SecureJar.Status status, CodeSigner[] signers, Jar jar) {
            jar.statusData.put(name, new StatusData(name, status, signers));
        }
    }
}

