/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ShaderInstance
implements Shader,
AutoCloseable {
    private static final String f_173321_ = "shaders/core/";
    private static final String f_173322_ = "shaders/include/";
    static final Logger f_173323_ = LogManager.getLogger();
    private static final AbstractUniform f_173324_ = new AbstractUniform();
    private static final boolean f_173325_ = true;
    private static ShaderInstance f_173326_;
    private static int f_173327_;
    private final Map<String, Object> f_173328_ = Maps.newHashMap();
    private final List<String> f_173329_ = Lists.newArrayList();
    private final List<Integer> f_173330_ = Lists.newArrayList();
    private final List<Uniform> f_173331_ = Lists.newArrayList();
    private final List<Integer> f_173332_ = Lists.newArrayList();
    private final Map<String, Uniform> f_173333_ = Maps.newHashMap();
    private final int f_173299_;
    private final String f_173300_;
    private boolean f_173301_;
    private final BlendMode f_173302_;
    private final List<Integer> f_173303_;
    private final List<String> f_173304_;
    private final Program f_173305_;
    private final Program f_173306_;
    private final VertexFormat f_173307_;
    @Nullable
    public final Uniform f_173308_;
    @Nullable
    public final Uniform f_173309_;
    @Nullable
    public final Uniform f_173310_;
    @Nullable
    public final Uniform f_173311_;
    @Nullable
    public final Uniform f_173312_;
    @Nullable
    public final Uniform f_173313_;
    @Nullable
    public final Uniform f_173314_;
    @Nullable
    public final Uniform f_173315_;
    @Nullable
    public final Uniform f_173316_;
    @Nullable
    public final Uniform f_173317_;
    @Nullable
    public final Uniform f_173318_;
    @Nullable
    public final Uniform f_173319_;
    @Nullable
    public final Uniform f_173320_;

    @Deprecated
    public ShaderInstance(ResourceProvider p_173336_, String p_173337_, VertexFormat p_173338_) throws IOException {
        this(p_173336_, new ResourceLocation(p_173337_), p_173338_);
    }

    public ShaderInstance(ResourceProvider p_173336_, ResourceLocation shaderLocation, VertexFormat p_173338_) throws IOException {
        this.f_173300_ = shaderLocation.m_135827_().equals("minecraft") ? shaderLocation.m_135815_() : shaderLocation.toString();
        this.f_173307_ = p_173338_;
        ResourceLocation resourcelocation = new ResourceLocation(shaderLocation.m_135827_(), f_173321_ + shaderLocation.m_135815_() + ".json");
        Resource resource = null;
        try {
            JsonArray jsonarray2;
            JsonArray jsonarray1;
            resource = p_173336_.m_142591_(resourcelocation);
            JsonObject jsonobject = GsonHelper.m_13859_((Reader)new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));
            String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"vertex");
            String s1 = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"fragment");
            JsonArray jsonarray = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"samplers", (JsonArray)null);
            if (jsonarray != null) {
                int i = 0;
                for (Object jsonelement : jsonarray) {
                    try {
                        this.m_173344_((JsonElement)jsonelement);
                    }
                    catch (Exception exception2) {
                        ChainedJsonException chainedjsonexception1 = ChainedJsonException.m_135906_((Exception)exception2);
                        chainedjsonexception1.m_135908_("samplers[" + i + "]");
                        throw chainedjsonexception1;
                    }
                    ++i;
                }
            }
            if ((jsonarray1 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"attributes", (JsonArray)null)) != null) {
                int j = 0;
                this.f_173303_ = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                this.f_173304_ = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                for (JsonElement jsonelement1 : jsonarray1) {
                    try {
                        this.f_173304_.add(GsonHelper.m_13805_((JsonElement)jsonelement1, (String)"attribute"));
                    }
                    catch (Exception exception1) {
                        ChainedJsonException chainedjsonexception2 = ChainedJsonException.m_135906_((Exception)exception1);
                        chainedjsonexception2.m_135908_("attributes[" + j + "]");
                        throw chainedjsonexception2;
                    }
                    ++j;
                }
            } else {
                this.f_173303_ = null;
                this.f_173304_ = null;
            }
            if ((jsonarray2 = GsonHelper.m_13832_((JsonObject)jsonobject, (String)"uniforms", (JsonArray)null)) != null) {
                int k = 0;
                for (JsonElement jsonelement2 : jsonarray2) {
                    try {
                        this.m_173354_(jsonelement2);
                    }
                    catch (Exception exception) {
                        ChainedJsonException chainedjsonexception3 = ChainedJsonException.m_135906_((Exception)exception);
                        chainedjsonexception3.m_135908_("uniforms[" + k + "]");
                        throw chainedjsonexception3;
                    }
                    ++k;
                }
            }
            this.f_173302_ = ShaderInstance.m_173346_(GsonHelper.m_13841_((JsonObject)jsonobject, (String)"blend", (JsonObject)null));
            this.f_173305_ = ShaderInstance.m_173340_(p_173336_, Program.Type.VERTEX, s);
            this.f_173306_ = ShaderInstance.m_173340_(p_173336_, Program.Type.FRAGMENT, s1);
            this.f_173299_ = ProgramManager.m_85577_();
            if (this.f_173304_ != null) {
                int l = 0;
                for (String s2 : p_173338_.m_166911_()) {
                    Uniform.m_166710_((int)this.f_173299_, (int)l, (CharSequence)s2);
                    this.f_173303_.add(l);
                    ++l;
                }
            }
            ProgramManager.m_166623_((Shader)this);
            this.m_173366_();
        }
        catch (Exception exception3) {
            ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception3);
            chainedjsonexception.m_135910_(resourcelocation.m_135815_());
            throw chainedjsonexception;
        }
        finally {
            IOUtils.closeQuietly((Closeable)resource);
        }
        this.m_142660_();
        this.f_173308_ = this.m_173348_("ModelViewMat");
        this.f_173309_ = this.m_173348_("ProjMat");
        this.f_173310_ = this.m_173348_("TextureMat");
        this.f_173311_ = this.m_173348_("ScreenSize");
        this.f_173312_ = this.m_173348_("ColorModulator");
        this.f_173313_ = this.m_173348_("Light0_Direction");
        this.f_173314_ = this.m_173348_("Light1_Direction");
        this.f_173315_ = this.m_173348_("FogStart");
        this.f_173316_ = this.m_173348_("FogEnd");
        this.f_173317_ = this.m_173348_("FogColor");
        this.f_173318_ = this.m_173348_("LineWidth");
        this.f_173319_ = this.m_173348_("GameTime");
        this.f_173320_ = this.m_173348_("ChunkOffset");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Program m_173340_(final ResourceProvider p_173341_, Program.Type p_173342_, String p_173343_) throws IOException {
        Program program;
        Program program1 = (Program)p_173342_.m_85570_().get(p_173343_);
        if (program1 == null) {
            ResourceLocation loc = new ResourceLocation(p_173343_);
            String s = f_173321_ + loc.m_135815_() + p_173342_.m_85569_();
            ResourceLocation resourcelocation = new ResourceLocation(loc.m_135827_(), s);
            Resource resource = p_173341_.m_142591_(resourcelocation);
            final String s1 = FileUtil.m_179922_((String)s);
            try {
                program = Program.m_166604_((Program.Type)p_173342_, (String)p_173343_, (InputStream)resource.m_6679_(), (String)resource.m_7816_(), (GlslPreprocessor)new GlslPreprocessor(){
                    private final Set<String> f_173369_ = Sets.newHashSet();

                    public String m_142138_(boolean p_173374_, String p_173375_) {
                        p_173375_ = FileUtil.m_179924_((String)((p_173374_ ? s1 : ShaderInstance.f_173322_) + p_173375_));
                        if (!this.f_173369_.add(p_173375_)) {
                            return null;
                        }
                        ResourceLocation resourcelocation1 = new ResourceLocation(p_173375_);
                        try {
                            String s2;
                            try (Resource resource1 = p_173341_.m_142591_(resourcelocation1);){
                                s2 = IOUtils.toString((InputStream)resource1.m_6679_(), (Charset)StandardCharsets.UTF_8);
                            }
                            return s2;
                        }
                        catch (IOException ioexception) {
                            f_173323_.error("Could not open GLSL import {}: {}", (Object)p_173375_, (Object)ioexception.getMessage());
                            return "#error " + ioexception.getMessage();
                        }
                    }
                });
            }
            finally {
                IOUtils.closeQuietly((Closeable)resource);
            }
        } else {
            program = program1;
        }
        return program;
    }

    public static BlendMode m_173346_(JsonObject p_173347_) {
        if (p_173347_ == null) {
            return new BlendMode();
        }
        int i = 32774;
        int j = 1;
        int k = 0;
        int l = 1;
        int i1 = 0;
        boolean flag = true;
        boolean flag1 = false;
        if (GsonHelper.m_13813_((JsonObject)p_173347_, (String)"func") && (i = BlendMode.m_85527_((String)p_173347_.get("func").getAsString())) != 32774) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)p_173347_, (String)"srcrgb") && (j = BlendMode.m_85530_((String)p_173347_.get("srcrgb").getAsString())) != 1) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)p_173347_, (String)"dstrgb") && (k = BlendMode.m_85530_((String)p_173347_.get("dstrgb").getAsString())) != 0) {
            flag = false;
        }
        if (GsonHelper.m_13813_((JsonObject)p_173347_, (String)"srcalpha")) {
            l = BlendMode.m_85530_((String)p_173347_.get("srcalpha").getAsString());
            if (l != 1) {
                flag = false;
            }
            flag1 = true;
        }
        if (GsonHelper.m_13813_((JsonObject)p_173347_, (String)"dstalpha")) {
            i1 = BlendMode.m_85530_((String)p_173347_.get("dstalpha").getAsString());
            if (i1 != 0) {
                flag = false;
            }
            flag1 = true;
        }
        if (flag) {
            return new BlendMode();
        }
        return flag1 ? new BlendMode(j, k, l, i1, i) : new BlendMode(j, k, i);
    }

    @Override
    public void close() {
        for (Uniform uniform : this.f_173331_) {
            uniform.close();
        }
        ProgramManager.m_166621_((Shader)this);
    }

    public void m_173362_() {
        RenderSystem.m_69393_(RenderSystem::m_69586_);
        ProgramManager.m_85578_((int)0);
        f_173327_ = -1;
        f_173326_ = null;
        int i = GlStateManager.m_157058_();
        for (int j = 0; j < this.f_173330_.size(); ++j) {
            if (this.f_173328_.get(this.f_173329_.get(j)) == null) continue;
            GlStateManager.m_84538_(33984 + j);
            GlStateManager.m_84544_(0);
        }
        GlStateManager.m_84538_(i);
    }

    public void m_173363_() {
        RenderSystem.m_69393_(RenderSystem::m_69586_);
        this.f_173301_ = false;
        f_173326_ = this;
        this.f_173302_.m_85526_();
        if (this.f_173299_ != f_173327_) {
            ProgramManager.m_85578_((int)this.f_173299_);
            f_173327_ = this.f_173299_;
        }
        int i = GlStateManager.m_157058_();
        for (int j = 0; j < this.f_173330_.size(); ++j) {
            String s = this.f_173329_.get(j);
            if (this.f_173328_.get(s) == null) continue;
            int k = Uniform.m_85624_((int)this.f_173299_, (CharSequence)s);
            Uniform.m_85616_((int)k, (int)j);
            RenderSystem.m_69388_((int)(33984 + j));
            RenderSystem.m_69493_();
            Object object = this.f_173328_.get(s);
            int l = -1;
            if (object instanceof RenderTarget) {
                l = ((RenderTarget)object).m_83975_();
            } else if (object instanceof AbstractTexture) {
                l = ((AbstractTexture)object).m_117963_();
            } else if (object instanceof Integer) {
                l = (Integer)object;
            }
            if (l == -1) continue;
            RenderSystem.m_69396_((int)l);
        }
        GlStateManager.m_84538_(i);
        for (Uniform uniform : this.f_173331_) {
            uniform.m_85633_();
        }
    }

    public void m_142660_() {
        this.f_173301_ = true;
    }

    @Nullable
    public Uniform m_173348_(String p_173349_) {
        RenderSystem.m_69393_(RenderSystem::m_69586_);
        return this.f_173333_.get(p_173349_);
    }

    public AbstractUniform m_173356_(String p_173357_) {
        RenderSystem.m_69393_(RenderSystem::m_69584_);
        Uniform uniform = this.m_173348_(p_173357_);
        return uniform == null ? f_173324_ : uniform;
    }

    private void m_173366_() {
        RenderSystem.m_69393_(RenderSystem::m_69586_);
        IntArrayList intlist = new IntArrayList();
        for (int i = 0; i < this.f_173329_.size(); ++i) {
            String s = this.f_173329_.get(i);
            int j = Uniform.m_85624_((int)this.f_173299_, (CharSequence)s);
            if (j == -1) {
                f_173323_.warn("Shader {} could not find sampler named {} in the specified shader program.", (Object)this.f_173300_, (Object)s);
                this.f_173328_.remove(s);
                intlist.add(i);
                continue;
            }
            this.f_173330_.add(j);
        }
        for (int l = intlist.size() - 1; l >= 0; --l) {
            int i1 = intlist.getInt(l);
            this.f_173329_.remove(i1);
        }
        for (Uniform uniform : this.f_173331_) {
            String s1 = uniform.m_85599_();
            int k = Uniform.m_85624_((int)this.f_173299_, (CharSequence)s1);
            if (k == -1) {
                f_173323_.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.f_173300_, (Object)s1);
                continue;
            }
            this.f_173332_.add(k);
            uniform.m_85614_(k);
            this.f_173333_.put(s1, uniform);
        }
    }

    private void m_173344_(JsonElement p_173345_) {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_173345_, (String)"sampler");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        if (!GsonHelper.m_13813_((JsonObject)jsonobject, (String)"file")) {
            this.f_173328_.put(s, null);
            this.f_173329_.add(s);
        } else {
            this.f_173329_.add(s);
        }
    }

    public void m_173350_(String p_173351_, Object p_173352_) {
        this.f_173328_.put(p_173351_, p_173352_);
        this.m_142660_();
    }

    private void m_173354_(JsonElement p_173355_) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_173355_, (String)"uniform");
        String s = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        int i = Uniform.m_85629_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type"));
        int j = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = GsonHelper.m_13888_((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception);
                chainedjsonexception.m_135908_("values[" + k + "]");
                throw chainedjsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        Uniform uniform = new Uniform(s, i + l, j, (Shader)this);
        if (i <= 3) {
            uniform.m_7401_((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i <= 7) {
            uniform.m_5808_(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            uniform.m_5941_(afloat);
        }
        this.f_173331_.add(uniform);
    }

    public Program m_142733_() {
        return this.f_173305_;
    }

    public Program m_142736_() {
        return this.f_173306_;
    }

    public void m_142662_() {
        this.f_173306_.m_166610_((Shader)this);
        this.f_173305_.m_166610_((Shader)this);
    }

    public VertexFormat m_173364_() {
        return this.f_173307_;
    }

    public String m_173365_() {
        return this.f_173300_;
    }

    public int m_142658_() {
        return this.f_173299_;
    }

    static {
        f_173327_ = -1;
    }
}

