/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SimpleJsonResourceReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger f_10762_ = LogManager.getLogger();
    private static final String f_143936_ = ".json";
    private static final int f_10763_ = ".json".length();
    private final Gson f_10764_;
    private final String f_10765_;

    public SimpleJsonResourceReloadListener(Gson p_10768_, String p_10769_) {
        this.f_10764_ = p_10768_;
        this.f_10765_ = p_10769_;
    }

    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager p_10771_, ProfilerFiller p_10772_) {
        HashMap map = Maps.newHashMap();
        int i = this.f_10765_.length() + 1;
        for (ResourceLocation resourcelocation : p_10771_.m_6540_(this.f_10765_, p_10774_ -> p_10774_.endsWith(f_143936_))) {
            String s = resourcelocation.m_135815_();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.m_135827_(), s.substring(i, s.length() - f_10763_));
            try {
                Resource resource = p_10771_.m_142591_(resourcelocation);
                try {
                    InputStream inputstream = resource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                        JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)this.f_10764_, (Reader)reader, JsonElement.class);
                        if (jsonelement != null) {
                            JsonElement jsonelement1 = map.put(resourcelocation1, jsonelement);
                            if (jsonelement1 == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + resourcelocation1);
                        }
                        f_10762_.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourcelocation1, (Object)resourcelocation);
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                f_10762_.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        return map;
    }

    protected ResourceLocation getPreparedPath(ResourceLocation rl) {
        return new ResourceLocation(rl.m_135827_(), this.f_10765_ + "/" + rl.m_135815_() + f_143936_);
    }
}

