/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.newbiome.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.WeighedRandom;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.newbiome.context.Context;
import net.minecraft.world.level.newbiome.layer.Layers;
import net.minecraft.world.level.newbiome.layer.traits.C0Transformer;
import net.minecraftforge.common.BiomeManager;

public class BiomeInitLayer
implements C0Transformer {
    private static final int[] f_76685_ = new int[]{2, 4, 3, 6, 1, 5};
    private static final int[] f_76686_ = new int[]{2, 2, 2, 35, 35, 1};
    private static final int[] f_76687_ = new int[]{4, 29, 3, 1, 27, 6};
    private static final int[] f_76688_ = new int[]{4, 3, 5, 1};
    private static final int[] f_76689_ = new int[]{12, 12, 12, 30};
    private int[] f_76690_ = f_76686_;
    private final boolean legacyDesert;
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];

    public BiomeInitLayer(boolean p_76693_) {
        this.legacyDesert = p_76693_;
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            this.biomes[type.ordinal()] = new ArrayList<BiomeManager.BiomeEntry>((Collection<BiomeManager.BiomeEntry>)BiomeManager.getBiomes((BiomeManager.BiomeType)type));
        }
    }

    public int m_8006_(Context p_76695_, int p_76696_) {
        int i = (p_76696_ & 0xF00) >> 8;
        if (!Layers.m_76721_((int)(p_76696_ &= 0xFFFFF0FF)) && p_76696_ != 14) {
            switch (p_76696_) {
                case 1: {
                    if (i > 0) {
                        return p_76695_.m_5826_(3) == 0 ? 39 : 38;
                    }
                    return this.getBiomeId(BiomeManager.BiomeType.DESERT, p_76695_);
                }
                case 2: {
                    if (i > 0) {
                        return 21;
                    }
                    return this.getBiomeId(BiomeManager.BiomeType.WARM, p_76695_);
                }
                case 3: {
                    if (i > 0) {
                        return 32;
                    }
                    return this.getBiomeId(BiomeManager.BiomeType.COOL, p_76695_);
                }
                case 4: {
                    return this.getBiomeId(BiomeManager.BiomeType.ICY, p_76695_);
                }
            }
            return 14;
        }
        return p_76696_;
    }

    private int getBiomeId(BiomeManager.BiomeType type, Context context) {
        return BuiltinRegistries.f_123865_.m_7447_(BuiltinRegistries.f_123865_.m_6246_(this.getBiome(type, context)));
    }

    protected ResourceKey<Biome> getBiome(BiomeManager.BiomeType type, Context context) {
        if (type == BiomeManager.BiomeType.DESERT && this.legacyDesert) {
            type = BiomeManager.BiomeType.DESERT_LEGACY;
        }
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeighedRandom.m_14470_(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? context.m_5826_(totalWeight) : context.m_5826_(totalWeight / 10) * 10;
        return ((BiomeManager.BiomeEntry)WeighedRandom.m_145031_(biomeList, (int)weight).get()).getKey();
    }
}

