/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.jar.Manifest;
import org.cadixdev.bombe.jar.AbstractJarEntry;
import org.cadixdev.bombe.jar.JarEntryTransformer;

public class JarManifestEntry
extends AbstractJarEntry {
    private static final String NAME = "META-INF/MANIFEST.MF";
    private static final String EXTENSION = "MF";
    private final Manifest manifest;

    public JarManifestEntry(long time, Manifest manifest) {
        super(NAME, time);
        this.manifest = manifest;
    }

    public final Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public final String getExtension() {
        return EXTENSION;
    }

    @Override
    public final byte[] getContents() {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.manifest.write(baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return null;
            }
        }
        baos.close();
        return byArray;
    }

    @Override
    public JarManifestEntry accept(JarEntryTransformer vistor) {
        return vistor.transform(this);
    }
}

