/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionException;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.util.MemoryReserve;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrashReport {
    private static final Logger f_127499_ = LogManager.getLogger();
    private final String f_127500_;
    private final Throwable f_127501_;
    private final List<CrashReportCategory> f_127503_ = Lists.newArrayList();
    private File f_127504_;
    private boolean f_127505_ = true;
    private StackTraceElement[] f_127506_ = new StackTraceElement[0];
    private final SystemReport f_178624_ = new SystemReport();

    public CrashReport(String p_127509_, Throwable p_127510_) {
        this.f_127500_ = p_127509_;
        this.f_127501_ = p_127510_;
    }

    public String m_127511_() {
        return this.f_127500_;
    }

    public Throwable m_127524_() {
        return this.f_127501_;
    }

    public String m_178625_() {
        StringBuilder stringBuilder = new StringBuilder();
        this.m_127519_(stringBuilder);
        return stringBuilder.toString();
    }

    public void m_127519_(StringBuilder p_127520_) {
        if (!(this.f_127506_ != null && this.f_127506_.length > 0 || this.f_127503_.isEmpty())) {
            this.f_127506_ = (StackTraceElement[])ArrayUtils.subarray((Object[])this.f_127503_.get(0).m_128143_(), (int)0, (int)1);
        }
        if (this.f_127506_ != null && this.f_127506_.length > 0) {
            p_127520_.append("-- Head --\n");
            p_127520_.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            p_127520_.append("Stacktrace:\n");
            for (StackTraceElement stackTraceElement : this.f_127506_) {
                p_127520_.append("\t").append("at ").append(stackTraceElement);
                p_127520_.append("\n");
            }
            p_127520_.append("\n");
        }
        for (CrashReportCategory crashReportCategory : this.f_127503_) {
            crashReportCategory.m_128168_(p_127520_);
            p_127520_.append("\n\n");
        }
        this.f_178624_.m_143525_(p_127520_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String m_127525_() {
        String string;
        StringWriter stringWriter = null;
        PrintWriter \u00e2\u02dc\u01922 = null;
        Throwable \u00e2\u02dc\u01923 = this.f_127501_;
        if (\u00e2\u02dc\u01923.getMessage() == null) {
            if (\u00e2\u02dc\u01923 instanceof NullPointerException) {
                \u00e2\u02dc\u01923 = new NullPointerException(this.f_127500_);
            } else if (\u00e2\u02dc\u01923 instanceof StackOverflowError) {
                \u00e2\u02dc\u01923 = new StackOverflowError(this.f_127500_);
            } else if (\u00e2\u02dc\u01923 instanceof OutOfMemoryError) {
                \u00e2\u02dc\u01923 = new OutOfMemoryError(this.f_127500_);
            }
            \u00e2\u02dc\u01923.setStackTrace(this.f_127501_.getStackTrace());
        }
        try {
            stringWriter = new StringWriter();
            \u00e2\u02dc\u01922 = new PrintWriter(stringWriter);
            \u00e2\u02dc\u01923.printStackTrace(\u00e2\u02dc\u01922);
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Writer)stringWriter);
            IOUtils.closeQuietly(\u00e2\u02dc\u01922);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)stringWriter);
        IOUtils.closeQuietly((Writer)\u00e2\u02dc\u01922);
        return string;
    }

    public String m_127526_() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Crash Report ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(CrashReport.m_127531_());
        stringBuilder.append("\n\n");
        stringBuilder.append("Time: ");
        stringBuilder.append(new SimpleDateFormat().format(new Date()));
        stringBuilder.append("\n");
        stringBuilder.append("Description: ");
        stringBuilder.append(this.f_127500_);
        stringBuilder.append("\n\n");
        stringBuilder.append(this.m_127525_());
        stringBuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            stringBuilder.append("-");
        }
        stringBuilder.append("\n\n");
        this.m_127519_(stringBuilder);
        return stringBuilder.toString();
    }

    public File m_127527_() {
        return this.f_127504_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_127512_(File p_127513_) {
        boolean bl;
        if (this.f_127504_ != null) {
            return false;
        }
        if (p_127513_.getParentFile() != null) {
            p_127513_.getParentFile().mkdirs();
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(p_127513_), StandardCharsets.UTF_8);
            outputStreamWriter.write(this.m_127526_());
            this.f_127504_ = p_127513_;
            bl = true;
        }
        catch (Throwable \u00e2\u02dc\u01922) {
            boolean bl2;
            try {
                f_127499_.error("Could not save crash report to {}", (Object)p_127513_, (Object)\u00e2\u02dc\u01922);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)outputStreamWriter);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
        return bl;
    }

    public SystemReport m_178626_() {
        return this.f_178624_;
    }

    public CrashReportCategory m_127514_(String p_127515_) {
        return this.m_127516_(p_127515_, 1);
    }

    public CrashReportCategory m_127516_(String p_127517_, int p_127518_) {
        CrashReportCategory crashReportCategory = new CrashReportCategory(p_127517_);
        if (this.f_127505_) {
            int n = crashReportCategory.m_128148_(p_127518_);
            StackTraceElement[] \u00e2\u02dc\u01922 = this.f_127501_.getStackTrace();
            StackTraceElement \u00e2\u02dc\u01923 = null;
            StackTraceElement \u00e2\u02dc\u01924 = null;
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.length - n;
            if (\u00e2\u02dc\u0192 < 0) {
                System.out.println("Negative index in crash report handler (" + \u00e2\u02dc\u01922.length + "/" + n + ")");
            }
            if (\u00e2\u02dc\u01922 != null && 0 <= \u00e2\u02dc\u0192 && \u00e2\u02dc\u0192 < \u00e2\u02dc\u01922.length) {
                \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922[\u00e2\u02dc\u0192];
                if (\u00e2\u02dc\u01922.length + 1 - n < \u00e2\u02dc\u01922.length) {
                    \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922[\u00e2\u02dc\u01922.length + 1 - n];
                }
            }
            this.f_127505_ = crashReportCategory.m_128156_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
            if (n > 0 && !this.f_127503_.isEmpty()) {
                CrashReportCategory crashReportCategory2 = this.f_127503_.get(this.f_127503_.size() - 1);
                crashReportCategory2.m_128174_(n);
            } else if (\u00e2\u02dc\u01922 != null && \u00e2\u02dc\u01922.length >= n && 0 <= \u00e2\u02dc\u0192 && \u00e2\u02dc\u0192 < \u00e2\u02dc\u01922.length) {
                this.f_127506_ = new StackTraceElement[\u00e2\u02dc\u0192];
                System.arraycopy(\u00e2\u02dc\u01922, 0, this.f_127506_, 0, this.f_127506_.length);
            } else {
                this.f_127505_ = false;
            }
        }
        this.f_127503_.add(crashReportCategory);
        return crashReportCategory;
    }

    private static String m_127531_() {
        String[] stringArray = new String[]{"Who set us up the TNT?", "Everything's going to plan. No, really, that was supposed to happen.", "Uh... Did I do that?", "Oops.", "Why did you do that?", "I feel sad now :(", "My bad.", "I'm sorry, Dave.", "I let you down. Sorry :(", "On the bright side, I bought you a teddy bear!", "Daisy, daisy...", "Oh - I know what I did wrong!", "Hey, that tickles! Hehehe!", "I blame Dinnerbone.", "You should try our sister game, Minceraft!", "Don't be sad. I'll do better next time, I promise!", "Don't be sad, have a hug! <3", "I just don't know what went wrong :(", "Shall we play a game?", "Quite honestly, I wouldn't worry myself about that.", "I bet Cylons wouldn't have this problem.", "Sorry :(", "Surprise! Haha. Well, this is awkward.", "Would you like a cupcake?", "Hi. I'm Minecraft, and I'm a crashaholic.", "Ooh. Shiny.", "This doesn't make any sense!", "Why is it breaking :(", "Don't do that.", "Ouch. That hurt :(", "You're mean.", "This is a token for 1 free hug. Redeem at your nearest Mojangsta: [~~HUG~~]", "There are four lights!", "But it works on my machine."};
        try {
            return stringArray[(int)(Util.m_137569_() % (long)stringArray.length)];
        }
        catch (Throwable \u00e2\u02dc\u01922) {
            return "Witty comment unavailable :(";
        }
    }

    public static CrashReport m_127521_(Throwable p_127522_, String p_127523_) {
        while (p_127522_ instanceof CompletionException && p_127522_.getCause() != null) {
            p_127522_ = p_127522_.getCause();
        }
        CrashReport crashReport = p_127522_ instanceof ReportedException ? ((ReportedException)p_127522_).m_134761_() : new CrashReport(p_127523_, p_127522_);
        return crashReport;
    }

    public static void m_127529_() {
        MemoryReserve.m_182327_();
        new CrashReport("Don't panic!", new Throwable()).m_127526_();
    }
}

