/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.SharedConstants;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    private static final Pattern f_133725_ = Pattern.compile("(<name>.*) \\((<count>\\d*)\\)", 66);
    private static final int f_179920_ = 255;
    private static final Pattern f_133726_ = Pattern.compile(".*\\.|(?:COM|CLOCK\\$|CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(?:\\..*)?", 2);

    public static String m_133730_(Path p_133731_, String p_133732_, String p_133733_) throws IOException {
        for (char c : SharedConstants.f_136184_) {
            p_133732_ = ((String)p_133732_).replace(c, '_');
        }
        if (f_133726_.matcher((CharSequence)(p_133732_ = ((String)p_133732_).replaceAll("[./\"]", "_"))).matches()) {
            p_133732_ = "_" + (String)p_133732_ + "_";
        }
        Matcher matcher = f_133725_.matcher((CharSequence)p_133732_);
        int \u00e2\u02dc\u01922 = 0;
        if (matcher.matches()) {
            p_133732_ = matcher.group("name");
            \u00e2\u02dc\u01922 = Integer.parseInt(matcher.group("count"));
        }
        if (((String)p_133732_).length() > 255 - p_133733_.length()) {
            p_133732_ = ((String)p_133732_).substring(0, 255 - p_133733_.length());
        }
        while (true) {
            Object object = p_133732_;
            if (\u00e2\u02dc\u01922 != 0) {
                \u00e2\u02dc\u0192 = " (" + \u00e2\u02dc\u01922 + ")";
                int n = 255 - ((String)\u00e2\u02dc\u0192).length();
                if (((String)object).length() > n) {
                    object = ((String)object).substring(0, n);
                }
                object = (String)object + (String)\u00e2\u02dc\u0192;
            }
            object = (String)object + p_133733_;
            \u00e2\u02dc\u0192 = p_133731_.resolve((String)object);
            try {
                Path path = Files.createDirectory((Path)\u00e2\u02dc\u0192, new FileAttribute[0]);
                Files.deleteIfExists(path);
                return p_133731_.relativize(path).toString();
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                ++\u00e2\u02dc\u01922;
                continue;
            }
            break;
        }
    }

    public static boolean m_133728_(Path p_133729_) {
        Path path = p_133729_.normalize();
        return path.equals(p_133729_);
    }

    public static boolean m_133734_(Path p_133735_) {
        for (Path path : p_133735_) {
            if (!f_133726_.matcher(path.toString()).matches()) continue;
            return false;
        }
        return true;
    }

    public static Path m_133736_(Path p_133737_, String p_133738_, String p_133739_) {
        String string = p_133738_ + p_133739_;
        Path \u00e2\u02dc\u01922 = Paths.get(string, new String[0]);
        if (\u00e2\u02dc\u01922.endsWith(p_133739_)) {
            throw new InvalidPathException(string, "empty resource name");
        }
        return p_133737_.resolve(\u00e2\u02dc\u01922);
    }

    public static String m_179922_(String p_179923_) {
        return FilenameUtils.getFullPath((String)p_179923_).replace(File.separator, "/");
    }

    public static String m_179924_(String p_179925_) {
        return FilenameUtils.normalize((String)p_179925_).replace(File.separator, "/");
    }
}

