/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.ArrayUtils;

public class Advancement {
    private final Advancement f_138298_;
    private final DisplayInfo f_138299_;
    private final AdvancementRewards f_138300_;
    private final ResourceLocation f_138301_;
    private final Map<String, Criterion> f_138302_;
    private final String[][] f_138303_;
    private final Set<Advancement> f_138304_ = Sets.newLinkedHashSet();
    private final Component f_138305_;

    public Advancement(ResourceLocation p_138307_, @Nullable Advancement p_138308_, @Nullable DisplayInfo p_138309_, AdvancementRewards p_138310_, Map<String, Criterion> p_138311_, String[][] p_138312_) {
        this.f_138301_ = p_138307_;
        this.f_138299_ = p_138309_;
        this.f_138302_ = ImmutableMap.copyOf(p_138311_);
        this.f_138298_ = p_138308_;
        this.f_138300_ = p_138310_;
        this.f_138303_ = p_138312_;
        if (p_138308_ != null) {
            p_138308_.m_138317_(this);
        }
        if (p_138309_ == null) {
            this.f_138305_ = new TextComponent(p_138307_.toString());
        } else {
            Component component = p_138309_.m_14977_();
            ChatFormatting \u00e2\u02dc\u01922 = p_138309_.m_14992_().m_15552_();
            MutableComponent \u00e2\u02dc\u01923 = ComponentUtils.m_130750_(component.m_6881_(), Style.f_131099_.m_131140_(\u00e2\u02dc\u01922)).m_130946_("\n").m_7220_(p_138309_.m_14985_());
            MutableComponent \u00e2\u02dc\u01924 = component.m_6881_().m_130938_(p_138316_ -> p_138316_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, \u00e2\u02dc\u01923)));
            this.f_138305_ = ComponentUtils.m_130748_(\u00e2\u02dc\u01924).m_130940_(\u00e2\u02dc\u01922);
        }
    }

    public Builder m_138313_() {
        return new Builder(this.f_138298_ == null ? null : this.f_138298_.m_138327_(), this.f_138299_, this.f_138300_, this.f_138302_, this.f_138303_);
    }

    @Nullable
    public Advancement m_138319_() {
        return this.f_138298_;
    }

    @Nullable
    public DisplayInfo m_138320_() {
        return this.f_138299_;
    }

    public AdvancementRewards m_138321_() {
        return this.f_138300_;
    }

    public String toString() {
        return "SimpleAdvancement{id=" + this.m_138327_() + ", parent=" + (Comparable)(this.f_138298_ == null ? "null" : this.f_138298_.m_138327_()) + ", display=" + this.f_138299_ + ", rewards=" + this.f_138300_ + ", criteria=" + this.f_138302_ + ", requirements=" + Arrays.deepToString((Object[])this.f_138303_) + "}";
    }

    public Iterable<Advancement> m_138322_() {
        return this.f_138304_;
    }

    public Map<String, Criterion> m_138325_() {
        return this.f_138302_;
    }

    public int m_138326_() {
        return this.f_138303_.length;
    }

    public void m_138317_(Advancement p_138318_) {
        this.f_138304_.add(p_138318_);
    }

    public ResourceLocation m_138327_() {
        return this.f_138301_;
    }

    public boolean equals(Object p_138324_) {
        if (this == p_138324_) {
            return true;
        }
        if (!(p_138324_ instanceof Advancement)) {
            return false;
        }
        Advancement advancement = (Advancement)p_138324_;
        return this.f_138301_.equals(advancement.f_138301_);
    }

    public int hashCode() {
        return this.f_138301_.hashCode();
    }

    public String[][] m_138329_() {
        return this.f_138303_;
    }

    public Component m_138330_() {
        return this.f_138305_;
    }

    public static class Builder {
        private ResourceLocation f_138332_;
        private Advancement f_138333_;
        private DisplayInfo f_138334_;
        private AdvancementRewards f_138335_ = AdvancementRewards.f_9978_;
        private Map<String, Criterion> f_138336_ = Maps.newLinkedHashMap();
        private String[][] f_138337_;
        private RequirementsStrategy f_138338_ = RequirementsStrategy.f_15978_;

        Builder(@Nullable ResourceLocation p_138341_, @Nullable DisplayInfo p_138342_, AdvancementRewards p_138343_, Map<String, Criterion> p_138344_, String[][] p_138345_) {
            this.f_138332_ = p_138341_;
            this.f_138334_ = p_138342_;
            this.f_138335_ = p_138343_;
            this.f_138336_ = p_138344_;
            this.f_138337_ = p_138345_;
        }

        private Builder() {
        }

        public static Builder m_138353_() {
            return new Builder();
        }

        public Builder m_138398_(Advancement p_138399_) {
            this.f_138333_ = p_138399_;
            return this;
        }

        public Builder m_138396_(ResourceLocation p_138397_) {
            this.f_138332_ = p_138397_;
            return this;
        }

        public Builder m_138362_(ItemStack p_138363_, Component p_138364_, Component p_138365_, @Nullable ResourceLocation p_138366_, FrameType p_138367_, boolean p_138368_, boolean p_138369_, boolean p_138370_) {
            return this.m_138358_(new DisplayInfo(p_138363_, p_138364_, p_138365_, p_138366_, p_138367_, p_138368_, p_138369_, p_138370_));
        }

        public Builder m_138371_(ItemLike p_138372_, Component p_138373_, Component p_138374_, @Nullable ResourceLocation p_138375_, FrameType p_138376_, boolean p_138377_, boolean p_138378_, boolean p_138379_) {
            return this.m_138358_(new DisplayInfo(new ItemStack(p_138372_.m_5456_()), p_138373_, p_138374_, p_138375_, p_138376_, p_138377_, p_138378_, p_138379_));
        }

        public Builder m_138358_(DisplayInfo p_138359_) {
            this.f_138334_ = p_138359_;
            return this;
        }

        public Builder m_138354_(AdvancementRewards.Builder p_138355_) {
            return this.m_138356_(p_138355_.m_10004_());
        }

        public Builder m_138356_(AdvancementRewards p_138357_) {
            this.f_138335_ = p_138357_;
            return this;
        }

        public Builder m_138386_(String p_138387_, CriterionTriggerInstance p_138388_) {
            return this.m_138383_(p_138387_, new Criterion(p_138388_));
        }

        public Builder m_138383_(String p_138384_, Criterion p_138385_) {
            if (this.f_138336_.containsKey(p_138384_)) {
                throw new IllegalArgumentException("Duplicate criterion " + p_138384_);
            }
            this.f_138336_.put(p_138384_, p_138385_);
            return this;
        }

        public Builder m_138360_(RequirementsStrategy p_138361_) {
            this.f_138338_ = p_138361_;
            return this;
        }

        public Builder m_143951_(String[][] p_143952_) {
            this.f_138337_ = p_143952_;
            return this;
        }

        public boolean m_138392_(Function<ResourceLocation, Advancement> p_138393_) {
            if (this.f_138332_ == null) {
                return true;
            }
            if (this.f_138333_ == null) {
                this.f_138333_ = p_138393_.apply(this.f_138332_);
            }
            return this.f_138333_ != null;
        }

        public Advancement m_138403_(ResourceLocation p_138404_) {
            if (!this.m_138392_(p_138407_ -> null)) {
                throw new IllegalStateException("Tried to build incomplete advancement!");
            }
            if (this.f_138337_ == null) {
                this.f_138337_ = this.f_138338_.m_15985_(this.f_138336_.keySet());
            }
            return new Advancement(p_138404_, this.f_138333_, this.f_138334_, this.f_138335_, this.f_138336_, this.f_138337_);
        }

        public Advancement m_138389_(Consumer<Advancement> p_138390_, String p_138391_) {
            Advancement advancement = this.m_138403_(new ResourceLocation(p_138391_));
            p_138390_.accept(advancement);
            return advancement;
        }

        public JsonObject m_138400_() {
            if (this.f_138337_ == null) {
                this.f_138337_ = this.f_138338_.m_15985_(this.f_138336_.keySet());
            }
            JsonObject jsonObject = new JsonObject();
            if (this.f_138333_ != null) {
                jsonObject.addProperty("parent", this.f_138333_.m_138327_().toString());
            } else if (this.f_138332_ != null) {
                jsonObject.addProperty("parent", this.f_138332_.toString());
            }
            if (this.f_138334_ != null) {
                jsonObject.add("display", this.f_138334_.m_14998_());
            }
            jsonObject.add("rewards", this.f_138335_.m_9997_());
            \u00e2\u02dc\u0192 = new JsonObject();
            for (Map.Entry<String, Criterion> entry : this.f_138336_.entrySet()) {
                \u00e2\u02dc\u0192.add(entry.getKey(), entry.getValue().m_11425_());
            }
            jsonObject.add("criteria", (JsonElement)\u00e2\u02dc\u0192);
            JsonArray \u00e2\u02dc\u01922 = new JsonArray();
            for (String[] stringArray : this.f_138337_) {
                JsonArray jsonArray = new JsonArray();
                for (String string : stringArray) {
                    jsonArray.add(string);
                }
                \u00e2\u02dc\u01922.add((JsonElement)jsonArray);
            }
            jsonObject.add("requirements", (JsonElement)\u00e2\u02dc\u01922);
            return jsonObject;
        }

        public void m_138394_(FriendlyByteBuf p_138395_) {
            if (this.f_138332_ == null) {
                p_138395_.writeBoolean(false);
            } else {
                p_138395_.writeBoolean(true);
                p_138395_.m_130085_(this.f_138332_);
            }
            if (this.f_138334_ == null) {
                p_138395_.writeBoolean(false);
            } else {
                p_138395_.writeBoolean(true);
                this.f_138334_.m_14983_(p_138395_);
            }
            Criterion.m_11420_(this.f_138336_, p_138395_);
            p_138395_.m_130130_(this.f_138337_.length);
            for (String[] stringArray : this.f_138337_) {
                p_138395_.m_130130_(stringArray.length);
                for (String string : stringArray) {
                    p_138395_.m_130070_(string);
                }
            }
        }

        public String toString() {
            return "Task Advancement{parentId=" + this.f_138332_ + ", display=" + this.f_138334_ + ", rewards=" + this.f_138335_ + ", criteria=" + this.f_138336_ + ", requirements=" + Arrays.deepToString((Object[])this.f_138337_) + "}";
        }

        public static Builder m_138380_(JsonObject p_138381_, DeserializationContext p_138382_) {
            ResourceLocation resourceLocation = p_138381_.has("parent") ? new ResourceLocation(GsonHelper.m_13906_(p_138381_, "parent")) : null;
            DisplayInfo \u00e2\u02dc\u01922 = p_138381_.has("display") ? DisplayInfo.m_14981_(GsonHelper.m_13930_(p_138381_, "display")) : null;
            AdvancementRewards \u00e2\u02dc\u01923 = p_138381_.has("rewards") ? AdvancementRewards.m_9991_(GsonHelper.m_13930_(p_138381_, "rewards")) : AdvancementRewards.f_9978_;
            Map<String, Criterion> \u00e2\u02dc\u01924 = Criterion.m_11426_(GsonHelper.m_13930_(p_138381_, "criteria"), p_138382_);
            if (\u00e2\u02dc\u01924.isEmpty()) {
                throw new JsonSyntaxException("Advancement criteria cannot be empty");
            }
            JsonArray \u00e2\u02dc\u01925 = GsonHelper.m_13832_(p_138381_, "requirements", new JsonArray());
            String[][] \u00e2\u02dc\u01926 = new String[\u00e2\u02dc\u01925.size()][];
            for (int n = 0; n < \u00e2\u02dc\u01925.size(); ++n) {
                JsonArray jsonArray = GsonHelper.m_13924_(\u00e2\u02dc\u01925.get(n), "requirements[" + n + "]");
                \u00e2\u02dc\u01926[n] = new String[jsonArray.size()];
                for (int i = 0; i < jsonArray.size(); ++i) {
                    \u00e2\u02dc\u01926[n][i] = GsonHelper.m_13805_(jsonArray.get(i), "requirements[" + n + "][" + i + "]");
                }
            }
            if (\u00e2\u02dc\u01926.length == 0) {
                \u00e2\u02dc\u01926 = new String[\u00e2\u02dc\u01924.size()][];
                int n = 0;
                for (String string3 : \u00e2\u02dc\u01924.keySet()) {
                    \u00e2\u02dc\u01926[n++] = new String[]{string3};
                }
            }
            for (String[] stringArray : \u00e2\u02dc\u01926) {
                if (stringArray.length == 0 && \u00e2\u02dc\u01924.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] stringArray2 = stringArray;
                int n2 = stringArray2.length;
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray2[i];
                    if (\u00e2\u02dc\u01924.containsKey(string)) continue;
                    throw new JsonSyntaxException("Unknown required criterion '" + string + "'");
                }
            }
            for (String string2 : \u00e2\u02dc\u01924.keySet()) {
                boolean bl = false;
                for (Object[] objectArray : \u00e2\u02dc\u01926) {
                    if (!ArrayUtils.contains((Object[])objectArray, (Object)string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new JsonSyntaxException("Criterion '" + string2 + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            return new Builder(resourceLocation, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01926);
        }

        public static Builder m_138401_(FriendlyByteBuf p_138402_) {
            ResourceLocation resourceLocation = p_138402_.readBoolean() ? p_138402_.m_130281_() : null;
            DisplayInfo \u00e2\u02dc\u01922 = p_138402_.readBoolean() ? DisplayInfo.m_14988_(p_138402_) : null;
            Map<String, Criterion> \u00e2\u02dc\u01923 = Criterion.m_11431_(p_138402_);
            String[][] \u00e2\u02dc\u01924 = new String[p_138402_.m_130242_()][];
            for (int i = 0; i < \u00e2\u02dc\u01924.length; ++i) {
                \u00e2\u02dc\u01924[i] = new String[p_138402_.m_130242_()];
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < \u00e2\u02dc\u01924[i].length; ++\u00e2\u02dc\u0192) {
                    \u00e2\u02dc\u01924[i][\u00e2\u02dc\u0192] = p_138402_.m_130277_();
                }
            }
            return new Builder(resourceLocation, \u00e2\u02dc\u01922, AdvancementRewards.f_9978_, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
        }

        public Map<String, Criterion> m_138405_() {
            return this.f_138336_;
        }
    }
}

