/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockPredicate {
    public static final BlockPredicate f_17902_ = new BlockPredicate(null, null, StatePropertiesPredicate.f_67658_, NbtPredicate.f_57471_);
    @Nullable
    private final Tag<Block> f_17903_;
    @Nullable
    private final Set<Block> f_146710_;
    private final StatePropertiesPredicate f_17905_;
    private final NbtPredicate f_17906_;

    public BlockPredicate(@Nullable Tag<Block> p_146712_, @Nullable Set<Block> p_146713_, StatePropertiesPredicate p_146714_, NbtPredicate p_146715_) {
        this.f_17903_ = p_146712_;
        this.f_146710_ = p_146713_;
        this.f_17905_ = p_146714_;
        this.f_17906_ = p_146715_;
    }

    public boolean m_17914_(ServerLevel p_17915_, BlockPos p_17916_) {
        if (this == f_17902_) {
            return true;
        }
        if (!p_17915_.m_46749_(p_17916_)) {
            return false;
        }
        BlockState blockState = p_17915_.m_8055_(p_17916_);
        if (this.f_17903_ != null && !blockState.m_60620_(this.f_17903_)) {
            return false;
        }
        if (this.f_146710_ != null && !this.f_146710_.contains(blockState.m_60734_())) {
            return false;
        }
        if (!this.f_17905_.m_67667_(blockState)) {
            return false;
        }
        return this.f_17906_ == NbtPredicate.f_57471_ || (\u00e2\u02dc\u0192 = p_17915_.m_7702_(p_17916_)) != null && this.f_17906_.m_57483_(\u00e2\u02dc\u0192.m_6945_(new CompoundTag()));
    }

    public static BlockPredicate m_17917_(@Nullable JsonElement p_17918_) {
        Object object;
        if (p_17918_ == null || p_17918_.isJsonNull()) {
            return f_17902_;
        }
        JsonObject jsonObject = GsonHelper.m_13918_(p_17918_, "block");
        NbtPredicate \u00e2\u02dc\u01922 = NbtPredicate.m_57481_(jsonObject.get("nbt"));
        ImmutableSet \u00e2\u02dc\u01923 = null;
        JsonArray \u00e2\u02dc\u01924 = GsonHelper.m_13832_(jsonObject, "blocks", null);
        if (\u00e2\u02dc\u01924 != null) {
            object = ImmutableSet.builder();
            for (JsonElement jsonElement : \u00e2\u02dc\u01924) {
                ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13805_(jsonElement, "block"));
                object.add((Object)Registry.f_122824_.m_6612_(resourceLocation).orElseThrow(() -> new JsonSyntaxException("Unknown block id '" + resourceLocation + "'")));
            }
            \u00e2\u02dc\u01923 = object.build();
        }
        object = null;
        if (jsonObject.has("tag")) {
            \u00e2\u02dc\u0192 = new ResourceLocation(GsonHelper.m_13906_(jsonObject, "tag"));
            object = SerializationTags.m_13199_().m_144458_(Registry.f_122901_, (ResourceLocation)\u00e2\u02dc\u0192, p_146717_ -> new JsonSyntaxException("Unknown block tag '" + p_146717_ + "'"));
        }
        \u00e2\u02dc\u0192 = StatePropertiesPredicate.m_67679_(jsonObject.get("state"));
        return new BlockPredicate((Tag<Block>)object, (Set<Block>)\u00e2\u02dc\u01923, (StatePropertiesPredicate)\u00e2\u02dc\u0192, \u00e2\u02dc\u01922);
    }

    public JsonElement m_17913_() {
        if (this == f_17902_) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.f_146710_ != null) {
            JsonArray jsonArray = new JsonArray();
            for (Block block : this.f_146710_) {
                jsonArray.add(Registry.f_122824_.m_7981_(block).toString());
            }
            jsonObject.add("blocks", (JsonElement)jsonArray);
        }
        if (this.f_17903_ != null) {
            jsonObject.addProperty("tag", SerializationTags.m_13199_().m_144454_(Registry.f_122901_, this.f_17903_, () -> new IllegalStateException("Unknown block tag")).toString());
        }
        jsonObject.add("nbt", this.f_17906_.m_57476_());
        jsonObject.add("state", this.f_17905_.m_67666_());
        return jsonObject;
    }

    public static class Builder {
        @Nullable
        private Set<Block> f_17920_;
        @Nullable
        private Tag<Block> f_146721_;
        private StatePropertiesPredicate f_17921_ = StatePropertiesPredicate.f_67658_;
        private NbtPredicate f_17922_ = NbtPredicate.f_57471_;

        private Builder() {
        }

        public static Builder m_17924_() {
            return new Builder();
        }

        public Builder m_146726_(Block ... p_146727_) {
            this.f_17920_ = ImmutableSet.copyOf((Object[])p_146727_);
            return this;
        }

        public Builder m_146722_(Iterable<Block> p_146723_) {
            this.f_17920_ = ImmutableSet.copyOf(p_146723_);
            return this;
        }

        public Builder m_17925_(Tag<Block> p_17926_) {
            this.f_146721_ = p_17926_;
            return this;
        }

        public Builder m_146724_(CompoundTag p_146725_) {
            this.f_17922_ = new NbtPredicate(p_146725_);
            return this;
        }

        public Builder m_17929_(StatePropertiesPredicate p_17930_) {
            this.f_17921_ = p_17930_;
            return this;
        }

        public BlockPredicate m_17931_() {
            return new BlockPredicate(this.f_146721_, this.f_17920_, this.f_17921_, this.f_17922_);
        }
    }
}

