/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class ItemPredicate {
    public static final ItemPredicate f_45028_ = new ItemPredicate();
    @Nullable
    private final Tag<Item> f_45029_;
    @Nullable
    private final Set<Item> f_151427_;
    private final MinMaxBounds.Ints f_45031_;
    private final MinMaxBounds.Ints f_45032_;
    private final EnchantmentPredicate[] f_45033_;
    private final EnchantmentPredicate[] f_45034_;
    @Nullable
    private final Potion f_45035_;
    private final NbtPredicate f_45036_;

    public ItemPredicate() {
        this.f_45029_ = null;
        this.f_151427_ = null;
        this.f_45035_ = null;
        this.f_45031_ = MinMaxBounds.Ints.f_55364_;
        this.f_45032_ = MinMaxBounds.Ints.f_55364_;
        this.f_45033_ = EnchantmentPredicate.f_30465_;
        this.f_45034_ = EnchantmentPredicate.f_30465_;
        this.f_45036_ = NbtPredicate.f_57471_;
    }

    public ItemPredicate(@Nullable Tag<Item> p_151429_, @Nullable Set<Item> p_151430_, MinMaxBounds.Ints p_151431_, MinMaxBounds.Ints p_151432_, EnchantmentPredicate[] p_151433_, EnchantmentPredicate[] p_151434_, @Nullable Potion p_151435_, NbtPredicate p_151436_) {
        this.f_45029_ = p_151429_;
        this.f_151427_ = p_151430_;
        this.f_45031_ = p_151431_;
        this.f_45032_ = p_151432_;
        this.f_45033_ = p_151433_;
        this.f_45034_ = p_151434_;
        this.f_45035_ = p_151435_;
        this.f_45036_ = p_151436_;
    }

    public boolean m_45049_(ItemStack p_45050_) {
        Map<Enchantment, Integer> map;
        if (this == f_45028_) {
            return true;
        }
        if (this.f_45029_ != null && !p_45050_.m_150922_(this.f_45029_)) {
            return false;
        }
        if (this.f_151427_ != null && !this.f_151427_.contains(p_45050_.m_41720_())) {
            return false;
        }
        if (!this.f_45031_.m_55390_(p_45050_.m_41613_())) {
            return false;
        }
        if (!this.f_45032_.m_55327_() && !p_45050_.m_41763_()) {
            return false;
        }
        if (!this.f_45032_.m_55390_(p_45050_.m_41776_() - p_45050_.m_41773_())) {
            return false;
        }
        if (!this.f_45036_.m_57479_(p_45050_)) {
            return false;
        }
        if (this.f_45033_.length > 0) {
            map = EnchantmentHelper.m_44882_(p_45050_.m_41785_());
            for (EnchantmentPredicate enchantmentPredicate : this.f_45033_) {
                if (enchantmentPredicate.m_30476_(map)) continue;
                return false;
            }
        }
        if (this.f_45034_.length > 0) {
            map = EnchantmentHelper.m_44882_(EnchantedBookItem.m_41163_(p_45050_));
            for (EnchantmentPredicate enchantmentPredicate : this.f_45034_) {
                if (enchantmentPredicate.m_30476_(map)) continue;
                return false;
            }
        }
        map = PotionUtils.m_43579_(p_45050_);
        return this.f_45035_ == null || this.f_45035_ == map;
    }

    public static ItemPredicate m_45051_(@Nullable JsonElement p_45052_) {
        Object \u00e2\u02dc\u01927;
        Object object;
        if (p_45052_ == null || p_45052_.isJsonNull()) {
            return f_45028_;
        }
        JsonObject jsonObject = GsonHelper.m_13918_(p_45052_, "item");
        MinMaxBounds.Ints \u00e2\u02dc\u01922 = MinMaxBounds.Ints.m_55373_(jsonObject.get("count"));
        MinMaxBounds.Ints \u00e2\u02dc\u01923 = MinMaxBounds.Ints.m_55373_(jsonObject.get("durability"));
        if (jsonObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        NbtPredicate \u00e2\u02dc\u01924 = NbtPredicate.m_57481_(jsonObject.get("nbt"));
        ImmutableSet \u00e2\u02dc\u01925 = null;
        JsonArray \u00e2\u02dc\u01926 = GsonHelper.m_13832_(jsonObject, "items", null);
        if (\u00e2\u02dc\u01926 != null) {
            object = ImmutableSet.builder();
            for (EnchantmentPredicate[] enchantmentPredicateArray : \u00e2\u02dc\u01926) {
                \u00e2\u02dc\u0192 = new ResourceLocation(GsonHelper.m_13805_((JsonElement)enchantmentPredicateArray, "item"));
                object.add((Object)Registry.f_122827_.m_6612_((ResourceLocation)\u00e2\u02dc\u0192).orElseThrow(() -> ItemPredicate.m_45057_((ResourceLocation)\u00e2\u02dc\u0192)));
            }
            \u00e2\u02dc\u01925 = object.build();
        }
        object = null;
        if (jsonObject.has("tag")) {
            \u00e2\u02dc\u01927 = new ResourceLocation(GsonHelper.m_13906_(jsonObject, "tag"));
            object = SerializationTags.m_13199_().m_144458_(Registry.f_122904_, (ResourceLocation)\u00e2\u02dc\u01927, p_45054_ -> new JsonSyntaxException("Unknown item tag '" + p_45054_ + "'"));
        }
        \u00e2\u02dc\u01927 = null;
        if (jsonObject.has("potion")) {
            EnchantmentPredicate[] enchantmentPredicateArray;
            enchantmentPredicateArray = new ResourceLocation(GsonHelper.m_13906_(jsonObject, "potion"));
            \u00e2\u02dc\u01927 = Registry.f_122828_.m_6612_((ResourceLocation)enchantmentPredicateArray).orElseThrow(() -> ItemPredicate.m_151437_((ResourceLocation)enchantmentPredicateArray));
        }
        enchantmentPredicateArray = EnchantmentPredicate.m_30480_(jsonObject.get("enchantments"));
        \u00e2\u02dc\u0192 = EnchantmentPredicate.m_30480_(jsonObject.get("stored_enchantments"));
        return new ItemPredicate((Tag<Item>)object, (Set<Item>)\u00e2\u02dc\u01925, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, enchantmentPredicateArray, \u00e2\u02dc\u0192, (Potion)\u00e2\u02dc\u01927, \u00e2\u02dc\u01924);
    }

    public JsonElement m_45048_() {
        JsonArray jsonArray;
        if (this == f_45028_) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.f_151427_ != null) {
            jsonArray = new JsonArray();
            for (Item item : this.f_151427_) {
                jsonArray.add(Registry.f_122827_.m_7981_(item).toString());
            }
            jsonObject.add("items", (JsonElement)jsonArray);
        }
        if (this.f_45029_ != null) {
            jsonObject.addProperty("tag", SerializationTags.m_13199_().m_144454_(Registry.f_122904_, this.f_45029_, () -> new IllegalStateException("Unknown item tag")).toString());
        }
        jsonObject.add("count", this.f_45031_.m_55328_());
        jsonObject.add("durability", this.f_45032_.m_55328_());
        jsonObject.add("nbt", this.f_45036_.m_57476_());
        if (this.f_45033_.length > 0) {
            jsonArray = new JsonArray();
            for (EnchantmentPredicate enchantmentPredicate : this.f_45033_) {
                jsonArray.add(enchantmentPredicate.m_30473_());
            }
            jsonObject.add("enchantments", (JsonElement)jsonArray);
        }
        if (this.f_45034_.length > 0) {
            jsonArray = new JsonArray();
            for (EnchantmentPredicate enchantmentPredicate : this.f_45034_) {
                jsonArray.add(enchantmentPredicate.m_30473_());
            }
            jsonObject.add("stored_enchantments", (JsonElement)jsonArray);
        }
        if (this.f_45035_ != null) {
            jsonObject.addProperty("potion", Registry.f_122828_.m_7981_(this.f_45035_).toString());
        }
        return jsonObject;
    }

    public static ItemPredicate[] m_45055_(@Nullable JsonElement p_45056_) {
        if (p_45056_ == null || p_45056_.isJsonNull()) {
            return new ItemPredicate[0];
        }
        JsonArray jsonArray = GsonHelper.m_13924_(p_45056_, "items");
        ItemPredicate[] \u00e2\u02dc\u01922 = new ItemPredicate[jsonArray.size()];
        for (int i = 0; i < \u00e2\u02dc\u01922.length; ++i) {
            \u00e2\u02dc\u01922[i] = ItemPredicate.m_45051_(jsonArray.get(i));
        }
        return \u00e2\u02dc\u01922;
    }

    private static /* synthetic */ JsonSyntaxException m_151437_(ResourceLocation p_151438_) {
        return new JsonSyntaxException("Unknown potion '" + p_151438_ + "'");
    }

    private static /* synthetic */ JsonSyntaxException m_45057_(ResourceLocation p_45058_) {
        return new JsonSyntaxException("Unknown item id '" + p_45058_ + "'");
    }

    public static class Builder {
        private final List<EnchantmentPredicate> f_45059_ = Lists.newArrayList();
        private final List<EnchantmentPredicate> f_45060_ = Lists.newArrayList();
        @Nullable
        private Set<Item> f_151440_;
        @Nullable
        private Tag<Item> f_45062_;
        private MinMaxBounds.Ints f_45063_ = MinMaxBounds.Ints.f_55364_;
        private MinMaxBounds.Ints f_45064_ = MinMaxBounds.Ints.f_55364_;
        @Nullable
        private Potion f_45065_;
        private NbtPredicate f_45066_ = NbtPredicate.f_57471_;

        private Builder() {
        }

        public static Builder m_45068_() {
            return new Builder();
        }

        public Builder m_151445_(ItemLike ... p_151446_) {
            this.f_151440_ = (Set)Stream.of(p_151446_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
            return this;
        }

        public Builder m_45069_(Tag<Item> p_45070_) {
            this.f_45062_ = p_45070_;
            return this;
        }

        public Builder m_151443_(MinMaxBounds.Ints p_151444_) {
            this.f_45063_ = p_151444_;
            return this;
        }

        public Builder m_151449_(MinMaxBounds.Ints p_151450_) {
            this.f_45064_ = p_151450_;
            return this;
        }

        public Builder m_151441_(Potion p_151442_) {
            this.f_45065_ = p_151442_;
            return this;
        }

        public Builder m_45075_(CompoundTag p_45076_) {
            this.f_45066_ = new NbtPredicate(p_45076_);
            return this;
        }

        public Builder m_45071_(EnchantmentPredicate p_45072_) {
            this.f_45059_.add(p_45072_);
            return this;
        }

        public Builder m_151447_(EnchantmentPredicate p_151448_) {
            this.f_45060_.add(p_151448_);
            return this;
        }

        public ItemPredicate m_45077_() {
            return new ItemPredicate(this.f_45062_, this.f_151440_, this.f_45063_, this.f_45064_, this.f_45059_.toArray(EnchantmentPredicate.f_30465_), this.f_45060_.toArray(EnchantmentPredicate.f_30465_), this.f_45065_, this.f_45066_);
        }
    }
}

