/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PlayerPredicate {
    public static final PlayerPredicate f_62244_ = new Builder().m_62313_();
    public static final int f_156743_ = 100;
    private final MinMaxBounds.Ints f_62245_;
    @Nullable
    private final GameType f_62246_;
    private final Map<Stat<?>, MinMaxBounds.Ints> f_62247_;
    private final Object2BooleanMap<ResourceLocation> f_62248_;
    private final Map<ResourceLocation, AdvancementPredicate> f_62249_;
    private final EntityPredicate f_156744_;

    private static AdvancementPredicate m_62289_(JsonElement p_62290_) {
        if (p_62290_.isJsonPrimitive()) {
            boolean bl = p_62290_.getAsBoolean();
            return new AdvancementDonePredicate(bl);
        }
        Object2BooleanOpenHashMap object2BooleanOpenHashMap = new Object2BooleanOpenHashMap();
        JsonObject \u00e2\u02dc\u01922 = GsonHelper.m_13918_(p_62290_, "criterion data");
        \u00e2\u02dc\u01922.entrySet().forEach(arg_0 -> PlayerPredicate.m_62286_((Object2BooleanMap)object2BooleanOpenHashMap, arg_0));
        return new AdvancementCriterionsPredicate((Object2BooleanMap<String>)object2BooleanOpenHashMap);
    }

    PlayerPredicate(MinMaxBounds.Ints p_156746_, @Nullable GameType p_156747_, Map<Stat<?>, MinMaxBounds.Ints> p_156748_, Object2BooleanMap<ResourceLocation> p_156749_, Map<ResourceLocation, AdvancementPredicate> p_156750_, EntityPredicate p_156751_) {
        this.f_62245_ = p_156746_;
        this.f_62246_ = p_156747_;
        this.f_62247_ = p_156748_;
        this.f_62248_ = p_156749_;
        this.f_62249_ = p_156750_;
        this.f_156744_ = p_156751_;
    }

    public boolean m_62270_(Entity p_62271_) {
        if (this == f_62244_) {
            return true;
        }
        if (!(p_62271_ instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)p_62271_;
        if (!this.f_62245_.m_55390_(serverPlayer.f_36078_)) {
            return false;
        }
        if (this.f_62246_ != null && this.f_62246_ != serverPlayer.f_8941_.m_9290_()) {
            return false;
        }
        ServerStatsCounter \u00e2\u02dc\u01922 = serverPlayer.m_8951_();
        for (Map.Entry<Stat<?>, MinMaxBounds.Ints> entry : this.f_62247_.entrySet()) {
            int n = \u00e2\u02dc\u01922.m_13015_(entry.getKey());
            if (entry.getValue().m_55390_(n)) continue;
            return false;
        }
        ServerRecipeBook \u00e2\u02dc\u01923 = serverPlayer.m_8952_();
        for (Object2BooleanMap.Entry entry : this.f_62248_.object2BooleanEntrySet()) {
            if (\u00e2\u02dc\u01923.m_12711_((ResourceLocation)entry.getKey()) == entry.getBooleanValue()) continue;
            return false;
        }
        if (!this.f_62249_.isEmpty()) {
            PlayerAdvancements playerAdvancements = serverPlayer.m_8960_();
            ServerAdvancementManager \u00e2\u02dc\u01925 = serverPlayer.m_20194_().m_129889_();
            for (Map.Entry<ResourceLocation, AdvancementPredicate> entry : this.f_62249_.entrySet()) {
                Advancement \u00e2\u02dc\u01929 = \u00e2\u02dc\u01925.m_136041_(entry.getKey());
                if (\u00e2\u02dc\u01929 != null && entry.getValue().test(playerAdvancements.m_135996_(\u00e2\u02dc\u01929))) continue;
                return false;
            }
        }
        if (this.f_156744_ != EntityPredicate.f_36550_) {
            Vec3 vec3 = serverPlayer.m_146892_();
            Vec3 \u00e2\u02dc\u01926 = serverPlayer.m_20252_(1.0f);
            Vec3 \u00e2\u02dc\u01927 = vec3.m_82520_(\u00e2\u02dc\u01926.f_82479_ * 100.0, \u00e2\u02dc\u01926.f_82480_ * 100.0, \u00e2\u02dc\u01926.f_82481_ * 100.0);
            EntityHitResult entityHitResult = ProjectileUtil.m_150175_(serverPlayer.f_19853_, serverPlayer, vec3, \u00e2\u02dc\u01927, new AABB(vec3, \u00e2\u02dc\u01927).m_82400_(1.0), p_156765_ -> !p_156765_.m_5833_(), 0.0f);
            if (entityHitResult == null || entityHitResult.m_6662_() != HitResult.Type.ENTITY) {
                return false;
            }
            Entity entity = entityHitResult.m_82443_();
            if (!this.f_156744_.m_36611_(serverPlayer, entity) || !serverPlayer.m_142582_(entity)) {
                return false;
            }
        }
        return true;
    }

    public static PlayerPredicate m_62276_(@Nullable JsonElement p_62277_) {
        StatType<?> \u00e2\u02dc\u01927;
        Object object;
        JsonElement \u00e2\u02dc\u019292;
        if (p_62277_ == null || p_62277_.isJsonNull()) {
            return f_62244_;
        }
        JsonObject jsonObject = GsonHelper.m_13918_(p_62277_, "player");
        MinMaxBounds.Ints \u00e2\u02dc\u01922 = MinMaxBounds.Ints.m_55373_(jsonObject.get("level"));
        String \u00e2\u02dc\u01923 = GsonHelper.m_13851_(jsonObject, "gamemode", "");
        GameType \u00e2\u02dc\u01924 = GameType.m_46402_(\u00e2\u02dc\u01923, null);
        HashMap \u00e2\u02dc\u01925 = Maps.newHashMap();
        JsonArray \u00e2\u02dc\u01926 = GsonHelper.m_13832_(jsonObject, "stats", null);
        if (\u00e2\u02dc\u01926 != null) {
            for (JsonElement \u00e2\u02dc\u019292 : \u00e2\u02dc\u01926) {
                object = GsonHelper.m_13918_(\u00e2\u02dc\u019292, "stats entry");
                object2 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, "type"));
                \u00e2\u02dc\u01927 = Registry.f_122867_.m_7745_((ResourceLocation)object2);
                if (\u00e2\u02dc\u01927 == null) {
                    throw new JsonParseException("Invalid stat type: " + (ResourceLocation)object2);
                }
                ResourceLocation \u00e2\u02dc\u01928 = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, "stat"));
                object3 = PlayerPredicate.m_62267_(\u00e2\u02dc\u01927, \u00e2\u02dc\u01928);
                \u00e2\u02dc\u0192 = MinMaxBounds.Ints.m_55373_(object.get("value"));
                \u00e2\u02dc\u01925.put(object3, \u00e2\u02dc\u0192);
            }
        }
        Object2BooleanOpenHashMap object2BooleanOpenHashMap = new Object2BooleanOpenHashMap();
        \u00e2\u02dc\u019292 = GsonHelper.m_13841_(jsonObject, "recipes", new JsonObject());
        for (Object object2 : \u00e2\u02dc\u019292.entrySet()) {
            \u00e2\u02dc\u01927 = new ResourceLocation((String)object2.getKey());
            boolean bl = GsonHelper.m_13877_((JsonElement)object2.getValue(), "recipe present");
            object2BooleanOpenHashMap.put(\u00e2\u02dc\u01927, bl);
        }
        object = Maps.newHashMap();
        object2 = GsonHelper.m_13841_(jsonObject, "advancements", new JsonObject());
        for (Map.Entry entry : object2.entrySet()) {
            Object object3 = new ResourceLocation((String)entry.getKey());
            \u00e2\u02dc\u0192 = PlayerPredicate.m_62289_((JsonElement)entry.getValue());
            object.put(object3, \u00e2\u02dc\u0192);
        }
        \u00e2\u02dc\u01927 = EntityPredicate.m_36614_(jsonObject.get("looking_at"));
        return new PlayerPredicate(\u00e2\u02dc\u01922, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, (Object2BooleanMap<ResourceLocation>)object2BooleanOpenHashMap, (Map<ResourceLocation, AdvancementPredicate>)object, (EntityPredicate)((Object)\u00e2\u02dc\u01927));
    }

    private static <T> Stat<T> m_62267_(StatType<T> p_62268_, ResourceLocation p_62269_) {
        Registry<T> registry = p_62268_.m_12893_();
        T \u00e2\u02dc\u01922 = registry.m_7745_(p_62269_);
        if (\u00e2\u02dc\u01922 == null) {
            throw new JsonParseException("Unknown object " + p_62269_ + " for stat type " + Registry.f_122867_.m_7981_(p_62268_));
        }
        return p_62268_.m_12902_(\u00e2\u02dc\u01922);
    }

    private static <T> ResourceLocation m_62265_(Stat<T> p_62266_) {
        return p_62266_.m_12859_().m_12893_().m_7981_(p_62266_.m_12867_());
    }

    public JsonElement m_62264_() {
        JsonArray jsonArray;
        if (this == f_62244_) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("level", this.f_62245_.m_55328_());
        if (this.f_62246_ != null) {
            jsonObject.addProperty("gamemode", this.f_62246_.m_46405_());
        }
        if (!this.f_62247_.isEmpty()) {
            jsonArray = new JsonArray();
            this.f_62247_.forEach((p_156754_, p_156755_) -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("type", Registry.f_122867_.m_7981_(p_156754_.m_12859_()).toString());
                jsonObject.addProperty("stat", PlayerPredicate.m_62265_(p_156754_).toString());
                jsonObject.add("value", p_156755_.m_55328_());
                jsonArray.add((JsonElement)jsonObject);
            });
            jsonObject.add("stats", (JsonElement)jsonArray);
        }
        if (!this.f_62248_.isEmpty()) {
            jsonArray = new JsonObject();
            this.f_62248_.forEach((arg_0, arg_1) -> PlayerPredicate.m_156760_((JsonObject)jsonArray, arg_0, arg_1));
            jsonObject.add("recipes", (JsonElement)jsonArray);
        }
        if (!this.f_62249_.isEmpty()) {
            jsonArray = new JsonObject();
            this.f_62249_.forEach((arg_0, arg_1) -> PlayerPredicate.m_156756_((JsonObject)jsonArray, arg_0, arg_1));
            jsonObject.add("advancements", (JsonElement)jsonArray);
        }
        jsonObject.add("looking_at", this.f_156744_.m_36606_());
        return jsonObject;
    }

    private static /* synthetic */ void m_156756_(JsonObject p_156757_, ResourceLocation p_156758_, AdvancementPredicate p_156759_) {
        p_156757_.add(p_156758_.toString(), p_156759_.m_7943_());
    }

    private static /* synthetic */ void m_156760_(JsonObject p_156761_, ResourceLocation p_156762_, Boolean p_156763_) {
        p_156761_.addProperty(p_156762_.toString(), p_156763_);
    }

    private static /* synthetic */ void m_62286_(Object2BooleanMap p_62287_, Map.Entry p_62288_) {
        boolean bl = GsonHelper.m_13877_((JsonElement)p_62288_.getValue(), "criterion test");
        p_62287_.put((Object)((String)p_62288_.getKey()), bl);
    }

    static class AdvancementDonePredicate
    implements AdvancementPredicate {
        private final boolean f_62299_;

        public AdvancementDonePredicate(boolean p_62301_) {
            this.f_62299_ = p_62301_;
        }

        @Override
        public JsonElement m_7943_() {
            return new JsonPrimitive(Boolean.valueOf(this.f_62299_));
        }

        @Override
        public boolean test(AdvancementProgress p_62304_) {
            return p_62304_.m_8193_() == this.f_62299_;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static class AdvancementCriterionsPredicate
    implements AdvancementPredicate {
        private final Object2BooleanMap<String> f_62291_;

        public AdvancementCriterionsPredicate(Object2BooleanMap<String> p_62293_) {
            this.f_62291_ = p_62293_;
        }

        @Override
        public JsonElement m_7943_() {
            JsonObject jsonObject = new JsonObject();
            this.f_62291_.forEach((arg_0, arg_1) -> ((JsonObject)jsonObject).addProperty(arg_0, arg_1));
            return jsonObject;
        }

        @Override
        public boolean test(AdvancementProgress p_62296_) {
            for (Object2BooleanMap.Entry entry : this.f_62291_.object2BooleanEntrySet()) {
                CriterionProgress criterionProgress = p_62296_.m_8214_((String)entry.getKey());
                if (criterionProgress != null && criterionProgress.m_12911_() == entry.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    static interface AdvancementPredicate
    extends Predicate<AdvancementProgress> {
        public JsonElement m_7943_();
    }

    public static class Builder {
        private MinMaxBounds.Ints f_62307_ = MinMaxBounds.Ints.f_55364_;
        @Nullable
        private GameType f_62308_;
        private final Map<Stat<?>, MinMaxBounds.Ints> f_62309_ = Maps.newHashMap();
        private final Object2BooleanMap<ResourceLocation> f_62310_ = new Object2BooleanOpenHashMap();
        private final Map<ResourceLocation, AdvancementPredicate> f_62311_ = Maps.newHashMap();
        private EntityPredicate f_156766_ = EntityPredicate.f_36550_;

        public static Builder m_156767_() {
            return new Builder();
        }

        public Builder m_156775_(MinMaxBounds.Ints p_156776_) {
            this.f_62307_ = p_156776_;
            return this;
        }

        public Builder m_156768_(Stat<?> p_156769_, MinMaxBounds.Ints p_156770_) {
            this.f_62309_.put(p_156769_, p_156770_);
            return this;
        }

        public Builder m_156780_(ResourceLocation p_156781_, boolean p_156782_) {
            this.f_62310_.put((Object)p_156781_, p_156782_);
            return this;
        }

        public Builder m_156773_(GameType p_156774_) {
            this.f_62308_ = p_156774_;
            return this;
        }

        public Builder m_156771_(EntityPredicate p_156772_) {
            this.f_156766_ = p_156772_;
            return this;
        }

        public Builder m_156783_(ResourceLocation p_156784_, boolean p_156785_) {
            this.f_62311_.put(p_156784_, new AdvancementDonePredicate(p_156785_));
            return this;
        }

        public Builder m_156777_(ResourceLocation p_156778_, Map<String, Boolean> p_156779_) {
            this.f_62311_.put(p_156778_, new AdvancementCriterionsPredicate((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(p_156779_)));
            return this;
        }

        public PlayerPredicate m_62313_() {
            return new PlayerPredicate(this.f_62307_, this.f_62308_, this.f_62309_, this.f_62310_, this.f_62311_, this.f_156766_);
        }
    }
}

