/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerFunctionManager;

public class CommandFunction {
    private final Entry[] f_77976_;
    final ResourceLocation f_77977_;

    public CommandFunction(ResourceLocation p_77979_, Entry[] p_77980_) {
        this.f_77977_ = p_77979_;
        this.f_77976_ = p_77980_;
    }

    public ResourceLocation m_77981_() {
        return this.f_77977_;
    }

    public Entry[] m_77989_() {
        return this.f_77976_;
    }

    public static CommandFunction m_77984_(ResourceLocation p_77985_, CommandDispatcher<CommandSourceStack> p_77986_, CommandSourceStack p_77987_, List<String> p_77988_) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)p_77988_.size());
        for (int i = 0; i < p_77988_.size(); ++i) {
            Object object;
            \u00e2\u02dc\u0192 = i + 1;
            String string = p_77988_.get(i).trim();
            StringReader \u00e2\u02dc\u01922 = new StringReader(string);
            if (!\u00e2\u02dc\u01922.canRead() || \u00e2\u02dc\u01922.peek() == '#') continue;
            if (\u00e2\u02dc\u01922.peek() == '/') {
                \u00e2\u02dc\u01922.skip();
                if (\u00e2\u02dc\u01922.peek() == '/') {
                    throw new IllegalArgumentException("Unknown or invalid command '" + string + "' on line " + \u00e2\u02dc\u0192 + " (if you intended to make a comment, use '#' not '//')");
                }
                object = \u00e2\u02dc\u01922.readUnquotedString();
                throw new IllegalArgumentException("Unknown or invalid command '" + string + "' on line " + \u00e2\u02dc\u0192 + " (did you mean '" + (String)object + "'? Do not use a preceding forwards slash.)");
            }
            try {
                object = p_77986_.parse(\u00e2\u02dc\u01922, (Object)p_77987_);
                if (object.getReader().canRead()) {
                    throw Commands.m_82097_(object);
                }
                arrayList.add(new CommandEntry((ParseResults<CommandSourceStack>)object));
                continue;
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new IllegalArgumentException("Whilst parsing command on line " + \u00e2\u02dc\u0192 + ": " + commandSyntaxException.getMessage());
            }
        }
        return new CommandFunction(p_77985_, arrayList.toArray(new Entry[0]));
    }

    @FunctionalInterface
    public static interface Entry {
        public void m_142134_(ServerFunctionManager var1, CommandSourceStack var2, Deque<ServerFunctionManager.QueuedCommand> var3, int var4, int var5, @Nullable ServerFunctionManager.TraceCallbacks var6) throws CommandSyntaxException;
    }

    public static class CommandEntry
    implements Entry {
        private final ParseResults<CommandSourceStack> f_78004_;

        public CommandEntry(ParseResults<CommandSourceStack> p_78006_) {
            this.f_78004_ = p_78006_;
        }

        @Override
        public void m_142134_(ServerFunctionManager p_164879_, CommandSourceStack p_164880_, Deque<ServerFunctionManager.QueuedCommand> p_164881_, int p_164882_, int p_164883_, @Nullable ServerFunctionManager.TraceCallbacks p_164884_) throws CommandSyntaxException {
            if (p_164884_ != null) {
                String string = this.f_78004_.getReader().getString();
                p_164884_.m_142256_(p_164883_, string);
                int \u00e2\u02dc\u01922 = this.m_164875_(p_164879_, p_164880_);
                p_164884_.m_142279_(p_164883_, string, \u00e2\u02dc\u01922);
            } else {
                this.m_164875_(p_164879_, p_164880_);
            }
        }

        private int m_164875_(ServerFunctionManager p_164876_, CommandSourceStack p_164877_) throws CommandSyntaxException {
            return p_164876_.m_136127_().execute(new ParseResults(this.f_78004_.getContext().withSource((Object)p_164877_), this.f_78004_.getReader(), this.f_78004_.getExceptions()));
        }

        public String toString() {
            return this.f_78004_.getReader().getString();
        }
    }

    public static class CacheableFunction {
        public static final CacheableFunction f_77990_ = new CacheableFunction((ResourceLocation)null);
        @Nullable
        private final ResourceLocation f_77991_;
        private boolean f_77992_;
        private Optional<CommandFunction> f_77993_ = Optional.empty();

        public CacheableFunction(@Nullable ResourceLocation p_77998_) {
            this.f_77991_ = p_77998_;
        }

        public CacheableFunction(CommandFunction p_77996_) {
            this.f_77992_ = true;
            this.f_77991_ = null;
            this.f_77993_ = Optional.of(p_77996_);
        }

        public Optional<CommandFunction> m_78002_(ServerFunctionManager p_78003_) {
            if (!this.f_77992_) {
                if (this.f_77991_ != null) {
                    this.f_77993_ = p_78003_.m_136118_(this.f_77991_);
                }
                this.f_77992_ = true;
            }
            return this.f_77993_;
        }

        @Nullable
        public ResourceLocation m_77999_() {
            return this.f_77993_.map(p_78001_ -> p_78001_.f_77977_).orElse(this.f_77991_);
        }
    }

    public static class FunctionEntry
    implements Entry {
        private final CacheableFunction f_78017_;

        public FunctionEntry(CommandFunction p_78019_) {
            this.f_78017_ = new CacheableFunction(p_78019_);
        }

        @Override
        public void m_142134_(ServerFunctionManager p_164902_, CommandSourceStack p_164903_, Deque<ServerFunctionManager.QueuedCommand> p_164904_, int p_164905_, int p_164906_, @Nullable ServerFunctionManager.TraceCallbacks p_164907_) {
            Util.m_137521_(this.f_78017_.m_78002_(p_164902_), p_164900_ -> {
                Entry[] entryArray = p_164900_.m_77989_();
                if (p_164907_ != null) {
                    p_164907_.m_142147_(p_164906_, p_164900_.m_77981_(), entryArray.length);
                }
                int \u00e2\u02dc\u01922 = p_164905_ - p_164904_.size();
                int \u00e2\u02dc\u01923 = Math.min(entryArray.length, \u00e2\u02dc\u01922);
                for (int i = \u00e2\u02dc\u01923 - 1; i >= 0; --i) {
                    p_164904_.addFirst(new ServerFunctionManager.QueuedCommand(p_164903_, p_164906_ + 1, entryArray[i]));
                }
            }, () -> {
                if (p_164907_ != null) {
                    p_164907_.m_142147_(p_164906_, this.f_78017_.m_77999_(), -1);
                }
            });
        }

        public String toString() {
            return "function " + this.f_78017_.m_77999_();
        }
    }
}

