/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockPredicateArgument
implements ArgumentType<Result> {
    private static final Collection<String> f_115566_ = Arrays.asList("stone", "minecraft:stone", "stone[foo=bar]", "#stone", "#stone[foo=bar]{baz=nbt}");
    private static final DynamicCommandExceptionType f_115567_ = new DynamicCommandExceptionType(p_115580_ -> new TranslatableComponent("arguments.block.tag.unknown", p_115580_));

    public static BlockPredicateArgument m_115570_() {
        return new BlockPredicateArgument();
    }

    public Result parse(StringReader p_115572_) throws CommandSyntaxException {
        BlockStateParser blockStateParser = new BlockStateParser(p_115572_, true).m_116806_(true);
        if (blockStateParser.m_116808_() != null) {
            BlockPredicate blockPredicate = new BlockPredicate(blockStateParser.m_116808_(), blockStateParser.m_116764_().keySet(), blockStateParser.m_116815_());
            return p_115578_ -> blockPredicate;
        }
        ResourceLocation \u00e2\u02dc\u01922 = blockStateParser.m_116822_();
        return p_173736_ -> {
            Tag<Block> tag = p_173736_.m_144458_(Registry.f_122901_, \u00e2\u02dc\u01922, p_173732_ -> f_115567_.create((Object)p_173732_.toString()));
            return new TagPredicate(tag, blockStateParser.m_116846_(), blockStateParser.m_116815_());
        };
    }

    public static Predicate<BlockInWorld> m_115573_(CommandContext<CommandSourceStack> p_115574_, String p_115575_) throws CommandSyntaxException {
        return ((Result)p_115574_.getArgument(p_115575_, Result.class)).m_115602_(((CommandSourceStack)p_115574_.getSource()).m_81377_().m_129895_());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_115587_, SuggestionsBuilder p_115588_) {
        StringReader stringReader = new StringReader(p_115588_.getInput());
        stringReader.setCursor(p_115588_.getStart());
        BlockStateParser \u00e2\u02dc\u01922 = new BlockStateParser(stringReader, true);
        try {
            \u00e2\u02dc\u01922.m_116806_(true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return \u00e2\u02dc\u01922.m_116779_(p_115588_, BlockTags.m_13115_());
    }

    public Collection<String> getExamples() {
        return f_115566_;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class BlockPredicate
    implements Predicate<BlockInWorld> {
        private final BlockState f_115591_;
        private final Set<Property<?>> f_115592_;
        @Nullable
        private final CompoundTag f_115593_;

        public BlockPredicate(BlockState p_115595_, Set<Property<?>> p_115596_, @Nullable CompoundTag p_115597_) {
            this.f_115591_ = p_115595_;
            this.f_115592_ = p_115596_;
            this.f_115593_ = p_115597_;
        }

        @Override
        public boolean test(BlockInWorld p_115599_) {
            BlockState blockState = p_115599_.m_61168_();
            if (!blockState.m_60713_(this.f_115591_.m_60734_())) {
                return false;
            }
            for (Property<?> property : this.f_115592_) {
                if (blockState.m_61143_(property) == this.f_115591_.m_61143_(property)) continue;
                return false;
            }
            if (this.f_115593_ != null) {
                BlockEntity blockEntity = p_115599_.m_61174_();
                return blockEntity != null && NbtUtils.m_129235_(this.f_115593_, blockEntity.m_6945_(new CompoundTag()), true);
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((BlockInWorld)object);
        }
    }

    public static interface Result {
        public Predicate<BlockInWorld> m_115602_(TagContainer var1) throws CommandSyntaxException;
    }

    static class TagPredicate
    implements Predicate<BlockInWorld> {
        private final Tag<Block> f_115604_;
        @Nullable
        private final CompoundTag f_115605_;
        private final Map<String, String> f_115606_;

        TagPredicate(Tag<Block> p_115608_, Map<String, String> p_115609_, @Nullable CompoundTag p_115610_) {
            this.f_115604_ = p_115608_;
            this.f_115606_ = p_115609_;
            this.f_115605_ = p_115610_;
        }

        @Override
        public boolean test(BlockInWorld p_115617_) {
            BlockState blockState = p_115617_.m_61168_();
            if (!blockState.m_60620_(this.f_115604_)) {
                return false;
            }
            for (Map.Entry<String, String> entry : this.f_115606_.entrySet()) {
                Property<?> property = blockState.m_60734_().m_49965_().m_61081_(entry.getKey());
                if (property == null) {
                    return false;
                }
                Comparable \u00e2\u02dc\u01922 = property.m_6215_(entry.getValue()).orElse(null);
                if (\u00e2\u02dc\u01922 == null) {
                    return false;
                }
                if (blockState.m_61143_(property) == \u00e2\u02dc\u01922) continue;
                return false;
            }
            if (this.f_115605_ != null) {
                BlockEntity \u00e2\u02dc\u01923 = p_115617_.m_61174_();
                return \u00e2\u02dc\u01923 != null && NbtUtils.m_129235_(this.f_115605_, \u00e2\u02dc\u01923.m_6945_(new CompoundTag()), true);
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((BlockInWorld)object);
        }
    }
}

