/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.WrappedMinMaxBounds;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.Team;

public class EntitySelectorOptions {
    private static final Map<String, Option> f_121392_ = Maps.newHashMap();
    public static final DynamicCommandExceptionType f_121384_ = new DynamicCommandExceptionType(p_121520_ -> new TranslatableComponent("argument.entity.options.unknown", p_121520_));
    public static final DynamicCommandExceptionType f_121385_ = new DynamicCommandExceptionType(p_121516_ -> new TranslatableComponent("argument.entity.options.inapplicable", p_121516_));
    public static final SimpleCommandExceptionType f_121386_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType f_121387_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType f_121388_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType f_121389_ = new DynamicCommandExceptionType(p_121508_ -> new TranslatableComponent("argument.entity.options.sort.irreversible", p_121508_));
    public static final DynamicCommandExceptionType f_121390_ = new DynamicCommandExceptionType(p_121493_ -> new TranslatableComponent("argument.entity.options.mode.invalid", p_121493_));
    public static final DynamicCommandExceptionType f_121391_ = new DynamicCommandExceptionType(p_121452_ -> new TranslatableComponent("argument.entity.options.type.invalid", p_121452_));

    private static void m_121453_(String p_121454_, Modifier p_121455_, Predicate<EntitySelectorParser> p_121456_, Component p_121457_) {
        f_121392_.put(p_121454_, new Option(p_121455_, p_121456_, p_121457_));
    }

    public static void m_121426_() {
        if (!f_121392_.isEmpty()) {
            return;
        }
        EntitySelectorOptions.m_121453_("name", p_121425_ -> {
            int n = p_121425_.m_121346_().getCursor();
            boolean \u00e2\u02dc\u01922 = p_121425_.m_121330_();
            String \u00e2\u02dc\u01923 = p_121425_.m_121346_().readString();
            if (p_121425_.m_121380_() && !\u00e2\u02dc\u01922) {
                p_121425_.m_121346_().setCursor(n);
                throw f_121385_.createWithContext((ImmutableStringReader)p_121425_.m_121346_(), (Object)"name");
            }
            if (\u00e2\u02dc\u01922) {
                p_121425_.m_121315_(true);
            } else {
                p_121425_.m_121302_(true);
            }
            p_121425_.m_121272_(p_175209_ -> p_175209_.m_7755_().getString().equals(\u00e2\u02dc\u01923) != \u00e2\u02dc\u01922);
        }, p_121423_ -> !p_121423_.m_121379_(), new TranslatableComponent("argument.entity.options.name.description"));
        EntitySelectorOptions.m_121453_("distance", p_121421_ -> {
            int n = p_121421_.m_121346_().getCursor();
            MinMaxBounds.Doubles \u00e2\u02dc\u01922 = MinMaxBounds.Doubles.m_154793_(p_121421_.m_121346_());
            if (\u00e2\u02dc\u01922.m_55305_() != null && (Double)\u00e2\u02dc\u01922.m_55305_() < 0.0 || \u00e2\u02dc\u01922.m_55326_() != null && (Double)\u00e2\u02dc\u01922.m_55326_() < 0.0) {
                p_121421_.m_121346_().setCursor(n);
                throw f_121386_.createWithContext((ImmutableStringReader)p_121421_.m_121346_());
            }
            p_121421_.m_175127_(\u00e2\u02dc\u01922);
            p_121421_.m_121352_();
        }, p_121419_ -> p_121419_.m_175142_().m_55327_(), new TranslatableComponent("argument.entity.options.distance.description"));
        EntitySelectorOptions.m_121453_("level", p_121417_ -> {
            int n = p_121417_.m_121346_().getCursor();
            MinMaxBounds.Ints \u00e2\u02dc\u01922 = MinMaxBounds.Ints.m_55375_(p_121417_.m_121346_());
            if (\u00e2\u02dc\u01922.m_55305_() != null && (Integer)\u00e2\u02dc\u01922.m_55305_() < 0 || \u00e2\u02dc\u01922.m_55326_() != null && (Integer)\u00e2\u02dc\u01922.m_55326_() < 0) {
                p_121417_.m_121346_().setCursor(n);
                throw f_121387_.createWithContext((ImmutableStringReader)p_121417_.m_121346_());
            }
            p_121417_.m_121245_(\u00e2\u02dc\u01922);
            p_121417_.m_121279_(false);
        }, p_121415_ -> p_121415_.m_121361_().m_55327_(), new TranslatableComponent("argument.entity.options.level.description"));
        EntitySelectorOptions.m_121453_("x", p_121413_ -> {
            p_121413_.m_121352_();
            p_121413_.m_121231_(p_121413_.m_121346_().readDouble());
        }, p_121411_ -> p_121411_.m_121371_() == null, new TranslatableComponent("argument.entity.options.x.description"));
        EntitySelectorOptions.m_121453_("y", p_121409_ -> {
            p_121409_.m_121352_();
            p_121409_.m_121282_(p_121409_.m_121346_().readDouble());
        }, p_121407_ -> p_121407_.m_121372_() == null, new TranslatableComponent("argument.entity.options.y.description"));
        EntitySelectorOptions.m_121453_("z", p_121405_ -> {
            p_121405_.m_121352_();
            p_121405_.m_121305_(p_121405_.m_121346_().readDouble());
        }, p_121403_ -> p_121403_.m_121373_() == null, new TranslatableComponent("argument.entity.options.z.description"));
        EntitySelectorOptions.m_121453_("dx", p_121401_ -> {
            p_121401_.m_121352_();
            p_121401_.m_121318_(p_121401_.m_121346_().readDouble());
        }, p_121399_ -> p_121399_.m_121374_() == null, new TranslatableComponent("argument.entity.options.dx.description"));
        EntitySelectorOptions.m_121453_("dy", p_121397_ -> {
            p_121397_.m_121352_();
            p_121397_.m_121331_(p_121397_.m_121346_().readDouble());
        }, p_121395_ -> p_121395_.m_121375_() == null, new TranslatableComponent("argument.entity.options.dy.description"));
        EntitySelectorOptions.m_121453_("dz", p_121562_ -> {
            p_121562_.m_121352_();
            p_121562_.m_121339_(p_121562_.m_121346_().readDouble());
        }, p_121560_ -> p_121560_.m_121376_() == null, new TranslatableComponent("argument.entity.options.dz.description"));
        EntitySelectorOptions.m_121453_("x_rotation", p_121558_ -> p_121558_.m_121252_(WrappedMinMaxBounds.m_75359_(p_121558_.m_121346_(), true, Mth::m_14177_)), p_121556_ -> p_121556_.m_121367_() == WrappedMinMaxBounds.f_75350_, new TranslatableComponent("argument.entity.options.x_rotation.description"));
        EntitySelectorOptions.m_121453_("y_rotation", p_121554_ -> p_121554_.m_121289_(WrappedMinMaxBounds.m_75359_(p_121554_.m_121346_(), true, Mth::m_14177_)), p_121552_ -> p_121552_.m_121370_() == WrappedMinMaxBounds.f_75350_, new TranslatableComponent("argument.entity.options.y_rotation.description"));
        EntitySelectorOptions.m_121453_("limit", p_121550_ -> {
            int n = p_121550_.m_121346_().getCursor();
            \u00e2\u02dc\u0192 = p_121550_.m_121346_().readInt();
            if (\u00e2\u02dc\u0192 < 1) {
                p_121550_.m_121346_().setCursor(n);
                throw f_121388_.createWithContext((ImmutableStringReader)p_121550_.m_121346_());
            }
            p_121550_.m_121237_(\u00e2\u02dc\u0192);
            p_121550_.m_121328_(true);
        }, p_121548_ -> !p_121548_.m_121378_() && !p_121548_.m_121381_(), new TranslatableComponent("argument.entity.options.limit.description"));
        EntitySelectorOptions.m_121453_("sort", p_121546_ -> {
            int n = p_121546_.m_121346_().getCursor();
            String \u00e2\u02dc\u01922 = p_121546_.m_121346_().readUnquotedString();
            p_121546_.m_121270_((p_175153_, p_175154_) -> SharedSuggestionProvider.m_82970_(Arrays.asList("nearest", "furthest", "random", "arbitrary"), p_175153_));
            p_121546_.m_121268_(switch (\u00e2\u02dc\u01922) {
                case "nearest" -> EntitySelectorParser.f_121197_;
                case "furthest" -> EntitySelectorParser.f_121198_;
                case "random" -> EntitySelectorParser.f_121199_;
                case "arbitrary" -> EntitySelectorParser.f_121196_;
                default -> {
                    p_121546_.m_121346_().setCursor(n);
                    throw f_121389_.createWithContext((ImmutableStringReader)p_121546_.m_121346_(), (Object)\u00e2\u02dc\u01922);
                }
            });
            p_121546_.m_121336_(true);
        }, p_121544_ -> !p_121544_.m_121378_() && !p_121544_.m_121382_(), new TranslatableComponent("argument.entity.options.sort.description"));
        EntitySelectorOptions.m_121453_("gamemode", p_121542_ -> {
            p_121542_.m_121270_((p_175193_, p_175194_) -> {
                String string = p_175193_.getRemaining().toLowerCase(Locale.ROOT);
                boolean \u00e2\u02dc\u01922 = !p_121542_.m_121222_();
                boolean \u00e2\u02dc\u01923 = true;
                if (!string.isEmpty()) {
                    if (string.charAt(0) == '!') {
                        \u00e2\u02dc\u01922 = false;
                        string = string.substring(1);
                    } else {
                        \u00e2\u02dc\u01923 = false;
                    }
                }
                for (GameType gameType : GameType.values()) {
                    if (!gameType.m_46405_().toLowerCase(Locale.ROOT).startsWith(string)) continue;
                    if (\u00e2\u02dc\u01923) {
                        p_175193_.suggest("!" + gameType.m_46405_());
                    }
                    if (!\u00e2\u02dc\u01922) continue;
                    p_175193_.suggest(gameType.m_46405_());
                }
                return p_175193_.buildFuture();
            });
            int n = p_121542_.m_121346_().getCursor();
            boolean \u00e2\u02dc\u01922 = p_121542_.m_121330_();
            if (p_121542_.m_121222_() && !\u00e2\u02dc\u01922) {
                p_121542_.m_121346_().setCursor(n);
                throw f_121385_.createWithContext((ImmutableStringReader)p_121542_.m_121346_(), (Object)"gamemode");
            }
            String \u00e2\u02dc\u01923 = p_121542_.m_121346_().readUnquotedString();
            GameType \u00e2\u02dc\u01924 = GameType.m_46402_(\u00e2\u02dc\u01923, null);
            if (\u00e2\u02dc\u01924 == null) {
                p_121542_.m_121346_().setCursor(n);
                throw f_121390_.createWithContext((ImmutableStringReader)p_121542_.m_121346_(), (Object)\u00e2\u02dc\u01923);
            }
            p_121542_.m_121279_(false);
            p_121542_.m_121272_(p_175190_ -> {
                if (!(p_175190_ instanceof ServerPlayer)) {
                    return false;
                }
                GameType gameType = ((ServerPlayer)p_175190_).f_8941_.m_9290_();
                return \u00e2\u02dc\u01922 ? gameType != \u00e2\u02dc\u01924 : gameType == \u00e2\u02dc\u01924;
            });
            if (\u00e2\u02dc\u01922) {
                p_121542_.m_121350_(true);
            } else {
                p_121542_.m_121344_(true);
            }
        }, p_121540_ -> !p_121540_.m_121383_(), new TranslatableComponent("argument.entity.options.gamemode.description"));
        EntitySelectorOptions.m_121453_("team", p_121538_ -> {
            boolean bl = p_121538_.m_121330_();
            String \u00e2\u02dc\u01922 = p_121538_.m_121346_().readUnquotedString();
            p_121538_.m_121272_(p_175198_ -> {
                if (!(p_175198_ instanceof LivingEntity)) {
                    return false;
                }
                Team team = p_175198_.m_5647_();
                String \u00e2\u02dc\u01922 = team == null ? "" : team.m_5758_();
                return \u00e2\u02dc\u01922.equals(\u00e2\u02dc\u01922) != bl;
            });
            if (bl) {
                p_121538_.m_121359_(true);
            } else {
                p_121538_.m_121356_(true);
            }
        }, p_121536_ -> !p_121536_.m_121223_(), new TranslatableComponent("argument.entity.options.team.description"));
        EntitySelectorOptions.m_121453_("type", p_121534_ -> {
            p_121534_.m_121270_((p_175161_, p_175162_) -> {
                SharedSuggestionProvider.m_82929_(Registry.f_122826_.m_6566_(), p_175161_, String.valueOf('!'));
                SharedSuggestionProvider.m_82929_(EntityTypeTags.m_13126_().m_13406_(), p_175161_, "!#");
                if (!p_121534_.m_121226_()) {
                    SharedSuggestionProvider.m_82926_(Registry.f_122826_.m_6566_(), p_175161_);
                    SharedSuggestionProvider.m_82929_(EntityTypeTags.m_13126_().m_13406_(), p_175161_, String.valueOf('#'));
                }
                return p_175161_.buildFuture();
            });
            int n = p_121534_.m_121346_().getCursor();
            boolean \u00e2\u02dc\u01922 = p_121534_.m_121330_();
            if (p_121534_.m_121226_() && !\u00e2\u02dc\u01922) {
                p_121534_.m_121346_().setCursor(n);
                throw f_121385_.createWithContext((ImmutableStringReader)p_121534_.m_121346_(), (Object)"type");
            }
            if (\u00e2\u02dc\u01922) {
                p_121534_.m_121224_();
            }
            if (p_121534_.m_121338_()) {
                ResourceLocation resourceLocation = ResourceLocation.m_135818_(p_121534_.m_121346_());
                p_121534_.m_121272_(p_175205_ -> p_175205_.m_6095_().m_20609_(p_175205_.m_20194_().m_129895_().m_144452_(Registry.f_122903_).m_7689_(resourceLocation)) != \u00e2\u02dc\u01922);
            } else {
                ResourceLocation resourceLocation = ResourceLocation.m_135818_(p_121534_.m_121346_());
                EntityType<?> \u00e2\u02dc\u01923 = Registry.f_122826_.m_6612_(resourceLocation).orElseThrow(() -> {
                    p_121534_.m_121346_().setCursor(n);
                    return f_121391_.createWithContext((ImmutableStringReader)p_121534_.m_121346_(), (Object)resourceLocation.toString());
                });
                if (Objects.equals(EntityType.f_20532_, \u00e2\u02dc\u01923) && !\u00e2\u02dc\u01922) {
                    p_121534_.m_121279_(false);
                }
                p_121534_.m_121272_(p_175151_ -> Objects.equals(\u00e2\u02dc\u01923, p_175151_.m_6095_()) != \u00e2\u02dc\u01922);
                if (!\u00e2\u02dc\u01922) {
                    p_121534_.m_121241_(\u00e2\u02dc\u01923);
                }
            }
        }, p_121532_ -> !p_121532_.m_121225_(), new TranslatableComponent("argument.entity.options.type.description"));
        EntitySelectorOptions.m_121453_("tag", p_121530_ -> {
            boolean bl = p_121530_.m_121330_();
            String \u00e2\u02dc\u01922 = p_121530_.m_121346_().readUnquotedString();
            p_121530_.m_121272_(p_175166_ -> {
                if ("".equals(\u00e2\u02dc\u01922)) {
                    return p_175166_.m_19880_().isEmpty() != bl;
                }
                return p_175166_.m_19880_().contains(\u00e2\u02dc\u01922) != bl;
            });
        }, p_121528_ -> true, new TranslatableComponent("argument.entity.options.tag.description"));
        EntitySelectorOptions.m_121453_("nbt", p_121526_ -> {
            boolean bl = p_121526_.m_121330_();
            CompoundTag \u00e2\u02dc\u01922 = new TagParser(p_121526_.m_121346_()).m_129373_();
            p_121526_.m_121272_(p_175176_ -> {
                CompoundTag compoundTag = p_175176_.m_20240_(new CompoundTag());
                if (p_175176_ instanceof ServerPlayer && !(\u00e2\u02dc\u0192 = ((ServerPlayer)p_175176_).m_150109_().m_36056_()).m_41619_()) {
                    compoundTag.m_128365_("SelectedItem", \u00e2\u02dc\u0192.m_41739_(new CompoundTag()));
                }
                return NbtUtils.m_129235_(\u00e2\u02dc\u01922, compoundTag, true) != bl;
            });
        }, p_121524_ -> true, new TranslatableComponent("argument.entity.options.nbt.description"));
        EntitySelectorOptions.m_121453_("scores", p_121522_ -> {
            StringReader stringReader = p_121522_.m_121346_();
            HashMap \u00e2\u02dc\u01922 = Maps.newHashMap();
            stringReader.expect('{');
            stringReader.skipWhitespace();
            while (stringReader.canRead() && stringReader.peek() != '}') {
                stringReader.skipWhitespace();
                String string = stringReader.readUnquotedString();
                stringReader.skipWhitespace();
                stringReader.expect('=');
                stringReader.skipWhitespace();
                MinMaxBounds.Ints \u00e2\u02dc\u01923 = MinMaxBounds.Ints.m_55375_(stringReader);
                \u00e2\u02dc\u01922.put(string, \u00e2\u02dc\u01923);
                stringReader.skipWhitespace();
                if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                stringReader.skip();
            }
            stringReader.expect('}');
            if (!\u00e2\u02dc\u01922.isEmpty()) {
                p_121522_.m_121272_(p_175201_ -> {
                    ServerScoreboard serverScoreboard = p_175201_.m_20194_().m_129896_();
                    String \u00e2\u02dc\u01922 = p_175201_.m_6302_();
                    for (Map.Entry entry : \u00e2\u02dc\u01922.entrySet()) {
                        Objective objective = serverScoreboard.m_83477_((String)entry.getKey());
                        if (objective == null) {
                            return false;
                        }
                        if (!serverScoreboard.m_83461_(\u00e2\u02dc\u01922, objective)) {
                            return false;
                        }
                        Score \u00e2\u02dc\u01923 = serverScoreboard.m_83471_(\u00e2\u02dc\u01922, objective);
                        int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.m_83400_();
                        if (((MinMaxBounds.Ints)entry.getValue()).m_55390_(\u00e2\u02dc\u01924)) continue;
                        return false;
                    }
                    return true;
                });
            }
            p_121522_.m_121365_(true);
        }, p_121518_ -> !p_121518_.m_121227_(), new TranslatableComponent("argument.entity.options.scores.description"));
        EntitySelectorOptions.m_121453_("advancements", p_121514_ -> {
            StringReader stringReader = p_121514_.m_121346_();
            HashMap \u00e2\u02dc\u01922 = Maps.newHashMap();
            stringReader.expect('{');
            stringReader.skipWhitespace();
            while (stringReader.canRead() && stringReader.peek() != '}') {
                stringReader.skipWhitespace();
                ResourceLocation resourceLocation = ResourceLocation.m_135818_(stringReader);
                stringReader.skipWhitespace();
                stringReader.expect('=');
                stringReader.skipWhitespace();
                if (stringReader.canRead() && stringReader.peek() == '{') {
                    HashMap hashMap = Maps.newHashMap();
                    stringReader.skipWhitespace();
                    stringReader.expect('{');
                    stringReader.skipWhitespace();
                    while (stringReader.canRead() && stringReader.peek() != '}') {
                        stringReader.skipWhitespace();
                        String string = stringReader.readUnquotedString();
                        stringReader.skipWhitespace();
                        stringReader.expect('=');
                        stringReader.skipWhitespace();
                        boolean \u00e2\u02dc\u01923 = stringReader.readBoolean();
                        hashMap.put(string, p_175186_ -> p_175186_.m_12911_() == \u00e2\u02dc\u01923);
                        stringReader.skipWhitespace();
                        if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                        stringReader.skip();
                    }
                    stringReader.skipWhitespace();
                    stringReader.expect('}');
                    stringReader.skipWhitespace();
                    \u00e2\u02dc\u01922.put(resourceLocation, p_175169_ -> {
                        for (Map.Entry entry : hashMap.entrySet()) {
                            CriterionProgress criterionProgress = p_175169_.m_8214_((String)entry.getKey());
                            if (criterionProgress != null && ((Predicate)entry.getValue()).test(criterionProgress)) continue;
                            return false;
                        }
                        return true;
                    });
                } else {
                    boolean bl = stringReader.readBoolean();
                    \u00e2\u02dc\u01922.put(resourceLocation, p_175183_ -> p_175183_.m_8193_() == bl);
                }
                stringReader.skipWhitespace();
                if (!stringReader.canRead() || stringReader.peek() != ',') continue;
                stringReader.skip();
            }
            stringReader.expect('}');
            if (!\u00e2\u02dc\u01922.isEmpty()) {
                p_121514_.m_121272_(p_175172_ -> {
                    if (!(p_175172_ instanceof ServerPlayer)) {
                        return false;
                    }
                    ServerPlayer serverPlayer = (ServerPlayer)p_175172_;
                    PlayerAdvancements \u00e2\u02dc\u01922 = serverPlayer.m_8960_();
                    ServerAdvancementManager \u00e2\u02dc\u01923 = serverPlayer.m_20194_().m_129889_();
                    for (Map.Entry entry : \u00e2\u02dc\u01922.entrySet()) {
                        Advancement advancement = \u00e2\u02dc\u01923.m_136041_((ResourceLocation)entry.getKey());
                        if (advancement != null && ((Predicate)entry.getValue()).test(\u00e2\u02dc\u01922.m_135996_(advancement))) continue;
                        return false;
                    }
                    return true;
                });
                p_121514_.m_121279_(false);
            }
            p_121514_.m_121368_(true);
        }, p_121506_ -> !p_121506_.m_121228_(), new TranslatableComponent("argument.entity.options.advancements.description"));
        EntitySelectorOptions.m_121453_("predicate", p_121487_ -> {
            boolean bl = p_121487_.m_121330_();
            ResourceLocation \u00e2\u02dc\u01922 = ResourceLocation.m_135818_(p_121487_.m_121346_());
            p_121487_.m_121272_(p_175180_ -> {
                if (!(p_175180_.f_19853_ instanceof ServerLevel)) {
                    return false;
                }
                ServerLevel serverLevel = (ServerLevel)p_175180_.f_19853_;
                LootItemCondition \u00e2\u02dc\u01922 = serverLevel.m_142572_().m_129899_().m_79252_(\u00e2\u02dc\u01922);
                if (\u00e2\u02dc\u01922 == null) {
                    return false;
                }
                LootContext \u00e2\u02dc\u01923 = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81455_, p_175180_).m_78972_(LootContextParams.f_81460_, p_175180_.m_20182_()).m_78975_(LootContextParamSets.f_81413_);
                return bl ^ \u00e2\u02dc\u01922.test(\u00e2\u02dc\u01923);
            });
        }, p_121435_ -> true, new TranslatableComponent("argument.entity.options.predicate.description"));
    }

    public static Modifier m_121447_(EntitySelectorParser p_121448_, String p_121449_, int p_121450_) throws CommandSyntaxException {
        Option option = f_121392_.get(p_121449_);
        if (option != null) {
            if (option.f_121566_.test(p_121448_)) {
                return option.f_121565_;
            }
            throw f_121385_.createWithContext((ImmutableStringReader)p_121448_.m_121346_(), (Object)p_121449_);
        }
        p_121448_.m_121346_().setCursor(p_121450_);
        throw f_121384_.createWithContext((ImmutableStringReader)p_121448_.m_121346_(), (Object)p_121449_);
    }

    public static void m_121440_(EntitySelectorParser p_121441_, SuggestionsBuilder p_121442_) {
        String string = p_121442_.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, Option> entry : f_121392_.entrySet()) {
            if (!entry.getValue().f_121566_.test(p_121441_) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(string)) continue;
            p_121442_.suggest(entry.getKey() + "=", (Message)entry.getValue().f_121567_);
        }
    }

    static class Option {
        public final Modifier f_121565_;
        public final Predicate<EntitySelectorParser> f_121566_;
        public final Component f_121567_;

        Option(Modifier p_121569_, Predicate<EntitySelectorParser> p_121570_, Component p_121571_) {
            this.f_121565_ = p_121569_;
            this.f_121566_ = p_121570_;
            this.f_121567_ = p_121571_;
        }
    }

    public static interface Modifier {
        public void m_121563_(EntitySelectorParser var1) throws CommandSyntaxException;
    }
}

