/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;

public final class Direction
extends Enum<Direction>
implements StringRepresentable {
    public static final /* enum */ Direction DOWN = new Direction(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0));
    public static final /* enum */ Direction UP = new Direction(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0));
    public static final /* enum */ Direction NORTH = new Direction(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1));
    public static final /* enum */ Direction SOUTH = new Direction(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1));
    public static final /* enum */ Direction WEST = new Direction(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0));
    public static final /* enum */ Direction EAST = new Direction(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));
    public static final Codec<Direction> f_175356_;
    private final int f_122339_;
    private final int f_122340_;
    private final int f_122341_;
    private final String f_122342_;
    private final Axis f_122343_;
    private final AxisDirection f_122344_;
    private final Vec3i f_122345_;
    private static final Direction[] f_122346_;
    private static final Map<String, Direction> f_122347_;
    private static final Direction[] f_122348_;
    private static final Direction[] f_122349_;
    private static final Long2ObjectMap<Direction> f_122350_;
    private static final /* synthetic */ Direction[] $VALUES;

    public static Direction[] values() {
        return (Direction[])$VALUES.clone();
    }

    public static Direction valueOf(String p_122439_) {
        return Enum.valueOf(Direction.class, p_122439_);
    }

    private Direction(int p_122356_, int p_122357_, int p_122358_, String p_122359_, AxisDirection p_122360_, Axis p_122361_, Vec3i p_122362_) {
        this.f_122339_ = p_122356_;
        this.f_122341_ = p_122358_;
        this.f_122340_ = p_122357_;
        this.f_122342_ = p_122359_;
        this.f_122343_ = p_122361_;
        this.f_122344_ = p_122360_;
        this.f_122345_ = p_122362_;
    }

    public static Direction[] m_122382_(Entity p_122383_) {
        float f = p_122383_.m_5686_(1.0f) * ((float)Math.PI / 180);
        \u00e2\u02dc\u0192 = -p_122383_.m_5675_(1.0f) * ((float)Math.PI / 180);
        \u00e2\u02dc\u0192 = Mth.m_14031_(f);
        \u00e2\u02dc\u0192 = Mth.m_14089_(f);
        \u00e2\u02dc\u0192 = Mth.m_14031_(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = Mth.m_14089_(\u00e2\u02dc\u0192);
        boolean \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192 > 0.0f;
        boolean \u00e2\u02dc\u01923 = \u00e2\u02dc\u0192 < 0.0f;
        boolean \u00e2\u02dc\u01924 = \u00e2\u02dc\u0192 > 0.0f;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922 ? \u00e2\u02dc\u0192 : -\u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923 ? -\u00e2\u02dc\u0192 : \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924 ? \u00e2\u02dc\u0192 : -\u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
        Direction \u00e2\u02dc\u01925 = \u00e2\u02dc\u01922 ? EAST : WEST;
        Direction \u00e2\u02dc\u01926 = \u00e2\u02dc\u01923 ? UP : DOWN;
        Direction direction = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924 ? SOUTH : NORTH;
        if (\u00e2\u02dc\u0192 > \u00e2\u02dc\u0192) {
            if (\u00e2\u02dc\u0192 > \u00e2\u02dc\u0192) {
                return Direction.m_122398_(\u00e2\u02dc\u01926, \u00e2\u02dc\u01925, \u00e2\u02dc\u0192);
            }
            if (\u00e2\u02dc\u0192 > \u00e2\u02dc\u0192) {
                return Direction.m_122398_(\u00e2\u02dc\u01925, \u00e2\u02dc\u0192, \u00e2\u02dc\u01926);
            }
            return Direction.m_122398_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01926, \u00e2\u02dc\u0192);
        }
        if (\u00e2\u02dc\u0192 > \u00e2\u02dc\u0192) {
            return Direction.m_122398_(\u00e2\u02dc\u01926, \u00e2\u02dc\u0192, \u00e2\u02dc\u01925);
        }
        if (\u00e2\u02dc\u0192 > \u00e2\u02dc\u0192) {
            return Direction.m_122398_(\u00e2\u02dc\u0192, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926);
        }
        return Direction.m_122398_(\u00e2\u02dc\u0192, \u00e2\u02dc\u01926, \u00e2\u02dc\u01925);
    }

    private static Direction[] m_122398_(Direction p_122399_, Direction p_122400_, Direction p_122401_) {
        return new Direction[]{p_122399_, p_122400_, p_122401_, p_122401_.m_122424_(), p_122400_.m_122424_(), p_122399_.m_122424_()};
    }

    public static Direction m_122384_(Matrix4f p_122385_, Direction p_122386_) {
        Vec3i vec3i = p_122386_.m_122436_();
        Vector4f \u00e2\u02dc\u01922 = new Vector4f(vec3i.m_123341_(), vec3i.m_123342_(), vec3i.m_123343_(), 0.0f);
        \u00e2\u02dc\u01922.m_123607_(p_122385_);
        return Direction.m_122372_(\u00e2\u02dc\u01922.m_123601_(), \u00e2\u02dc\u01922.m_123615_(), \u00e2\u02dc\u01922.m_123616_());
    }

    public Quaternion m_122406_() {
        Quaternion quaternion = Vector3f.f_122223_.m_122240_(90.0f);
        switch (this) {
            case DOWN: {
                return Vector3f.f_122223_.m_122240_(180.0f);
            }
            case UP: {
                return Quaternion.f_80118_.m_80161_();
            }
            case NORTH: {
                quaternion.m_80148_(Vector3f.f_122227_.m_122240_(180.0f));
                return quaternion;
            }
            case SOUTH: {
                return quaternion;
            }
            case WEST: {
                quaternion.m_80148_(Vector3f.f_122227_.m_122240_(90.0f));
                return quaternion;
            }
        }
        quaternion.m_80148_(Vector3f.f_122227_.m_122240_(-90.0f));
        return quaternion;
    }

    public int m_122411_() {
        return this.f_122339_;
    }

    public int m_122416_() {
        return this.f_122341_;
    }

    public AxisDirection m_122421_() {
        return this.f_122344_;
    }

    public static Direction m_175357_(Entity p_175358_, Axis p_175359_) {
        switch (p_175359_) {
            case X: {
                return EAST.m_122370_(p_175358_.m_5675_(1.0f)) ? EAST : WEST;
            }
            case Z: {
                return SOUTH.m_122370_(p_175358_.m_5675_(1.0f)) ? SOUTH : NORTH;
            }
        }
        return p_175358_.m_5686_(1.0f) < 0.0f ? UP : DOWN;
    }

    public Direction m_122424_() {
        return Direction.m_122376_(this.f_122340_);
    }

    public Direction m_175362_(Axis p_175363_) {
        switch (p_175363_) {
            case X: {
                if (this == WEST || this == EAST) {
                    return this;
                }
                return this.m_175366_();
            }
            case Y: {
                if (this == UP || this == DOWN) {
                    return this;
                }
                return this.m_122427_();
            }
            case Z: {
                if (this == NORTH || this == SOUTH) {
                    return this;
                }
                return this.m_175368_();
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + p_175363_);
    }

    public Direction m_175364_(Axis p_175365_) {
        switch (p_175365_) {
            case X: {
                if (this == WEST || this == EAST) {
                    return this;
                }
                return this.m_175367_();
            }
            case Y: {
                if (this == UP || this == DOWN) {
                    return this;
                }
                return this.m_122428_();
            }
            case Z: {
                if (this == NORTH || this == SOUTH) {
                    return this;
                }
                return this.m_175369_();
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + p_175365_);
    }

    public Direction m_122427_() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + this);
    }

    private Direction m_175366_() {
        switch (this) {
            case UP: {
                return NORTH;
            }
            case NORTH: {
                return DOWN;
            }
            case DOWN: {
                return SOUTH;
            }
            case SOUTH: {
                return UP;
            }
        }
        throw new IllegalStateException("Unable to get X-rotated facing of " + this);
    }

    private Direction m_175367_() {
        switch (this) {
            case UP: {
                return SOUTH;
            }
            case SOUTH: {
                return DOWN;
            }
            case DOWN: {
                return NORTH;
            }
            case NORTH: {
                return UP;
            }
        }
        throw new IllegalStateException("Unable to get X-rotated facing of " + this);
    }

    private Direction m_175368_() {
        switch (this) {
            case UP: {
                return EAST;
            }
            case EAST: {
                return DOWN;
            }
            case DOWN: {
                return WEST;
            }
            case WEST: {
                return UP;
            }
        }
        throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
    }

    private Direction m_175369_() {
        switch (this) {
            case UP: {
                return WEST;
            }
            case WEST: {
                return DOWN;
            }
            case DOWN: {
                return EAST;
            }
            case EAST: {
                return UP;
            }
        }
        throw new IllegalStateException("Unable to get Z-rotated facing of " + this);
    }

    public Direction m_122428_() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + this);
    }

    public int m_122429_() {
        return this.f_122345_.m_123341_();
    }

    public int m_122430_() {
        return this.f_122345_.m_123342_();
    }

    public int m_122431_() {
        return this.f_122345_.m_123343_();
    }

    public Vector3f m_122432_() {
        return new Vector3f(this.m_122429_(), this.m_122430_(), this.m_122431_());
    }

    public String m_122433_() {
        return this.f_122342_;
    }

    public Axis m_122434_() {
        return this.f_122343_;
    }

    @Nullable
    public static Direction m_122402_(@Nullable String p_122403_) {
        if (p_122403_ == null) {
            return null;
        }
        return f_122347_.get(p_122403_.toLowerCase(Locale.ROOT));
    }

    public static Direction m_122376_(int p_122377_) {
        return f_122348_[Mth.m_14040_(p_122377_ % f_122348_.length)];
    }

    public static Direction m_122407_(int p_122408_) {
        return f_122349_[Mth.m_14040_(p_122408_ % f_122349_.length)];
    }

    @Nullable
    public static Direction m_175360_(BlockPos p_175361_) {
        return (Direction)f_122350_.get(p_175361_.m_121878_());
    }

    @Nullable
    public static Direction m_122378_(int p_122379_, int p_122380_, int p_122381_) {
        return (Direction)f_122350_.get(BlockPos.m_121882_(p_122379_, p_122380_, p_122381_));
    }

    public static Direction m_122364_(double p_122365_) {
        return Direction.m_122407_(Mth.m_14107_(p_122365_ / 90.0 + 0.5) & 3);
    }

    public static Direction m_122387_(Axis p_122388_, AxisDirection p_122389_) {
        switch (p_122388_) {
            case X: {
                return p_122389_ == AxisDirection.POSITIVE ? EAST : WEST;
            }
            case Y: {
                return p_122389_ == AxisDirection.POSITIVE ? UP : DOWN;
            }
        }
        return p_122389_ == AxisDirection.POSITIVE ? SOUTH : NORTH;
    }

    public float m_122435_() {
        return (this.f_122341_ & 3) * 90;
    }

    public static Direction m_122404_(Random p_122405_) {
        return Util.m_137545_(f_122346_, p_122405_);
    }

    public static Direction m_122366_(double p_122367_, double p_122368_, double p_122369_) {
        return Direction.m_122372_((float)p_122367_, (float)p_122368_, (float)p_122369_);
    }

    public static Direction m_122372_(float p_122373_, float p_122374_, float p_122375_) {
        Direction \u00e2\u02dc\u01923 = NORTH;
        float \u00e2\u02dc\u01922 = Float.MIN_VALUE;
        for (Direction direction : f_122346_) {
            float f = p_122373_ * (float)direction.f_122345_.m_123341_() + p_122374_ * (float)direction.f_122345_.m_123342_() + p_122375_ * (float)direction.f_122345_.m_123343_();
            if (!(f > \u00e2\u02dc\u01922)) continue;
            \u00e2\u02dc\u01922 = f;
            \u00e2\u02dc\u01923 = direction;
        }
        return \u00e2\u02dc\u01923;
    }

    public String toString() {
        return this.f_122342_;
    }

    @Override
    public String m_7912_() {
        return this.f_122342_;
    }

    public static Direction m_122390_(AxisDirection p_122391_, Axis p_122392_) {
        for (Direction direction : f_122346_) {
            if (direction.m_122421_() != p_122391_ || direction.m_122434_() != p_122392_) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + p_122391_ + " " + p_122392_);
    }

    public Vec3i m_122436_() {
        return this.f_122345_;
    }

    public boolean m_122370_(float p_122371_) {
        float f = p_122371_ * ((float)Math.PI / 180);
        \u00e2\u02dc\u0192 = -Mth.m_14031_(f);
        \u00e2\u02dc\u0192 = Mth.m_14089_(f);
        return (float)this.f_122345_.m_123341_() * \u00e2\u02dc\u0192 + (float)this.f_122345_.m_123343_() * \u00e2\u02dc\u0192 > 0.0f;
    }

    private static /* synthetic */ Direction[] m_175370_() {
        return new Direction[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    }

    static {
        $VALUES = Direction.m_175370_();
        f_175356_ = StringRepresentable.m_14350_(Direction::values, Direction::m_122402_);
        f_122346_ = Direction.values();
        f_122347_ = Arrays.stream(f_122346_).collect(Collectors.toMap(Direction::m_122433_, p_122426_ -> p_122426_));
        f_122348_ = (Direction[])Arrays.stream(f_122346_).sorted(Comparator.comparingInt(p_122423_ -> p_122423_.f_122339_)).toArray(Direction[]::new);
        f_122349_ = (Direction[])Arrays.stream(f_122346_).filter(p_122420_ -> p_122420_.m_122434_().m_122479_()).sorted(Comparator.comparingInt(p_122415_ -> p_122415_.f_122341_)).toArray(Direction[]::new);
        f_122350_ = (Long2ObjectMap)Arrays.stream(f_122346_).collect(Collectors.toMap(p_122410_ -> new BlockPos(p_122410_.m_122436_()).m_121878_(), p_122394_ -> p_122394_, (p_122396_, p_122397_) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    public static abstract class Axis
    extends Enum<Axis>
    implements StringRepresentable,
    Predicate<Direction> {
        public static final /* enum */ Axis X = new Axis("x"){

            @Override
            public int m_7863_(int p_122496_, int p_122497_, int p_122498_) {
                return p_122496_;
            }

            @Override
            public double m_6150_(double p_122492_, double p_122493_, double p_122494_) {
                return p_122492_;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        };
        public static final /* enum */ Axis Y = new Axis("y"){

            @Override
            public int m_7863_(int p_122510_, int p_122511_, int p_122512_) {
                return p_122511_;
            }

            @Override
            public double m_6150_(double p_122506_, double p_122507_, double p_122508_) {
                return p_122507_;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        };
        public static final /* enum */ Axis Z = new Axis("z"){

            @Override
            public int m_7863_(int p_122524_, int p_122525_, int p_122526_) {
                return p_122526_;
            }

            @Override
            public double m_6150_(double p_122520_, double p_122521_, double p_122522_) {
                return p_122522_;
            }

            @Override
            public /* synthetic */ boolean test(@Nullable Object object) {
                return super.test((Direction)object);
            }
        };
        public static final Axis[] f_122448_;
        public static final Codec<Axis> f_122447_;
        private static final Map<String, Axis> f_122449_;
        private final String f_122450_;
        private static final /* synthetic */ Axis[] $VALUES;

        public static Axis[] values() {
            return (Axis[])$VALUES.clone();
        }

        public static Axis valueOf(String p_122485_) {
            return Enum.valueOf(Axis.class, p_122485_);
        }

        Axis(String p_122456_) {
            this.f_122450_ = p_122456_;
        }

        @Nullable
        public static Axis m_122473_(String p_122474_) {
            return f_122449_.get(p_122474_.toLowerCase(Locale.ROOT));
        }

        public String m_122477_() {
            return this.f_122450_;
        }

        public boolean m_122478_() {
            return this == Y;
        }

        public boolean m_122479_() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.f_122450_;
        }

        public static Axis m_122475_(Random p_122476_) {
            return Util.m_137545_(f_122448_, p_122476_);
        }

        @Override
        public boolean test(@Nullable Direction p_122472_) {
            return p_122472_ != null && p_122472_.m_122434_() == this;
        }

        public Plane m_122480_() {
            switch (this) {
                case X: 
                case Z: {
                    return Plane.HORIZONTAL;
                }
                case Y: {
                    return Plane.VERTICAL;
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        @Override
        public String m_7912_() {
            return this.f_122450_;
        }

        public abstract int m_7863_(int var1, int var2, int var3);

        public abstract double m_6150_(double var1, double var3, double var5);

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((Direction)object);
        }

        private static /* synthetic */ Axis[] m_175371_() {
            return new Axis[]{X, Y, Z};
        }

        static {
            $VALUES = Axis.m_175371_();
            f_122448_ = Axis.values();
            f_122447_ = StringRepresentable.m_14350_(Axis::values, Axis::m_122473_);
            f_122449_ = Arrays.stream(f_122448_).collect(Collectors.toMap(Axis::m_122477_, p_122470_ -> p_122470_));
        }
    }

    public static final class AxisDirection
    extends Enum<AxisDirection> {
        public static final /* enum */ AxisDirection POSITIVE = new AxisDirection(1, "Towards positive");
        public static final /* enum */ AxisDirection NEGATIVE = new AxisDirection(-1, "Towards negative");
        private final int f_122531_;
        private final String f_122532_;
        private static final /* synthetic */ AxisDirection[] $VALUES;

        public static AxisDirection[] values() {
            return (AxisDirection[])$VALUES.clone();
        }

        public static AxisDirection valueOf(String p_122544_) {
            return Enum.valueOf(AxisDirection.class, p_122544_);
        }

        private AxisDirection(int p_122538_, String p_122539_) {
            this.f_122531_ = p_122538_;
            this.f_122532_ = p_122539_;
        }

        public int m_122540_() {
            return this.f_122531_;
        }

        public String m_175372_() {
            return this.f_122532_;
        }

        public String toString() {
            return this.f_122532_;
        }

        public AxisDirection m_122541_() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }

        private static /* synthetic */ AxisDirection[] m_175373_() {
            return new AxisDirection[]{POSITIVE, NEGATIVE};
        }

        static {
            $VALUES = AxisDirection.m_175373_();
        }
    }

    public static final class Plane
    extends Enum<Plane>
    implements Iterable<Direction>,
    Predicate<Direction> {
        public static final /* enum */ Plane HORIZONTAL = new Plane(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z});
        public static final /* enum */ Plane VERTICAL = new Plane(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});
        private final Direction[] f_122548_;
        private final Axis[] f_122549_;
        private static final /* synthetic */ Plane[] $VALUES;

        public static Plane[] values() {
            return (Plane[])$VALUES.clone();
        }

        public static Plane valueOf(String p_122568_) {
            return Enum.valueOf(Plane.class, p_122568_);
        }

        private Plane(Direction[] p_122555_, Axis[] p_122556_) {
            this.f_122548_ = p_122555_;
            this.f_122549_ = p_122556_;
        }

        public Direction m_122560_(Random p_122561_) {
            return Util.m_137545_(this.f_122548_, p_122561_);
        }

        public Axis m_122562_(Random p_122563_) {
            return Util.m_137545_(this.f_122549_, p_122563_);
        }

        @Override
        public boolean test(@Nullable Direction p_122559_) {
            return p_122559_ != null && p_122559_.m_122434_().m_122480_() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.f_122548_);
        }

        public Stream<Direction> m_122557_() {
            return Arrays.stream(this.f_122548_);
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((Direction)object);
        }

        private static /* synthetic */ Plane[] m_175374_() {
            return new Plane[]{HORIZONTAL, VERTICAL};
        }

        static {
            $VALUES = Plane.m_175374_();
        }
    }
}

