/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryDataPackCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MappedRegistry<T>
extends WritableRegistry<T> {
    protected static final Logger f_122670_ = LogManager.getLogger();
    private final ObjectList<T> f_122672_ = new ObjectArrayList(256);
    private final Object2IntMap<T> f_122673_ = new Object2IntOpenCustomHashMap(Util.m_137583_());
    private final BiMap<ResourceLocation, T> f_122674_;
    private final BiMap<ResourceKey<T>, T> f_122675_;
    private final Map<T, Lifecycle> f_122676_;
    private Lifecycle f_122677_;
    protected Object[] f_122671_;
    private int f_122678_;

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_122681_, Lifecycle p_122682_) {
        super(p_122681_, p_122682_);
        this.f_122673_.defaultReturnValue(-1);
        this.f_122674_ = HashBiMap.create();
        this.f_122675_ = HashBiMap.create();
        this.f_122676_ = Maps.newIdentityHashMap();
        this.f_122677_ = p_122682_;
    }

    public static <T> MapCodec<RegistryEntry<T>> m_122727_(ResourceKey<? extends Registry<T>> p_122728_, MapCodec<T> p_122729_) {
        return RecordCodecBuilder.mapCodec(p_122733_ -> p_122733_.group((App)ResourceLocation.f_135803_.xmap(ResourceKey.m_135797_(p_122728_), ResourceKey::m_135782_).fieldOf("name").forGetter(p_175394_ -> p_175394_.f_122766_), (App)Codec.INT.fieldOf("id").forGetter(p_175390_ -> p_175390_.f_122767_), (App)p_122729_.forGetter(p_175383_ -> p_175383_.f_122768_)).apply((Applicative)p_122733_, RegistryEntry::new));
    }

    @Override
    public <V extends T> V m_5748_(int p_122686_, ResourceKey<T> p_122687_, V p_122688_, Lifecycle p_122689_) {
        return this.m_122690_(p_122686_, p_122687_, p_122688_, p_122689_, true);
    }

    private <V extends T> V m_122690_(int p_122691_, ResourceKey<T> p_122692_, V p_122693_, Lifecycle p_122694_, boolean p_122695_) {
        Validate.notNull(p_122692_);
        Validate.notNull(p_122693_);
        this.f_122672_.size(Math.max(this.f_122672_.size(), p_122691_ + 1));
        this.f_122672_.set(p_122691_, p_122693_);
        this.f_122673_.put(p_122693_, p_122691_);
        this.f_122671_ = null;
        if (p_122695_ && this.f_122675_.containsKey(p_122692_)) {
            f_122670_.debug("Adding duplicate key '{}' to registry", p_122692_);
        }
        if (this.f_122674_.containsValue(p_122693_)) {
            f_122670_.error("Adding duplicate value '{}' to registry", p_122693_);
        }
        this.f_122674_.put((Object)p_122692_.m_135782_(), p_122693_);
        this.f_122675_.put(p_122692_, p_122693_);
        this.f_122676_.put(p_122693_, p_122694_);
        this.f_122677_ = this.f_122677_.add(p_122694_);
        if (this.f_122678_ <= p_122691_) {
            this.f_122678_ = p_122691_ + 1;
        }
        return p_122693_;
    }

    @Override
    public <V extends T> V m_7135_(ResourceKey<T> p_122735_, V p_122736_, Lifecycle p_122737_) {
        return this.m_5748_(this.f_122678_, p_122735_, p_122736_, p_122737_);
    }

    @Override
    public <V extends T> V m_7794_(OptionalInt p_122708_, ResourceKey<T> p_122709_, V p_122710_, Lifecycle p_122711_) {
        int \u00e2\u02dc\u01922;
        Validate.notNull(p_122709_);
        Validate.notNull(p_122710_);
        Object object = this.f_122675_.get(p_122709_);
        if (object == null) {
            \u00e2\u02dc\u01922 = p_122708_.isPresent() ? p_122708_.getAsInt() : this.f_122678_;
        } else {
            \u00e2\u02dc\u01922 = this.f_122673_.getInt(object);
            if (p_122708_.isPresent() && p_122708_.getAsInt() != \u00e2\u02dc\u01922) {
                throw new IllegalStateException("ID mismatch");
            }
            this.f_122673_.removeInt(object);
            this.f_122676_.remove(object);
        }
        return this.m_122690_(\u00e2\u02dc\u01922, p_122709_, p_122710_, p_122711_, false);
    }

    @Override
    @Nullable
    public ResourceLocation m_7981_(T p_122746_) {
        return (ResourceLocation)this.f_122674_.inverse().get(p_122746_);
    }

    @Override
    public Optional<ResourceKey<T>> m_7854_(T p_122755_) {
        return Optional.ofNullable((ResourceKey)this.f_122675_.inverse().get(p_122755_));
    }

    @Override
    public int m_7447_(@Nullable T p_122706_) {
        return this.f_122673_.getInt(p_122706_);
    }

    @Override
    @Nullable
    public T m_6246_(@Nullable ResourceKey<T> p_122714_) {
        return (T)this.f_122675_.get(p_122714_);
    }

    @Override
    @Nullable
    public T m_7942_(int p_122684_) {
        if (p_122684_ < 0 || p_122684_ >= this.f_122672_.size()) {
            return null;
        }
        return (T)this.f_122672_.get(p_122684_);
    }

    @Override
    public Lifecycle m_6228_(T p_122764_) {
        return this.f_122676_.get(p_122764_);
    }

    @Override
    public Lifecycle m_7837_() {
        return this.f_122677_;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter((Iterator)this.f_122672_.iterator(), Objects::nonNull);
    }

    @Override
    @Nullable
    public T m_7745_(@Nullable ResourceLocation p_122739_) {
        return (T)this.f_122674_.get((Object)p_122739_);
    }

    @Override
    public Set<ResourceLocation> m_6566_() {
        return Collections.unmodifiableSet(this.f_122674_.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> m_6579_() {
        return Collections.unmodifiableMap(this.f_122675_).entrySet();
    }

    @Override
    public boolean m_142427_() {
        return this.f_122674_.isEmpty();
    }

    @Override
    @Nullable
    public T m_142697_(Random p_122712_) {
        if (this.f_122671_ == null) {
            Set set = this.f_122674_.values();
            if (set.isEmpty()) {
                return null;
            }
            this.f_122671_ = set.toArray(new Object[set.size()]);
        }
        return (T)Util.m_137545_(this.f_122671_, p_122712_);
    }

    @Override
    public boolean m_7804_(ResourceLocation p_122761_) {
        return this.f_122674_.containsKey((Object)p_122761_);
    }

    @Override
    public boolean m_142003_(ResourceKey<T> p_175392_) {
        return this.f_122675_.containsKey(p_175392_);
    }

    public static <T> Codec<MappedRegistry<T>> m_122715_(ResourceKey<? extends Registry<T>> p_122716_, Lifecycle p_122717_, Codec<T> p_122718_) {
        return MappedRegistry.m_122727_(p_122716_, p_122718_.fieldOf("element")).codec().listOf().xmap(p_122722_ -> {
            MappedRegistry mappedRegistry = new MappedRegistry(p_122716_, p_122717_);
            for (RegistryEntry registryEntry : p_122722_) {
                mappedRegistry.m_5748_(registryEntry.f_122767_, registryEntry.f_122766_, registryEntry.f_122768_, p_122717_);
            }
            return mappedRegistry;
        }, p_122744_ -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object t : p_122744_) {
                builder.add(new RegistryEntry(p_122744_.m_7854_(t).get(), p_122744_.m_7447_(t), t));
            }
            return builder.build();
        });
    }

    public static <T> Codec<MappedRegistry<T>> m_122747_(ResourceKey<? extends Registry<T>> p_122748_, Lifecycle p_122749_, Codec<T> p_122750_) {
        return RegistryDataPackCodec.m_135558_(p_122748_, p_122749_, p_122750_);
    }

    public static <T> Codec<MappedRegistry<T>> m_122756_(ResourceKey<? extends Registry<T>> p_122757_, Lifecycle p_122758_, Codec<T> p_122759_) {
        return Codec.unboundedMap((Codec)ResourceLocation.f_135803_.xmap(ResourceKey.m_135797_(p_122757_), ResourceKey::m_135782_), p_122759_).xmap(p_122726_ -> {
            MappedRegistry mappedRegistry = new MappedRegistry(p_122757_, p_122758_);
            p_122726_.forEach((? super K p_175387_, ? super V p_175388_) -> mappedRegistry.m_7135_((ResourceKey)p_175387_, (Object)p_175388_, p_122758_));
            return mappedRegistry;
        }, p_122699_ -> ImmutableMap.copyOf(p_122699_.f_122675_));
    }

    public static class RegistryEntry<T> {
        public final ResourceKey<T> f_122766_;
        public final int f_122767_;
        public final T f_122768_;

        public RegistryEntry(ResourceKey<T> p_122770_, int p_122771_, T p_122772_) {
            this.f_122766_ = p_122770_;
            this.f_122767_ = p_122771_;
            this.f_122768_ = p_122772_;
        }
    }
}

