/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HashCache {
    private static final Logger f_123926_ = LogManager.getLogger();
    private final Path f_123927_;
    private final Path f_123928_;
    private int f_123929_;
    private final Map<Path, String> f_123930_ = Maps.newHashMap();
    private final Map<Path, String> f_123931_ = Maps.newHashMap();
    private final Set<Path> f_123932_ = Sets.newHashSet();

    public HashCache(Path p_123935_, String p_123936_) throws IOException {
        this.f_123927_ = p_123935_;
        Path path = p_123935_.resolve(".cache");
        Files.createDirectories(path, new FileAttribute[0]);
        this.f_123928_ = path.resolve(p_123936_);
        this.m_123951_().forEach(p_123959_ -> this.f_123930_.put((Path)p_123959_, ""));
        if (Files.isReadable(this.f_123928_)) {
            IOUtils.readLines((InputStream)Files.newInputStream(this.f_123928_, new OpenOption[0]), (Charset)Charsets.UTF_8).forEach(p_123950_ -> {
                int n = p_123950_.indexOf(32);
                this.f_123930_.put(p_123935_.resolve(p_123950_.substring(n + 1)), p_123950_.substring(0, n));
            });
        }
    }

    public void m_123937_() throws IOException {
        this.m_123945_();
        try {
            BufferedWriter bufferedWriter = Files.newBufferedWriter(this.f_123928_, new OpenOption[0]);
        }
        catch (IOException iOException) {
            f_123926_.warn("Unable write cachefile {}: {}", (Object)this.f_123928_, (Object)iOException.toString());
            return;
        }
        IOUtils.writeLines((Collection)this.f_123931_.entrySet().stream().map(p_123944_ -> (String)p_123944_.getValue() + " " + this.f_123927_.relativize((Path)p_123944_.getKey())).collect(Collectors.toList()), (String)System.lineSeparator(), (Writer)bufferedWriter);
        ((Writer)bufferedWriter).close();
        f_123926_.debug("Caching: cache hits: {}, created: {} removed: {}", (Object)this.f_123929_, (Object)(this.f_123931_.size() - this.f_123929_), (Object)this.f_123930_.size());
    }

    @Nullable
    public String m_123938_(Path p_123939_) {
        return this.f_123930_.get(p_123939_);
    }

    public void m_123940_(Path p_123941_, String p_123942_) {
        this.f_123931_.put(p_123941_, p_123942_);
        if (Objects.equals(this.f_123930_.remove(p_123941_), p_123942_)) {
            ++this.f_123929_;
        }
    }

    public boolean m_123946_(Path p_123947_) {
        return this.f_123930_.containsKey(p_123947_);
    }

    public void m_123952_(Path p_123953_) {
        this.f_123932_.add(p_123953_);
    }

    private void m_123945_() throws IOException {
        this.m_123951_().forEach(p_123957_ -> {
            if (this.m_123946_((Path)p_123957_) && !this.f_123932_.contains(p_123957_)) {
                try {
                    Files.delete(p_123957_);
                }
                catch (IOException iOException) {
                    f_123926_.debug("Unable to delete: {} ({})", p_123957_, (Object)iOException.toString());
                }
            }
        });
    }

    private Stream<Path> m_123951_() throws IOException {
        return Files.walk(this.f_123927_, new FileVisitOption[0]).filter(p_123955_ -> !Objects.equals(this.f_123928_, p_123955_) && !Files.isDirectory(p_123955_, new LinkOption[0]));
    }
}

