/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Collectors;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.worldgen.biome.BiomeReport;
import net.minecraft.obfuscate.DontObfuscate;

public class Main {
    @DontObfuscate
    public static void main(String[] p_129669_) throws IOException {
        SharedConstants.m_142977_();
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec \u00e2\u02dc\u01922 = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder \u00e2\u02dc\u01923 = optionParser.accepts("server", "Include server generators");
        OptionSpecBuilder \u00e2\u02dc\u01924 = optionParser.accepts("client", "Include client generators");
        OptionSpecBuilder \u00e2\u02dc\u01925 = optionParser.accepts("dev", "Include development tools");
        OptionSpecBuilder \u00e2\u02dc\u01926 = optionParser.accepts("reports", "Include data reports");
        OptionSpecBuilder \u00e2\u02dc\u01927 = optionParser.accepts("validate", "Validate inputs");
        OptionSpecBuilder \u00e2\u02dc\u01928 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u01929 = optionParser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019210 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet \u00e2\u02dc\u019211 = optionParser.parse(p_129669_);
        if (\u00e2\u02dc\u019211.has((OptionSpec)\u00e2\u02dc\u01922) || !\u00e2\u02dc\u019211.hasOptions()) {
            optionParser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path \u00e2\u02dc\u019212 = Paths.get((String)\u00e2\u02dc\u01929.value(\u00e2\u02dc\u019211), new String[0]);
        boolean \u00e2\u02dc\u019213 = \u00e2\u02dc\u019211.has((OptionSpec)\u00e2\u02dc\u01928);
        boolean \u00e2\u02dc\u019214 = \u00e2\u02dc\u019213 || \u00e2\u02dc\u019211.has((OptionSpec)\u00e2\u02dc\u01924);
        boolean \u00e2\u02dc\u019215 = \u00e2\u02dc\u019213 || \u00e2\u02dc\u019211.has((OptionSpec)\u00e2\u02dc\u01923);
        boolean \u00e2\u02dc\u019216 = \u00e2\u02dc\u019213 || \u00e2\u02dc\u019211.has((OptionSpec)\u00e2\u02dc\u01925);
        boolean \u00e2\u02dc\u019217 = \u00e2\u02dc\u019213 || \u00e2\u02dc\u019211.has((OptionSpec)\u00e2\u02dc\u01926);
        boolean \u00e2\u02dc\u019218 = \u00e2\u02dc\u019213 || \u00e2\u02dc\u019211.has((OptionSpec)\u00e2\u02dc\u01927);
        DataGenerator \u00e2\u02dc\u019219 = Main.m_129660_(\u00e2\u02dc\u019212, \u00e2\u02dc\u019211.valuesOf((OptionSpec)\u00e2\u02dc\u019210).stream().map(p_129659_ -> Paths.get(p_129659_, new String[0])).collect(Collectors.toList()), \u00e2\u02dc\u019214, \u00e2\u02dc\u019215, \u00e2\u02dc\u019216, \u00e2\u02dc\u019217, \u00e2\u02dc\u019218);
        \u00e2\u02dc\u019219.m_123917_();
    }

    public static DataGenerator m_129660_(Path p_129661_, Collection<Path> p_129662_, boolean p_129663_, boolean p_129664_, boolean p_129665_, boolean p_129666_, boolean p_129667_) {
        DataGenerator dataGenerator = new DataGenerator(p_129661_, p_129662_);
        if (p_129663_ || p_129664_) {
            dataGenerator.m_123914_(new SnbtToNbt(dataGenerator).m_126475_(new StructureUpdater()));
        }
        if (p_129663_) {
            dataGenerator.m_123914_(new ModelProvider(dataGenerator));
        }
        if (p_129664_) {
            dataGenerator.m_123914_(new FluidTagsProvider(dataGenerator));
            BlockTagsProvider blockTagsProvider = new BlockTagsProvider(dataGenerator);
            dataGenerator.m_123914_(blockTagsProvider);
            dataGenerator.m_123914_(new ItemTagsProvider(dataGenerator, blockTagsProvider));
            dataGenerator.m_123914_(new EntityTypeTagsProvider(dataGenerator));
            dataGenerator.m_123914_(new RecipeProvider(dataGenerator));
            dataGenerator.m_123914_(new AdvancementProvider(dataGenerator));
            dataGenerator.m_123914_(new LootTableProvider(dataGenerator));
            dataGenerator.m_123914_(new GameEventTagsProvider(dataGenerator));
        }
        if (p_129665_) {
            dataGenerator.m_123914_(new NbtToSnbt(dataGenerator));
        }
        if (p_129666_) {
            dataGenerator.m_123914_(new BlockListReport(dataGenerator));
            dataGenerator.m_123914_(new RegistryDumpReport(dataGenerator));
            dataGenerator.m_123914_(new CommandsReport(dataGenerator));
            dataGenerator.m_123914_(new BiomeReport(dataGenerator));
        }
        return dataGenerator;
    }
}

