/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelProvider
implements DataProvider {
    private static final Logger f_125095_ = LogManager.getLogger();
    private static final Gson f_125096_ = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator f_125097_;

    public ModelProvider(DataGenerator p_125100_) {
        this.f_125097_ = p_125100_;
    }

    @Override
    public void m_6865_(HashCache p_125103_) {
        Path path = this.f_125097_.m_123916_();
        HashMap \u00e2\u02dc\u01922 = Maps.newHashMap();
        Consumer<BlockStateGenerator> \u00e2\u02dc\u01923 = p_125120_ -> {
            Block block = p_125120_.m_6968_();
            BlockStateGenerator \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.put(block, p_125120_);
            if (\u00e2\u02dc\u01922 != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + block);
            }
        };
        HashMap \u00e2\u02dc\u01924 = Maps.newHashMap();
        HashSet \u00e2\u02dc\u01925 = Sets.newHashSet();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> \u00e2\u02dc\u01926 = (p_125123_, p_125124_) -> {
            Supplier supplier = \u00e2\u02dc\u01924.put(p_125123_, p_125124_);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + p_125123_);
            }
        };
        Consumer<Item> \u00e2\u02dc\u01927 = \u00e2\u02dc\u01925::add;
        new BlockModelGenerators(\u00e2\u02dc\u01923, \u00e2\u02dc\u01926, \u00e2\u02dc\u01927).m_124510_();
        new ItemModelGenerators(\u00e2\u02dc\u01926).m_125083_();
        List \u00e2\u02dc\u01928 = Registry.f_122824_.m_123024_().filter(p_125117_ -> !\u00e2\u02dc\u01922.containsKey(p_125117_)).collect(Collectors.toList());
        if (!\u00e2\u02dc\u01928.isEmpty()) {
            throw new IllegalStateException("Missing blockstate definitions for: " + \u00e2\u02dc\u01928);
        }
        Registry.f_122824_.forEach(p_125128_ -> {
            Item item = Item.f_41373_.get(p_125128_);
            if (item != null) {
                if (\u00e2\u02dc\u01925.contains(item)) {
                    return;
                }
                ResourceLocation resourceLocation = ModelLocationUtils.m_125571_(item);
                if (!\u00e2\u02dc\u01924.containsKey(resourceLocation)) {
                    \u00e2\u02dc\u01924.put(resourceLocation, new DelegatedModel(ModelLocationUtils.m_125576_(p_125128_)));
                }
            }
        });
        this.m_125104_(p_125103_, path, \u00e2\u02dc\u01922, ModelProvider::m_125109_);
        this.m_125104_(p_125103_, path, \u00e2\u02dc\u01924, ModelProvider::m_125112_);
    }

    private <T> void m_125104_(HashCache p_125105_, Path p_125106_, Map<T, ? extends Supplier<JsonElement>> p_125107_, BiFunction<Path, T, Path> p_125108_) {
        p_125107_.forEach((p_125133_, p_125134_) -> {
            Path path = (Path)p_125108_.apply(p_125106_, p_125133_);
            try {
                DataProvider.m_123920_(f_125096_, p_125105_, (JsonElement)p_125134_.get(), path);
            }
            catch (Exception \u00e2\u02dc\u01922) {
                f_125095_.error("Couldn't save {}", (Object)path, (Object)\u00e2\u02dc\u01922);
            }
        });
    }

    private static Path m_125109_(Path p_125110_, Block p_125111_) {
        ResourceLocation resourceLocation = Registry.f_122824_.m_7981_(p_125111_);
        return p_125110_.resolve("assets/" + resourceLocation.m_135827_() + "/blockstates/" + resourceLocation.m_135815_() + ".json");
    }

    private static Path m_125112_(Path p_125113_, ResourceLocation p_125114_) {
        return p_125113_.resolve("assets/" + p_125114_.m_135827_() + "/models/" + p_125114_.m_135815_() + ".json");
    }

    @Override
    public String m_6055_() {
        return "Block State Definitions";
    }
}

