/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NbtToSnbt
implements DataProvider {
    private static final Logger f_126421_ = LogManager.getLogger();
    private final DataGenerator f_126422_;

    public NbtToSnbt(DataGenerator p_126425_) {
        this.f_126422_ = p_126425_;
    }

    @Override
    public void m_6865_(HashCache p_126428_) throws IOException {
        Path path = this.f_126422_.m_123916_();
        for (Path path2 : this.f_126422_.m_123913_()) {
            Files.walk(path2, new FileVisitOption[0]).filter(p_126430_ -> p_126430_.toString().endsWith(".nbt")).forEach(p_126441_ -> NbtToSnbt.m_126431_(p_126441_, this.m_126435_(path2, (Path)p_126441_), path));
        }
    }

    @Override
    public String m_6055_() {
        return "NBT to SNBT";
    }

    private String m_126435_(Path p_126436_, Path p_126437_) {
        String string = p_126436_.relativize(p_126437_).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".nbt".length());
    }

    @Nullable
    public static Path m_126431_(Path p_126432_, String p_126433_, Path p_126434_) {
        try {
            NbtToSnbt.m_176812_(p_126434_.resolve(p_126433_ + ".snbt"), NbtUtils.m_178063_(NbtIo.m_128939_(Files.newInputStream(p_126432_, new OpenOption[0]))));
            f_126421_.info("Converted {} from NBT to SNBT", (Object)p_126433_);
            return p_126434_.resolve(p_126433_ + ".snbt");
        }
        catch (IOException iOException) {
            f_126421_.error("Couldn't convert {} from NBT to SNBT at {}", (Object)p_126433_, (Object)p_126432_, (Object)iOException);
            return null;
        }
    }

    public static void m_176812_(Path p_176813_, String p_176814_) throws IOException {
        Files.createDirectories(p_176813_.getParent(), new FileAttribute[0]);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(p_176813_, new OpenOption[0]);){
            bufferedWriter.write(p_176814_);
            bufferedWriter.write(10);
        }
    }
}

