/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SnbtToNbt
implements DataProvider {
    @Nullable
    private static final Path f_176815_ = null;
    private static final Logger f_126443_ = LogManager.getLogger();
    private final DataGenerator f_126444_;
    private final List<Filter> f_126445_ = Lists.newArrayList();

    public SnbtToNbt(DataGenerator p_126448_) {
        this.f_126444_ = p_126448_;
    }

    public SnbtToNbt m_126475_(Filter p_126476_) {
        this.f_126445_.add(p_126476_);
        return this;
    }

    private CompoundTag m_126460_(String p_126461_, CompoundTag p_126462_) {
        CompoundTag compoundTag = p_126462_;
        for (Filter filter : this.f_126445_) {
            compoundTag = filter.m_6392_(p_126461_, compoundTag);
        }
        return compoundTag;
    }

    @Override
    public void m_6865_(HashCache p_126451_) throws IOException {
        Path path = this.f_126444_.m_123916_();
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        for (Path path2 : this.f_126444_.m_123913_()) {
            Files.walk(path2, new FileVisitOption[0]).filter(p_126464_ -> p_126464_.toString().endsWith(".snbt")).forEach(p_126474_ -> \u00e2\u02dc\u01922.add(CompletableFuture.supplyAsync(() -> this.m_126465_((Path)p_126474_, this.m_126468_(path2, (Path)p_126474_)), Util.m_137578_())));
        }
        boolean \u00e2\u02dc\u01923 = false;
        for (CompletableFuture completableFuture : \u00e2\u02dc\u01922) {
            try {
                this.m_126456_(p_126451_, (TaskResult)completableFuture.get(), path);
            }
            catch (Exception exception) {
                f_126443_.error("Failed to process structure", (Throwable)exception);
                \u00e2\u02dc\u01923 = true;
            }
        }
        if (\u00e2\u02dc\u01923) {
            throw new IllegalStateException("Failed to convert all structures, aborting");
        }
    }

    @Override
    public String m_6055_() {
        return "SNBT -> NBT";
    }

    private String m_126468_(Path p_126469_, Path p_126470_) {
        String string = p_126469_.relativize(p_126470_).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    private TaskResult m_126465_(Path p_126466_, String p_126467_) {
        TaskResult taskResult;
        block8: {
            BufferedReader bufferedReader = Files.newBufferedReader(p_126466_);
            try {
                String string = IOUtils.toString((Reader)bufferedReader);
                CompoundTag \u00e2\u02dc\u01922 = this.m_126460_(p_126467_, NbtUtils.m_178024_(string));
                ByteArrayOutputStream \u00e2\u02dc\u01923 = new ByteArrayOutputStream();
                NbtIo.m_128947_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
                byte[] \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.toByteArray();
                \u00e2\u02dc\u0192 = f_123918_.hashBytes(\u00e2\u02dc\u01924).toString();
                \u00e2\u02dc\u0192 = f_176815_ != null ? NbtUtils.m_178063_(\u00e2\u02dc\u01922) : null;
                taskResult = new TaskResult(p_126467_, \u00e2\u02dc\u01924, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable \u00e2\u02dc\u01925) {
                    throw new StructureConversionException(p_126466_, \u00e2\u02dc\u01925);
                }
            }
            bufferedReader.close();
        }
        return taskResult;
    }

    private void m_126456_(HashCache p_126457_, TaskResult p_126458_, Path p_126459_) {
        Path path;
        if (p_126458_.f_126484_ != null) {
            path = f_176815_.resolve(p_126458_.f_126482_ + ".snbt");
            try {
                NbtToSnbt.m_176812_(path, p_126458_.f_126484_);
            }
            catch (IOException \u00e2\u02dc\u01922) {
                f_126443_.error("Couldn't write structure SNBT {} at {}", (Object)p_126458_.f_126482_, (Object)path, (Object)\u00e2\u02dc\u01922);
            }
        }
        path = p_126459_.resolve(p_126458_.f_126482_ + ".nbt");
        try {
            if (!Objects.equals(p_126457_.m_123938_(path), p_126458_.f_126485_) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                    outputStream.write(p_126458_.f_126483_);
                }
            }
            p_126457_.m_123940_(path, p_126458_.f_126485_);
        }
        catch (IOException iOException) {
            f_126443_.error("Couldn't write structure {} at {}", (Object)p_126458_.f_126482_, (Object)path, (Object)iOException);
        }
    }

    @FunctionalInterface
    public static interface Filter {
        public CompoundTag m_6392_(String var1, CompoundTag var2);
    }

    static class TaskResult {
        final String f_126482_;
        final byte[] f_126483_;
        @Nullable
        final String f_126484_;
        final String f_126485_;

        public TaskResult(String p_126487_, byte[] p_126488_, @Nullable String p_126489_, String p_126490_) {
            this.f_126482_ = p_126487_;
            this.f_126483_ = p_126488_;
            this.f_126484_ = p_126489_;
            this.f_126485_ = p_126490_;
        }
    }

    static class StructureConversionException
    extends RuntimeException {
        public StructureConversionException(Path p_176820_, Throwable p_176821_) {
            super(p_176820_.toAbsolutePath().toString(), p_176821_);
        }
    }
}

