/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TagsProvider<T>
implements DataProvider {
    private static final Logger f_126541_ = LogManager.getLogger();
    private static final Gson f_126542_ = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator f_126539_;
    protected final Registry<T> f_126540_;
    private final Map<ResourceLocation, Tag.Builder> f_126543_ = Maps.newLinkedHashMap();

    protected TagsProvider(DataGenerator p_126546_, Registry<T> p_126547_) {
        this.f_126539_ = p_126546_;
        this.f_126540_ = p_126547_;
    }

    protected abstract void m_6577_();

    @Override
    public void m_6865_(HashCache p_126554_) {
        this.f_126543_.clear();
        this.m_6577_();
        this.f_126543_.forEach((p_176835_, p_176836_) -> {
            List list = p_176836_.m_13330_().filter(p_176832_ -> !p_176832_.m_13347_().m_142746_(this.f_126540_::m_7804_, this.f_126543_::containsKey)).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Couldn't define tag %s as it is missing following references: %s", p_176835_, list.stream().map(Objects::toString).collect(Collectors.joining(","))));
            }
            JsonObject \u00e2\u02dc\u01922 = p_176836_.m_13334_();
            Path \u00e2\u02dc\u01923 = this.m_6648_((ResourceLocation)p_176835_);
            try {
                String string;
                String string2 = f_126542_.toJson((JsonElement)\u00e2\u02dc\u01922);
                string = f_123918_.hashUnencodedChars((CharSequence)string2).toString();
                if (!Objects.equals(p_126554_.m_123938_(\u00e2\u02dc\u01923), string) || !Files.exists(\u00e2\u02dc\u01923, new LinkOption[0])) {
                    Files.createDirectories(\u00e2\u02dc\u01923.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(\u00e2\u02dc\u01923, new OpenOption[0]);){
                        bufferedWriter.write(string2);
                    }
                }
                p_126554_.m_123940_(\u00e2\u02dc\u01923, string);
            }
            catch (IOException iOException) {
                f_126541_.error("Couldn't save tags to {}", (Object)\u00e2\u02dc\u01923, (Object)iOException);
            }
        });
    }

    protected abstract Path m_6648_(ResourceLocation var1);

    protected TagAppender<T> m_126548_(Tag.Named<T> p_126549_) {
        Tag.Builder builder = this.m_126562_(p_126549_);
        return new TagAppender<T>(builder, this.f_126540_, "vanilla");
    }

    protected Tag.Builder m_126562_(Tag.Named<T> p_126563_) {
        return this.f_126543_.computeIfAbsent(p_126563_.m_6979_(), p_176838_ -> new Tag.Builder());
    }

    protected static class TagAppender<T> {
        private final Tag.Builder f_126568_;
        private final Registry<T> f_126569_;
        private final String f_126570_;

        TagAppender(Tag.Builder p_126572_, Registry<T> p_126573_, String p_126574_) {
            this.f_126568_ = p_126572_;
            this.f_126569_ = p_126573_;
            this.f_126570_ = p_126574_;
        }

        public TagAppender<T> m_126582_(T p_126583_) {
            this.f_126568_.m_13327_(this.f_126569_.m_7981_(p_126583_), this.f_126570_);
            return this;
        }

        public TagAppender<T> m_176839_(ResourceLocation p_176840_) {
            this.f_126568_.m_144379_(p_176840_, this.f_126570_);
            return this;
        }

        public TagAppender<T> m_126580_(Tag.Named<T> p_126581_) {
            this.f_126568_.m_13335_(p_126581_.m_6979_(), this.f_126570_);
            return this;
        }

        public TagAppender<T> m_176841_(ResourceLocation p_176842_) {
            this.f_126568_.m_144382_(p_176842_, this.f_126570_);
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> m_126584_(T ... p_126585_) {
            Stream.of(p_126585_).map(this.f_126569_::m_7981_).forEach(p_126587_ -> this.f_126568_.m_13327_((ResourceLocation)p_126587_, this.f_126570_));
            return this;
        }
    }
}

