/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerTickList;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureUtils {
    private static final Logger f_177742_ = LogManager.getLogger();
    public static final String f_177741_ = "gameteststructures";
    public static String f_127833_ = "gameteststructures";
    private static final int f_177743_ = 4;

    public static Rotation m_127835_(int p_127836_) {
        switch (p_127836_) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + p_127836_);
    }

    public static int m_177751_(Rotation p_177752_) {
        switch (p_177752_) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + p_177752_);
    }

    public static void m_177770_(String[] p_177771_) throws IOException {
        Bootstrap.m_135870_();
        Files.walk(Paths.get(f_127833_, new String[0]), new FileVisitOption[0]).filter(p_177775_ -> p_177775_.toString().endsWith(".snbt")).forEach(p_177773_ -> {
            try {
                String string = new String(Files.readAllBytes(p_177773_), StandardCharsets.UTF_8);
                CompoundTag \u00e2\u02dc\u01922 = NbtUtils.m_178024_(string);
                CompoundTag \u00e2\u02dc\u01923 = StructureUpdater.m_176822_(p_177773_.toString(), \u00e2\u02dc\u01922);
                NbtToSnbt.m_176812_(p_177773_, NbtUtils.m_178063_(\u00e2\u02dc\u01923));
            }
            catch (CommandSyntaxException | IOException throwable) {
                f_177742_.error("Something went wrong upgrading: {}", p_177773_, (Object)throwable);
            }
        });
    }

    public static AABB m_127847_(StructureBlockEntity p_127848_) {
        BlockPos blockPos = p_127848_.m_58899_();
        \u00e2\u02dc\u0192 = blockPos.m_141952_(p_127848_.m_155805_().m_142082_(-1, -1, -1));
        \u00e2\u02dc\u0192 = StructureTemplate.m_74593_(\u00e2\u02dc\u0192, Mirror.NONE, p_127848_.m_59906_(), blockPos);
        return new AABB(blockPos, \u00e2\u02dc\u0192);
    }

    public static BoundingBox m_127904_(StructureBlockEntity p_127905_) {
        BlockPos blockPos = p_127905_.m_58899_();
        \u00e2\u02dc\u0192 = blockPos.m_141952_(p_127905_.m_155805_().m_142082_(-1, -1, -1));
        \u00e2\u02dc\u0192 = StructureTemplate.m_74593_(\u00e2\u02dc\u0192, Mirror.NONE, p_127905_.m_59906_(), blockPos);
        return BoundingBox.m_162375_(blockPos, \u00e2\u02dc\u0192);
    }

    public static void m_127875_(BlockPos p_127876_, BlockPos p_127877_, Rotation p_127878_, ServerLevel p_127879_) {
        BlockPos blockPos = StructureTemplate.m_74593_(p_127876_.m_141952_(p_127877_), Mirror.NONE, p_127878_, p_127876_);
        p_127879_.m_46597_(blockPos, Blocks.f_50272_.m_49966_());
        CommandBlockEntity \u00e2\u02dc\u01922 = (CommandBlockEntity)p_127879_.m_7702_(blockPos);
        \u00e2\u02dc\u01922.m_59141_().m_6590_("test runthis");
        \u00e2\u02dc\u0192 = StructureTemplate.m_74593_(blockPos.m_142082_(0, 0, -1), Mirror.NONE, p_127878_, blockPos);
        p_127879_.m_46597_(\u00e2\u02dc\u0192, Blocks.f_50124_.m_49966_().m_60717_(p_127878_));
    }

    public static void m_177764_(String p_177765_, BlockPos p_177766_, Vec3i p_177767_, Rotation p_177768_, ServerLevel p_177769_) {
        BoundingBox boundingBox = StructureUtils.m_177760_(p_177766_, p_177767_, p_177768_);
        StructureUtils.m_127849_(boundingBox, p_177766_.m_123342_(), p_177769_);
        p_177769_.m_46597_(p_177766_, Blocks.f_50677_.m_49966_());
        StructureBlockEntity \u00e2\u02dc\u01922 = (StructureBlockEntity)p_177769_.m_7702_(p_177766_);
        \u00e2\u02dc\u01922.m_59876_(false);
        \u00e2\u02dc\u01922.m_59874_(new ResourceLocation(p_177765_));
        \u00e2\u02dc\u01922.m_155797_(p_177767_);
        \u00e2\u02dc\u01922.m_59860_(StructureMode.SAVE);
        \u00e2\u02dc\u01922.m_59898_(true);
    }

    public static StructureBlockEntity m_127883_(String p_127884_, BlockPos p_127885_, Rotation p_127886_, int p_127887_, ServerLevel p_127888_, boolean p_127889_) {
        BlockPos \u00e2\u02dc\u01923;
        Vec3i vec3i = StructureUtils.m_127880_(p_127884_, p_127888_).m_163801_();
        BoundingBox \u00e2\u02dc\u01922 = StructureUtils.m_177760_(p_127885_, vec3i, p_127886_);
        if (p_127886_ == Rotation.NONE) {
            \u00e2\u02dc\u01923 = p_127885_;
        } else if (p_127886_ == Rotation.CLOCKWISE_90) {
            \u00e2\u02dc\u01923 = p_127885_.m_142082_(vec3i.m_123343_() - 1, 0, 0);
        } else if (p_127886_ == Rotation.CLOCKWISE_180) {
            \u00e2\u02dc\u01923 = p_127885_.m_142082_(vec3i.m_123341_() - 1, 0, vec3i.m_123343_() - 1);
        } else if (p_127886_ == Rotation.COUNTERCLOCKWISE_90) {
            \u00e2\u02dc\u01923 = p_127885_.m_142082_(0, 0, vec3i.m_123341_() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + p_127886_);
        }
        StructureUtils.m_127857_(p_127885_, p_127888_);
        StructureUtils.m_127849_(\u00e2\u02dc\u01922, p_127885_.m_123342_(), p_127888_);
        StructureBlockEntity structureBlockEntity = StructureUtils.m_127890_(p_127884_, \u00e2\u02dc\u01923, p_127886_, p_127888_, p_127889_);
        ((ServerTickList)p_127888_.m_6219_()).m_47232_(\u00e2\u02dc\u01922, true, false);
        p_127888_.m_8722_(\u00e2\u02dc\u01922);
        return structureBlockEntity;
    }

    private static void m_127857_(BlockPos p_127858_, ServerLevel p_127859_) {
        ChunkPos chunkPos = new ChunkPos(p_127858_);
        for (int i = -1; i < 4; ++i) {
            for (\u00e2\u02dc\u0192 = -1; \u00e2\u02dc\u0192 < 4; ++\u00e2\u02dc\u0192) {
                \u00e2\u02dc\u0192 = chunkPos.f_45578_ + i;
                \u00e2\u02dc\u0192 = chunkPos.f_45579_ + \u00e2\u02dc\u0192;
                p_127859_.m_8602_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, true);
            }
        }
    }

    public static void m_127849_(BoundingBox p_127850_, int p_127851_, ServerLevel p_127852_) {
        BoundingBox boundingBox = new BoundingBox(p_127850_.m_162395_() - 2, p_127850_.m_162396_() - 3, p_127850_.m_162398_() - 3, p_127850_.m_162399_() + 3, p_127850_.m_162400_() + 20, p_127850_.m_162401_() + 3);
        BlockPos.m_121919_(boundingBox).forEach(p_177748_ -> StructureUtils.m_127841_(p_127851_, p_177748_, p_127852_));
        ((ServerTickList)p_127852_.m_6219_()).m_47232_(boundingBox, true, false);
        p_127852_.m_8722_(boundingBox);
        AABB \u00e2\u02dc\u01922 = new AABB(boundingBox.m_162395_(), boundingBox.m_162396_(), boundingBox.m_162398_(), boundingBox.m_162399_(), boundingBox.m_162400_(), boundingBox.m_162401_());
        List<Entity> \u00e2\u02dc\u01923 = p_127852_.m_6443_(Entity.class, \u00e2\u02dc\u01922, p_177750_ -> !(p_177750_ instanceof Player));
        \u00e2\u02dc\u01923.forEach(Entity::m_146870_);
    }

    public static BoundingBox m_177760_(BlockPos p_177761_, Vec3i p_177762_, Rotation p_177763_) {
        BlockPos blockPos = p_177761_.m_141952_(p_177762_).m_142082_(-1, -1, -1);
        \u00e2\u02dc\u0192 = StructureTemplate.m_74593_(blockPos, Mirror.NONE, p_177763_, p_177761_);
        BoundingBox \u00e2\u02dc\u01922 = BoundingBox.m_162375_(p_177761_, \u00e2\u02dc\u0192);
        int \u00e2\u02dc\u01923 = Math.min(\u00e2\u02dc\u01922.m_162395_(), \u00e2\u02dc\u01922.m_162399_());
        int \u00e2\u02dc\u01924 = Math.min(\u00e2\u02dc\u01922.m_162398_(), \u00e2\u02dc\u01922.m_162401_());
        return \u00e2\u02dc\u01922.m_162367_(p_177761_.m_123341_() - \u00e2\u02dc\u01923, 0, p_177761_.m_123343_() - \u00e2\u02dc\u01924);
    }

    public static Optional<BlockPos> m_127853_(BlockPos p_127854_, int p_127855_, ServerLevel p_127856_) {
        return StructureUtils.m_127910_(p_127854_, p_127855_, p_127856_).stream().filter(p_177756_ -> StructureUtils.m_127867_(p_177756_, p_127854_, p_127856_)).findFirst();
    }

    @Nullable
    public static BlockPos m_127906_(BlockPos p_127907_, int p_127908_, ServerLevel p_127909_) {
        Comparator<BlockPos> comparator = Comparator.comparingInt(p_177759_ -> p_177759_.m_123333_(p_127907_));
        Collection<BlockPos> \u00e2\u02dc\u01922 = StructureUtils.m_127910_(p_127907_, p_127908_, p_127909_);
        Optional<BlockPos> \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.stream().min(comparator);
        return \u00e2\u02dc\u01923.orElse(null);
    }

    public static Collection<BlockPos> m_127910_(BlockPos p_127911_, int p_127912_, ServerLevel p_127913_) {
        ArrayList arrayList = Lists.newArrayList();
        AABB \u00e2\u02dc\u01922 = new AABB(p_127911_);
        \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.m_82400_(p_127912_);
        for (int i = (int)\u00e2\u02dc\u01922.f_82288_; i <= (int)\u00e2\u02dc\u01922.f_82291_; ++i) {
            for (\u00e2\u02dc\u0192 = (int)\u00e2\u02dc\u01922.f_82289_; \u00e2\u02dc\u0192 <= (int)\u00e2\u02dc\u01922.f_82292_; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = (int)\u00e2\u02dc\u01922.f_82290_; \u00e2\u02dc\u0192 <= (int)\u00e2\u02dc\u01922.f_82293_; ++\u00e2\u02dc\u0192) {
                    BlockPos blockPos = new BlockPos(i, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                    BlockState \u00e2\u02dc\u01923 = p_127913_.m_8055_(blockPos);
                    if (!\u00e2\u02dc\u01923.m_60713_(Blocks.f_50677_)) continue;
                    arrayList.add(blockPos);
                }
            }
        }
        return arrayList;
    }

    private static StructureTemplate m_127880_(String p_127881_, ServerLevel p_127882_) {
        StructureManager structureManager = p_127882_.m_8875_();
        Optional<StructureTemplate> \u00e2\u02dc\u01922 = structureManager.m_163774_(new ResourceLocation(p_127881_));
        if (\u00e2\u02dc\u01922.isPresent()) {
            return \u00e2\u02dc\u01922.get();
        }
        String \u00e2\u02dc\u01923 = p_127881_ + ".snbt";
        Path \u00e2\u02dc\u01924 = Paths.get(f_127833_, \u00e2\u02dc\u01923);
        CompoundTag \u00e2\u02dc\u01925 = StructureUtils.m_127902_(\u00e2\u02dc\u01924);
        if (\u00e2\u02dc\u01925 == null) {
            throw new RuntimeException("Could not find structure file " + \u00e2\u02dc\u01924 + ", and the structure is not available in the world structures either.");
        }
        return structureManager.m_74339_(\u00e2\u02dc\u01925);
    }

    private static StructureBlockEntity m_127890_(String p_127891_, BlockPos p_127892_, Rotation p_127893_, ServerLevel p_127894_, boolean p_127895_) {
        p_127894_.m_46597_(p_127892_, Blocks.f_50677_.m_49966_());
        StructureBlockEntity structureBlockEntity = (StructureBlockEntity)p_127894_.m_7702_(p_127892_);
        structureBlockEntity.m_59860_(StructureMode.LOAD);
        structureBlockEntity.m_59883_(p_127893_);
        structureBlockEntity.m_59876_(false);
        structureBlockEntity.m_59874_(new ResourceLocation(p_127891_));
        structureBlockEntity.m_59844_(p_127894_, p_127895_);
        if (structureBlockEntity.m_155805_() != Vec3i.f_123288_) {
            return structureBlockEntity;
        }
        StructureTemplate \u00e2\u02dc\u01922 = StructureUtils.m_127880_(p_127891_, p_127894_);
        structureBlockEntity.m_59847_(p_127894_, p_127895_, \u00e2\u02dc\u01922);
        if (structureBlockEntity.m_155805_() == Vec3i.f_123288_) {
            throw new RuntimeException("Failed to load structure " + p_127891_);
        }
        return structureBlockEntity;
    }

    @Nullable
    private static CompoundTag m_127902_(Path p_127903_) {
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(p_127903_);
            String \u00e2\u02dc\u01922 = IOUtils.toString((Reader)bufferedReader);
            return NbtUtils.m_178024_(\u00e2\u02dc\u01922);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new RuntimeException("Error while trying to load structure " + p_127903_, commandSyntaxException);
        }
    }

    private static void m_127841_(int p_127842_, BlockPos p_127843_, ServerLevel p_127844_) {
        Object \u00e2\u02dc\u01924;
        BlockState blockState = null;
        FlatLevelGeneratorSettings \u00e2\u02dc\u01922 = FlatLevelGeneratorSettings.m_70376_(p_127844_.m_5962_().m_175515_(Registry.f_122885_));
        if (\u00e2\u02dc\u01922 instanceof FlatLevelGeneratorSettings) {
            \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.m_161917_();
            int \u00e2\u02dc\u01923 = p_127843_.m_123342_() - p_127844_.m_141937_();
            if (p_127843_.m_123342_() < p_127842_ && \u00e2\u02dc\u01923 > 0 && \u00e2\u02dc\u01923 <= \u00e2\u02dc\u01924.size()) {
                blockState = \u00e2\u02dc\u01924.get(\u00e2\u02dc\u01923 - 1);
            }
        } else if (p_127843_.m_123342_() == p_127842_ - 1) {
            blockState = p_127844_.m_46857_(p_127843_).m_47536_().m_47824_().m_6743_();
        } else if (p_127843_.m_123342_() < p_127842_ - 1) {
            blockState = p_127844_.m_46857_(p_127843_).m_47536_().m_47824_().m_6744_();
        }
        if (blockState == null) {
            blockState = Blocks.f_50016_.m_49966_();
        }
        \u00e2\u02dc\u01924 = new BlockInput(blockState, Collections.emptySet(), null);
        ((BlockInput)\u00e2\u02dc\u01924).m_114670_(p_127844_, p_127843_, 2);
        p_127844_.m_6289_(p_127843_, blockState.m_60734_());
    }

    private static boolean m_127867_(BlockPos p_127868_, BlockPos p_127869_, ServerLevel p_127870_) {
        StructureBlockEntity structureBlockEntity = (StructureBlockEntity)p_127870_.m_7702_(p_127868_);
        AABB \u00e2\u02dc\u01922 = StructureUtils.m_127847_(structureBlockEntity).m_82400_(1.0);
        return \u00e2\u02dc\u01922.m_82390_(Vec3.m_82512_(p_127869_));
    }
}

