/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class IntArrayTag
extends CollectionTag<IntTag> {
    private static final int f_177867_ = 192;
    public static final TagType<IntArrayTag> f_128599_ = new TagType<IntArrayTag>(){

        @Override
        public IntArrayTag m_7300_(DataInput p_128662_, int p_128663_, NbtAccounter p_128664_) throws IOException {
            p_128664_.m_6800_(192L);
            int n = p_128662_.readInt();
            p_128664_.m_6800_(32L * (long)n);
            int[] \u00e2\u02dc\u01922 = new int[n];
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < n; ++\u00e2\u02dc\u0192) {
                \u00e2\u02dc\u01922[\u00e2\u02dc\u0192] = p_128662_.readInt();
            }
            return new IntArrayTag(\u00e2\u02dc\u01922);
        }

        @Override
        public String m_5987_() {
            return "INT[]";
        }

        @Override
        public String m_5986_() {
            return "TAG_Int_Array";
        }

        @Override
        public /* synthetic */ Tag m_7300_(DataInput dataInput, int n, NbtAccounter nbtAccounter) throws IOException {
            return this.m_7300_(dataInput, n, nbtAccounter);
        }
    };
    private int[] f_128600_;

    public IntArrayTag(int[] p_128605_) {
        this.f_128600_ = p_128605_;
    }

    public IntArrayTag(List<Integer> p_128603_) {
        this(IntArrayTag.m_128620_(p_128603_));
    }

    private static int[] m_128620_(List<Integer> p_128621_) {
        int[] nArray = new int[p_128621_.size()];
        for (int i = 0; i < p_128621_.size(); ++i) {
            Integer n = p_128621_.get(i);
            nArray[i] = n == null ? 0 : n;
        }
        return nArray;
    }

    @Override
    public void m_6434_(DataOutput p_128616_) throws IOException {
        p_128616_.writeInt(this.f_128600_.length);
        for (int n : this.f_128600_) {
            p_128616_.writeInt(n);
        }
    }

    @Override
    public byte m_7060_() {
        return 11;
    }

    public TagType<IntArrayTag> m_6458_() {
        return f_128599_;
    }

    @Override
    public String toString() {
        return this.m_7916_();
    }

    @Override
    public IntArrayTag m_6426_() {
        int[] nArray = new int[this.f_128600_.length];
        System.arraycopy(this.f_128600_, 0, nArray, 0, this.f_128600_.length);
        return new IntArrayTag(nArray);
    }

    @Override
    public boolean equals(Object p_128647_) {
        if (this == p_128647_) {
            return true;
        }
        return p_128647_ instanceof IntArrayTag && Arrays.equals(this.f_128600_, ((IntArrayTag)p_128647_).f_128600_);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.f_128600_);
    }

    public int[] m_128648_() {
        return this.f_128600_;
    }

    @Override
    public void m_142327_(TagVisitor p_177869_) {
        p_177869_.m_142251_(this);
    }

    @Override
    public int size() {
        return this.f_128600_.length;
    }

    @Override
    public IntTag get(int p_128608_) {
        return IntTag.m_128679_(this.f_128600_[p_128608_]);
    }

    @Override
    public IntTag set(int p_128610_, IntTag p_128611_) {
        int n = this.f_128600_[p_128610_];
        this.f_128600_[p_128610_] = p_128611_.m_7047_();
        return IntTag.m_128679_(n);
    }

    @Override
    public void add(int p_128629_, IntTag p_128630_) {
        this.f_128600_ = ArrayUtils.add((int[])this.f_128600_, (int)p_128629_, (int)p_128630_.m_7047_());
    }

    @Override
    public boolean m_7615_(int p_128613_, Tag p_128614_) {
        if (p_128614_ instanceof NumericTag) {
            this.f_128600_[p_128613_] = ((NumericTag)p_128614_).m_7047_();
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7614_(int p_128632_, Tag p_128633_) {
        if (p_128633_ instanceof NumericTag) {
            this.f_128600_ = ArrayUtils.add((int[])this.f_128600_, (int)p_128632_, (int)((NumericTag)p_128633_).m_7047_());
            return true;
        }
        return false;
    }

    @Override
    public IntTag remove(int p_128627_) {
        int n = this.f_128600_[p_128627_];
        this.f_128600_ = ArrayUtils.remove((int[])this.f_128600_, (int)p_128627_);
        return IntTag.m_128679_(n);
    }

    @Override
    public byte m_7264_() {
        return 3;
    }

    @Override
    public void clear() {
        this.f_128600_ = new int[0];
    }

    @Override
    public /* synthetic */ Tag remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Tag tag) {
        this.add(n, (IntTag)tag);
    }

    @Override
    public /* synthetic */ Tag set(int n, Tag tag) {
        return this.set(n, (IntTag)tag);
    }

    @Override
    public /* synthetic */ Tag m_6426_() {
        return this.m_6426_();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (IntTag)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (IntTag)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }
}

