/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class ListTag
extends CollectionTag<Tag> {
    private static final int f_177988_ = 296;
    public static final TagType<ListTag> f_128714_ = new TagType<ListTag>(){

        @Override
        public ListTag m_7300_(DataInput p_128792_, int p_128793_, NbtAccounter p_128794_) throws IOException {
            p_128794_.m_6800_(296L);
            if (p_128793_ > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte by = p_128792_.readByte();
            int \u00e2\u02dc\u01922 = p_128792_.readInt();
            if (by == 0 && \u00e2\u02dc\u01922 > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            p_128794_.m_6800_(32L * (long)\u00e2\u02dc\u01922);
            TagType<?> \u00e2\u02dc\u01923 = TagTypes.m_129397_(by);
            ArrayList \u00e2\u02dc\u01924 = Lists.newArrayListWithCapacity((int)\u00e2\u02dc\u01922);
            for (int i = 0; i < \u00e2\u02dc\u01922; ++i) {
                \u00e2\u02dc\u01924.add(\u00e2\u02dc\u01923.m_7300_(p_128792_, p_128793_ + 1, p_128794_));
            }
            return new ListTag(\u00e2\u02dc\u01924, by);
        }

        @Override
        public String m_5987_() {
            return "LIST";
        }

        @Override
        public String m_5986_() {
            return "TAG_List";
        }

        @Override
        public /* synthetic */ Tag m_7300_(DataInput dataInput, int n, NbtAccounter nbtAccounter) throws IOException {
            return this.m_7300_(dataInput, n, nbtAccounter);
        }
    };
    private final List<Tag> f_128716_;
    private byte f_128717_;

    ListTag(List<Tag> p_128721_, byte p_128722_) {
        this.f_128716_ = p_128721_;
        this.f_128717_ = p_128722_;
    }

    public ListTag() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void m_6434_(DataOutput p_128734_) throws IOException {
        this.f_128717_ = this.f_128716_.isEmpty() ? (byte)0 : this.f_128716_.get(0).m_7060_();
        p_128734_.writeByte(this.f_128717_);
        p_128734_.writeInt(this.f_128716_.size());
        for (Tag tag : this.f_128716_) {
            tag.m_6434_(p_128734_);
        }
    }

    @Override
    public byte m_7060_() {
        return 9;
    }

    public TagType<ListTag> m_6458_() {
        return f_128714_;
    }

    @Override
    public String toString() {
        return this.m_7916_();
    }

    private void m_128769_() {
        if (this.f_128716_.isEmpty()) {
            this.f_128717_ = 0;
        }
    }

    @Override
    public Tag remove(int p_128751_) {
        Tag tag = this.f_128716_.remove(p_128751_);
        this.m_128769_();
        return tag;
    }

    @Override
    public boolean isEmpty() {
        return this.f_128716_.isEmpty();
    }

    public CompoundTag m_128728_(int p_128729_) {
        Tag tag;
        if (p_128729_ >= 0 && p_128729_ < this.f_128716_.size() && (tag = this.f_128716_.get(p_128729_)).m_7060_() == 10) {
            return (CompoundTag)tag;
        }
        return new CompoundTag();
    }

    public ListTag m_128744_(int p_128745_) {
        Tag tag;
        if (p_128745_ >= 0 && p_128745_ < this.f_128716_.size() && (tag = this.f_128716_.get(p_128745_)).m_7060_() == 9) {
            return (ListTag)tag;
        }
        return new ListTag();
    }

    public short m_128757_(int p_128758_) {
        Tag tag;
        if (p_128758_ >= 0 && p_128758_ < this.f_128716_.size() && (tag = this.f_128716_.get(p_128758_)).m_7060_() == 2) {
            return ((ShortTag)tag).m_7053_();
        }
        return 0;
    }

    public int m_128763_(int p_128764_) {
        Tag tag;
        if (p_128764_ >= 0 && p_128764_ < this.f_128716_.size() && (tag = this.f_128716_.get(p_128764_)).m_7060_() == 3) {
            return ((IntTag)tag).m_7047_();
        }
        return 0;
    }

    public int[] m_128767_(int p_128768_) {
        Tag tag;
        if (p_128768_ >= 0 && p_128768_ < this.f_128716_.size() && (tag = this.f_128716_.get(p_128768_)).m_7060_() == 11) {
            return ((IntArrayTag)tag).m_128648_();
        }
        return new int[0];
    }

    public long[] m_177991_(int p_177992_) {
        Tag tag;
        if (p_177992_ >= 0 && p_177992_ < this.f_128716_.size() && (tag = this.f_128716_.get(p_177992_)).m_7060_() == 11) {
            return ((LongArrayTag)tag).m_128851_();
        }
        return new long[0];
    }

    public double m_128772_(int p_128773_) {
        Tag tag;
        if (p_128773_ >= 0 && p_128773_ < this.f_128716_.size() && (tag = this.f_128716_.get(p_128773_)).m_7060_() == 6) {
            return ((DoubleTag)tag).m_7061_();
        }
        return 0.0;
    }

    public float m_128775_(int p_128776_) {
        Tag tag;
        if (p_128776_ >= 0 && p_128776_ < this.f_128716_.size() && (tag = this.f_128716_.get(p_128776_)).m_7060_() == 5) {
            return ((FloatTag)tag).m_7057_();
        }
        return 0.0f;
    }

    public String m_128778_(int p_128779_) {
        if (p_128779_ < 0 || p_128779_ >= this.f_128716_.size()) {
            return "";
        }
        Tag tag = this.f_128716_.get(p_128779_);
        if (tag.m_7060_() == 8) {
            return tag.m_7916_();
        }
        return tag.toString();
    }

    @Override
    public int size() {
        return this.f_128716_.size();
    }

    @Override
    public Tag get(int p_128781_) {
        return this.f_128716_.get(p_128781_);
    }

    @Override
    public Tag set(int p_128760_, Tag p_128761_) {
        Tag tag = this.get(p_128760_);
        if (!this.m_7615_(p_128760_, p_128761_)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", p_128761_.m_7060_(), this.f_128717_));
        }
        return tag;
    }

    @Override
    public void add(int p_128753_, Tag p_128754_) {
        if (!this.m_7614_(p_128753_, p_128754_)) {
            throw new UnsupportedOperationException(String.format("Trying to add tag of type %d to list of %d", p_128754_.m_7060_(), this.f_128717_));
        }
    }

    @Override
    public boolean m_7615_(int p_128731_, Tag p_128732_) {
        if (this.m_128738_(p_128732_)) {
            this.f_128716_.set(p_128731_, p_128732_);
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7614_(int p_128747_, Tag p_128748_) {
        if (this.m_128738_(p_128748_)) {
            this.f_128716_.add(p_128747_, p_128748_);
            return true;
        }
        return false;
    }

    private boolean m_128738_(Tag p_128739_) {
        if (p_128739_.m_7060_() == 0) {
            return false;
        }
        if (this.f_128717_ == 0) {
            this.f_128717_ = p_128739_.m_7060_();
            return true;
        }
        return this.f_128717_ == p_128739_.m_7060_();
    }

    @Override
    public ListTag m_6426_() {
        List<Tag> list = TagTypes.m_129397_(this.f_128717_).m_7064_() ? this.f_128716_ : Iterables.transform(this.f_128716_, Tag::m_6426_);
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList(list);
        return new ListTag(\u00e2\u02dc\u01922, this.f_128717_);
    }

    @Override
    public boolean equals(Object p_128766_) {
        if (this == p_128766_) {
            return true;
        }
        return p_128766_ instanceof ListTag && Objects.equals(this.f_128716_, ((ListTag)p_128766_).f_128716_);
    }

    @Override
    public int hashCode() {
        return this.f_128716_.hashCode();
    }

    @Override
    public void m_142327_(TagVisitor p_177990_) {
        p_177990_.m_142447_(this);
    }

    @Override
    public byte m_7264_() {
        return this.f_128717_;
    }

    @Override
    public void clear() {
        this.f_128716_.clear();
        this.f_128717_ = 0;
    }

    @Override
    public /* synthetic */ Tag m_6426_() {
        return this.m_6426_();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }
}

