/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;

public class NbtIo {
    public static CompoundTag m_128937_(File p_128938_) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(p_128938_);){
            CompoundTag compoundTag = NbtIo.m_128939_(fileInputStream);
            return compoundTag;
        }
    }

    public static CompoundTag m_128939_(InputStream p_128940_) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(p_128940_)));){
            CompoundTag compoundTag = NbtIo.m_128934_(dataInputStream, NbtAccounter.f_128917_);
            return compoundTag;
        }
    }

    public static void m_128944_(CompoundTag p_128945_, File p_128946_) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(p_128946_);){
            NbtIo.m_128947_(p_128945_, fileOutputStream);
        }
    }

    public static void m_128947_(CompoundTag p_128948_, OutputStream p_128949_) throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(p_128949_)));){
            NbtIo.m_128941_(p_128948_, dataOutputStream);
        }
    }

    public static void m_128955_(CompoundTag p_128956_, File p_128957_) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(p_128957_);
             DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);){
            NbtIo.m_128941_(p_128956_, dataOutputStream);
        }
    }

    @Nullable
    public static CompoundTag m_128953_(File p_128954_) throws IOException {
        if (!p_128954_.exists()) {
            return null;
        }
        try (FileInputStream fileInputStream = new FileInputStream(p_128954_);){
            CompoundTag compoundTag;
            try (DataInputStream dataInputStream = new DataInputStream(fileInputStream);){
                compoundTag = NbtIo.m_128934_(dataInputStream, NbtAccounter.f_128917_);
            }
            return compoundTag;
        }
    }

    public static CompoundTag m_128928_(DataInput p_128929_) throws IOException {
        return NbtIo.m_128934_(p_128929_, NbtAccounter.f_128917_);
    }

    public static CompoundTag m_128934_(DataInput p_128935_, NbtAccounter p_128936_) throws IOException {
        Tag tag = NbtIo.m_128930_(p_128935_, 0, p_128936_);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void m_128941_(CompoundTag p_128942_, DataOutput p_128943_) throws IOException {
        NbtIo.m_128950_(p_128942_, p_128943_);
    }

    private static void m_128950_(Tag p_128951_, DataOutput p_128952_) throws IOException {
        p_128952_.writeByte(p_128951_.m_7060_());
        if (p_128951_.m_7060_() == 0) {
            return;
        }
        p_128952_.writeUTF("");
        p_128951_.m_6434_(p_128952_);
    }

    private static Tag m_128930_(DataInput p_128931_, int p_128932_, NbtAccounter p_128933_) throws IOException {
        byte by = p_128931_.readByte();
        if (by == 0) {
            return EndTag.f_128534_;
        }
        p_128931_.readUTF();
        try {
            return TagTypes.m_129397_(by).m_7300_(p_128931_, p_128932_, p_128933_);
        }
        catch (IOException \u00e2\u02dc\u01922) {
            CrashReport crashReport = CrashReport.m_127521_(\u00e2\u02dc\u01922, "Loading NBT data");
            CrashReportCategory \u00e2\u02dc\u01923 = crashReport.m_127514_("NBT Tag");
            \u00e2\u02dc\u01923.m_128159_("Tag type", by);
            throw new ReportedException(crashReport);
        }
    }
}

