/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SerializableUUID;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.material.FluidState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NbtUtils {
    private static final Comparator<ListTag> f_178008_ = Comparator.comparingInt(p_178074_ -> p_178074_.m_128763_(1)).thenComparingInt(p_178070_ -> p_178070_.m_128763_(0)).thenComparingInt(p_178066_ -> p_178066_.m_128763_(2));
    private static final Comparator<ListTag> f_178009_ = Comparator.comparingDouble(p_178060_ -> p_178060_.m_128772_(1)).thenComparingDouble(p_178056_ -> p_178056_.m_128772_(0)).thenComparingDouble(p_178042_ -> p_178042_.m_128772_(2));
    public static final String f_178007_ = "data";
    private static final char f_178010_ = '{';
    private static final char f_178011_ = '}';
    private static final String f_178012_ = ",";
    private static final char f_178013_ = ':';
    private static final Splitter f_178014_ = Splitter.on((String)",");
    private static final Splitter f_178015_ = Splitter.on((char)':').limit(2);
    private static final Logger f_129200_ = LogManager.getLogger();
    private static final int f_178016_ = 2;
    private static final int f_178017_ = -1;

    private NbtUtils() {
    }

    @Nullable
    public static GameProfile m_129228_(CompoundTag p_129229_) {
        String string = null;
        UUID \u00e2\u02dc\u01922 = null;
        if (p_129229_.m_128425_("Name", 8)) {
            string = p_129229_.m_128461_("Name");
        }
        if (p_129229_.m_128403_("Id")) {
            \u00e2\u02dc\u01922 = p_129229_.m_128342_("Id");
        }
        try {
            GameProfile gameProfile = new GameProfile(\u00e2\u02dc\u01922, string);
            if (p_129229_.m_128425_("Properties", 10)) {
                CompoundTag compoundTag = p_129229_.m_128469_("Properties");
                for (String string2 : compoundTag.m_128431_()) {
                    ListTag listTag = compoundTag.m_128437_(string2, 10);
                    for (int i = 0; i < listTag.size(); ++i) {
                        CompoundTag compoundTag2 = listTag.m_128728_(i);
                        String \u00e2\u02dc\u01923 = compoundTag2.m_128461_("Value");
                        if (compoundTag2.m_128425_("Signature", 8)) {
                            gameProfile.getProperties().put((Object)string2, (Object)new Property(string2, \u00e2\u02dc\u01923, compoundTag2.m_128461_("Signature")));
                            continue;
                        }
                        gameProfile.getProperties().put((Object)string2, (Object)new Property(string2, \u00e2\u02dc\u01923));
                    }
                }
            }
            return gameProfile;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static CompoundTag m_129230_(CompoundTag p_129231_, GameProfile p_129232_) {
        if (!StringUtil.m_14408_(p_129232_.getName())) {
            p_129231_.m_128359_("Name", p_129232_.getName());
        }
        if (p_129232_.getId() != null) {
            p_129231_.m_128362_("Id", p_129232_.getId());
        }
        if (!p_129232_.getProperties().isEmpty()) {
            CompoundTag compoundTag = new CompoundTag();
            for (String string : p_129232_.getProperties().keySet()) {
                ListTag listTag = new ListTag();
                for (Property property : p_129232_.getProperties().get((Object)string)) {
                    CompoundTag compoundTag2 = new CompoundTag();
                    compoundTag2.m_128359_("Value", property.getValue());
                    if (property.hasSignature()) {
                        compoundTag2.m_128359_("Signature", property.getSignature());
                    }
                    listTag.add(compoundTag2);
                }
                compoundTag.m_128365_(string, listTag);
            }
            p_129231_.m_128365_("Properties", compoundTag);
        }
        return p_129231_;
    }

    @VisibleForTesting
    public static boolean m_129235_(@Nullable Tag p_129236_, @Nullable Tag p_129237_, boolean p_129238_) {
        if (p_129236_ == p_129237_) {
            return true;
        }
        if (p_129236_ == null) {
            return true;
        }
        if (p_129237_ == null) {
            return false;
        }
        if (!p_129236_.getClass().equals(p_129237_.getClass())) {
            return false;
        }
        if (p_129236_ instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)p_129236_;
            \u00e2\u02dc\u0192 = (CompoundTag)p_129237_;
            for (String string : compoundTag.m_128431_()) {
                Tag tag = compoundTag.m_128423_(string);
                if (NbtUtils.m_129235_(tag, \u00e2\u02dc\u0192.m_128423_(string), p_129238_)) continue;
                return false;
            }
            return true;
        }
        if (p_129236_ instanceof ListTag && p_129238_) {
            ListTag listTag = (ListTag)p_129236_;
            \u00e2\u02dc\u0192 = (ListTag)p_129237_;
            if (listTag.isEmpty()) {
                return \u00e2\u02dc\u0192.isEmpty();
            }
            for (int i = 0; i < listTag.size(); ++i) {
                Tag tag = listTag.get(i);
                boolean \u00e2\u02dc\u01922 = false;
                for (int j = 0; j < \u00e2\u02dc\u0192.size(); ++j) {
                    if (!NbtUtils.m_129235_(tag, \u00e2\u02dc\u0192.get(j), p_129238_)) continue;
                    \u00e2\u02dc\u01922 = true;
                    break;
                }
                if (\u00e2\u02dc\u01922) continue;
                return false;
            }
            return true;
        }
        return p_129236_.equals(p_129237_);
    }

    public static IntArrayTag m_129226_(UUID p_129227_) {
        return new IntArrayTag(SerializableUUID.m_123277_(p_129227_));
    }

    public static UUID m_129233_(Tag p_129234_) {
        if (p_129234_.m_6458_() != IntArrayTag.f_128599_) {
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + IntArrayTag.f_128599_.m_5987_() + ", but found " + p_129234_.m_6458_().m_5987_() + ".");
        }
        int[] nArray = ((IntArrayTag)p_129234_).m_128648_();
        if (nArray.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + nArray.length + ".");
        }
        return SerializableUUID.m_123281_(nArray);
    }

    public static BlockPos m_129239_(CompoundTag p_129240_) {
        return new BlockPos(p_129240_.m_128451_("X"), p_129240_.m_128451_("Y"), p_129240_.m_128451_("Z"));
    }

    public static CompoundTag m_129224_(BlockPos p_129225_) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("X", p_129225_.m_123341_());
        compoundTag.m_128405_("Y", p_129225_.m_123342_());
        compoundTag.m_128405_("Z", p_129225_.m_123343_());
        return compoundTag;
    }

    public static BlockState m_129241_(CompoundTag p_129242_) {
        if (!p_129242_.m_128425_("Name", 8)) {
            return Blocks.f_50016_.m_49966_();
        }
        Block block = Registry.f_122824_.m_7745_(new ResourceLocation(p_129242_.m_128461_("Name")));
        BlockState \u00e2\u02dc\u01922 = block.m_49966_();
        if (p_129242_.m_128425_("Properties", 10)) {
            CompoundTag compoundTag = p_129242_.m_128469_("Properties");
            StateDefinition<Block, BlockState> \u00e2\u02dc\u01923 = block.m_49965_();
            for (String string : compoundTag.m_128431_()) {
                net.minecraft.world.level.block.state.properties.Property<?> property = \u00e2\u02dc\u01923.m_61081_(string);
                if (property == null) continue;
                \u00e2\u02dc\u01922 = NbtUtils.m_129204_(\u00e2\u02dc\u01922, property, string, compoundTag, p_129242_);
            }
        }
        return \u00e2\u02dc\u01922;
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S m_129204_(S p_129205_, net.minecraft.world.level.block.state.properties.Property<T> p_129206_, String p_129207_, CompoundTag p_129208_, CompoundTag p_129209_) {
        Optional<T> optional = p_129206_.m_6215_(p_129208_.m_128461_(p_129207_));
        if (optional.isPresent()) {
            return (S)((StateHolder)p_129205_.m_61124_(p_129206_, (Comparable)((Comparable)optional.get())));
        }
        f_129200_.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)p_129207_, (Object)p_129208_.m_128461_(p_129207_), (Object)p_129209_.toString());
        return p_129205_;
    }

    public static CompoundTag m_129202_(BlockState p_129203_) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("Name", Registry.f_122824_.m_7981_(p_129203_.m_60734_()).toString());
        ImmutableMap<net.minecraft.world.level.block.state.properties.Property<?>, Comparable<?>> \u00e2\u02dc\u01922 = p_129203_.m_61148_();
        if (!\u00e2\u02dc\u01922.isEmpty()) {
            \u00e2\u02dc\u0192 = new CompoundTag();
            for (Map.Entry entry : \u00e2\u02dc\u01922.entrySet()) {
                net.minecraft.world.level.block.state.properties.Property property = (net.minecraft.world.level.block.state.properties.Property)entry.getKey();
                \u00e2\u02dc\u0192.m_128359_(property.m_61708_(), NbtUtils.m_129210_(property, (Comparable)entry.getValue()));
            }
            compoundTag.m_128365_("Properties", \u00e2\u02dc\u0192);
        }
        return compoundTag;
    }

    public static CompoundTag m_178022_(FluidState p_178023_) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("Name", Registry.f_122822_.m_7981_(p_178023_.m_76152_()).toString());
        ImmutableMap<net.minecraft.world.level.block.state.properties.Property<?>, Comparable<?>> \u00e2\u02dc\u01922 = p_178023_.m_61148_();
        if (!\u00e2\u02dc\u01922.isEmpty()) {
            \u00e2\u02dc\u0192 = new CompoundTag();
            for (Map.Entry entry : \u00e2\u02dc\u01922.entrySet()) {
                net.minecraft.world.level.block.state.properties.Property property = (net.minecraft.world.level.block.state.properties.Property)entry.getKey();
                \u00e2\u02dc\u0192.m_128359_(property.m_61708_(), NbtUtils.m_129210_(property, (Comparable)entry.getValue()));
            }
            compoundTag.m_128365_("Properties", \u00e2\u02dc\u0192);
        }
        return compoundTag;
    }

    private static <T extends Comparable<T>> String m_129210_(net.minecraft.world.level.block.state.properties.Property<T> p_129211_, Comparable<?> p_129212_) {
        return p_129211_.m_6940_(p_129212_);
    }

    public static String m_178057_(Tag p_178058_) {
        return NbtUtils.m_178050_(p_178058_, false);
    }

    public static String m_178050_(Tag p_178051_, boolean p_178052_) {
        return NbtUtils.m_178026_(new StringBuilder(), p_178051_, 0, p_178052_).toString();
    }

    public static StringBuilder m_178026_(StringBuilder p_178027_, Tag p_178028_, int p_178029_, boolean p_178030_) {
        switch (p_178028_.m_7060_()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                p_178027_.append(p_178028_);
                break;
            }
            case 0: {
                break;
            }
            case 7: {
                ByteArrayTag byteArrayTag = (ByteArrayTag)p_178028_;
                byte[] \u00e2\u02dc\u01922 = byteArrayTag.m_128227_();
                int \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.length;
                NbtUtils.m_178019_(p_178029_, p_178027_).append("byte[").append(\u00e2\u02dc\u01923).append("] {\n");
                if (p_178030_) {
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_);
                    for (int i = 0; i < \u00e2\u02dc\u01922.length; ++i) {
                        if (i != 0) {
                            p_178027_.append(',');
                        }
                        if (i % 16 == 0 && i / 16 > 0) {
                            p_178027_.append('\n');
                            if (i < \u00e2\u02dc\u01922.length) {
                                NbtUtils.m_178019_(p_178029_ + 1, p_178027_);
                            }
                        } else if (i != 0) {
                            p_178027_.append(' ');
                        }
                        p_178027_.append(String.format("0x%02X", \u00e2\u02dc\u01922[i] & 0xFF));
                    }
                } else {
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_).append(" // Skipped, supply withBinaryBlobs true");
                }
                p_178027_.append('\n');
                NbtUtils.m_178019_(p_178029_, p_178027_).append('}');
                break;
            }
            case 9: {
                ListTag listTag = (ListTag)p_178028_;
                int \u00e2\u02dc\u01924 = listTag.size();
                byte \u00e2\u02dc\u01925 = listTag.m_7264_();
                String \u00e2\u02dc\u01926 = \u00e2\u02dc\u01925 == 0 ? "undefined" : TagTypes.m_129397_(\u00e2\u02dc\u01925).m_5986_();
                NbtUtils.m_178019_(p_178029_, p_178027_).append("list<").append(\u00e2\u02dc\u01926).append(">[").append(\u00e2\u02dc\u01924).append("] [");
                if (\u00e2\u02dc\u01924 != 0) {
                    p_178027_.append('\n');
                }
                for (int \u00e2\u02dc\u01929 = 0; \u00e2\u02dc\u01929 < \u00e2\u02dc\u01924; ++\u00e2\u02dc\u01929) {
                    if (\u00e2\u02dc\u01929 != 0) {
                        p_178027_.append(",\n");
                    }
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_);
                    NbtUtils.m_178026_(p_178027_, listTag.get(\u00e2\u02dc\u01929), p_178029_ + 1, p_178030_);
                }
                if (\u00e2\u02dc\u01924 != 0) {
                    p_178027_.append('\n');
                }
                NbtUtils.m_178019_(p_178029_, p_178027_).append(']');
                break;
            }
            case 11: {
                IntArrayTag intArrayTag = (IntArrayTag)p_178028_;
                int[] \u00e2\u02dc\u01927 = intArrayTag.m_128648_();
                int \u00e2\u02dc\u01928 = 0;
                int[] \u00e2\u02dc\u01926 = \u00e2\u02dc\u01927;
                int \u00e2\u02dc\u01929 = \u00e2\u02dc\u01926.length;
                for (int i = 0; i < \u00e2\u02dc\u01929; ++i) {
                    int n = \u00e2\u02dc\u01926[i];
                    \u00e2\u02dc\u01928 = Math.max(\u00e2\u02dc\u01928, String.format("%X", n).length());
                }
                int n = \u00e2\u02dc\u01927.length;
                NbtUtils.m_178019_(p_178029_, p_178027_).append("int[").append(n).append("] {\n");
                if (p_178030_) {
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_);
                    for (\u00e2\u02dc\u01929 = 0; \u00e2\u02dc\u01929 < \u00e2\u02dc\u01927.length; ++\u00e2\u02dc\u01929) {
                        if (\u00e2\u02dc\u01929 != 0) {
                            p_178027_.append(',');
                        }
                        if (\u00e2\u02dc\u01929 % 16 == 0 && \u00e2\u02dc\u01929 / 16 > 0) {
                            p_178027_.append('\n');
                            if (\u00e2\u02dc\u01929 < \u00e2\u02dc\u01927.length) {
                                NbtUtils.m_178019_(p_178029_ + 1, p_178027_);
                            }
                        } else if (\u00e2\u02dc\u01929 != 0) {
                            p_178027_.append(' ');
                        }
                        p_178027_.append(String.format("0x%0" + \u00e2\u02dc\u01928 + "X", \u00e2\u02dc\u01927[\u00e2\u02dc\u01929]));
                    }
                } else {
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_).append(" // Skipped, supply withBinaryBlobs true");
                }
                p_178027_.append('\n');
                NbtUtils.m_178019_(p_178029_, p_178027_).append('}');
                break;
            }
            case 10: {
                CompoundTag compoundTag = (CompoundTag)p_178028_;
                ArrayList \u00e2\u02dc\u019210 = Lists.newArrayList(compoundTag.m_128431_());
                Collections.sort(\u00e2\u02dc\u019210);
                NbtUtils.m_178019_(p_178029_, p_178027_).append('{');
                if (p_178027_.length() - p_178027_.lastIndexOf("\n") > 2 * (p_178029_ + 1)) {
                    p_178027_.append('\n');
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_);
                }
                int \u00e2\u02dc\u019211 = \u00e2\u02dc\u019210.stream().mapToInt(String::length).max().orElse(0);
                String \u00e2\u02dc\u019212 = Strings.repeat((String)" ", (int)\u00e2\u02dc\u019211);
                for (int \u00e2\u02dc\u019215 = 0; \u00e2\u02dc\u019215 < \u00e2\u02dc\u019210.size(); ++\u00e2\u02dc\u019215) {
                    if (\u00e2\u02dc\u019215 != 0) {
                        p_178027_.append(",\n");
                    }
                    String string = (String)\u00e2\u02dc\u019210.get(\u00e2\u02dc\u019215);
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_).append('\"').append(string).append('\"').append(\u00e2\u02dc\u019212, 0, \u00e2\u02dc\u019212.length() - string.length()).append(": ");
                    NbtUtils.m_178026_(p_178027_, compoundTag.m_128423_(string), p_178029_ + 1, p_178030_);
                }
                if (!\u00e2\u02dc\u019210.isEmpty()) {
                    p_178027_.append('\n');
                }
                NbtUtils.m_178019_(p_178029_, p_178027_).append('}');
                break;
            }
            case 12: {
                int n;
                LongArrayTag longArrayTag = (LongArrayTag)p_178028_;
                long[] \u00e2\u02dc\u019213 = longArrayTag.m_128851_();
                long \u00e2\u02dc\u019214 = 0L;
                long[] \u00e2\u02dc\u019215 = \u00e2\u02dc\u019213;
                int n2 = \u00e2\u02dc\u019215.length;
                for (n = 0; n < n2; ++n) {
                    long l = \u00e2\u02dc\u019215[n];
                    \u00e2\u02dc\u019214 = Math.max(\u00e2\u02dc\u019214, (long)String.format("%X", l).length());
                }
                long l = \u00e2\u02dc\u019213.length;
                NbtUtils.m_178019_(p_178029_, p_178027_).append("long[").append(l).append("] {\n");
                if (p_178030_) {
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_);
                    for (n = 0; n < \u00e2\u02dc\u019213.length; ++n) {
                        if (n != 0) {
                            p_178027_.append(',');
                        }
                        if (n % 16 == 0 && n / 16 > 0) {
                            p_178027_.append('\n');
                            if (n < \u00e2\u02dc\u019213.length) {
                                NbtUtils.m_178019_(p_178029_ + 1, p_178027_);
                            }
                        } else if (n != 0) {
                            p_178027_.append(' ');
                        }
                        p_178027_.append(String.format("0x%0" + \u00e2\u02dc\u019214 + "X", \u00e2\u02dc\u019213[n]));
                    }
                } else {
                    NbtUtils.m_178019_(p_178029_ + 1, p_178027_).append(" // Skipped, supply withBinaryBlobs true");
                }
                p_178027_.append('\n');
                NbtUtils.m_178019_(p_178029_, p_178027_).append('}');
                break;
            }
            default: {
                p_178027_.append("<UNKNOWN :(>");
            }
        }
        return p_178027_;
    }

    private static StringBuilder m_178019_(int p_178020_, StringBuilder p_178021_) {
        int n = p_178021_.lastIndexOf("\n") + 1;
        \u00e2\u02dc\u0192 = p_178021_.length() - n;
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 2 * p_178020_ - \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
            p_178021_.append(' ');
        }
        return p_178021_;
    }

    public static CompoundTag m_129213_(DataFixer p_129214_, DataFixTypes p_129215_, CompoundTag p_129216_, int p_129217_) {
        return NbtUtils.m_129218_(p_129214_, p_129215_, p_129216_, p_129217_, SharedConstants.m_136187_().getWorldVersion());
    }

    public static CompoundTag m_129218_(DataFixer p_129219_, DataFixTypes p_129220_, CompoundTag p_129221_, int p_129222_, int p_129223_) {
        return (CompoundTag)p_129219_.update(p_129220_.m_14504_(), new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_129221_), p_129222_, p_129223_).getValue();
    }

    public static Component m_178061_(Tag p_178062_) {
        return new TextComponentTagVisitor("", 0).m_178281_(p_178062_);
    }

    public static String m_178063_(CompoundTag p_178064_) {
        return new SnbtPrinterTagVisitor().m_178141_(NbtUtils.m_178067_(p_178064_));
    }

    public static CompoundTag m_178024_(String p_178025_) throws CommandSyntaxException {
        return NbtUtils.m_178071_(TagParser.m_129359_(p_178025_));
    }

    @VisibleForTesting
    static CompoundTag m_178067_(CompoundTag p_178068_) {
        ListTag listTag;
        boolean bl = p_178068_.m_128425_("palettes", 9);
        ListTag \u00e2\u02dc\u01922 = bl ? p_178068_.m_128437_("palettes", 9).m_128744_(0) : p_178068_.m_128437_("palette", 10);
        ListTag \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.stream().map(CompoundTag.class::cast).map(NbtUtils::m_178075_).map(StringTag::m_129297_).collect(Collectors.toCollection(ListTag::new));
        p_178068_.m_128365_("palette", \u00e2\u02dc\u01923);
        if (bl) {
            listTag = new ListTag();
            \u00e2\u02dc\u0192 = p_178068_.m_128437_("palettes", 9);
            \u00e2\u02dc\u0192.stream().map(ListTag.class::cast).forEach(p_178049_ -> {
                CompoundTag compoundTag = new CompoundTag();
                for (int i = 0; i < p_178049_.size(); ++i) {
                    compoundTag.m_128359_(\u00e2\u02dc\u01923.m_128778_(i), NbtUtils.m_178075_(p_178049_.m_128728_(i)));
                }
                listTag.add(compoundTag);
            });
            p_178068_.m_128365_("palettes", listTag);
        }
        if (p_178068_.m_128425_("entities", 10)) {
            listTag = p_178068_.m_128437_("entities", 10);
            \u00e2\u02dc\u0192 = listTag.stream().map(CompoundTag.class::cast).sorted(Comparator.comparing(p_178080_ -> p_178080_.m_128437_("pos", 6), f_178009_)).collect(Collectors.toCollection(ListTag::new));
            p_178068_.m_128365_("entities", \u00e2\u02dc\u0192);
        }
        listTag = p_178068_.m_128437_("blocks", 10).stream().map(CompoundTag.class::cast).sorted(Comparator.comparing(p_178078_ -> p_178078_.m_128437_("pos", 3), f_178008_)).peek(p_178045_ -> p_178045_.m_128359_("state", \u00e2\u02dc\u01923.m_128778_(p_178045_.m_128451_("state")))).collect(Collectors.toCollection(ListTag::new));
        p_178068_.m_128365_(f_178007_, listTag);
        p_178068_.m_128473_("blocks");
        return p_178068_;
    }

    @VisibleForTesting
    static CompoundTag m_178071_(CompoundTag p_178072_) {
        ListTag listTag = p_178072_.m_128437_("palette", 8);
        Map \u00e2\u02dc\u01922 = (Map)listTag.stream().map(StringTag.class::cast).map(StringTag::m_7916_).collect(ImmutableMap.toImmutableMap(Function.identity(), NbtUtils::m_178053_));
        if (p_178072_.m_128425_("palettes", 9)) {
            p_178072_.m_128365_("palettes", p_178072_.m_128437_("palettes", 10).stream().map(CompoundTag.class::cast).map(p_178033_ -> \u00e2\u02dc\u01922.keySet().stream().map(p_178033_::m_128461_).map(NbtUtils::m_178053_).collect(Collectors.toCollection(ListTag::new))).collect(Collectors.toCollection(ListTag::new)));
            p_178072_.m_128473_("palette");
        } else {
            p_178072_.m_128365_("palette", \u00e2\u02dc\u01922.values().stream().collect(Collectors.toCollection(ListTag::new)));
        }
        if (p_178072_.m_128425_(f_178007_, 9)) {
            Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
            object2IntOpenHashMap.defaultReturnValue(-1);
            for (int i = 0; i < listTag.size(); ++i) {
                object2IntOpenHashMap.put((Object)listTag.m_128778_(i), i);
            }
            ListTag listTag2 = p_178072_.m_128437_(f_178007_, 10);
            for (int i = 0; i < listTag2.size(); ++i) {
                CompoundTag compoundTag = listTag2.m_128728_(i);
                String \u00e2\u02dc\u01923 = compoundTag.m_128461_("state");
                int \u00e2\u02dc\u01924 = object2IntOpenHashMap.getInt((Object)\u00e2\u02dc\u01923);
                if (\u00e2\u02dc\u01924 == -1) {
                    throw new IllegalStateException("Entry " + \u00e2\u02dc\u01923 + " missing from palette");
                }
                compoundTag.m_128405_("state", \u00e2\u02dc\u01924);
            }
            p_178072_.m_128365_("blocks", listTag2);
            p_178072_.m_128473_(f_178007_);
        }
        return p_178072_;
    }

    @VisibleForTesting
    static String m_178075_(CompoundTag p_178076_) {
        StringBuilder stringBuilder = new StringBuilder(p_178076_.m_128461_("Name"));
        if (p_178076_.m_128425_("Properties", 10)) {
            CompoundTag compoundTag = p_178076_.m_128469_("Properties");
            String \u00e2\u02dc\u01922 = compoundTag.m_128431_().stream().sorted().map(p_178036_ -> p_178036_ + ":" + compoundTag.m_128423_((String)p_178036_).m_7916_()).collect(Collectors.joining(f_178012_));
            stringBuilder.append('{').append(\u00e2\u02dc\u01922).append('}');
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    static CompoundTag m_178053_(String p_178054_) {
        CompoundTag compoundTag = new CompoundTag();
        int \u00e2\u02dc\u01922 = p_178054_.indexOf(123);
        if (\u00e2\u02dc\u01922 >= 0) {
            String string = p_178054_.substring(0, \u00e2\u02dc\u01922);
            CompoundTag \u00e2\u02dc\u01923 = new CompoundTag();
            if (\u00e2\u02dc\u01922 + 2 <= p_178054_.length()) {
                \u00e2\u02dc\u0192 = p_178054_.substring(\u00e2\u02dc\u01922 + 1, p_178054_.indexOf(125, \u00e2\u02dc\u01922));
                f_178014_.split((CharSequence)\u00e2\u02dc\u0192).forEach(p_178040_ -> {
                    List list = f_178015_.splitToList((CharSequence)p_178040_);
                    if (list.size() == 2) {
                        \u00e2\u02dc\u01923.m_128359_((String)list.get(0), (String)list.get(1));
                    } else {
                        f_129200_.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)p_178054_);
                    }
                });
                compoundTag.m_128365_("Properties", \u00e2\u02dc\u01923);
            }
        } else {
            string = p_178054_;
        }
        compoundTag.m_128359_("Name", string);
        return compoundTag;
    }
}

