/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.IOException;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.SkipPacketException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PacketEncoder
extends MessageToByteEncoder<Packet<?>> {
    private static final Logger f_130538_ = LogManager.getLogger();
    private static final Marker f_130539_ = MarkerManager.getMarker((String)"PACKET_SENT", (Marker)Connection.f_129460_);
    private final PacketFlow f_130540_;

    public PacketEncoder(PacketFlow p_130543_) {
        this.f_130540_ = p_130543_;
    }

    protected void encode(ChannelHandlerContext p_130545_, Packet<?> p_130546_, ByteBuf p_130547_) throws Exception {
        ConnectionProtocol connectionProtocol = (ConnectionProtocol)((Object)p_130545_.channel().attr(Connection.f_129461_).get());
        if (connectionProtocol == null) {
            throw new RuntimeException("ConnectionProtocol unknown: " + p_130546_);
        }
        Integer \u00e2\u02dc\u01922 = connectionProtocol.m_129597_(this.f_130540_, p_130546_);
        if (f_130538_.isDebugEnabled()) {
            f_130538_.debug(f_130539_, "OUT: [{}:{}] {}", p_130545_.channel().attr(Connection.f_129461_).get(), (Object)\u00e2\u02dc\u01922, (Object)p_130546_.getClass().getName());
        }
        if (\u00e2\u02dc\u01922 == null) {
            throw new IOException("Can't serialize unregistered packet");
        }
        FriendlyByteBuf \u00e2\u02dc\u01923 = new FriendlyByteBuf(p_130547_);
        \u00e2\u02dc\u01923.m_130130_(\u00e2\u02dc\u01922);
        try {
            int n = \u00e2\u02dc\u01923.writerIndex();
            p_130546_.m_5779_(\u00e2\u02dc\u01923);
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923.writerIndex() - n;
            if (\u00e2\u02dc\u0192 > 0x800000) {
                throw new IllegalArgumentException("Packet too big (is " + \u00e2\u02dc\u0192 + ", should be less than 8388608): " + p_130546_);
            }
        }
        catch (Throwable throwable) {
            f_130538_.error((Object)throwable);
            if (p_130546_.m_6588_()) {
                throw new SkipPacketException(throwable);
            }
            throw throwable;
        }
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, ByteBuf byteBuf) throws Exception {
        this.encode(channelHandlerContext, (Packet)object, byteBuf);
    }
}

