/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.KeybindComponent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.NbtComponent;
import net.minecraft.network.chat.ScoreComponent;
import net.minecraft.network.chat.SelectorComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;

public interface Component
extends Message,
FormattedText {
    public Style m_7383_();

    public String m_6111_();

    @Override
    default public String getString() {
        return FormattedText.super.getString();
    }

    default public String m_130668_(int p_130669_) {
        StringBuilder stringBuilder = new StringBuilder();
        this.m_5651_(p_130673_ -> {
            int n = p_130669_ - stringBuilder.length();
            if (n <= 0) {
                return f_130759_;
            }
            stringBuilder.append(p_130673_.length() <= n ? p_130673_ : p_130673_.substring(0, n));
            return Optional.empty();
        });
        return stringBuilder.toString();
    }

    public List<Component> m_7360_();

    public MutableComponent m_6879_();

    public MutableComponent m_6881_();

    public FormattedCharSequence m_7532_();

    @Override
    default public <T> Optional<T> m_7451_(FormattedText.StyledContentConsumer<T> p_130679_, Style p_130680_) {
        Style style = this.m_7383_().m_131146_(p_130680_);
        Optional<T> \u00e2\u02dc\u01922 = this.m_7452_(p_130679_, style);
        if (\u00e2\u02dc\u01922.isPresent()) {
            return \u00e2\u02dc\u01922;
        }
        for (Component component : this.m_7360_()) {
            Optional<T> optional = component.m_7451_(p_130679_, style);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> m_5651_(FormattedText.ContentConsumer<T> p_130677_) {
        Optional<T> optional = this.m_5655_(p_130677_);
        if (optional.isPresent()) {
            return optional;
        }
        for (Component component : this.m_7360_()) {
            Optional<T> optional2 = component.m_5651_(p_130677_);
            if (!optional2.isPresent()) continue;
            return optional2;
        }
        return Optional.empty();
    }

    default public <T> Optional<T> m_7452_(FormattedText.StyledContentConsumer<T> p_130682_, Style p_130683_) {
        return p_130682_.m_7164_(p_130683_, this.m_6111_());
    }

    default public <T> Optional<T> m_5655_(FormattedText.ContentConsumer<T> p_130681_) {
        return p_130681_.m_130809_(this.m_6111_());
    }

    default public List<Component> m_178405_(Style p_178406_) {
        ArrayList arrayList = Lists.newArrayList();
        this.m_7451_((p_178403_, p_178404_) -> {
            if (!p_178404_.isEmpty()) {
                arrayList.add(new TextComponent(p_178404_).m_130948_(p_178403_));
            }
            return Optional.empty();
        }, p_178406_);
        return arrayList;
    }

    public static Component m_130674_(@Nullable String p_130675_) {
        return p_130675_ != null ? new TextComponent(p_130675_) : TextComponent.f_131282_;
    }

    public static class Serializer
    implements JsonDeserializer<MutableComponent>,
    JsonSerializer<Component> {
        private static final Gson f_130685_ = Util.m_137537_(() -> {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.disableHtmlEscaping();
            gsonBuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Serializer());
            gsonBuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
            return gsonBuilder.create();
        });
        private static final Field f_130686_ = Util.m_137537_(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", noSuchFieldException);
            }
        });
        private static final Field f_130687_ = Util.m_137537_(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", noSuchFieldException);
            }
        });

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MutableComponent deserialize(JsonElement p_130694_, Type p_130695_, JsonDeserializationContext p_130696_) throws JsonParseException {
            void var5_19;
            if (p_130694_.isJsonPrimitive()) {
                return new TextComponent(p_130694_.getAsString());
            }
            if (p_130694_.isJsonObject()) {
                void var5_17;
                JsonObject jsonObject = p_130694_.getAsJsonObject();
                if (jsonObject.has("text")) {
                    TextComponent textComponent = new TextComponent(GsonHelper.m_13906_(jsonObject, "text"));
                } else if (jsonObject.has("translate")) {
                    \u00e2\u02dc\u0192 = GsonHelper.m_13906_(jsonObject, "translate");
                    if (jsonObject.has("with")) {
                        JsonArray jsonArray = GsonHelper.m_13933_(jsonObject, "with");
                        Object[] objectArray = new Object[jsonArray.size()];
                        for (int i = 0; i < objectArray.length; ++i) {
                            objectArray[i] = this.deserialize(jsonArray.get(i), p_130695_, p_130696_);
                            if (!(objectArray[i] instanceof TextComponent) || !(\u00e2\u02dc\u0192 = (TextComponent)objectArray[i]).m_7383_().m_131179_() || !\u00e2\u02dc\u0192.m_7360_().isEmpty()) continue;
                            objectArray[i] = \u00e2\u02dc\u0192.m_131292_();
                        }
                        TranslatableComponent translatableComponent = new TranslatableComponent((String)\u00e2\u02dc\u0192, objectArray);
                    } else {
                        TranslatableComponent translatableComponent = new TranslatableComponent((String)\u00e2\u02dc\u0192);
                    }
                } else if (jsonObject.has("score")) {
                    \u00e2\u02dc\u0192 = GsonHelper.m_13930_(jsonObject, "score");
                    if (!\u00e2\u02dc\u0192.has("name") || !\u00e2\u02dc\u0192.has("objective")) throw new JsonParseException("A score component needs a least a name and an objective");
                    ScoreComponent scoreComponent = new ScoreComponent(GsonHelper.m_13906_((JsonObject)\u00e2\u02dc\u0192, "name"), GsonHelper.m_13906_((JsonObject)\u00e2\u02dc\u0192, "objective"));
                } else if (jsonObject.has("selector")) {
                    \u00e2\u02dc\u0192 = this.m_178415_(p_130695_, p_130696_, jsonObject);
                    SelectorComponent selectorComponent = new SelectorComponent(GsonHelper.m_13906_(jsonObject, "selector"), (Optional<Component>)\u00e2\u02dc\u0192);
                } else if (jsonObject.has("keybind")) {
                    KeybindComponent keybindComponent = new KeybindComponent(GsonHelper.m_13906_(jsonObject, "keybind"));
                } else {
                    if (!jsonObject.has("nbt")) throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
                    \u00e2\u02dc\u0192 = GsonHelper.m_13906_(jsonObject, "nbt");
                    Optional<Component> optional = this.m_178415_(p_130695_, p_130696_, jsonObject);
                    boolean \u00e2\u02dc\u01922 = GsonHelper.m_13855_(jsonObject, "interpret", false);
                    if (jsonObject.has("block")) {
                        NbtComponent.BlockNbtComponent blockNbtComponent = new NbtComponent.BlockNbtComponent((String)\u00e2\u02dc\u0192, \u00e2\u02dc\u01922, GsonHelper.m_13906_(jsonObject, "block"), optional);
                    } else if (jsonObject.has("entity")) {
                        NbtComponent.EntityNbtComponent entityNbtComponent = new NbtComponent.EntityNbtComponent((String)\u00e2\u02dc\u0192, \u00e2\u02dc\u01922, GsonHelper.m_13906_(jsonObject, "entity"), optional);
                    } else {
                        if (!jsonObject.has("storage")) throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
                        NbtComponent.StorageNbtComponent storageNbtComponent = new NbtComponent.StorageNbtComponent((String)\u00e2\u02dc\u0192, \u00e2\u02dc\u01922, new ResourceLocation(GsonHelper.m_13906_(jsonObject, "storage")), optional);
                    }
                }
                if (jsonObject.has("extra")) {
                    void var7_27;
                    \u00e2\u02dc\u0192 = GsonHelper.m_13933_(jsonObject, "extra");
                    if (\u00e2\u02dc\u0192.size() <= 0) throw new JsonParseException("Unexpected empty array of components");
                    boolean bl = false;
                    while (var7_27 < \u00e2\u02dc\u0192.size()) {
                        var5_17.m_7220_(this.deserialize(\u00e2\u02dc\u0192.get((int)var7_27), p_130695_, p_130696_));
                        ++var7_27;
                    }
                }
                var5_17.m_6270_((Style)p_130696_.deserialize(p_130694_, Style.class));
                return var5_17;
            }
            if (!p_130694_.isJsonArray()) throw new JsonParseException("Don't know how to turn " + p_130694_ + " into a Component");
            JsonArray jsonArray = p_130694_.getAsJsonArray();
            Object var5_18 = null;
            for (JsonElement jsonElement : jsonArray) {
                MutableComponent mutableComponent = this.deserialize(jsonElement, jsonElement.getClass(), p_130696_);
                if (var5_19 == null) {
                    MutableComponent mutableComponent2 = mutableComponent;
                    continue;
                }
                var5_19.m_7220_(mutableComponent);
            }
            return var5_19;
        }

        private Optional<Component> m_178415_(Type p_178416_, JsonDeserializationContext p_178417_, JsonObject p_178418_) {
            if (p_178418_.has("separator")) {
                return Optional.of(this.deserialize(p_178418_.get("separator"), p_178416_, p_178417_));
            }
            return Optional.empty();
        }

        private void m_130709_(Style p_130710_, JsonObject p_130711_, JsonSerializationContext p_130712_) {
            JsonElement jsonElement = p_130712_.serialize((Object)p_130710_);
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    p_130711_.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JsonElement serialize(Component p_130706_, Type p_130707_, JsonSerializationContext p_130708_) {
            Object object;
            JsonObject jsonObject = new JsonObject();
            if (!p_130706_.m_7383_().m_131179_()) {
                this.m_130709_(p_130706_.m_7383_(), jsonObject, p_130708_);
            }
            if (!p_130706_.m_7360_().isEmpty()) {
                object = new JsonArray();
                for (Component component : p_130706_.m_7360_()) {
                    object.add(this.serialize(component, component.getClass(), p_130708_));
                }
                jsonObject.add("extra", (JsonElement)object);
            }
            if (p_130706_ instanceof TextComponent) {
                jsonObject.addProperty("text", ((TextComponent)p_130706_).m_131292_());
                return jsonObject;
            } else if (p_130706_ instanceof TranslatableComponent) {
                object = (TranslatableComponent)p_130706_;
                jsonObject.addProperty("translate", ((TranslatableComponent)object).m_131328_());
                if (((TranslatableComponent)object).m_131329_() == null || ((TranslatableComponent)object).m_131329_().length <= 0) return jsonObject;
                \u00e2\u02dc\u0192 = new JsonArray();
                for (Object object2 : ((TranslatableComponent)object).m_131329_()) {
                    if (object2 instanceof Component) {
                        \u00e2\u02dc\u0192.add(this.serialize((Component)object2, object2.getClass(), p_130708_));
                        continue;
                    }
                    \u00e2\u02dc\u0192.add((JsonElement)new JsonPrimitive(String.valueOf(object2)));
                }
                jsonObject.add("with", (JsonElement)\u00e2\u02dc\u0192);
                return jsonObject;
            } else if (p_130706_ instanceof ScoreComponent) {
                object = (ScoreComponent)p_130706_;
                \u00e2\u02dc\u0192 = new JsonObject();
                \u00e2\u02dc\u0192.addProperty("name", ((ScoreComponent)object).m_131071_());
                \u00e2\u02dc\u0192.addProperty("objective", ((ScoreComponent)object).m_131072_());
                jsonObject.add("score", (JsonElement)\u00e2\u02dc\u0192);
                return jsonObject;
            } else if (p_130706_ instanceof SelectorComponent) {
                object = (SelectorComponent)p_130706_;
                jsonObject.addProperty("selector", ((SelectorComponent)object).m_131096_());
                this.m_178411_(p_130708_, jsonObject, ((SelectorComponent)object).m_178519_());
                return jsonObject;
            } else if (p_130706_ instanceof KeybindComponent) {
                object = (KeybindComponent)p_130706_;
                jsonObject.addProperty("keybind", ((KeybindComponent)object).m_130935_());
                return jsonObject;
            } else {
                if (!(p_130706_ instanceof NbtComponent)) throw new IllegalArgumentException("Don't know how to serialize " + p_130706_ + " as a Component");
                object = (NbtComponent)p_130706_;
                jsonObject.addProperty("nbt", ((NbtComponent)object).m_130979_());
                jsonObject.addProperty("interpret", Boolean.valueOf(((NbtComponent)object).m_130980_()));
                this.m_178411_(p_130708_, jsonObject, ((NbtComponent)object).f_178447_);
                if (p_130706_ instanceof NbtComponent.BlockNbtComponent) {
                    \u00e2\u02dc\u0192 = (NbtComponent.BlockNbtComponent)p_130706_;
                    jsonObject.addProperty("block", ((NbtComponent.BlockNbtComponent)\u00e2\u02dc\u0192).m_131001_());
                    return jsonObject;
                } else if (p_130706_ instanceof NbtComponent.EntityNbtComponent) {
                    \u00e2\u02dc\u0192 = (NbtComponent.EntityNbtComponent)p_130706_;
                    jsonObject.addProperty("entity", ((NbtComponent.EntityNbtComponent)\u00e2\u02dc\u0192).m_131024_());
                    return jsonObject;
                } else {
                    if (!(p_130706_ instanceof NbtComponent.StorageNbtComponent)) throw new IllegalArgumentException("Don't know how to serialize " + p_130706_ + " as a Component");
                    \u00e2\u02dc\u0192 = (NbtComponent.StorageNbtComponent)p_130706_;
                    jsonObject.addProperty("storage", ((NbtComponent.StorageNbtComponent)\u00e2\u02dc\u0192).m_131043_().toString());
                }
            }
            return jsonObject;
        }

        private void m_178411_(JsonSerializationContext p_178412_, JsonObject p_178413_, Optional<Component> p_178414_) {
            p_178414_.ifPresent(p_178410_ -> p_178413_.add("separator", this.serialize((Component)p_178410_, (Type)p_178410_.getClass(), p_178412_)));
        }

        public static String m_130703_(Component p_130704_) {
            return f_130685_.toJson((Object)p_130704_);
        }

        public static JsonElement m_130716_(Component p_130717_) {
            return f_130685_.toJsonTree((Object)p_130717_);
        }

        @Nullable
        public static MutableComponent m_130701_(String p_130702_) {
            return GsonHelper.m_13798_(f_130685_, p_130702_, MutableComponent.class, false);
        }

        @Nullable
        public static MutableComponent m_130691_(JsonElement p_130692_) {
            return (MutableComponent)f_130685_.fromJson(p_130692_, MutableComponent.class);
        }

        @Nullable
        public static MutableComponent m_130714_(String p_130715_) {
            return GsonHelper.m_13798_(f_130685_, p_130715_, MutableComponent.class, true);
        }

        public static MutableComponent m_130699_(com.mojang.brigadier.StringReader p_130700_) {
            try {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(p_130700_.getRemaining()));
                jsonReader.setLenient(false);
                MutableComponent \u00e2\u02dc\u01922 = (MutableComponent)f_130685_.getAdapter(MutableComponent.class).read(jsonReader);
                p_130700_.setCursor(p_130700_.getCursor() + Serializer.m_130697_(jsonReader));
                return \u00e2\u02dc\u01922;
            }
            catch (IOException | StackOverflowError throwable) {
                throw new JsonParseException(throwable);
            }
        }

        private static int m_130697_(JsonReader p_130698_) {
            try {
                return f_130686_.getInt(p_130698_) - f_130687_.getInt(p_130698_) + 1;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalAccessException);
            }
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((Component)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

