/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.ContextAwareComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableFormatException;
import net.minecraft.world.entity.Entity;

public class TranslatableComponent
extends BaseComponent
implements ContextAwareComponent {
    private static final Object[] f_131295_ = new Object[0];
    private static final FormattedText f_131296_ = FormattedText.m_130775_("%");
    private static final FormattedText f_131297_ = FormattedText.m_130775_("null");
    private final String f_131298_;
    private final Object[] f_131299_;
    @Nullable
    private Language f_131300_;
    private final List<FormattedText> f_131301_ = Lists.newArrayList();
    private static final Pattern f_131302_ = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslatableComponent(String p_131305_) {
        this.f_131298_ = p_131305_;
        this.f_131299_ = f_131295_;
    }

    public TranslatableComponent(String p_131307_, Object ... p_131308_) {
        this.f_131298_ = p_131307_;
        this.f_131299_ = p_131308_;
    }

    private void m_131330_() {
        Language language = Language.m_128107_();
        if (language == this.f_131300_) {
            return;
        }
        this.f_131300_ = language;
        this.f_131301_.clear();
        String \u00e2\u02dc\u01922 = language.m_6834_(this.f_131298_);
        try {
            this.m_131321_(\u00e2\u02dc\u01922);
        }
        catch (TranslatableFormatException \u00e2\u02dc\u01923) {
            this.f_131301_.clear();
            this.f_131301_.add(FormattedText.m_130775_(\u00e2\u02dc\u01922));
        }
    }

    private void m_131321_(String p_131322_) {
        Matcher matcher = f_131302_.matcher(p_131322_);
        try {
            int n;
            int n2 = 0;
            n = 0;
            while (matcher.find(n)) {
                int n3;
                String \u00e2\u02dc\u01922;
                \u00e2\u02dc\u0192 = matcher.start();
                n3 = matcher.end();
                if (\u00e2\u02dc\u0192 > n) {
                    \u00e2\u02dc\u01922 = p_131322_.substring(n, \u00e2\u02dc\u0192);
                    if (\u00e2\u02dc\u01922.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    this.f_131301_.add(FormattedText.m_130775_(\u00e2\u02dc\u01922));
                }
                \u00e2\u02dc\u01922 = matcher.group(2);
                String \u00e2\u02dc\u01923 = p_131322_.substring(\u00e2\u02dc\u0192, n3);
                if ("%".equals(\u00e2\u02dc\u01922) && "%%".equals(\u00e2\u02dc\u01923)) {
                    this.f_131301_.add(f_131296_);
                } else if ("s".equals(\u00e2\u02dc\u01922)) {
                    String string = matcher.group(1);
                    int n4 = \u00e2\u02dc\u0192 = string != null ? Integer.parseInt(string) - 1 : n2++;
                    if (\u00e2\u02dc\u0192 < this.f_131299_.length) {
                        this.f_131301_.add(this.m_131313_(\u00e2\u02dc\u0192));
                    }
                } else {
                    throw new TranslatableFormatException(this, "Unsupported format: '" + \u00e2\u02dc\u01923 + "'");
                }
                n = n3;
            }
            if (n < p_131322_.length()) {
                String string = p_131322_.substring(n);
                if (string.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                this.f_131301_.add(FormattedText.m_130775_(string));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TranslatableFormatException(this, (Throwable)illegalArgumentException);
        }
    }

    private FormattedText m_131313_(int p_131314_) {
        if (p_131314_ >= this.f_131299_.length) {
            throw new TranslatableFormatException(this, p_131314_);
        }
        Object object = this.f_131299_[p_131314_];
        if (object instanceof Component) {
            return (Component)object;
        }
        return object == null ? f_131297_ : FormattedText.m_130775_(object.toString());
    }

    @Override
    public TranslatableComponent m_6879_() {
        return new TranslatableComponent(this.f_131298_, this.f_131299_);
    }

    @Override
    public <T> Optional<T> m_7452_(FormattedText.StyledContentConsumer<T> p_131318_, Style p_131319_) {
        this.m_131330_();
        for (FormattedText formattedText : this.f_131301_) {
            Optional<T> optional = formattedText.m_7451_(p_131318_, p_131319_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> m_5655_(FormattedText.ContentConsumer<T> p_131316_) {
        this.m_131330_();
        for (FormattedText formattedText : this.f_131301_) {
            Optional<T> optional = formattedText.m_5651_(p_131316_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public MutableComponent m_5638_(@Nullable CommandSourceStack p_131310_, @Nullable Entity p_131311_, int p_131312_) throws CommandSyntaxException {
        Object[] objectArray = new Object[this.f_131299_.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = this.f_131299_[i];
            objectArray[i] = object instanceof Component ? ComponentUtils.m_130731_(p_131310_, (Component)object, p_131311_, p_131312_) : object;
        }
        return new TranslatableComponent(this.f_131298_, objectArray);
    }

    @Override
    public boolean equals(Object p_131324_) {
        if (this == p_131324_) {
            return true;
        }
        if (p_131324_ instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)p_131324_;
            return Arrays.equals(this.f_131299_, translatableComponent.f_131299_) && this.f_131298_.equals(translatableComponent.f_131298_) && super.equals(p_131324_);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.f_131298_.hashCode();
        n = 31 * n + Arrays.hashCode(this.f_131299_);
        return n;
    }

    @Override
    public String toString() {
        return "TranslatableComponent{key='" + this.f_131298_ + "', args=" + Arrays.toString(this.f_131299_) + ", siblings=" + this.f_130578_ + ", style=" + this.m_7383_() + "}";
    }

    public String m_131328_() {
        return this.f_131298_;
    }

    public Object[] m_131329_() {
        return this.f_131299_;
    }

    @Override
    public /* synthetic */ BaseComponent m_6879_() {
        return this.m_6879_();
    }

    @Override
    public /* synthetic */ MutableComponent m_6879_() {
        return this.m_6879_();
    }
}

