/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    private static final byte f_178797_ = 3;
    private static final byte f_178798_ = 4;
    private static final byte f_178799_ = 8;
    private static final byte f_178800_ = 16;
    private static final byte f_178801_ = 0;
    private static final byte f_178802_ = 1;
    private static final byte f_178803_ = 2;
    private final RootCommandNode<SharedSuggestionProvider> f_131858_;

    public ClientboundCommandsPacket(RootCommandNode<SharedSuggestionProvider> p_131861_) {
        this.f_131858_ = p_131861_;
    }

    public ClientboundCommandsPacket(FriendlyByteBuf p_178805_) {
        List<Entry> list = p_178805_.m_178366_(ClientboundCommandsPacket::m_131887_);
        ClientboundCommandsPacket.m_178812_(list);
        int \u00e2\u02dc\u01922 = p_178805_.m_130242_();
        this.f_131858_ = (RootCommandNode)list.get((int)\u00e2\u02dc\u01922).f_131893_;
    }

    @Override
    public void m_5779_(FriendlyByteBuf p_131886_) {
        Object2IntMap<CommandNode<SharedSuggestionProvider>> object2IntMap = ClientboundCommandsPacket.m_131862_(this.f_131858_);
        List<CommandNode<SharedSuggestionProvider>> \u00e2\u02dc\u01922 = ClientboundCommandsPacket.m_178806_(object2IntMap);
        p_131886_.m_178352_(\u00e2\u02dc\u01922, (p_178810_, p_178811_) -> ClientboundCommandsPacket.m_131871_(p_178810_, (CommandNode<SharedSuggestionProvider>)p_178811_, (Map<CommandNode<SharedSuggestionProvider>, Integer>)object2IntMap));
        p_131886_.m_130130_(object2IntMap.get(this.f_131858_));
    }

    private static void m_178812_(List<Entry> p_178813_) {
        ArrayList arrayList = Lists.newArrayList(p_178813_);
        while (!arrayList.isEmpty()) {
            boolean bl = arrayList.removeIf(p_178816_ -> p_178816_.m_178817_(p_178813_));
            if (bl) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static Object2IntMap<CommandNode<SharedSuggestionProvider>> m_131862_(RootCommandNode<SharedSuggestionProvider> p_131863_) {
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        ArrayDeque \u00e2\u02dc\u01922 = Queues.newArrayDeque();
        \u00e2\u02dc\u01922.add(p_131863_);
        while ((\u00e2\u02dc\u0192 = (CommandNode)\u00e2\u02dc\u01922.poll()) != null) {
            if (object2IntOpenHashMap.containsKey((Object)\u00e2\u02dc\u0192)) continue;
            int n = object2IntOpenHashMap.size();
            object2IntOpenHashMap.put((Object)\u00e2\u02dc\u0192, n);
            \u00e2\u02dc\u01922.addAll(\u00e2\u02dc\u0192.getChildren());
            if (\u00e2\u02dc\u0192.getRedirect() == null) continue;
            \u00e2\u02dc\u01922.add(\u00e2\u02dc\u0192.getRedirect());
        }
        return object2IntOpenHashMap;
    }

    private static List<CommandNode<SharedSuggestionProvider>> m_178806_(Object2IntMap<CommandNode<SharedSuggestionProvider>> p_178807_) {
        ObjectArrayList objectArrayList = new ObjectArrayList(p_178807_.size());
        objectArrayList.size(p_178807_.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(p_178807_)) {
            objectArrayList.set(entry.getIntValue(), (Object)((CommandNode)entry.getKey()));
        }
        return objectArrayList;
    }

    private static Entry m_131887_(FriendlyByteBuf p_131888_) {
        byte by = p_131888_.readByte();
        int[] \u00e2\u02dc\u01922 = p_131888_.m_130100_();
        int \u00e2\u02dc\u01923 = (by & 8) != 0 ? p_131888_.m_130242_() : 0;
        ArgumentBuilder<SharedSuggestionProvider, ?> \u00e2\u02dc\u01924 = ClientboundCommandsPacket.m_131868_(p_131888_, by);
        return new Entry(\u00e2\u02dc\u01924, by, \u00e2\u02dc\u01923, \u00e2\u02dc\u01922);
    }

    @Nullable
    private static ArgumentBuilder<SharedSuggestionProvider, ?> m_131868_(FriendlyByteBuf p_131869_, byte p_131870_) {
        int n = p_131870_ & 3;
        if (n == 2) {
            String string = p_131869_.m_130277_();
            ArgumentType<?> \u00e2\u02dc\u01922 = ArgumentTypes.m_121609_(p_131869_);
            if (\u00e2\u02dc\u01922 == null) {
                return null;
            }
            RequiredArgumentBuilder \u00e2\u02dc\u01923 = RequiredArgumentBuilder.argument((String)string, \u00e2\u02dc\u01922);
            if ((p_131870_ & 0x10) != 0) {
                \u00e2\u02dc\u01923.suggests(SuggestionProviders.m_121656_(p_131869_.m_130281_()));
            }
            return \u00e2\u02dc\u01923;
        }
        if (n == 1) {
            return LiteralArgumentBuilder.literal((String)p_131869_.m_130277_());
        }
        return null;
    }

    private static void m_131871_(FriendlyByteBuf p_131872_, CommandNode<SharedSuggestionProvider> p_131873_, Map<CommandNode<SharedSuggestionProvider>, Integer> p_131874_) {
        int n = 0;
        if (p_131873_.getRedirect() != null) {
            n = (byte)(n | 8);
        }
        if (p_131873_.getCommand() != null) {
            n = (byte)(n | 4);
        }
        if (p_131873_ instanceof RootCommandNode) {
            n = (byte)(n | 0);
        } else if (p_131873_ instanceof ArgumentCommandNode) {
            n = (byte)(n | 2);
            if (((ArgumentCommandNode)p_131873_).getCustomSuggestions() != null) {
                n = (byte)(n | 0x10);
            }
        } else if (p_131873_ instanceof LiteralCommandNode) {
            n = (byte)(n | 1);
        } else {
            throw new UnsupportedOperationException("Unknown node type " + p_131873_);
        }
        p_131872_.writeByte(n);
        p_131872_.m_130130_(p_131873_.getChildren().size());
        for (CommandNode commandNode : p_131873_.getChildren()) {
            p_131872_.m_130130_(p_131874_.get(commandNode));
        }
        if (p_131873_.getRedirect() != null) {
            p_131872_.m_130130_(p_131874_.get(p_131873_.getRedirect()));
        }
        if (p_131873_ instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)p_131873_;
            p_131872_.m_130070_(argumentCommandNode.getName());
            ArgumentTypes.m_121611_(p_131872_, argumentCommandNode.getType());
            if (argumentCommandNode.getCustomSuggestions() != null) {
                p_131872_.m_130085_(SuggestionProviders.m_121654_((SuggestionProvider<SharedSuggestionProvider>)argumentCommandNode.getCustomSuggestions()));
            }
        } else if (p_131873_ instanceof LiteralCommandNode) {
            p_131872_.m_130070_(((LiteralCommandNode)p_131873_).getLiteral());
        }
    }

    @Override
    public void m_5797_(ClientGamePacketListener p_131878_) {
        p_131878_.m_7443_(this);
    }

    public RootCommandNode<SharedSuggestionProvider> m_131884_() {
        return this.f_131858_;
    }

    static class Entry {
        @Nullable
        private final ArgumentBuilder<SharedSuggestionProvider, ?> f_131889_;
        private final byte f_131890_;
        private final int f_131891_;
        private final int[] f_131892_;
        @Nullable
        CommandNode<SharedSuggestionProvider> f_131893_;

        Entry(@Nullable ArgumentBuilder<SharedSuggestionProvider, ?> p_131895_, byte p_131896_, int p_131897_, int[] p_131898_) {
            this.f_131889_ = p_131895_;
            this.f_131890_ = p_131896_;
            this.f_131891_ = p_131897_;
            this.f_131892_ = p_131898_;
        }

        public boolean m_178817_(List<Entry> p_178818_) {
            if (this.f_131893_ == null) {
                if (this.f_131889_ == null) {
                    this.f_131893_ = new RootCommandNode();
                } else {
                    if ((this.f_131890_ & 8) != 0) {
                        if (p_178818_.get((int)this.f_131891_).f_131893_ == null) {
                            return false;
                        }
                        this.f_131889_.redirect(p_178818_.get((int)this.f_131891_).f_131893_);
                    }
                    if ((this.f_131890_ & 4) != 0) {
                        this.f_131889_.executes(p_131906_ -> 0);
                    }
                    this.f_131893_ = this.f_131889_.build();
                }
            }
            for (int n : this.f_131892_) {
                if (p_178818_.get((int)n).f_131893_ != null) continue;
                return false;
            }
            for (int n : this.f_131892_) {
                CommandNode<SharedSuggestionProvider> commandNode = p_178818_.get((int)n).f_131893_;
                if (commandNode instanceof RootCommandNode) continue;
                this.f_131893_.addChild(commandNode);
            }
            return true;
        }
    }
}

