/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkBiomeContainer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;

public class ClientboundLevelChunkPacket
implements Packet<ClientGamePacketListener> {
    public static final int f_178896_ = 0x200000;
    private final int f_132222_;
    private final int f_132223_;
    private final BitSet f_132224_;
    private final CompoundTag f_132225_;
    private final int[] f_132226_;
    private final byte[] f_132227_;
    private final List<CompoundTag> f_132228_;

    public ClientboundLevelChunkPacket(LevelChunk p_178898_) {
        ChunkPos chunkPos = p_178898_.m_7697_();
        this.f_132222_ = chunkPos.f_45578_;
        this.f_132223_ = chunkPos.f_45579_;
        this.f_132225_ = new CompoundTag();
        for (Map.Entry<Heightmap.Types, Heightmap> entry : p_178898_.m_6890_()) {
            if (!entry.getKey().m_64297_()) continue;
            this.f_132225_.m_128365_(entry.getKey().m_64294_(), new LongArrayTag(entry.getValue().m_64239_()));
        }
        this.f_132226_ = p_178898_.m_6221_().m_62131_();
        this.f_132227_ = new byte[this.m_178901_(p_178898_)];
        this.f_132224_ = this.m_178903_(new FriendlyByteBuf(this.m_132257_()), p_178898_);
        this.f_132228_ = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : p_178898_.m_62954_().entrySet()) {
            BlockEntity blockEntity = (BlockEntity)entry.getValue();
            CompoundTag \u00e2\u02dc\u01922 = blockEntity.m_5995_();
            this.f_132228_.add(\u00e2\u02dc\u01922);
        }
    }

    public ClientboundLevelChunkPacket(FriendlyByteBuf p_178900_) {
        this.f_132222_ = p_178900_.readInt();
        this.f_132223_ = p_178900_.readInt();
        this.f_132224_ = p_178900_.m_178384_();
        this.f_132225_ = p_178900_.m_130260_();
        if (this.f_132225_ == null) {
            throw new RuntimeException("Can't read heightmap in packet for [" + this.f_132222_ + ", " + this.f_132223_ + "]");
        }
        this.f_132226_ = p_178900_.m_130116_(ChunkBiomeContainer.f_156118_);
        int n = p_178900_.m_130242_();
        if (n > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.f_132227_ = new byte[n];
        p_178900_.readBytes(this.f_132227_);
        this.f_132228_ = p_178900_.m_178366_(FriendlyByteBuf::m_130260_);
    }

    @Override
    public void m_5779_(FriendlyByteBuf p_132249_) {
        p_132249_.writeInt(this.f_132222_);
        p_132249_.writeInt(this.f_132223_);
        p_132249_.m_178350_(this.f_132224_);
        p_132249_.m_130079_(this.f_132225_);
        p_132249_.m_130089_(this.f_132226_);
        p_132249_.m_130130_(this.f_132227_.length);
        p_132249_.writeBytes(this.f_132227_);
        p_132249_.m_178352_(this.f_132228_, FriendlyByteBuf::m_130079_);
    }

    @Override
    public void m_5797_(ClientGamePacketListener p_132246_) {
        p_132246_.m_5623_(this);
    }

    public FriendlyByteBuf m_132247_() {
        return new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])this.f_132227_));
    }

    private ByteBuf m_132257_() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.f_132227_);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    public BitSet m_178903_(FriendlyByteBuf p_178904_, LevelChunk p_178905_) {
        BitSet bitSet = new BitSet();
        LevelChunkSection[] \u00e2\u02dc\u01922 = p_178905_.m_7103_();
        int \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.length;
        for (int i = 0; i < \u00e2\u02dc\u01923; ++i) {
            LevelChunkSection levelChunkSection = \u00e2\u02dc\u01922[i];
            if (levelChunkSection == LevelChunk.f_62770_ || levelChunkSection.m_63013_()) continue;
            bitSet.set(i);
            levelChunkSection.m_63011_(p_178904_);
        }
        return bitSet;
    }

    protected int m_178901_(LevelChunk p_178902_) {
        int n = 0;
        for (LevelChunkSection levelChunkSection : p_178902_.m_7103_()) {
            if (levelChunkSection == LevelChunk.f_62770_ || levelChunkSection.m_63013_()) continue;
            n += levelChunkSection.m_63020_();
        }
        return n;
    }

    public int m_132250_() {
        return this.f_132222_;
    }

    public int m_132251_() {
        return this.f_132223_;
    }

    public BitSet m_178906_() {
        return this.f_132224_;
    }

    public CompoundTag m_132254_() {
        return this.f_132225_;
    }

    public List<CompoundTag> m_132255_() {
        return this.f_132228_;
    }

    public int[] m_132256_() {
        return this.f_132226_;
    }
}

