/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;

public class ClientboundPlayerInfoPacket
implements Packet<ClientGamePacketListener> {
    private final Action f_132717_;
    private final List<PlayerUpdate> f_132718_;

    public ClientboundPlayerInfoPacket(Action p_132724_, ServerPlayer ... p_132725_) {
        this.f_132717_ = p_132724_;
        this.f_132718_ = Lists.newArrayListWithCapacity((int)p_132725_.length);
        for (ServerPlayer serverPlayer : p_132725_) {
            this.f_132718_.add(new PlayerUpdate(serverPlayer.m_36316_(), serverPlayer.f_8943_, serverPlayer.f_8941_.m_9290_(), serverPlayer.m_8957_()));
        }
    }

    public ClientboundPlayerInfoPacket(Action p_179083_, Collection<ServerPlayer> p_179084_) {
        this.f_132717_ = p_179083_;
        this.f_132718_ = Lists.newArrayListWithCapacity((int)p_179084_.size());
        for (ServerPlayer serverPlayer : p_179084_) {
            this.f_132718_.add(new PlayerUpdate(serverPlayer.m_36316_(), serverPlayer.f_8943_, serverPlayer.f_8941_.m_9290_(), serverPlayer.m_8957_()));
        }
    }

    public ClientboundPlayerInfoPacket(FriendlyByteBuf p_179081_) {
        this.f_132717_ = p_179081_.m_130066_(Action.class);
        this.f_132718_ = p_179081_.m_178366_(this.f_132717_::m_142553_);
    }

    @Override
    public void m_5779_(FriendlyByteBuf p_132734_) {
        p_132734_.m_130068_(this.f_132717_);
        p_132734_.m_178352_(this.f_132718_, this.f_132717_::m_142214_);
    }

    @Override
    public void m_5797_(ClientGamePacketListener p_132731_) {
        p_132731_.m_7039_(this);
    }

    public List<PlayerUpdate> m_132732_() {
        return this.f_132718_;
    }

    public Action m_132735_() {
        return this.f_132717_;
    }

    @Nullable
    static Component m_179088_(FriendlyByteBuf p_179089_) {
        return p_179089_.readBoolean() ? p_179089_.m_130238_() : null;
    }

    static void m_179085_(FriendlyByteBuf p_179086_, @Nullable Component p_179087_) {
        if (p_179087_ == null) {
            p_179086_.writeBoolean(false);
        } else {
            p_179086_.writeBoolean(true);
            p_179086_.m_130083_(p_179087_);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.f_132717_).add("entries", this.f_132718_).toString();
    }

    public static abstract class Action
    extends Enum<Action> {
        public static final /* enum */ Action ADD_PLAYER = new Action(){

            @Override
            protected PlayerUpdate m_142553_(FriendlyByteBuf p_179101_) {
                GameProfile gameProfile = new GameProfile(p_179101_.m_130259_(), p_179101_.m_130136_(16));
                PropertyMap \u00e2\u02dc\u01922 = gameProfile.getProperties();
                p_179101_.m_178364_(p_179099_ -> {
                    String string = p_179099_.m_130277_();
                    \u00e2\u02dc\u0192 = p_179099_.m_130277_();
                    if (p_179099_.readBoolean()) {
                        \u00e2\u02dc\u0192 = p_179099_.m_130277_();
                        \u00e2\u02dc\u01922.put((Object)string, (Object)new Property(string, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
                    } else {
                        \u00e2\u02dc\u01922.put((Object)string, (Object)new Property(string, \u00e2\u02dc\u0192));
                    }
                });
                GameType \u00e2\u02dc\u01923 = GameType.m_46393_(p_179101_.m_130242_());
                int \u00e2\u02dc\u01924 = p_179101_.m_130242_();
                Component \u00e2\u02dc\u01925 = ClientboundPlayerInfoPacket.m_179088_(p_179101_);
                return new PlayerUpdate(gameProfile, \u00e2\u02dc\u01924, \u00e2\u02dc\u01923, \u00e2\u02dc\u01925);
            }

            @Override
            protected void m_142214_(FriendlyByteBuf p_179106_, PlayerUpdate p_179107_) {
                p_179106_.m_130077_(p_179107_.m_132763_().getId());
                p_179106_.m_130070_(p_179107_.m_132763_().getName());
                p_179106_.m_178352_(p_179107_.m_132763_().getProperties().values(), (p_179103_, p_179104_) -> {
                    p_179103_.m_130070_(p_179104_.getName());
                    p_179103_.m_130070_(p_179104_.getValue());
                    if (p_179104_.hasSignature()) {
                        p_179103_.writeBoolean(true);
                        p_179103_.m_130070_(p_179104_.getSignature());
                    } else {
                        p_179103_.writeBoolean(false);
                    }
                });
                p_179106_.m_130130_(p_179107_.m_132765_().m_46392_());
                p_179106_.m_130130_(p_179107_.m_132764_());
                ClientboundPlayerInfoPacket.m_179085_(p_179106_, p_179107_.m_132766_());
            }
        };
        public static final /* enum */ Action UPDATE_GAME_MODE = new Action(){

            @Override
            protected PlayerUpdate m_142553_(FriendlyByteBuf p_179112_) {
                GameProfile gameProfile = new GameProfile(p_179112_.m_130259_(), null);
                GameType \u00e2\u02dc\u01922 = GameType.m_46393_(p_179112_.m_130242_());
                return new PlayerUpdate(gameProfile, 0, \u00e2\u02dc\u01922, null);
            }

            @Override
            protected void m_142214_(FriendlyByteBuf p_179114_, PlayerUpdate p_179115_) {
                p_179114_.m_130077_(p_179115_.m_132763_().getId());
                p_179114_.m_130130_(p_179115_.m_132765_().m_46392_());
            }
        };
        public static final /* enum */ Action UPDATE_LATENCY = new Action(){

            @Override
            protected PlayerUpdate m_142553_(FriendlyByteBuf p_179120_) {
                GameProfile gameProfile = new GameProfile(p_179120_.m_130259_(), null);
                int \u00e2\u02dc\u01922 = p_179120_.m_130242_();
                return new PlayerUpdate(gameProfile, \u00e2\u02dc\u01922, null, null);
            }

            @Override
            protected void m_142214_(FriendlyByteBuf p_179122_, PlayerUpdate p_179123_) {
                p_179122_.m_130077_(p_179123_.m_132763_().getId());
                p_179122_.m_130130_(p_179123_.m_132764_());
            }
        };
        public static final /* enum */ Action UPDATE_DISPLAY_NAME = new Action(){

            @Override
            protected PlayerUpdate m_142553_(FriendlyByteBuf p_179128_) {
                GameProfile gameProfile = new GameProfile(p_179128_.m_130259_(), null);
                Component \u00e2\u02dc\u01922 = ClientboundPlayerInfoPacket.m_179088_(p_179128_);
                return new PlayerUpdate(gameProfile, 0, null, \u00e2\u02dc\u01922);
            }

            @Override
            protected void m_142214_(FriendlyByteBuf p_179130_, PlayerUpdate p_179131_) {
                p_179130_.m_130077_(p_179131_.m_132763_().getId());
                ClientboundPlayerInfoPacket.m_179085_(p_179130_, p_179131_.m_132766_());
            }
        };
        public static final /* enum */ Action REMOVE_PLAYER = new Action(){

            @Override
            protected PlayerUpdate m_142553_(FriendlyByteBuf p_179136_) {
                GameProfile gameProfile = new GameProfile(p_179136_.m_130259_(), null);
                return new PlayerUpdate(gameProfile, 0, null, null);
            }

            @Override
            protected void m_142214_(FriendlyByteBuf p_179138_, PlayerUpdate p_179139_) {
                p_179138_.m_130077_(p_179139_.m_132763_().getId());
            }
        };
        private static final /* synthetic */ Action[] $VALUES;

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String p_132750_) {
            return Enum.valueOf(Action.class, p_132750_);
        }

        protected abstract PlayerUpdate m_142553_(FriendlyByteBuf var1);

        protected abstract void m_142214_(FriendlyByteBuf var1, PlayerUpdate var2);

        private static /* synthetic */ Action[] m_179090_() {
            return new Action[]{ADD_PLAYER, UPDATE_GAME_MODE, UPDATE_LATENCY, UPDATE_DISPLAY_NAME, REMOVE_PLAYER};
        }

        static {
            $VALUES = Action.m_179090_();
        }
    }

    public static class PlayerUpdate {
        private final int f_132753_;
        private final GameType f_132754_;
        private final GameProfile f_132755_;
        @Nullable
        private final Component f_132756_;

        public PlayerUpdate(GameProfile p_179141_, int p_179142_, @Nullable GameType p_179143_, @Nullable Component p_179144_) {
            this.f_132755_ = p_179141_;
            this.f_132753_ = p_179142_;
            this.f_132754_ = p_179143_;
            this.f_132756_ = p_179144_;
        }

        public GameProfile m_132763_() {
            return this.f_132755_;
        }

        public int m_132764_() {
            return this.f_132753_;
        }

        public GameType m_132765_() {
            return this.f_132754_;
        }

        @Nullable
        public Component m_132766_() {
            return this.f_132756_;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("latency", this.f_132753_).add("gameMode", (Object)this.f_132754_).add("profile", (Object)this.f_132755_).add("displayName", this.f_132756_ == null ? null : Component.Serializer.m_130703_(this.f_132756_)).toString();
        }
    }
}

