/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.DelegatingOps;
import net.minecraft.resources.RegistryWriteOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryReadOps<T>
extends DelegatingOps<T> {
    static final Logger f_135634_ = LogManager.getLogger();
    private static final String f_179859_ = ".json";
    private final ResourceAccess f_135635_;
    private final RegistryAccess f_179860_;
    private final Map<ResourceKey<? extends Registry<?>>, ReadCache<?>> f_135637_;
    private final RegistryReadOps<JsonElement> f_135638_;

    public static <T> RegistryReadOps<T> m_179866_(DynamicOps<T> p_179867_, ResourceManager p_179868_, RegistryAccess p_179869_) {
        return RegistryReadOps.m_179870_(p_179867_, ResourceAccess.m_135714_(p_179868_), p_179869_);
    }

    public static <T> RegistryReadOps<T> m_179870_(DynamicOps<T> p_179871_, ResourceAccess p_179872_, RegistryAccess p_179873_) {
        RegistryReadOps<T> registryReadOps = new RegistryReadOps<T>(p_179871_, p_179872_, p_179873_, Maps.newIdentityHashMap());
        RegistryAccess.m_175500_(p_179873_, registryReadOps);
        return registryReadOps;
    }

    public static <T> RegistryReadOps<T> m_179882_(DynamicOps<T> p_179883_, ResourceManager p_179884_, RegistryAccess p_179885_) {
        return RegistryReadOps.m_179886_(p_179883_, ResourceAccess.m_135714_(p_179884_), p_179885_);
    }

    public static <T> RegistryReadOps<T> m_179886_(DynamicOps<T> p_179887_, ResourceAccess p_179888_, RegistryAccess p_179889_) {
        return new RegistryReadOps<T>(p_179887_, p_179888_, p_179889_, Maps.newIdentityHashMap());
    }

    private RegistryReadOps(DynamicOps<T> p_179862_, ResourceAccess p_179863_, RegistryAccess p_179864_, IdentityHashMap<ResourceKey<? extends Registry<?>>, ReadCache<?>> p_179865_) {
        super(p_179862_);
        this.f_135635_ = p_179863_;
        this.f_179860_ = p_179864_;
        this.f_135637_ = p_179865_;
        this.f_135638_ = p_179862_ == JsonOps.INSTANCE ? this : new RegistryReadOps<T>(JsonOps.INSTANCE, p_179863_, p_179864_, (IdentityHashMap<ResourceKey<Registry<?>>, ReadCache<?>>)p_179865_);
    }

    protected <E> DataResult<Pair<Supplier<E>, T>> m_135677_(T p_135678_, ResourceKey<? extends Registry<E>> p_135679_, Codec<E> p_135680_, boolean p_135681_) {
        Optional optional = this.f_179860_.m_142664_(p_135679_);
        if (!optional.isPresent()) {
            return DataResult.error((String)("Unknown registry: " + p_135679_));
        }
        WritableRegistry \u00e2\u02dc\u01922 = optional.get();
        DataResult \u00e2\u02dc\u01923 = ResourceLocation.f_135803_.decode(this.f_135465_, p_135678_);
        if (!\u00e2\u02dc\u01923.result().isPresent()) {
            if (!p_135681_) {
                return DataResult.error((String)"Inline definitions not allowed here");
            }
            return p_135680_.decode((DynamicOps)this, p_135678_).map(p_135647_ -> p_135647_.mapFirst(p_179881_ -> () -> p_179881_));
        }
        Pair \u00e2\u02dc\u01924 = (Pair)\u00e2\u02dc\u01923.result().get();
        ResourceLocation \u00e2\u02dc\u01925 = (ResourceLocation)\u00e2\u02dc\u01924.getFirst();
        return this.m_135689_(p_135679_, \u00e2\u02dc\u01922, p_135680_, \u00e2\u02dc\u01925).map(p_135650_ -> Pair.of((Object)p_135650_, (Object)\u00e2\u02dc\u01924.getSecond()));
    }

    public <E> DataResult<MappedRegistry<E>> m_135662_(MappedRegistry<E> p_135663_, ResourceKey<? extends Registry<E>> p_135664_, Codec<E> p_135665_) {
        Collection<ResourceLocation> collection = this.f_135635_.m_7115_(p_135664_);
        DataResult \u00e2\u02dc\u01922 = DataResult.success(p_135663_, (Lifecycle)Lifecycle.stable());
        String \u00e2\u02dc\u01923 = p_135664_.m_135782_().m_135815_() + "/";
        for (ResourceLocation resourceLocation : collection) {
            String string = resourceLocation.m_135815_();
            if (!string.endsWith(f_179859_)) {
                f_135634_.warn("Skipping resource {} since it is not a json file", (Object)resourceLocation);
                continue;
            }
            if (!string.startsWith(\u00e2\u02dc\u01923)) {
                f_135634_.warn("Skipping resource {} since it does not have a registry name prefix", (Object)resourceLocation);
                continue;
            }
            \u00e2\u02dc\u0192 = string.substring(\u00e2\u02dc\u01923.length(), string.length() - f_179859_.length());
            ResourceLocation \u00e2\u02dc\u01924 = new ResourceLocation(resourceLocation.m_135827_(), \u00e2\u02dc\u0192);
            \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.flatMap(p_135688_ -> this.m_135689_(p_135664_, (WritableRegistry)p_135688_, p_135665_, \u00e2\u02dc\u01924).map(p_179876_ -> p_135688_));
        }
        return \u00e2\u02dc\u01922.setPartial(p_135663_);
    }

    private <E> DataResult<Supplier<E>> m_135689_(ResourceKey<? extends Registry<E>> p_135690_, final WritableRegistry<E> p_135691_, Codec<E> p_135692_, ResourceLocation p_135693_) {
        DataResult \u00e2\u02dc\u01927;
        final ResourceKey resourceKey = ResourceKey.m_135785_(p_135690_, p_135693_);
        ReadCache<E> \u00e2\u02dc\u01922 = this.m_135699_(p_135690_);
        DataResult \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.f_135708_.get(resourceKey);
        if (\u00e2\u02dc\u01923 != null) {
            return \u00e2\u02dc\u01923;
        }
        com.google.common.base.Supplier \u00e2\u02dc\u01924 = Suppliers.memoize(() -> {
            Object t = p_135691_.m_6246_(resourceKey);
            if (t == null) {
                throw new RuntimeException("Error during recursive registry parsing, element resolved too early: " + resourceKey);
            }
            return t;
        });
        \u00e2\u02dc\u01922.f_135708_.put(resourceKey, DataResult.success((Object)\u00e2\u02dc\u01924));
        Optional \u00e2\u02dc\u01925 = this.f_135635_.m_142701_((DynamicOps<JsonElement>)this.f_135638_, p_135690_, resourceKey, p_135692_);
        if (!\u00e2\u02dc\u01925.isPresent()) {
            \u00e2\u02dc\u01927 = DataResult.success((Object)new Supplier<E>(){

                @Override
                public E get() {
                    return p_135691_.m_6246_(resourceKey);
                }

                public String toString() {
                    return resourceKey.toString();
                }
            }, (Lifecycle)Lifecycle.stable());
        } else {
            DataResult dataResult = \u00e2\u02dc\u01925.get();
            Optional \u00e2\u02dc\u01926 = dataResult.result();
            if (\u00e2\u02dc\u01926.isPresent()) {
                Pair pair = (Pair)\u00e2\u02dc\u01926.get();
                p_135691_.m_7794_((OptionalInt)pair.getSecond(), resourceKey, pair.getFirst(), dataResult.lifecycle());
            }
            \u00e2\u02dc\u01927 = dataResult.map(p_135674_ -> () -> p_135691_.m_6246_(resourceKey));
        }
        \u00e2\u02dc\u01922.f_135708_.put(resourceKey, \u00e2\u02dc\u01927);
        return \u00e2\u02dc\u01927;
    }

    private <E> ReadCache<E> m_135699_(ResourceKey<? extends Registry<E>> p_135700_) {
        return this.f_135637_.computeIfAbsent(p_135700_, p_135707_ -> new ReadCache());
    }

    protected <E> DataResult<Registry<E>> m_135682_(ResourceKey<? extends Registry<E>> p_135683_) {
        return this.f_179860_.m_142664_(p_135683_).map(p_135667_ -> DataResult.success((Object)p_135667_, (Lifecycle)p_135667_.m_7837_())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + p_135683_)));
    }

    public static interface ResourceAccess {
        public Collection<ResourceLocation> m_7115_(ResourceKey<? extends Registry<?>> var1);

        public <E> Optional<DataResult<Pair<E, OptionalInt>>> m_142701_(DynamicOps<JsonElement> var1, ResourceKey<? extends Registry<E>> var2, ResourceKey<E> var3, Decoder<E> var4);

        public static ResourceAccess m_135714_(final ResourceManager p_135715_) {
            return new ResourceAccess(){

                @Override
                public Collection<ResourceLocation> m_7115_(ResourceKey<? extends Registry<?>> p_135734_) {
                    return p_135715_.m_6540_(p_135734_.m_135782_().m_135815_(), p_135732_ -> p_135732_.endsWith(RegistryReadOps.f_179859_));
                }

                /*
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public <E> Optional<DataResult<Pair<E, OptionalInt>>> m_142701_(DynamicOps<JsonElement> p_179897_, ResourceKey<? extends Registry<E>> p_179898_, ResourceKey<E> p_179899_, Decoder<E> p_179900_) {
                    ResourceLocation resourceLocation = p_179899_.m_135782_();
                    \u00e2\u02dc\u0192 = new ResourceLocation(resourceLocation.m_135827_(), p_179898_.m_135782_().m_135815_() + "/" + resourceLocation.m_135815_() + RegistryReadOps.f_179859_);
                    if (!p_135715_.m_7165_(\u00e2\u02dc\u0192)) {
                        return Optional.empty();
                    }
                    try (Resource resource = p_135715_.m_142591_(\u00e2\u02dc\u0192);){
                        Optional<DataResult<Pair<E, OptionalInt>>> optional;
                        try (InputStreamReader inputStreamReader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);){
                            JsonParser jsonParser = new JsonParser();
                            JsonElement \u00e2\u02dc\u01922 = jsonParser.parse((Reader)inputStreamReader);
                            optional = Optional.of(p_179900_.parse(p_179897_, (Object)\u00e2\u02dc\u01922).map(p_135730_ -> Pair.of((Object)p_135730_, (Object)OptionalInt.empty())));
                        }
                        return optional;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException throwable) {
                        return Optional.of(DataResult.error((String)("Failed to parse " + \u00e2\u02dc\u0192 + " file: " + throwable.getMessage())));
                    }
                }

                public String toString() {
                    return "ResourceAccess[" + p_135715_ + "]";
                }
            };
        }

        public static final class MemoryMap
        implements ResourceAccess {
            private final Map<ResourceKey<?>, JsonElement> f_135736_ = Maps.newIdentityHashMap();
            private final Object2IntMap<ResourceKey<?>> f_135737_ = new Object2IntOpenCustomHashMap(Util.m_137583_());
            private final Map<ResourceKey<?>, Lifecycle> f_135738_ = Maps.newIdentityHashMap();

            public <E> void m_135745_(RegistryAccess.RegistryHolder p_135746_, ResourceKey<E> p_135747_, Encoder<E> p_135748_, int p_135749_, E p_135750_, Lifecycle p_135751_) {
                DataResult dataResult = p_135748_.encodeStart(RegistryWriteOps.m_135767_(JsonOps.INSTANCE, p_135746_), p_135750_);
                Optional \u00e2\u02dc\u01922 = dataResult.error();
                if (\u00e2\u02dc\u01922.isPresent()) {
                    f_135634_.error("Error adding element: {}", (Object)((DataResult.PartialResult)\u00e2\u02dc\u01922.get()).message());
                    return;
                }
                this.f_135736_.put(p_135747_, (JsonElement)dataResult.result().get());
                this.f_135737_.put(p_135747_, p_135749_);
                this.f_135738_.put(p_135747_, p_135751_);
            }

            @Override
            public Collection<ResourceLocation> m_7115_(ResourceKey<? extends Registry<?>> p_135753_) {
                return this.f_135736_.keySet().stream().filter(p_135762_ -> p_135762_.m_135783_(p_135753_)).map(p_135759_ -> new ResourceLocation(p_135759_.m_135782_().m_135827_(), p_135753_.m_135782_().m_135815_() + "/" + p_135759_.m_135782_().m_135815_() + RegistryReadOps.f_179859_)).collect(Collectors.toList());
            }

            @Override
            public <E> Optional<DataResult<Pair<E, OptionalInt>>> m_142701_(DynamicOps<JsonElement> p_179902_, ResourceKey<? extends Registry<E>> p_179903_, ResourceKey<E> p_179904_, Decoder<E> p_179905_) {
                JsonElement jsonElement = this.f_135736_.get(p_179904_);
                if (jsonElement == null) {
                    return Optional.of(DataResult.error((String)("Unknown element: " + p_179904_)));
                }
                return Optional.of(p_179905_.parse(p_179902_, (Object)jsonElement).setLifecycle(this.f_135738_.get(p_179904_)).map(p_135756_ -> Pair.of((Object)p_135756_, (Object)OptionalInt.of(this.f_135737_.getInt((Object)p_179904_)))));
            }
        }
    }

    static final class ReadCache<E> {
        final Map<ResourceKey<E>, DataResult<Supplier<E>>> f_135708_ = Maps.newIdentityHashMap();

        ReadCache() {
        }
    }
}

