/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.PrintStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.locale.Language;
import net.minecraft.server.DebugLoggedPrintStream;
import net.minecraft.server.LoggedPrintStream;
import net.minecraft.tags.StaticTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bootstrap {
    public static final PrintStream f_135866_ = System.out;
    private static volatile boolean f_135867_;
    private static final Logger f_135868_;

    public static void m_135870_() {
        if (f_135867_) {
            return;
        }
        f_135867_ = true;
        if (Registry.f_122897_.m_6566_().isEmpty()) {
            throw new IllegalStateException("Unable to load registries");
        }
        FireBlock.m_53484_();
        ComposterBlock.m_51988_();
        if (EntityType.m_20613_(EntityType.f_20532_) == null) {
            throw new IllegalStateException("Failed loading EntityTypes");
        }
        PotionBrewing.m_43499_();
        EntitySelectorOptions.m_121426_();
        DispenseItemBehavior.m_123402_();
        CauldronInteraction.m_175649_();
        ArgumentTypes.m_121586_();
        StaticTags.m_13282_();
        Bootstrap.m_135890_();
    }

    private static <T> void m_135871_(Iterable<T> p_135872_, Function<T, String> p_135873_, Set<String> p_135874_) {
        Language language = Language.m_128107_();
        p_135872_.forEach(p_135883_ -> {
            String string = (String)p_135873_.apply(p_135883_);
            if (!language.m_6722_(string)) {
                p_135874_.add(string);
            }
        });
    }

    private static void m_135877_(final Set<String> p_135878_) {
        final Language language = Language.m_128107_();
        GameRules.m_46164_(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void m_6889_(GameRules.Key<T> p_135897_, GameRules.Type<T> p_135898_) {
                if (!language.m_6722_(p_135897_.m_46331_())) {
                    p_135878_.add(p_135897_.m_46328_());
                }
            }
        });
    }

    public static Set<String> m_135886_() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Bootstrap.m_135871_(Registry.f_122866_, Attribute::m_22087_, treeSet);
        Bootstrap.m_135871_(Registry.f_122826_, EntityType::m_20675_, treeSet);
        Bootstrap.m_135871_(Registry.f_122823_, MobEffect::m_19481_, treeSet);
        Bootstrap.m_135871_(Registry.f_122827_, Item::m_5524_, treeSet);
        Bootstrap.m_135871_(Registry.f_122825_, Enchantment::m_44704_, treeSet);
        Bootstrap.m_135871_(Registry.f_122824_, Block::m_7705_, treeSet);
        Bootstrap.m_135871_(Registry.f_122832_, p_135885_ -> "stat." + p_135885_.toString().replace(':', '.'), treeSet);
        Bootstrap.m_135877_(treeSet);
        return treeSet;
    }

    public static void m_179912_(Supplier<String> p_179913_) {
        if (!f_135867_) {
            throw Bootstrap.m_179916_(p_179913_);
        }
    }

    private static RuntimeException m_179916_(Supplier<String> p_179917_) {
        try {
            String string = p_179917_.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + string + ")");
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            illegalArgumentException.addSuppressed(exception);
            return illegalArgumentException;
        }
    }

    public static void m_135889_() {
        Bootstrap.m_179912_(() -> "validate");
        if (SharedConstants.f_136183_) {
            Bootstrap.m_135886_().forEach(p_179915_ -> f_135868_.error("Missing translations: {}", p_179915_));
            Commands.m_82138_();
        }
        DefaultAttributes.m_22296_();
    }

    private static void m_135890_() {
        if (f_135868_.isDebugEnabled()) {
            System.setErr(new DebugLoggedPrintStream("STDERR", System.err));
            System.setOut(new DebugLoggedPrintStream("STDOUT", f_135866_));
        } else {
            System.setErr(new LoggedPrintStream("STDERR", System.err));
            System.setOut(new LoggedPrintStream("STDOUT", f_135866_));
        }
    }

    public static void m_135875_(String p_135876_) {
        f_135866_.println(p_135876_);
    }

    static {
        f_135868_ = LogManager.getLogger();
    }
}

