/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerResources;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.LoggerChunkProgressListener;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger f_129670_ = LogManager.getLogger();

    @DontObfuscate
    public static void main(String[] p_129699_) {
        SharedConstants.m_142977_();
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u00e2\u02dc\u01922 = optionParser.accepts("nogui");
        OptionSpecBuilder \u00e2\u02dc\u01923 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u00e2\u02dc\u01924 = optionParser.accepts("demo");
        OptionSpecBuilder \u00e2\u02dc\u01925 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u00e2\u02dc\u01926 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u00e2\u02dc\u01927 = optionParser.accepts("eraseCache");
        OptionSpecBuilder \u00e2\u02dc\u01928 = optionParser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec \u00e2\u02dc\u01929 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019210 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019211 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019212 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019213 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u00e2\u02dc\u019214 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u00e2\u02dc\u019215 = optionParser.nonOptions();
        try {
            Object object;
            OptionSet optionSet = optionParser.parse(p_129699_);
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01929)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            CrashReport.m_127529_();
            Bootstrap.m_135870_();
            Bootstrap.m_135889_();
            Util.m_137584_();
            RegistryAccess.RegistryHolder \u00e2\u02dc\u019216 = RegistryAccess.m_123086_();
            Path \u00e2\u02dc\u019217 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings \u00e2\u02dc\u019218 = new DedicatedServerSettings(\u00e2\u02dc\u019217);
            \u00e2\u02dc\u019218.m_139780_();
            Path \u00e2\u02dc\u019219 = Paths.get("eula.txt", new String[0]);
            Eula \u00e2\u02dc\u019220 = new Eula(\u00e2\u02dc\u019219);
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01923)) {
                f_129670_.info("Initialized '{}' and '{}'", (Object)\u00e2\u02dc\u019217.toAbsolutePath(), (Object)\u00e2\u02dc\u019219.toAbsolutePath());
                return;
            }
            if (!\u00e2\u02dc\u019220.m_135944_()) {
                f_129670_.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File \u00e2\u02dc\u019221 = new File((String)optionSet.valueOf((OptionSpec)\u00e2\u02dc\u019211));
            YggdrasilAuthenticationService \u00e2\u02dc\u019222 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService \u00e2\u02dc\u019223 = \u00e2\u02dc\u019222.createMinecraftSessionService();
            GameProfileRepository \u00e2\u02dc\u019224 = \u00e2\u02dc\u019222.createProfileRepository();
            GameProfileCache \u00e2\u02dc\u019225 = new GameProfileCache(\u00e2\u02dc\u019224, new File(\u00e2\u02dc\u019221, MinecraftServer.f_129742_.getName()));
            String \u00e2\u02dc\u019226 = Optional.ofNullable((String)optionSet.valueOf((OptionSpec)\u00e2\u02dc\u019212)).orElse(\u00e2\u02dc\u019218.m_139777_().f_139741_);
            LevelStorageSource \u00e2\u02dc\u019227 = LevelStorageSource.m_78242_(\u00e2\u02dc\u019221.toPath());
            LevelStorageSource.LevelStorageAccess \u00e2\u02dc\u019228 = \u00e2\u02dc\u019227.m_78260_(\u00e2\u02dc\u019226);
            MinecraftServer.m_129845_(\u00e2\u02dc\u019228);
            LevelSummary \u00e2\u02dc\u019229 = \u00e2\u02dc\u019228.m_78308_();
            if (\u00e2\u02dc\u019229 != null && \u00e2\u02dc\u019229.m_164915_()) {
                f_129670_.info("Loading of worlds with extended height is disabled.");
                return;
            }
            DataPackConfig \u00e2\u02dc\u019230 = \u00e2\u02dc\u019228.m_78309_();
            boolean \u00e2\u02dc\u019231 = optionSet.has((OptionSpec)\u00e2\u02dc\u01928);
            if (\u00e2\u02dc\u019231) {
                f_129670_.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository \u00e2\u02dc\u019232 = new PackRepository(PackType.SERVER_DATA, new ServerPacksSource(), new FolderRepositorySource(\u00e2\u02dc\u019228.m_78283_(LevelResource.f_78180_).toFile(), PackSource.f_10529_));
            DataPackConfig \u00e2\u02dc\u019233 = MinecraftServer.m_129819_(\u00e2\u02dc\u019232, \u00e2\u02dc\u019230 == null ? DataPackConfig.f_45842_ : \u00e2\u02dc\u019230, \u00e2\u02dc\u019231);
            CompletableFuture<ServerResources> \u00e2\u02dc\u019234 = ServerResources.m_180005_(\u00e2\u02dc\u019232.m_10525_(), \u00e2\u02dc\u019216, Commands.CommandSelection.DEDICATED, \u00e2\u02dc\u019218.m_139777_().f_139711_, Util.m_137578_(), Runnable::run);
            try {
                ServerResources serverResources = \u00e2\u02dc\u019234.get();
            }
            catch (Exception exception) {
                f_129670_.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                \u00e2\u02dc\u019232.close();
                return;
            }
            serverResources.m_136179_();
            RegistryReadOps<Tag> registryReadOps = RegistryReadOps.m_179866_(NbtOps.f_128958_, serverResources.m_136178_(), \u00e2\u02dc\u019216);
            \u00e2\u02dc\u019218.m_139777_().m_180927_(\u00e2\u02dc\u019216);
            WorldData \u00e2\u02dc\u019235 = \u00e2\u02dc\u019228.m_78280_(registryReadOps, \u00e2\u02dc\u019233);
            if (\u00e2\u02dc\u019235 == null) {
                if (optionSet.has((OptionSpec)\u00e2\u02dc\u01924)) {
                    object = MinecraftServer.f_129743_;
                    \u00e2\u02dc\u0192 = WorldGenSettings.m_64645_(\u00e2\u02dc\u019216);
                } else {
                    Object object2 = \u00e2\u02dc\u019218.m_139777_();
                    object = new LevelSettings(((DedicatedServerProperties)object2).f_139741_, ((DedicatedServerProperties)object2).f_139740_, ((DedicatedServerProperties)object2).f_139752_, ((DedicatedServerProperties)object2).f_139739_, false, new GameRules(), \u00e2\u02dc\u019233);
                    \u00e2\u02dc\u0192 = optionSet.has((OptionSpec)\u00e2\u02dc\u01925) ? ((DedicatedServerProperties)object2).m_180927_(\u00e2\u02dc\u019216).m_64671_() : ((DedicatedServerProperties)object2).m_180927_(\u00e2\u02dc\u019216);
                }
                \u00e2\u02dc\u019235 = new PrimaryLevelData((LevelSettings)object, (WorldGenSettings)\u00e2\u02dc\u0192, Lifecycle.stable());
            }
            if (optionSet.has((OptionSpec)\u00e2\u02dc\u01926)) {
                Main.m_129674_(\u00e2\u02dc\u019228, DataFixers.m_14512_(), optionSet.has((OptionSpec)\u00e2\u02dc\u01927), () -> true, \u00e2\u02dc\u019235.m_5961_().m_64667_());
            }
            \u00e2\u02dc\u019228.m_78287_(\u00e2\u02dc\u019216, \u00e2\u02dc\u019235);
            object = \u00e2\u02dc\u019235;
            \u00e2\u02dc\u0192 = MinecraftServer.m_129872_(arg_0 -> Main.m_129680_(\u00e2\u02dc\u019216, \u00e2\u02dc\u019228, \u00e2\u02dc\u019232, serverResources, (WorldData)object, \u00e2\u02dc\u019218, \u00e2\u02dc\u019223, \u00e2\u02dc\u019224, \u00e2\u02dc\u019225, optionSet, (OptionSpec)\u00e2\u02dc\u019210, (OptionSpec)\u00e2\u02dc\u019213, (OptionSpec)\u00e2\u02dc\u01924, (OptionSpec)\u00e2\u02dc\u019214, (OptionSpec)\u00e2\u02dc\u01922, (OptionSpec)\u00e2\u02dc\u019215, arg_0));
            object2 = new Thread("Server Shutdown Thread", (DedicatedServer)\u00e2\u02dc\u0192){
                final /* synthetic */ DedicatedServer f_129700_;
                {
                    this.f_129700_ = dedicatedServer;
                    super(p_129702_);
                }

                @Override
                public void run() {
                    this.f_129700_.m_7570_(true);
                }
            };
            ((Thread)object2).setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_129670_));
            Runtime.getRuntime().addShutdownHook((Thread)object2);
        }
        catch (Exception exception) {
            f_129670_.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    private static void m_129674_(LevelStorageSource.LevelStorageAccess p_129675_, DataFixer p_129676_, boolean p_129677_, BooleanSupplier p_129678_, ImmutableSet<ResourceKey<Level>> p_129679_) {
        f_129670_.info("Forcing world upgrade!");
        WorldUpgrader worldUpgrader = new WorldUpgrader(p_129675_, p_129676_, p_129679_, p_129677_);
        Component \u00e2\u02dc\u01922 = null;
        while (!worldUpgrader.m_18829_()) {
            Component component = worldUpgrader.m_18837_();
            if (\u00e2\u02dc\u01922 != component) {
                \u00e2\u02dc\u01922 = component;
                f_129670_.info(worldUpgrader.m_18837_().getString());
            }
            if ((\u00e2\u02dc\u0192 = worldUpgrader.m_18834_()) > 0) {
                int n = worldUpgrader.m_18835_() + worldUpgrader.m_18836_();
                f_129670_.info("{}% completed ({} / {} chunks)...", (Object)Mth.m_14143_((float)n / (float)\u00e2\u02dc\u0192 * 100.0f), (Object)n, (Object)\u00e2\u02dc\u0192);
            }
            if (!p_129678_.getAsBoolean()) {
                worldUpgrader.m_18820_();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ DedicatedServer m_129680_(RegistryAccess.RegistryHolder p_129681_, LevelStorageSource.LevelStorageAccess p_129682_, PackRepository p_129683_, ServerResources p_129684_, WorldData p_129685_, DedicatedServerSettings p_129686_, MinecraftSessionService p_129687_, GameProfileRepository p_129688_, GameProfileCache p_129689_, OptionSet p_129690_, OptionSpec p_129691_, OptionSpec p_129692_, OptionSpec p_129693_, OptionSpec p_129694_, OptionSpec p_129695_, OptionSpec p_129696_, Thread p_129697_) {
        DedicatedServer dedicatedServer = new DedicatedServer(p_129697_, p_129681_, p_129682_, p_129683_, p_129684_, p_129685_, p_129686_, DataFixers.m_14512_(), p_129687_, p_129688_, p_129689_, LoggerChunkProgressListener::new);
        dedicatedServer.m_129981_((String)p_129690_.valueOf(p_129691_));
        dedicatedServer.m_129801_((Integer)p_129690_.valueOf(p_129692_));
        dedicatedServer.m_129975_(p_129690_.has(p_129693_));
        dedicatedServer.m_129948_((String)p_129690_.valueOf(p_129694_));
        boolean bl = \u00e2\u02dc\u0192 = !p_129690_.has(p_129695_) && !p_129690_.valuesOf(p_129696_).contains("nogui");
        if (\u00e2\u02dc\u0192 && !GraphicsEnvironment.isHeadless()) {
            dedicatedServer.m_139667_();
        }
        return dedicatedServer;
    }
}

