/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.GameRules;

public class ServerFunctionManager {
    private static final Component f_179958_ = new TranslatableComponent("commands.debug.function.noRecursion");
    private static final ResourceLocation f_136099_ = new ResourceLocation("tick");
    private static final ResourceLocation f_136100_ = new ResourceLocation("load");
    final MinecraftServer f_136101_;
    @Nullable
    private ExecutionContext f_179959_;
    private List<CommandFunction> f_136105_ = ImmutableList.of();
    private boolean f_136106_;
    private ServerFunctionLibrary f_136107_;

    public ServerFunctionManager(MinecraftServer p_136110_, ServerFunctionLibrary p_136111_) {
        this.f_136101_ = p_136110_;
        this.f_136107_ = p_136111_;
        this.m_136125_(p_136111_);
    }

    public int m_136122_() {
        return this.f_136101_.m_129900_().m_46215_(GameRules.f_46152_);
    }

    public CommandDispatcher<CommandSourceStack> m_136127_() {
        return this.f_136101_.m_129892_().m_82094_();
    }

    public void m_136128_() {
        this.m_136115_(this.f_136105_, f_136099_);
        if (this.f_136106_) {
            this.f_136106_ = false;
            List<CommandFunction> list = this.f_136107_.m_136096_().m_7689_(f_136100_).m_6497_();
            this.m_136115_(list, f_136100_);
        }
    }

    private void m_136115_(Collection<CommandFunction> p_136116_, ResourceLocation p_136117_) {
        this.f_136101_.m_129905_().m_6521_(p_136117_::toString);
        for (CommandFunction commandFunction : p_136116_) {
            this.m_136112_(commandFunction, this.m_136129_());
        }
        this.f_136101_.m_129905_().m_7238_();
    }

    public int m_136112_(CommandFunction p_136113_, CommandSourceStack p_136114_) {
        return this.m_179960_(p_136113_, p_136114_, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int m_179960_(CommandFunction p_179961_, CommandSourceStack p_179962_, @Nullable TraceCallbacks p_179963_) {
        if (this.f_179959_ != null) {
            if (p_179963_ != null) {
                this.f_179959_.m_179975_(f_179958_.getString());
                return 0;
            }
            this.f_179959_.m_179972_(p_179961_, p_179962_);
            return 0;
        }
        try {
            this.f_179959_ = new ExecutionContext(p_179963_);
            int n = this.f_179959_.m_179977_(p_179961_, p_179962_);
            return n;
        }
        finally {
            this.f_179959_ = null;
        }
    }

    public void m_136120_(ServerFunctionLibrary p_136121_) {
        this.f_136107_ = p_136121_;
        this.m_136125_(p_136121_);
    }

    private void m_136125_(ServerFunctionLibrary p_136126_) {
        this.f_136105_ = ImmutableList.copyOf(p_136126_.m_136096_().m_7689_(f_136099_).m_6497_());
        this.f_136106_ = true;
    }

    public CommandSourceStack m_136129_() {
        return this.f_136101_.m_129893_().m_81325_(2).m_81324_();
    }

    public Optional<CommandFunction> m_136118_(ResourceLocation p_136119_) {
        return this.f_136107_.m_136089_(p_136119_);
    }

    public Tag<CommandFunction> m_136123_(ResourceLocation p_136124_) {
        return this.f_136107_.m_136097_(p_136124_);
    }

    public Iterable<ResourceLocation> m_136130_() {
        return this.f_136107_.m_136055_().keySet();
    }

    public Iterable<ResourceLocation> m_136131_() {
        return this.f_136107_.m_136096_().m_13406_();
    }

    public static interface TraceCallbacks {
        public void m_142256_(int var1, String var2);

        public void m_142279_(int var1, String var2, int var3);

        public void m_142255_(int var1, String var2);

        public void m_142147_(int var1, ResourceLocation var2, int var3);
    }

    class ExecutionContext {
        private int f_179965_;
        @Nullable
        private final TraceCallbacks f_179966_;
        private final Deque<QueuedCommand> f_179967_ = Queues.newArrayDeque();
        private final List<QueuedCommand> f_179968_ = Lists.newArrayList();

        ExecutionContext(TraceCallbacks p_179971_) {
            this.f_179966_ = p_179971_;
        }

        void m_179972_(CommandFunction p_179973_, CommandSourceStack p_179974_) {
            int n = ServerFunctionManager.this.m_136122_();
            if (this.f_179967_.size() + this.f_179968_.size() < n) {
                this.f_179968_.add(new QueuedCommand(p_179974_, this.f_179965_, new CommandFunction.FunctionEntry(p_179973_)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int m_179977_(CommandFunction p_179978_, CommandSourceStack p_179979_) {
            int n;
            int n2 = ServerFunctionManager.this.m_136122_();
            n = 0;
            CommandFunction.Entry[] \u00e2\u02dc\u01922 = p_179978_.m_77989_();
            for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.length - 1; \u00e2\u02dc\u0192 >= 0; --\u00e2\u02dc\u0192) {
                this.f_179967_.push(new QueuedCommand(p_179979_, 0, \u00e2\u02dc\u01922[\u00e2\u02dc\u0192]));
            }
            while (!this.f_179967_.isEmpty()) {
                try {
                    QueuedCommand queuedCommand = this.f_179967_.removeFirst();
                    ServerFunctionManager.this.f_136101_.m_129905_().m_6521_(queuedCommand::toString);
                    this.f_179965_ = queuedCommand.f_179980_;
                    queuedCommand.m_179985_(ServerFunctionManager.this, this.f_179967_, n2, this.f_179966_);
                    if (!this.f_179968_.isEmpty()) {
                        Lists.reverse(this.f_179968_).forEach(this.f_179967_::addFirst);
                        this.f_179968_.clear();
                    }
                }
                finally {
                    ServerFunctionManager.this.f_136101_.m_129905_().m_7238_();
                }
                if (++n < n2) continue;
                return n;
            }
            return n;
        }

        public void m_179975_(String p_179976_) {
            if (this.f_179966_ != null) {
                this.f_179966_.m_142255_(this.f_179965_, p_179976_);
            }
        }
    }

    public static class QueuedCommand {
        private final CommandSourceStack f_136133_;
        final int f_179980_;
        private final CommandFunction.Entry f_136134_;

        public QueuedCommand(CommandSourceStack p_179982_, int p_179983_, CommandFunction.Entry p_179984_) {
            this.f_136133_ = p_179982_;
            this.f_179980_ = p_179983_;
            this.f_136134_ = p_179984_;
        }

        public void m_179985_(ServerFunctionManager p_179986_, Deque<QueuedCommand> p_179987_, int p_179988_, @Nullable TraceCallbacks p_179989_) {
            block4: {
                try {
                    this.f_136134_.m_142134_(p_179986_, this.f_136133_, p_179987_, p_179988_, this.f_179980_, p_179989_);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    if (p_179989_ != null) {
                        p_179989_.m_142255_(this.f_179980_, commandSyntaxException.getRawMessage().getString());
                    }
                }
                catch (Exception exception) {
                    if (p_179989_ == null) break block4;
                    p_179989_.m_142255_(this.f_179980_, exception.getMessage());
                }
            }
        }

        public String toString() {
            return this.f_136134_.toString();
        }
    }
}

