/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.IntFunction;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.PredicateManager;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;

public class ExecuteCommand {
    private static final int f_180148_ = 32768;
    private static final Dynamic2CommandExceptionType f_137030_ = new Dynamic2CommandExceptionType((p_137129_, p_137130_) -> new TranslatableComponent("commands.execute.blocks.toobig", p_137129_, p_137130_));
    private static final SimpleCommandExceptionType f_137031_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType f_137032_ = new DynamicCommandExceptionType(p_137127_ -> new TranslatableComponent("commands.execute.conditional.fail_count", p_137127_));
    private static final BinaryOperator<ResultConsumer<CommandSourceStack>> f_137033_ = (p_137045_, p_137046_) -> (p_180160_, p_180161_, p_180162_) -> {
        p_137045_.onCommandComplete(p_180160_, p_180161_, p_180162_);
        p_137046_.onCommandComplete(p_180160_, p_180161_, p_180162_);
    };
    private static final SuggestionProvider<CommandSourceStack> f_137034_ = (p_137062_, p_137063_) -> {
        PredicateManager predicateManager = ((CommandSourceStack)p_137062_.getSource()).m_81377_().m_129899_();
        return SharedSuggestionProvider.m_82926_(predicateManager.m_79232_(), p_137063_);
    };

    public static void m_137042_(CommandDispatcher<CommandSourceStack> p_137043_) {
        LiteralCommandNode literalCommandNode = p_137043_.register((LiteralArgumentBuilder)Commands.m_82127_("execute").requires(p_137197_ -> p_137197_.m_6761_(2)));
        p_137043_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_("execute").requires(p_137103_ -> p_137103_.m_6761_(2))).then(Commands.m_82127_("run").redirect((CommandNode)p_137043_.getRoot()))).then(ExecuteCommand.m_137084_((CommandNode<CommandSourceStack>)literalCommandNode, Commands.m_82127_("if"), true))).then(ExecuteCommand.m_137084_((CommandNode<CommandSourceStack>)literalCommandNode, Commands.m_82127_("unless"), false))).then(Commands.m_82127_("as").then(Commands.m_82129_("targets", EntityArgument.m_91460_()).fork((CommandNode)literalCommandNode, p_137299_ -> {
            ArrayList arrayList = Lists.newArrayList();
            for (Entity entity : EntityArgument.m_91467_((CommandContext<CommandSourceStack>)p_137299_, "targets")) {
                arrayList.add(((CommandSourceStack)p_137299_.getSource()).m_81329_(entity));
            }
            return arrayList;
        })))).then(Commands.m_82127_("at").then(Commands.m_82129_("targets", EntityArgument.m_91460_()).fork((CommandNode)literalCommandNode, p_137297_ -> {
            ArrayList arrayList = Lists.newArrayList();
            for (Entity entity : EntityArgument.m_91467_((CommandContext<CommandSourceStack>)p_137297_, "targets")) {
                arrayList.add(((CommandSourceStack)p_137297_.getSource()).m_81327_((ServerLevel)entity.f_19853_).m_81348_(entity.m_20182_()).m_81346_(entity.m_20155_()));
            }
            return arrayList;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_("store").then(ExecuteCommand.m_137093_((LiteralCommandNode<CommandSourceStack>)literalCommandNode, Commands.m_82127_("result"), true))).then(ExecuteCommand.m_137093_((LiteralCommandNode<CommandSourceStack>)literalCommandNode, Commands.m_82127_("success"), false)))).then(((LiteralArgumentBuilder)Commands.m_82127_("positioned").then(Commands.m_82129_("pos", Vec3Argument.m_120841_()).redirect((CommandNode)literalCommandNode, p_137295_ -> ((CommandSourceStack)p_137295_.getSource()).m_81348_(Vec3Argument.m_120844_((CommandContext<CommandSourceStack>)p_137295_, "pos")).m_81350_(EntityAnchorArgument.Anchor.FEET)))).then(Commands.m_82127_("as").then(Commands.m_82129_("targets", EntityArgument.m_91460_()).fork((CommandNode)literalCommandNode, p_137293_ -> {
            ArrayList arrayList = Lists.newArrayList();
            for (Entity entity : EntityArgument.m_91467_((CommandContext<CommandSourceStack>)p_137293_, "targets")) {
                arrayList.add(((CommandSourceStack)p_137293_.getSource()).m_81348_(entity.m_20182_()));
            }
            return arrayList;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_("rotated").then(Commands.m_82129_("rot", RotationArgument.m_120479_()).redirect((CommandNode)literalCommandNode, p_137291_ -> ((CommandSourceStack)p_137291_.getSource()).m_81346_(RotationArgument.m_120482_((CommandContext<CommandSourceStack>)p_137291_, "rot").m_6970_((CommandSourceStack)p_137291_.getSource()))))).then(Commands.m_82127_("as").then(Commands.m_82129_("targets", EntityArgument.m_91460_()).fork((CommandNode)literalCommandNode, p_137289_ -> {
            ArrayList arrayList = Lists.newArrayList();
            for (Entity entity : EntityArgument.m_91467_((CommandContext<CommandSourceStack>)p_137289_, "targets")) {
                arrayList.add(((CommandSourceStack)p_137289_.getSource()).m_81346_(entity.m_20155_()));
            }
            return arrayList;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_("facing").then(Commands.m_82127_("entity").then(Commands.m_82129_("targets", EntityArgument.m_91460_()).then(Commands.m_82129_("anchor", EntityAnchorArgument.m_90350_()).fork((CommandNode)literalCommandNode, p_137287_ -> {
            ArrayList arrayList = Lists.newArrayList();
            EntityAnchorArgument.Anchor \u00e2\u02dc\u01922 = EntityAnchorArgument.m_90353_((CommandContext<CommandSourceStack>)p_137287_, "anchor");
            for (Entity entity : EntityArgument.m_91467_((CommandContext<CommandSourceStack>)p_137287_, "targets")) {
                arrayList.add(((CommandSourceStack)p_137287_.getSource()).m_81331_(entity, \u00e2\u02dc\u01922));
            }
            return arrayList;
        }))))).then(Commands.m_82129_("pos", Vec3Argument.m_120841_()).redirect((CommandNode)literalCommandNode, p_137285_ -> ((CommandSourceStack)p_137285_.getSource()).m_81364_(Vec3Argument.m_120844_((CommandContext<CommandSourceStack>)p_137285_, "pos")))))).then(Commands.m_82127_("align").then(Commands.m_82129_("axes", SwizzleArgument.m_120807_()).redirect((CommandNode)literalCommandNode, p_137283_ -> ((CommandSourceStack)p_137283_.getSource()).m_81348_(((CommandSourceStack)p_137283_.getSource()).m_81371_().m_82517_(SwizzleArgument.m_120810_((CommandContext<CommandSourceStack>)p_137283_, "axes"))))))).then(Commands.m_82127_("anchored").then(Commands.m_82129_("anchor", EntityAnchorArgument.m_90350_()).redirect((CommandNode)literalCommandNode, p_137281_ -> ((CommandSourceStack)p_137281_.getSource()).m_81350_(EntityAnchorArgument.m_90353_((CommandContext<CommandSourceStack>)p_137281_, "anchor")))))).then(Commands.m_82127_("in").then(Commands.m_82129_("dimension", DimensionArgument.m_88805_()).redirect((CommandNode)literalCommandNode, p_137279_ -> ((CommandSourceStack)p_137279_.getSource()).m_81327_(DimensionArgument.m_88808_((CommandContext<CommandSourceStack>)p_137279_, "dimension"))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> m_137093_(LiteralCommandNode<CommandSourceStack> p_137094_, LiteralArgumentBuilder<CommandSourceStack> p_137095_, boolean p_137096_) {
        p_137095_.then(Commands.m_82127_("score").then(Commands.m_82129_("targets", ScoreHolderArgument.m_108239_()).suggests(ScoreHolderArgument.f_108210_).then(Commands.m_82129_("objective", ObjectiveArgument.m_101957_()).redirect(p_137094_, p_137271_ -> ExecuteCommand.m_137107_((CommandSourceStack)p_137271_.getSource(), ScoreHolderArgument.m_108246_((CommandContext<CommandSourceStack>)p_137271_, "targets"), ObjectiveArgument.m_101960_((CommandContext<CommandSourceStack>)p_137271_, "objective"), p_137096_)))));
        p_137095_.then(Commands.m_82127_("bossbar").then(((RequiredArgumentBuilder)Commands.m_82129_("id", ResourceLocationArgument.m_106984_()).suggests(BossBarCommands.f_136570_).then(Commands.m_82127_("value").redirect(p_137094_, p_137259_ -> ExecuteCommand.m_137112_((CommandSourceStack)p_137259_.getSource(), BossBarCommands.m_136584_((CommandContext<CommandSourceStack>)p_137259_), true, p_137096_)))).then(Commands.m_82127_("max").redirect(p_137094_, p_137247_ -> ExecuteCommand.m_137112_((CommandSourceStack)p_137247_.getSource(), BossBarCommands.m_136584_((CommandContext<CommandSourceStack>)p_137247_), false, p_137096_)))));
        for (DataCommands.DataProvider dataProvider : DataCommands.f_139350_) {
            dataProvider.m_7621_((ArgumentBuilder<CommandSourceStack, ?>)p_137095_, p_137101_ -> p_137101_.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_("path", NbtPathArgument.m_99487_()).then(Commands.m_82127_("int").then(Commands.m_82129_("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)p_137094_, p_180216_ -> ExecuteCommand.m_137117_((CommandSourceStack)p_180216_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_180216_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_180216_, "path"), p_180219_ -> IntTag.m_128679_((int)((double)p_180219_ * DoubleArgumentType.getDouble((CommandContext)p_180216_, (String)"scale"))), p_137096_))))).then(Commands.m_82127_("float").then(Commands.m_82129_("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)p_137094_, p_180209_ -> ExecuteCommand.m_137117_((CommandSourceStack)p_180209_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_180209_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_180209_, "path"), p_180212_ -> FloatTag.m_128566_((float)((double)p_180212_ * DoubleArgumentType.getDouble((CommandContext)p_180209_, (String)"scale"))), p_137096_))))).then(Commands.m_82127_("short").then(Commands.m_82129_("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)p_137094_, p_180199_ -> ExecuteCommand.m_137117_((CommandSourceStack)p_180199_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_180199_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_180199_, "path"), p_180202_ -> ShortTag.m_129258_((short)((double)p_180202_ * DoubleArgumentType.getDouble((CommandContext)p_180199_, (String)"scale"))), p_137096_))))).then(Commands.m_82127_("long").then(Commands.m_82129_("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)p_137094_, p_180189_ -> ExecuteCommand.m_137117_((CommandSourceStack)p_180189_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_180189_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_180189_, "path"), p_180192_ -> LongTag.m_128882_((long)((double)p_180192_ * DoubleArgumentType.getDouble((CommandContext)p_180189_, (String)"scale"))), p_137096_))))).then(Commands.m_82127_("double").then(Commands.m_82129_("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)p_137094_, p_180179_ -> ExecuteCommand.m_137117_((CommandSourceStack)p_180179_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_180179_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_180179_, "path"), p_180182_ -> DoubleTag.m_128500_((double)p_180182_ * DoubleArgumentType.getDouble((CommandContext)p_180179_, (String)"scale")), p_137096_))))).then(Commands.m_82127_("byte").then(Commands.m_82129_("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)p_137094_, p_180156_ -> ExecuteCommand.m_137117_((CommandSourceStack)p_180156_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_180156_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_180156_, "path"), p_180165_ -> ByteTag.m_128266_((byte)((double)p_180165_ * DoubleArgumentType.getDouble((CommandContext)p_180156_, (String)"scale"))), p_137096_))))));
        }
        return p_137095_;
    }

    private static CommandSourceStack m_137107_(CommandSourceStack p_137108_, Collection<String> p_137109_, Objective p_137110_, boolean p_137111_) {
        ServerScoreboard serverScoreboard = p_137108_.m_81377_().m_129896_();
        return p_137108_.m_81336_((ResultConsumer<CommandSourceStack>)((ResultConsumer)(p_137136_, p_137137_, p_137138_) -> {
            for (String string : p_137109_) {
                Score score = serverScoreboard.m_83471_(string, p_137110_);
                int \u00e2\u02dc\u01922 = p_137111_ ? p_137138_ : (p_137137_ ? 1 : 0);
                score.m_83402_(\u00e2\u02dc\u01922);
            }
        }), f_137033_);
    }

    private static CommandSourceStack m_137112_(CommandSourceStack p_137113_, CustomBossEvent p_137114_, boolean p_137115_, boolean p_137116_) {
        return p_137113_.m_81336_((ResultConsumer<CommandSourceStack>)((ResultConsumer)(p_137185_, p_137186_, p_137187_) -> {
            int n;
            int n2 = p_137116_ ? p_137187_ : (n = p_137186_ ? 1 : 0);
            if (p_137115_) {
                p_137114_.m_136264_(n);
            } else {
                p_137114_.m_136278_(n);
            }
        }), f_137033_);
    }

    private static CommandSourceStack m_137117_(CommandSourceStack p_137118_, DataAccessor p_137119_, NbtPathArgument.NbtPath p_137120_, IntFunction<Tag> p_137121_, boolean p_137122_) {
        return p_137118_.m_81336_((ResultConsumer<CommandSourceStack>)((ResultConsumer)(p_137153_, p_137154_, p_137155_) -> {
            try {
                CompoundTag compoundTag = p_137119_.m_6184_();
                int \u00e2\u02dc\u01922 = p_137122_ ? p_137155_ : (p_137154_ ? 1 : 0);
                p_137120_.m_99645_(compoundTag, () -> (Tag)p_137121_.apply(\u00e2\u02dc\u01922));
                p_137119_.m_7603_(compoundTag);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }), f_137033_);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> m_137084_(CommandNode<CommandSourceStack> p_137085_, LiteralArgumentBuilder<CommandSourceStack> p_137086_, boolean p_137087_) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)p_137086_.then(Commands.m_82127_("block").then(Commands.m_82129_("pos", BlockPosArgument.m_118239_()).then(ExecuteCommand.m_137074_(p_137085_, Commands.m_82129_("block", BlockPredicateArgument.m_115570_()), p_137087_, p_137277_ -> BlockPredicateArgument.m_115573_((CommandContext<CommandSourceStack>)p_137277_, "block").test(new BlockInWorld(((CommandSourceStack)p_137277_.getSource()).m_81372_(), BlockPosArgument.m_118242_((CommandContext<CommandSourceStack>)p_137277_, "pos"), true))))))).then(Commands.m_82127_("score").then(Commands.m_82129_("target", ScoreHolderArgument.m_108217_()).suggests(ScoreHolderArgument.f_108210_).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_("targetObjective", ObjectiveArgument.m_101957_()).then(Commands.m_82127_("=").then(Commands.m_82129_("source", ScoreHolderArgument.m_108217_()).suggests(ScoreHolderArgument.f_108210_).then(ExecuteCommand.m_137074_(p_137085_, Commands.m_82129_("sourceObjective", ObjectiveArgument.m_101957_()), p_137087_, p_137275_ -> ExecuteCommand.m_137064_((CommandContext<CommandSourceStack>)p_137275_, Integer::equals)))))).then(Commands.m_82127_("<").then(Commands.m_82129_("source", ScoreHolderArgument.m_108217_()).suggests(ScoreHolderArgument.f_108210_).then(ExecuteCommand.m_137074_(p_137085_, Commands.m_82129_("sourceObjective", ObjectiveArgument.m_101957_()), p_137087_, p_137273_ -> ExecuteCommand.m_137064_((CommandContext<CommandSourceStack>)p_137273_, (p_180204_, p_180205_) -> p_180204_ < p_180205_)))))).then(Commands.m_82127_("<=").then(Commands.m_82129_("source", ScoreHolderArgument.m_108217_()).suggests(ScoreHolderArgument.f_108210_).then(ExecuteCommand.m_137074_(p_137085_, Commands.m_82129_("sourceObjective", ObjectiveArgument.m_101957_()), p_137087_, p_137261_ -> ExecuteCommand.m_137064_((CommandContext<CommandSourceStack>)p_137261_, (p_180194_, p_180195_) -> p_180194_ <= p_180195_)))))).then(Commands.m_82127_(">").then(Commands.m_82129_("source", ScoreHolderArgument.m_108217_()).suggests(ScoreHolderArgument.f_108210_).then(ExecuteCommand.m_137074_(p_137085_, Commands.m_82129_("sourceObjective", ObjectiveArgument.m_101957_()), p_137087_, p_137249_ -> ExecuteCommand.m_137064_((CommandContext<CommandSourceStack>)p_137249_, (p_180184_, p_180185_) -> p_180184_ > p_180185_)))))).then(Commands.m_82127_(">=").then(Commands.m_82129_("source", ScoreHolderArgument.m_108217_()).suggests(ScoreHolderArgument.f_108210_).then(ExecuteCommand.m_137074_(p_137085_, Commands.m_82129_("sourceObjective", ObjectiveArgument.m_101957_()), p_137087_, p_137234_ -> ExecuteCommand.m_137064_((CommandContext<CommandSourceStack>)p_137234_, (p_180167_, p_180168_) -> p_180167_ >= p_180168_)))))).then(Commands.m_82127_("matches").then(ExecuteCommand.m_137074_(p_137085_, Commands.m_82129_("range", RangeArgument.m_105404_()), p_137087_, p_137216_ -> ExecuteCommand.m_137058_((CommandContext<CommandSourceStack>)p_137216_, RangeArgument.Ints.m_105419_((CommandContext<CommandSourceStack>)p_137216_, "range"))))))))).then(Commands.m_82127_("blocks").then(Commands.m_82129_("start", BlockPosArgument.m_118239_()).then(Commands.m_82129_("end", BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_("destination", BlockPosArgument.m_118239_()).then(ExecuteCommand.m_137079_(p_137085_, Commands.m_82127_("all"), p_137087_, false))).then(ExecuteCommand.m_137079_(p_137085_, Commands.m_82127_("masked"), p_137087_, true))))))).then(Commands.m_82127_("entity").then(((RequiredArgumentBuilder)Commands.m_82129_("entities", EntityArgument.m_91460_()).fork(p_137085_, p_137232_ -> ExecuteCommand.m_137070_((CommandContext<CommandSourceStack>)p_137232_, p_137087_, !EntityArgument.m_91467_((CommandContext<CommandSourceStack>)p_137232_, "entities").isEmpty()))).executes(ExecuteCommand.m_137166_(p_137087_, p_137189_ -> EntityArgument.m_91467_((CommandContext<CommandSourceStack>)p_137189_, "entities").size()))))).then(Commands.m_82127_("predicate").then(ExecuteCommand.m_137074_(p_137085_, Commands.m_82129_("predicate", ResourceLocationArgument.m_106984_()).suggests(f_137034_), p_137087_, p_137054_ -> ExecuteCommand.m_137104_((CommandSourceStack)p_137054_.getSource(), ResourceLocationArgument.m_107001_((CommandContext<CommandSourceStack>)p_137054_, "predicate")))));
        for (DataCommands.DataProvider dataProvider : DataCommands.f_139351_) {
            p_137086_.then(dataProvider.m_7621_((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_("data"), p_137092_ -> p_137092_.then(((RequiredArgumentBuilder)Commands.m_82129_("path", NbtPathArgument.m_99487_()).fork(p_137085_, p_180175_ -> ExecuteCommand.m_137070_((CommandContext<CommandSourceStack>)p_180175_, p_137087_, ExecuteCommand.m_137145_(dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_180175_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_180175_, "path")) > 0))).executes(ExecuteCommand.m_137166_(p_137087_, p_180152_ -> ExecuteCommand.m_137145_(dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_180152_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_180152_, "path")))))));
        }
        return p_137086_;
    }

    private static Command<CommandSourceStack> m_137166_(boolean p_137167_, CommandNumericPredicate p_137168_) {
        if (p_137167_) {
            return p_137203_ -> {
                int n = p_137168_.m_137300_((CommandContext<CommandSourceStack>)p_137203_);
                if (n > 0) {
                    ((CommandSourceStack)p_137203_.getSource()).m_81354_(new TranslatableComponent("commands.execute.conditional.pass_count", n), false);
                    return n;
                }
                throw f_137031_.create();
            };
        }
        return p_137144_ -> {
            int n = p_137168_.m_137300_((CommandContext<CommandSourceStack>)p_137144_);
            if (n == 0) {
                ((CommandSourceStack)p_137144_.getSource()).m_81354_(new TranslatableComponent("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw f_137032_.create((Object)n);
        };
    }

    private static int m_137145_(DataAccessor p_137146_, NbtPathArgument.NbtPath p_137147_) throws CommandSyntaxException {
        return p_137147_.m_99643_(p_137146_.m_6184_());
    }

    private static boolean m_137064_(CommandContext<CommandSourceStack> p_137065_, BiPredicate<Integer, Integer> p_137066_) throws CommandSyntaxException {
        String string = ScoreHolderArgument.m_108223_(p_137065_, "target");
        Objective \u00e2\u02dc\u01922 = ObjectiveArgument.m_101960_(p_137065_, "targetObjective");
        \u00e2\u02dc\u0192 = ScoreHolderArgument.m_108223_(p_137065_, "source");
        Objective \u00e2\u02dc\u01923 = ObjectiveArgument.m_101960_(p_137065_, "sourceObjective");
        ServerScoreboard \u00e2\u02dc\u01924 = ((CommandSourceStack)p_137065_.getSource()).m_81377_().m_129896_();
        if (!\u00e2\u02dc\u01924.m_83461_(string, \u00e2\u02dc\u01922) || !\u00e2\u02dc\u01924.m_83461_(\u00e2\u02dc\u0192, \u00e2\u02dc\u01923)) {
            return false;
        }
        Score \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_83471_(string, \u00e2\u02dc\u01922);
        Score \u00e2\u02dc\u01926 = \u00e2\u02dc\u01924.m_83471_(\u00e2\u02dc\u0192, \u00e2\u02dc\u01923);
        return p_137066_.test(\u00e2\u02dc\u01925.m_83400_(), \u00e2\u02dc\u01926.m_83400_());
    }

    private static boolean m_137058_(CommandContext<CommandSourceStack> p_137059_, MinMaxBounds.Ints p_137060_) throws CommandSyntaxException {
        String string = ScoreHolderArgument.m_108223_(p_137059_, "target");
        Objective \u00e2\u02dc\u01922 = ObjectiveArgument.m_101960_(p_137059_, "targetObjective");
        ServerScoreboard \u00e2\u02dc\u01923 = ((CommandSourceStack)p_137059_.getSource()).m_81377_().m_129896_();
        if (!\u00e2\u02dc\u01923.m_83461_(string, \u00e2\u02dc\u01922)) {
            return false;
        }
        return p_137060_.m_55390_(\u00e2\u02dc\u01923.m_83471_(string, \u00e2\u02dc\u01922).m_83400_());
    }

    private static boolean m_137104_(CommandSourceStack p_137105_, LootItemCondition p_137106_) {
        ServerLevel serverLevel = p_137105_.m_81372_();
        LootContext.Builder \u00e2\u02dc\u01922 = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, p_137105_.m_81371_()).m_78984_(LootContextParams.f_81455_, p_137105_.m_81373_());
        return p_137106_.test(\u00e2\u02dc\u01922.m_78975_(LootContextParamSets.f_81412_));
    }

    private static Collection<CommandSourceStack> m_137070_(CommandContext<CommandSourceStack> p_137071_, boolean p_137072_, boolean p_137073_) {
        if (p_137073_ == p_137072_) {
            return Collections.singleton((CommandSourceStack)p_137071_.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandSourceStack, ?> m_137074_(CommandNode<CommandSourceStack> p_137075_, ArgumentBuilder<CommandSourceStack, ?> p_137076_, boolean p_137077_, CommandPredicate p_137078_) {
        return p_137076_.fork(p_137075_, p_137214_ -> ExecuteCommand.m_137070_((CommandContext<CommandSourceStack>)p_137214_, p_137077_, p_137078_.m_137302_((CommandContext<CommandSourceStack>)p_137214_))).executes(p_137172_ -> {
            if (p_137077_ == p_137078_.m_137302_((CommandContext<CommandSourceStack>)p_137172_)) {
                ((CommandSourceStack)p_137172_.getSource()).m_81354_(new TranslatableComponent("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw f_137031_.create();
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> m_137079_(CommandNode<CommandSourceStack> p_137080_, ArgumentBuilder<CommandSourceStack, ?> p_137081_, boolean p_137082_, boolean p_137083_) {
        return p_137081_.fork(p_137080_, p_137180_ -> ExecuteCommand.m_137070_((CommandContext<CommandSourceStack>)p_137180_, p_137082_, ExecuteCommand.m_137220_((CommandContext<CommandSourceStack>)p_137180_, p_137083_).isPresent())).executes(p_137082_ ? p_137210_ -> ExecuteCommand.m_137067_((CommandContext<CommandSourceStack>)p_137210_, p_137083_) : p_137165_ -> ExecuteCommand.m_137193_((CommandContext<CommandSourceStack>)p_137165_, p_137083_));
    }

    private static int m_137067_(CommandContext<CommandSourceStack> p_137068_, boolean p_137069_) throws CommandSyntaxException {
        OptionalInt optionalInt = ExecuteCommand.m_137220_(p_137068_, p_137069_);
        if (optionalInt.isPresent()) {
            ((CommandSourceStack)p_137068_.getSource()).m_81354_(new TranslatableComponent("commands.execute.conditional.pass_count", optionalInt.getAsInt()), false);
            return optionalInt.getAsInt();
        }
        throw f_137031_.create();
    }

    private static int m_137193_(CommandContext<CommandSourceStack> p_137194_, boolean p_137195_) throws CommandSyntaxException {
        OptionalInt optionalInt = ExecuteCommand.m_137220_(p_137194_, p_137195_);
        if (optionalInt.isPresent()) {
            throw f_137032_.create((Object)optionalInt.getAsInt());
        }
        ((CommandSourceStack)p_137194_.getSource()).m_81354_(new TranslatableComponent("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt m_137220_(CommandContext<CommandSourceStack> p_137221_, boolean p_137222_) throws CommandSyntaxException {
        return ExecuteCommand.m_137036_(((CommandSourceStack)p_137221_.getSource()).m_81372_(), BlockPosArgument.m_118242_(p_137221_, "start"), BlockPosArgument.m_118242_(p_137221_, "end"), BlockPosArgument.m_118242_(p_137221_, "destination"), p_137222_);
    }

    private static OptionalInt m_137036_(ServerLevel p_137037_, BlockPos p_137038_, BlockPos p_137039_, BlockPos p_137040_, boolean p_137041_) throws CommandSyntaxException {
        BoundingBox boundingBox = BoundingBox.m_162375_(p_137038_, p_137039_);
        \u00e2\u02dc\u0192 = BoundingBox.m_162375_(p_137040_, p_137040_.m_141952_(boundingBox.m_71053_()));
        BlockPos \u00e2\u02dc\u01922 = new BlockPos(\u00e2\u02dc\u0192.m_162395_() - boundingBox.m_162395_(), \u00e2\u02dc\u0192.m_162396_() - boundingBox.m_162396_(), \u00e2\u02dc\u0192.m_162398_() - boundingBox.m_162398_());
        int \u00e2\u02dc\u01923 = boundingBox.m_71056_() * boundingBox.m_71057_() * boundingBox.m_71058_();
        if (\u00e2\u02dc\u01923 > 32768) {
            throw f_137030_.create((Object)32768, (Object)\u00e2\u02dc\u01923);
        }
        int \u00e2\u02dc\u01924 = 0;
        for (int i = boundingBox.m_162398_(); i <= boundingBox.m_162401_(); ++i) {
            for (\u00e2\u02dc\u0192 = boundingBox.m_162396_(); \u00e2\u02dc\u0192 <= boundingBox.m_162400_(); ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = boundingBox.m_162395_(); \u00e2\u02dc\u0192 <= boundingBox.m_162399_(); ++\u00e2\u02dc\u0192) {
                    BlockPos blockPos = new BlockPos(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, i);
                    \u00e2\u02dc\u0192 = blockPos.m_141952_(\u00e2\u02dc\u01922);
                    BlockState \u00e2\u02dc\u01925 = p_137037_.m_8055_(blockPos);
                    if (p_137041_ && \u00e2\u02dc\u01925.m_60713_(Blocks.f_50016_)) continue;
                    if (\u00e2\u02dc\u01925 != p_137037_.m_8055_(\u00e2\u02dc\u0192)) {
                        return OptionalInt.empty();
                    }
                    BlockEntity \u00e2\u02dc\u01926 = p_137037_.m_7702_(blockPos);
                    BlockEntity \u00e2\u02dc\u01927 = p_137037_.m_7702_(\u00e2\u02dc\u0192);
                    if (\u00e2\u02dc\u01926 != null) {
                        if (\u00e2\u02dc\u01927 == null) {
                            return OptionalInt.empty();
                        }
                        CompoundTag compoundTag = \u00e2\u02dc\u01926.m_6945_(new CompoundTag());
                        compoundTag.m_128473_("x");
                        compoundTag.m_128473_("y");
                        compoundTag.m_128473_("z");
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01927.m_6945_(new CompoundTag());
                        \u00e2\u02dc\u0192.m_128473_("x");
                        \u00e2\u02dc\u0192.m_128473_("y");
                        \u00e2\u02dc\u0192.m_128473_("z");
                        if (!compoundTag.equals(\u00e2\u02dc\u0192)) {
                            return OptionalInt.empty();
                        }
                    }
                    ++\u00e2\u02dc\u01924;
                }
            }
        }
        return OptionalInt.of(\u00e2\u02dc\u01924);
    }

    @FunctionalInterface
    static interface CommandPredicate {
        public boolean m_137302_(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface CommandNumericPredicate {
        public int m_137300_(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }
}

