/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.base.Joiner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ForceLoadCommand {
    private static final int f_180227_ = 256;
    private static final Dynamic2CommandExceptionType f_137668_ = new Dynamic2CommandExceptionType((p_137698_, p_137699_) -> new TranslatableComponent("commands.forceload.toobig", p_137698_, p_137699_));
    private static final Dynamic2CommandExceptionType f_137669_ = new Dynamic2CommandExceptionType((p_137691_, p_137692_) -> new TranslatableComponent("commands.forceload.query.failure", p_137691_, p_137692_));
    private static final SimpleCommandExceptionType f_137670_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.forceload.added.failure"));
    private static final SimpleCommandExceptionType f_137671_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.forceload.removed.failure"));

    public static void m_137676_(CommandDispatcher<CommandSourceStack> p_137677_) {
        p_137677_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_("forceload").requires(p_137703_ -> p_137703_.m_6761_(2))).then(Commands.m_82127_("add").then(((RequiredArgumentBuilder)Commands.m_82129_("from", ColumnPosArgument.m_118989_()).executes(p_137711_ -> ForceLoadCommand.m_137685_((CommandSourceStack)p_137711_.getSource(), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137711_, "from"), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137711_, "from"), true))).then(Commands.m_82129_("to", ColumnPosArgument.m_118989_()).executes(p_137709_ -> ForceLoadCommand.m_137685_((CommandSourceStack)p_137709_.getSource(), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137709_, "from"), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137709_, "to"), true)))))).then(((LiteralArgumentBuilder)Commands.m_82127_("remove").then(((RequiredArgumentBuilder)Commands.m_82129_("from", ColumnPosArgument.m_118989_()).executes(p_137707_ -> ForceLoadCommand.m_137685_((CommandSourceStack)p_137707_.getSource(), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137707_, "from"), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137707_, "from"), false))).then(Commands.m_82129_("to", ColumnPosArgument.m_118989_()).executes(p_137705_ -> ForceLoadCommand.m_137685_((CommandSourceStack)p_137705_.getSource(), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137705_, "from"), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137705_, "to"), false))))).then(Commands.m_82127_("all").executes(p_137701_ -> ForceLoadCommand.m_137695_((CommandSourceStack)p_137701_.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_("query").executes(p_137694_ -> ForceLoadCommand.m_137680_((CommandSourceStack)p_137694_.getSource()))).then(Commands.m_82129_("pos", ColumnPosArgument.m_118989_()).executes(p_137679_ -> ForceLoadCommand.m_137682_((CommandSourceStack)p_137679_.getSource(), ColumnPosArgument.m_118992_((CommandContext<CommandSourceStack>)p_137679_, "pos"))))));
    }

    private static int m_137682_(CommandSourceStack p_137683_, ColumnPos p_137684_) throws CommandSyntaxException {
        ChunkPos chunkPos = new ChunkPos(SectionPos.m_123171_(p_137684_.f_140723_), SectionPos.m_123171_(p_137684_.f_140724_));
        ServerLevel \u00e2\u02dc\u01922 = p_137683_.m_81372_();
        ResourceKey<Level> \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_46472_();
        boolean \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.m_8902_().contains(chunkPos.m_45588_());
        if (\u00e2\u02dc\u01924) {
            p_137683_.m_81354_(new TranslatableComponent("commands.forceload.query.success", chunkPos, \u00e2\u02dc\u01923.m_135782_()), false);
            return 1;
        }
        throw f_137669_.create((Object)chunkPos, (Object)\u00e2\u02dc\u01923.m_135782_());
    }

    private static int m_137680_(CommandSourceStack p_137681_) {
        ServerLevel serverLevel = p_137681_.m_81372_();
        ResourceKey<Level> \u00e2\u02dc\u01922 = serverLevel.m_46472_();
        LongSet \u00e2\u02dc\u01923 = serverLevel.m_8902_();
        int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.size();
        if (\u00e2\u02dc\u01924 > 0) {
            String string = Joiner.on((String)", ").join(\u00e2\u02dc\u01923.stream().sorted().map(ChunkPos::new).map(ChunkPos::toString).iterator());
            if (\u00e2\u02dc\u01924 == 1) {
                p_137681_.m_81354_(new TranslatableComponent("commands.forceload.list.single", \u00e2\u02dc\u01922.m_135782_(), string), false);
            } else {
                p_137681_.m_81354_(new TranslatableComponent("commands.forceload.list.multiple", \u00e2\u02dc\u01924, \u00e2\u02dc\u01922.m_135782_(), string), false);
            }
        } else {
            p_137681_.m_81352_(new TranslatableComponent("commands.forceload.added.none", \u00e2\u02dc\u01922.m_135782_()));
        }
        return \u00e2\u02dc\u01924;
    }

    private static int m_137695_(CommandSourceStack p_137696_) {
        ServerLevel serverLevel = p_137696_.m_81372_();
        ResourceKey<Level> \u00e2\u02dc\u01922 = serverLevel.m_46472_();
        LongSet \u00e2\u02dc\u01923 = serverLevel.m_8902_();
        \u00e2\u02dc\u01923.forEach(p_137675_ -> serverLevel.m_8602_(ChunkPos.m_45592_(p_137675_), ChunkPos.m_45602_(p_137675_), false));
        p_137696_.m_81354_(new TranslatableComponent("commands.forceload.removed.all", \u00e2\u02dc\u01922.m_135782_()), true);
        return 0;
    }

    private static int m_137685_(CommandSourceStack p_137686_, ColumnPos p_137687_, ColumnPos p_137688_, boolean p_137689_) throws CommandSyntaxException {
        int n;
        int n2 = Math.min(p_137687_.f_140723_, p_137688_.f_140723_);
        \u00e2\u02dc\u0192 = Math.min(p_137687_.f_140724_, p_137688_.f_140724_);
        \u00e2\u02dc\u0192 = Math.max(p_137687_.f_140723_, p_137688_.f_140723_);
        \u00e2\u02dc\u0192 = Math.max(p_137687_.f_140724_, p_137688_.f_140724_);
        if (n2 < -30000000 || \u00e2\u02dc\u0192 < -30000000 || \u00e2\u02dc\u0192 >= 30000000 || \u00e2\u02dc\u0192 >= 30000000) {
            throw BlockPosArgument.f_118235_.create();
        }
        \u00e2\u02dc\u0192 = SectionPos.m_123171_(n2);
        \u00e2\u02dc\u0192 = SectionPos.m_123171_(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = SectionPos.m_123171_(\u00e2\u02dc\u0192);
        long \u00e2\u02dc\u01922 = ((long)(\u00e2\u02dc\u0192 - \u00e2\u02dc\u0192) + 1L) * ((long)((\u00e2\u02dc\u0192 = SectionPos.m_123171_(\u00e2\u02dc\u0192)) - \u00e2\u02dc\u0192) + 1L);
        if (\u00e2\u02dc\u01922 > 256L) {
            throw f_137668_.create((Object)256, (Object)\u00e2\u02dc\u01922);
        }
        ServerLevel \u00e2\u02dc\u01923 = p_137686_.m_81372_();
        ResourceKey<Level> \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.m_46472_();
        ChunkPos \u00e2\u02dc\u01925 = null;
        n = 0;
        for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
            for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                boolean bl = \u00e2\u02dc\u01923.m_8602_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, p_137689_);
                if (!bl) continue;
                ++n;
                if (\u00e2\u02dc\u01925 != null) continue;
                \u00e2\u02dc\u01925 = new ChunkPos(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            }
        }
        if (n == 0) {
            throw (p_137689_ ? f_137670_ : f_137671_).create();
        }
        if (n == 1) {
            p_137686_.m_81354_(new TranslatableComponent("commands.forceload." + (p_137689_ ? "added" : "removed") + ".single", \u00e2\u02dc\u01925, \u00e2\u02dc\u01924.m_135782_()), true);
        } else {
            ChunkPos chunkPos = new ChunkPos(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            \u00e2\u02dc\u0192 = new ChunkPos(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            p_137686_.m_81354_(new TranslatableComponent("commands.forceload." + (p_137689_ ? "added" : "removed") + ".multiple", n, \u00e2\u02dc\u01924.m_135782_(), chunkPos, \u00e2\u02dc\u0192), true);
        }
        return n;
    }
}

